/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtsensors_python.h"

// main header
#include "qlidfilter_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QLidFilterWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QLidFilterWrapper::QLidFilterWrapper() : QLidFilter()
{
    resetPyMethodCache();
    // ... middle
}

bool QLidFilterWrapper::filter(::QLidReading * reading)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLidFilter.filter()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "filter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLidFilter.filter()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QLIDREADING_IDX]), reading)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLidFilter.filter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QLidFilterWrapper::setSensor(::QSensor * sensor)
{
    if (m_PyMethodCache[1]) {
        return this->::QSensorFilter::setSensor(sensor);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setSensor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSensorFilter::setSensor(sensor);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX]), sensor)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QLidFilterWrapper::~QLidFilterWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QLidFilter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QLIDFILTER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QLidFilter' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QLidFilter >()))
        return -1;

    ::QLidFilterWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QLidFilter.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QLidFilter()
            cptr = new ::QLidFilterWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QLidFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QLidFilterFunc_filter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLidFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QLIDFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QLidFilter.filter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensorFilter::filter(QSensorReading*)
    // 1: QLidFilter::filter(QLidReading*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QLIDREADING_IDX]), (pyArg)))) {
        overloadId = 1; // filter(QLidReading*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORREADING_IDX]), (pyArg)))) {
        overloadId = 0; // filter(QSensorReading*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLidFilterFunc_filter_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // filter(QSensorReading * reading)
        {
            PyErr_Format(PyExc_TypeError, "%s is a private method.", "filter(QSensorReading * reading)");
            return {};
            break;
        }
        case 1: // filter(QLidReading * reading)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QLidReading *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // filter(QLidReading*)
                if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLidFilter.filter()' not implemented.");
                    return {};
                }
                bool cppResult = cppSelf->filter(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLidFilterFunc_filter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QLidFilter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QLidFilter_methods[] = {
    {"filter", reinterpret_cast<PyCFunction>(Sbk_QLidFilterFunc_filter), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QLidFilter_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QLidFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QLIDFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QLidFilterWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QLidFilter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QLidFilter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QLidFilter_Type = nullptr;
static SbkObjectType *Sbk_QLidFilter_TypeF(void)
{
    return _Sbk_QLidFilter_Type;
}

static PyType_Slot Sbk_QLidFilter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QLidFilter_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QLidFilter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QLidFilter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QLidFilter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QLidFilter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QLidFilter_spec = {
    "2:PySide2.QtSensors.QLidFilter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QLidFilter_slots
};

} //extern "C"

static void *Sbk_QLidFilter_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QSensorFilter >()))
        return dynamic_cast< ::QLidFilter *>(reinterpret_cast< ::QSensorFilter *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QLidFilter_PythonToCpp_QLidFilter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QLidFilter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QLidFilter_PythonToCpp_QLidFilter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLidFilter_TypeF())))
        return QLidFilter_PythonToCpp_QLidFilter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QLidFilter_PTR_CppToPython_QLidFilter(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QLidFilter *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QLidFilter_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QLidFilter_SignatureStrings[] = {
    "PySide2.QtSensors.QLidFilter(self)",
    "1:PySide2.QtSensors.QLidFilter.filter(self,reading:PySide2.QtSensors.QSensorReading)->bool",
    "0:PySide2.QtSensors.QLidFilter.filter(self,reading:PySide2.QtSensors.QLidReading)->bool",
    nullptr}; // Sentinel

void init_QLidFilter(PyObject *module)
{
    _Sbk_QLidFilter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QLidFilter",
        "QLidFilter*",
        &Sbk_QLidFilter_spec,
        &Shiboken::callCppDestructor< ::QLidFilter >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORFILTER_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QLidFilter_Type);
    InitSignatureStrings(pyType, QLidFilter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QLidFilter_Type), Sbk_QLidFilter_PropertyStrings);
    SbkPySide2_QtSensorsTypes[SBK_QLIDFILTER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QLidFilter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QLidFilter_TypeF(),
        QLidFilter_PythonToCpp_QLidFilter_PTR,
        is_QLidFilter_PythonToCpp_QLidFilter_PTR_Convertible,
        QLidFilter_PTR_CppToPython_QLidFilter);

    Shiboken::Conversions::registerConverterName(converter, "QLidFilter");
    Shiboken::Conversions::registerConverterName(converter, "QLidFilter*");
    Shiboken::Conversions::registerConverterName(converter, "QLidFilter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLidFilter).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLidFilterWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QLidFilter_TypeF(), &Sbk_QLidFilter_typeDiscovery);

}
