/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtsql_python.h"

// main header
#include "qsql_wrapper.h"

// inner classes

// Extra includes
#include <QtSql/qtsqlglobal.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {

static const char *Sbk_QSql_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSql_methods[] = {

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSql_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSql_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSql_Type = nullptr;
static SbkObjectType *Sbk_QSql_TypeF(void)
{
    return _Sbk_QSql_Type;
}

static PyType_Slot Sbk_QSql_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSql_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSql_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSql_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSql_spec = {
    "2:PySide2.QtSql.QSql",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSql_slots
};

} //extern "C"

PyObject *SbkPySide2_QtSql_QSql_ParamTypeFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QSql::ParamType cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSql::ParamType>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSql::ParamType>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSql::ParamType>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSql::ParamType>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtSql_QSql_ParamTypeFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QSql::ParamType cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSql::ParamType>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSql::ParamType>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSql::ParamType>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSql::ParamType>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtSql_QSql_ParamTypeFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSql::ParamType cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSql::ParamType>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSql::ParamType>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSql::ParamType>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSql::ParamType>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtSql_QSql_ParamTypeFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSql::ParamType cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX])->converter, self, &cppSelf);
    ::QSql::ParamType cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtSql_QSql_ParamTypeFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtSql_QSql_ParamTypeFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtSql_QSql_ParamTypeFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtSql_QSql_ParamTypeFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSql_Location_PythonToCpp_QSql_Location(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSql::Location *>(cppOut) =
        static_cast<::QSql::Location>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSql_Location_PythonToCpp_QSql_Location_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQL_LOCATION_IDX]))
        return QSql_Location_PythonToCpp_QSql_Location;
    return {};
}
static PyObject *QSql_Location_CppToPython_QSql_Location(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSql::Location *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQL_LOCATION_IDX], castCppIn);

}

static void QSql_ParamTypeFlag_PythonToCpp_QSql_ParamTypeFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSql::ParamTypeFlag *>(cppOut) =
        static_cast<::QSql::ParamTypeFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSql_ParamTypeFlag_PythonToCpp_QSql_ParamTypeFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX]))
        return QSql_ParamTypeFlag_PythonToCpp_QSql_ParamTypeFlag;
    return {};
}
static PyObject *QSql_ParamTypeFlag_CppToPython_QSql_ParamTypeFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSql::ParamTypeFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX], castCppIn);

}

static void QFlags_QSql_ParamTypeFlag__PythonToCpp_QFlags_QSql_ParamTypeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSql::ParamTypeFlag> *>(cppOut) =
        ::QFlags<QSql::ParamTypeFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSql_ParamTypeFlag__PythonToCpp_QFlags_QSql_ParamTypeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX]))
        return QFlags_QSql_ParamTypeFlag__PythonToCpp_QFlags_QSql_ParamTypeFlag_;
    return {};
}
static PyObject *QFlags_QSql_ParamTypeFlag__CppToPython_QFlags_QSql_ParamTypeFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSql::ParamTypeFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX]));

}

static void QSql_ParamTypeFlag_PythonToCpp_QFlags_QSql_ParamTypeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSql::ParamTypeFlag> *>(cppOut) =
        ::QFlags<QSql::ParamTypeFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSql_ParamTypeFlag_PythonToCpp_QFlags_QSql_ParamTypeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX]))
        return QSql_ParamTypeFlag_PythonToCpp_QFlags_QSql_ParamTypeFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QSql_ParamTypeFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSql::ParamTypeFlag> *>(cppOut) =
        ::QFlags<QSql::ParamTypeFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSql_ParamTypeFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX]))
        return number_PythonToCpp_QFlags_QSql_ParamTypeFlag_;
    return {};
}
static void QSql_TableType_PythonToCpp_QSql_TableType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSql::TableType *>(cppOut) =
        static_cast<::QSql::TableType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSql_TableType_PythonToCpp_QSql_TableType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX]))
        return QSql_TableType_PythonToCpp_QSql_TableType;
    return {};
}
static PyObject *QSql_TableType_CppToPython_QSql_TableType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSql::TableType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX], castCppIn);

}

static void QSql_NumericalPrecisionPolicy_PythonToCpp_QSql_NumericalPrecisionPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSql::NumericalPrecisionPolicy *>(cppOut) =
        static_cast<::QSql::NumericalPrecisionPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSql_NumericalPrecisionPolicy_PythonToCpp_QSql_NumericalPrecisionPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX]))
        return QSql_NumericalPrecisionPolicy_PythonToCpp_QSql_NumericalPrecisionPolicy;
    return {};
}
static PyObject *QSql_NumericalPrecisionPolicy_CppToPython_QSql_NumericalPrecisionPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSql::NumericalPrecisionPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX], castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtSqlQSql_SignatureStrings[] = {
    nullptr}; // Sentinel

void init_QtSqlQSql(PyObject *module)
{
    _Sbk_QSql_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSql",
        "QSql",
        &Sbk_QSql_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSql_Type);
    InitSignatureStrings(pyType, QtSqlQSql_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSql_Type), Sbk_QSql_PropertyStrings);
    SbkPySide2_QtSqlTypes[SBK_QtSqlQSQL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSql_TypeF());


    // Initialization of enums.

    // Initialization of enum 'Location'.
    SbkPySide2_QtSqlTypes[SBK_QSQL_LOCATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSql_TypeF(),
        "Location",
        "2:PySide2.QtSql.QSql.Location",
        "QSql::Location");
    if (!SbkPySide2_QtSqlTypes[SBK_QSQL_LOCATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_LOCATION_IDX],
        Sbk_QSql_TypeF(), "BeforeFirstRow", (long) QSql::Location::BeforeFirstRow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_LOCATION_IDX],
        Sbk_QSql_TypeF(), "AfterLastRow", (long) QSql::Location::AfterLastRow))
        return;
    // Register converter for enum 'QSql::Location'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQL_LOCATION_IDX],
            QSql_Location_CppToPython_QSql_Location);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSql_Location_PythonToCpp_QSql_Location,
            is_QSql_Location_PythonToCpp_QSql_Location_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQL_LOCATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSql::Location");
        Shiboken::Conversions::registerConverterName(converter, "Location");
    }
    // End of 'Location' enum.

    // Initialization of enum 'ParamTypeFlag'.
    SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtSql.QSql.ParamType", SbkPySide2_QtSql_QSql_ParamTypeFlag_number_slots);
    SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSql_TypeF(),
        "ParamTypeFlag",
        "2:PySide2.QtSql.QSql.ParamTypeFlag",
        "QSql::ParamTypeFlag",
        SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX]);
    if (!SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX],
        Sbk_QSql_TypeF(), "In", (long) QSql::ParamTypeFlag::In))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX],
        Sbk_QSql_TypeF(), "Out", (long) QSql::ParamTypeFlag::Out))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX],
        Sbk_QSql_TypeF(), "InOut", (long) QSql::ParamTypeFlag::InOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX],
        Sbk_QSql_TypeF(), "Binary", (long) QSql::ParamTypeFlag::Binary))
        return;
    // Register converter for enum 'QSql::ParamTypeFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX],
            QSql_ParamTypeFlag_CppToPython_QSql_ParamTypeFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSql_ParamTypeFlag_PythonToCpp_QSql_ParamTypeFlag,
            is_QSql_ParamTypeFlag_PythonToCpp_QSql_ParamTypeFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQL_PARAMTYPEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSql::ParamTypeFlag");
        Shiboken::Conversions::registerConverterName(converter, "ParamTypeFlag");
    }
    // Register converter for flag 'QFlags<QSql::ParamTypeFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX],
            QFlags_QSql_ParamTypeFlag__CppToPython_QFlags_QSql_ParamTypeFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSql_ParamTypeFlag_PythonToCpp_QFlags_QSql_ParamTypeFlag_,
            is_QSql_ParamTypeFlag_PythonToCpp_QFlags_QSql_ParamTypeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSql_ParamTypeFlag__PythonToCpp_QFlags_QSql_ParamTypeFlag_,
            is_QFlags_QSql_ParamTypeFlag__PythonToCpp_QFlags_QSql_ParamTypeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSql_ParamTypeFlag_,
            is_number_PythonToCpp_QFlags_QSql_ParamTypeFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QFLAGS_QSQL_PARAMTYPEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSql::ParamType");
        Shiboken::Conversions::registerConverterName(converter, "ParamType");
    }
    // End of 'ParamTypeFlag' enum/flags.

    // Initialization of enum 'TableType'.
    SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSql_TypeF(),
        "TableType",
        "2:PySide2.QtSql.QSql.TableType",
        "QSql::TableType");
    if (!SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX],
        Sbk_QSql_TypeF(), "Tables", (long) QSql::TableType::Tables))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX],
        Sbk_QSql_TypeF(), "SystemTables", (long) QSql::TableType::SystemTables))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX],
        Sbk_QSql_TypeF(), "Views", (long) QSql::TableType::Views))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX],
        Sbk_QSql_TypeF(), "AllTables", (long) QSql::TableType::AllTables))
        return;
    // Register converter for enum 'QSql::TableType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX],
            QSql_TableType_CppToPython_QSql_TableType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSql_TableType_PythonToCpp_QSql_TableType,
            is_QSql_TableType_PythonToCpp_QSql_TableType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSql::TableType");
        Shiboken::Conversions::registerConverterName(converter, "TableType");
    }
    // End of 'TableType' enum.

    // Initialization of enum 'NumericalPrecisionPolicy'.
    SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSql_TypeF(),
        "NumericalPrecisionPolicy",
        "2:PySide2.QtSql.QSql.NumericalPrecisionPolicy",
        "QSql::NumericalPrecisionPolicy");
    if (!SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX],
        Sbk_QSql_TypeF(), "LowPrecisionInt32", (long) QSql::NumericalPrecisionPolicy::LowPrecisionInt32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX],
        Sbk_QSql_TypeF(), "LowPrecisionInt64", (long) QSql::NumericalPrecisionPolicy::LowPrecisionInt64))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX],
        Sbk_QSql_TypeF(), "LowPrecisionDouble", (long) QSql::NumericalPrecisionPolicy::LowPrecisionDouble))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX],
        Sbk_QSql_TypeF(), "HighPrecision", (long) QSql::NumericalPrecisionPolicy::HighPrecision))
        return;
    // Register converter for enum 'QSql::NumericalPrecisionPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX],
            QSql_NumericalPrecisionPolicy_CppToPython_QSql_NumericalPrecisionPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSql_NumericalPrecisionPolicy_PythonToCpp_QSql_NumericalPrecisionPolicy,
            is_QSql_NumericalPrecisionPolicy_PythonToCpp_QSql_NumericalPrecisionPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSql::NumericalPrecisionPolicy");
        Shiboken::Conversions::registerConverterName(converter, "NumericalPrecisionPolicy");
    }
    // End of 'NumericalPrecisionPolicy' enum.

    qRegisterMetaType< ::QSql::Location >("QSql::Location");
    qRegisterMetaType< ::QSql::ParamTypeFlag >("QSql::ParamTypeFlag");
    qRegisterMetaType< ::QSql::ParamType >("QSql::ParamType");
    qRegisterMetaType< ::QSql::TableType >("QSql::TableType");
    qRegisterMetaType< ::QSql::NumericalPrecisionPolicy >("QSql::NumericalPrecisionPolicy");
}
