/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtsql_python.h"

// main header
#include "qsqldatabase_wrapper.h"

// inner classes

// Extra includes
#include <QSize>
#include <QSqlError>
#include <QSqlIndex>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QStringList>
#include <QtSql/qsqldatabase.h>
#include <QtSql/qsqldriver.h>
#include <QtSql/qsqlerror.h>
#include <QtSql/qsqlindex.h>
#include <QtSql/qsqlquery.h>
#include <QtSql/qsqlrecord.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSqlDatabase_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSqlDatabase >()))
        return -1;

    ::QSqlDatabase *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSqlDatabase", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSqlDatabase::QSqlDatabase()
    // 1: QSqlDatabase::QSqlDatabase(QSqlDriver*)
    // 2: QSqlDatabase::QSqlDatabase(QSqlDatabase)
    // 3: QSqlDatabase::QSqlDatabase(QString)
    if (numArgs == 0) {
        overloadId = 0; // QSqlDatabase()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QSqlDatabase(QSqlDatabase)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QSqlDatabase(QSqlDriver*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 3; // QSqlDatabase(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabase_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSqlDatabase()
        {

            if (!PyErr_Occurred()) {
                // QSqlDatabase()
                cptr = new ::QSqlDatabase();
            }
            break;
        }
        case 1: // QSqlDatabase(QSqlDriver * driver)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSqlDriver *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSqlDatabase(QSqlDriver*)
                cptr = new ::QSqlDatabase(cppArg0);
            }
            break;
        }
        case 2: // QSqlDatabase(const QSqlDatabase & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSqlDatabase cppArg0_local;
            ::QSqlDatabase *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSqlDatabase(QSqlDatabase)
                cptr = new ::QSqlDatabase(*cppArg0);
            }
            break;
        }
        case 3: // QSqlDatabase(const QString & type)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSqlDatabase(QString)
                cptr = new ::QSqlDatabase(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSqlDatabase >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSqlDatabase_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSqlDatabase_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSqlDatabaseFunc_addDatabase(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.addDatabase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDatabaseFunc_addDatabase_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDatabaseFunc_addDatabase_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:addDatabase", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSqlDatabase::addDatabase(QSqlDriver*,QString)
    // 1: static QSqlDatabase::addDatabase(QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addDatabase(QSqlDriver*,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // addDatabase(QSqlDriver*,QString)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // addDatabase(QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // addDatabase(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_addDatabase_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addDatabase(QSqlDriver * driver, const QString & connectionName)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_connectionName = Shiboken::String::createStaticString("connectionName");
                if (PyDict_Contains(kwds, key_connectionName)) {
                    value = PyDict_GetItem(kwds, key_connectionName);
                    if (value && pyArgs[1]) {
                        errInfo = key_connectionName;
                        Py_INCREF(errInfo);
                        goto Sbk_QSqlDatabaseFunc_addDatabase_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QSqlDatabaseFunc_addDatabase_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_connectionName);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSqlDatabaseFunc_addDatabase_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSqlDriver *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QLatin1String(QSqlDatabase::defaultConnection);
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addDatabase(QSqlDriver*,QString)
                QSqlDatabase cppResult = ::QSqlDatabase::addDatabase(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // addDatabase(const QString & type, const QString & connectionName)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_connectionName = Shiboken::String::createStaticString("connectionName");
                if (PyDict_Contains(kwds, key_connectionName)) {
                    value = PyDict_GetItem(kwds, key_connectionName);
                    if (value && pyArgs[1]) {
                        errInfo = key_connectionName;
                        Py_INCREF(errInfo);
                        goto Sbk_QSqlDatabaseFunc_addDatabase_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QSqlDatabaseFunc_addDatabase_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_connectionName);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSqlDatabaseFunc_addDatabase_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QLatin1String(QSqlDatabase::defaultConnection);
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addDatabase(QString,QString)
                QSqlDatabase cppResult = ::QSqlDatabase::addDatabase(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_addDatabase_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_cloneDatabase(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.cloneDatabase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "cloneDatabase", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSqlDatabase::cloneDatabase(QSqlDatabase,QString)
    // 1: static QSqlDatabase::cloneDatabase(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 1; // cloneDatabase(QString,QString)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // cloneDatabase(QSqlDatabase,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_cloneDatabase_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // cloneDatabase(const QSqlDatabase & other, const QString & connectionName)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSqlDatabase cppArg0_local;
            ::QSqlDatabase *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // cloneDatabase(QSqlDatabase,QString)
                QSqlDatabase cppResult = ::QSqlDatabase::cloneDatabase(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // cloneDatabase(const QString & other, const QString & connectionName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // cloneDatabase(QString,QString)
                QSqlDatabase cppResult = ::QSqlDatabase::cloneDatabase(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_cloneDatabase_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            cppSelf->close();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSqlDatabaseFunc_commit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.commit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // commit()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->commit();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_connectOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.connectOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // connectOptions()const
            QString cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->connectOptions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_connectionName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.connectionName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // connectionName()const
            QString cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->connectionName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_connectionNames(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.connectionNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // connectionNames()
            QStringList cppResult = ::QSqlDatabase::connectionNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_contains(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDatabaseFunc_contains_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:contains", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QSqlDatabase::contains(QString)
    if (numArgs == 0) {
        overloadId = 0; // contains(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // contains(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_contains_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_connectionName = Shiboken::String::createStaticString("connectionName");
            if (PyDict_Contains(kwds, key_connectionName)) {
                value = PyDict_GetItem(kwds, key_connectionName);
                if (value && pyArgs[0]) {
                    errInfo = key_connectionName;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDatabaseFunc_contains_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QSqlDatabaseFunc_contains_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_connectionName);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSqlDatabaseFunc_contains_TypeError;
            }
        }
        ::QString cppArg0 = QLatin1String(QSqlDatabase::defaultConnection);
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // contains(QString)
            bool cppResult = ::QSqlDatabase::contains(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_database(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.database";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDatabaseFunc_database_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:database", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSqlDatabase::database(QString,bool)
    if (numArgs == 0) {
        overloadId = 0; // database(QString,bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // database(QString,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // database(QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_database_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_connectionName = Shiboken::String::createStaticString("connectionName");
            if (PyDict_Contains(kwds, key_connectionName)) {
                value = PyDict_GetItem(kwds, key_connectionName);
                if (value && pyArgs[0]) {
                    errInfo = key_connectionName;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDatabaseFunc_database_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QSqlDatabaseFunc_database_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_connectionName);
            }
            static PyObject *const key_open = Shiboken::String::createStaticString("open");
            if (PyDict_Contains(kwds, key_open)) {
                value = PyDict_GetItem(kwds, key_open);
                if (value && pyArgs[1]) {
                    errInfo = key_open;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDatabaseFunc_database_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QSqlDatabaseFunc_database_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_open);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSqlDatabaseFunc_database_TypeError;
            }
        }
        ::QString cppArg0 = QLatin1String(QSqlDatabase::defaultConnection);
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // database(QString,bool)
            QSqlDatabase cppResult = ::QSqlDatabase::database(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_database_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_databaseName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.databaseName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // databaseName()const
            QString cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->databaseName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_driver(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.driver";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // driver()const
            QSqlDriver * cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->driver();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_driverName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.driverName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // driverName()const
            QString cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->driverName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_drivers(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.drivers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // drivers()
            QStringList cppResult = ::QSqlDatabase::drivers();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_exec_(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.exec_";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDatabaseFunc_exec__TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:exec_", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDatabase::exec(QString)const
    if (numArgs == 0) {
        overloadId = 0; // exec(QString)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // exec(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_exec__TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_query = Shiboken::String::createStaticString("query");
            if (PyDict_Contains(kwds, key_query)) {
                value = PyDict_GetItem(kwds, key_query);
                if (value && pyArgs[0]) {
                    errInfo = key_query;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDatabaseFunc_exec__TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QSqlDatabaseFunc_exec__TypeError;
                }
                PyDict_DelItem(kwds_dup, key_query);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSqlDatabaseFunc_exec__TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // exec(QString)const
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QSqlQuery cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->exec(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLQUERY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_exec__TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_hostName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.hostName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hostName()const
            QString cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->hostName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_isDriverAvailable(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.isDriverAvailable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QSqlDatabase::isDriverAvailable(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // isDriverAvailable(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_isDriverAvailable_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isDriverAvailable(QString)
            bool cppResult = ::QSqlDatabase::isDriverAvailable(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_isDriverAvailable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_isOpen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.isOpen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOpen()const
            bool cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->isOpen();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_isOpenError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.isOpenError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOpenError()const
            bool cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->isOpenError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_lastError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.lastError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastError()const
            QSqlError cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->lastError();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_numericalPrecisionPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.numericalPrecisionPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // numericalPrecisionPolicy()const
            QSql::NumericalPrecisionPolicy cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->numericalPrecisionPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_open(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.open";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto Sbk_QSqlDatabaseFunc_open_TypeError;

    if (!PyArg_UnpackTuple(args, "open", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDatabase::open()
    // 1: QSqlDatabase::open(QString,QString)
    if (numArgs == 0) {
        overloadId = 0; // open()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 1; // open(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_open_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // open()
        {

            if (!PyErr_Occurred()) {
                // open()
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->open();
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // open(const QString & user, const QString & password)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // open(QString,QString)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->open(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_open_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_password(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.password";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // password()const
            QString cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->password();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_port(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.port";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // port()const
            int cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->port();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_primaryIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.primaryIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDatabase::primaryIndex(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // primaryIndex(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_primaryIndex_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // primaryIndex(QString)const
            QSqlIndex cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->primaryIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_primaryIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_record(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.record";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDatabase::record(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // record(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_record_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // record(QString)const
            QSqlRecord cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->record(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_record_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_registerSqlDriver(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.registerSqlDriver";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "registerSqlDriver", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSqlDatabase::registerSqlDriver(QString,QSqlDriverCreatorBase*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVERCREATORBASE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // registerSqlDriver(QString,QSqlDriverCreatorBase*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_registerSqlDriver_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSqlDriverCreatorBase *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // registerSqlDriver(QString,QSqlDriverCreatorBase*)
            ::QSqlDatabase::registerSqlDriver(cppArg0, cppArg1);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDatabaseFunc_registerSqlDriver_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_removeDatabase(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.removeDatabase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QSqlDatabase::removeDatabase(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeDatabase(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_removeDatabase_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeDatabase(QString)
            ::QSqlDatabase::removeDatabase(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDatabaseFunc_removeDatabase_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_rollback(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.rollback";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rollback()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->rollback();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_setConnectOptions(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.setConnectOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDatabaseFunc_setConnectOptions_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setConnectOptions", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDatabase::setConnectOptions(QString)
    if (numArgs == 0) {
        overloadId = 0; // setConnectOptions(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // setConnectOptions(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_setConnectOptions_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDatabaseFunc_setConnectOptions_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QSqlDatabaseFunc_setConnectOptions_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSqlDatabaseFunc_setConnectOptions_TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setConnectOptions(QString)
            cppSelf->setConnectOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDatabaseFunc_setConnectOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_setDatabaseName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.setDatabaseName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDatabase::setDatabaseName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDatabaseName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_setDatabaseName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDatabaseName(QString)
            cppSelf->setDatabaseName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDatabaseFunc_setDatabaseName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_setHostName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.setHostName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDatabase::setHostName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setHostName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_setHostName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHostName(QString)
            cppSelf->setHostName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDatabaseFunc_setHostName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_setNumericalPrecisionPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.setNumericalPrecisionPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDatabase::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_setNumericalPrecisionPolicy_TypeError;

    // Call function/method
    {
        ::QSql::NumericalPrecisionPolicy cppArg0{QSql::HighPrecision};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
            cppSelf->setNumericalPrecisionPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDatabaseFunc_setNumericalPrecisionPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_setPassword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.setPassword";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDatabase::setPassword(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPassword(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_setPassword_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPassword(QString)
            cppSelf->setPassword(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDatabaseFunc_setPassword_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_setPort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.setPort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDatabase::setPort(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPort(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_setPort_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPort(int)
            cppSelf->setPort(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDatabaseFunc_setPort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_setUserName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.setUserName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDatabase::setUserName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setUserName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_setUserName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUserName(QString)
            cppSelf->setUserName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDatabaseFunc_setUserName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_tables(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.tables";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDatabaseFunc_tables_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:tables", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDatabase::tables(QSql::TableType)const
    if (numArgs == 0) {
        overloadId = 0; // tables(QSql::TableType)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // tables(QSql::TableType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDatabaseFunc_tables_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[0]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDatabaseFunc_tables_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QSqlDatabaseFunc_tables_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSqlDatabaseFunc_tables_TypeError;
            }
        }
        ::QSql::TableType cppArg0 = QSql::Tables;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // tables(QSql::TableType)const
            QStringList cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->tables(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDatabaseFunc_tables_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDatabaseFunc_transaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.transaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transaction()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->transaction();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabaseFunc_userName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDatabase.userName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // userName()const
            QString cppResult = const_cast<const ::QSqlDatabase *>(cppSelf)->userName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDatabase___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSqlDatabase_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSqlDatabase_methods[] = {
    {"addDatabase", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_addDatabase), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"cloneDatabase", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_cloneDatabase), METH_VARARGS|METH_STATIC},
    {"close", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_close), METH_NOARGS},
    {"commit", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_commit), METH_NOARGS},
    {"connectOptions", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_connectOptions), METH_NOARGS},
    {"connectionName", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_connectionName), METH_NOARGS},
    {"connectionNames", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_connectionNames), METH_NOARGS|METH_STATIC},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_contains), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"database", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_database), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"databaseName", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_databaseName), METH_NOARGS},
    {"driver", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_driver), METH_NOARGS},
    {"driverName", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_driverName), METH_NOARGS},
    {"drivers", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_drivers), METH_NOARGS|METH_STATIC},
    {"exec_", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_exec_), METH_VARARGS|METH_KEYWORDS},
    {"hostName", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_hostName), METH_NOARGS},
    {"isDriverAvailable", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_isDriverAvailable), METH_O|METH_STATIC},
    {"isOpen", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_isOpen), METH_NOARGS},
    {"isOpenError", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_isOpenError), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_isValid), METH_NOARGS},
    {"lastError", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_lastError), METH_NOARGS},
    {"numericalPrecisionPolicy", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_numericalPrecisionPolicy), METH_NOARGS},
    {"open", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_open), METH_VARARGS},
    {"password", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_password), METH_NOARGS},
    {"port", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_port), METH_NOARGS},
    {"primaryIndex", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_primaryIndex), METH_O},
    {"record", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_record), METH_O},
    {"registerSqlDriver", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_registerSqlDriver), METH_VARARGS|METH_STATIC},
    {"removeDatabase", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_removeDatabase), METH_O|METH_STATIC},
    {"rollback", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_rollback), METH_NOARGS},
    {"setConnectOptions", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_setConnectOptions), METH_VARARGS|METH_KEYWORDS},
    {"setDatabaseName", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_setDatabaseName), METH_O},
    {"setHostName", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_setHostName), METH_O},
    {"setNumericalPrecisionPolicy", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_setNumericalPrecisionPolicy), METH_O},
    {"setPassword", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_setPassword), METH_O},
    {"setPort", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_setPort), METH_O},
    {"setUserName", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_setUserName), METH_O},
    {"tables", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_tables), METH_VARARGS|METH_KEYWORDS},
    {"transaction", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_transaction), METH_NOARGS},
    {"userName", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabaseFunc_userName), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSqlDatabase___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSqlDatabase_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSqlDatabase_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSqlDatabase__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSqlDatabase_Type = nullptr;
static SbkObjectType *Sbk_QSqlDatabase_TypeF(void)
{
    return _Sbk_QSqlDatabase_Type;
}

static PyType_Slot Sbk_QSqlDatabase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSqlDatabase__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSqlDatabase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSqlDatabase_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSqlDatabase_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSqlDatabase_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSqlDatabase_spec = {
    "2:PySide2.QtSql.QSqlDatabase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSqlDatabase_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSqlDatabase_PythonToCpp_QSqlDatabase_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSqlDatabase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSqlDatabase_PythonToCpp_QSqlDatabase_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSqlDatabase_TypeF())))
        return QSqlDatabase_PythonToCpp_QSqlDatabase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSqlDatabase_PTR_CppToPython_QSqlDatabase(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSqlDatabase *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSqlDatabase_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSqlDatabase_COPY_CppToPython_QSqlDatabase(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSqlDatabase_TypeF(), new ::QSqlDatabase(*reinterpret_cast<const ::QSqlDatabase *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSqlDatabase_PythonToCpp_QSqlDatabase_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSqlDatabase *>(cppOut) = *reinterpret_cast< ::QSqlDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSqlDatabase_PythonToCpp_QSqlDatabase_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSqlDatabase_TypeF())))
        return QSqlDatabase_PythonToCpp_QSqlDatabase_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSqlDatabase_SignatureStrings[] = {
    "3:PySide2.QtSql.QSqlDatabase(self)",
    "2:PySide2.QtSql.QSqlDatabase(self,driver:PySide2.QtSql.QSqlDriver)",
    "1:PySide2.QtSql.QSqlDatabase(self,other:PySide2.QtSql.QSqlDatabase)",
    "0:PySide2.QtSql.QSqlDatabase(self,type:QString)",
    "1:PySide2.QtSql.QSqlDatabase.addDatabase(driver:PySide2.QtSql.QSqlDriver,connectionName:QString=QLatin1String(defaultConnection))->PySide2.QtSql.QSqlDatabase",
    "0:PySide2.QtSql.QSqlDatabase.addDatabase(type:QString,connectionName:QString=QLatin1String(defaultConnection))->PySide2.QtSql.QSqlDatabase",
    "1:PySide2.QtSql.QSqlDatabase.cloneDatabase(other:PySide2.QtSql.QSqlDatabase,connectionName:QString)->PySide2.QtSql.QSqlDatabase",
    "0:PySide2.QtSql.QSqlDatabase.cloneDatabase(other:QString,connectionName:QString)->PySide2.QtSql.QSqlDatabase",
    "PySide2.QtSql.QSqlDatabase.close(self)",
    "PySide2.QtSql.QSqlDatabase.commit(self)->bool",
    "PySide2.QtSql.QSqlDatabase.connectOptions(self)->QString",
    "PySide2.QtSql.QSqlDatabase.connectionName(self)->QString",
    "PySide2.QtSql.QSqlDatabase.connectionNames()->QStringList",
    "PySide2.QtSql.QSqlDatabase.contains(connectionName:QString=QLatin1String(defaultConnection))->bool",
    "PySide2.QtSql.QSqlDatabase.database(connectionName:QString=QLatin1String(defaultConnection),open:bool=true)->PySide2.QtSql.QSqlDatabase",
    "PySide2.QtSql.QSqlDatabase.databaseName(self)->QString",
    "PySide2.QtSql.QSqlDatabase.driver(self)->PySide2.QtSql.QSqlDriver",
    "PySide2.QtSql.QSqlDatabase.driverName(self)->QString",
    "PySide2.QtSql.QSqlDatabase.drivers()->QStringList",
    "PySide2.QtSql.QSqlDatabase.exec_(self,query:QString=QString())->PySide2.QtSql.QSqlQuery",
    "PySide2.QtSql.QSqlDatabase.hostName(self)->QString",
    "PySide2.QtSql.QSqlDatabase.isDriverAvailable(name:QString)->bool",
    "PySide2.QtSql.QSqlDatabase.isOpen(self)->bool",
    "PySide2.QtSql.QSqlDatabase.isOpenError(self)->bool",
    "PySide2.QtSql.QSqlDatabase.isValid(self)->bool",
    "PySide2.QtSql.QSqlDatabase.lastError(self)->PySide2.QtSql.QSqlError",
    "PySide2.QtSql.QSqlDatabase.numericalPrecisionPolicy(self)->PySide2.QtSql.QSql.NumericalPrecisionPolicy",
    "1:PySide2.QtSql.QSqlDatabase.open(self)->bool",
    "0:PySide2.QtSql.QSqlDatabase.open(self,user:QString,password:QString)->bool",
    "PySide2.QtSql.QSqlDatabase.password(self)->QString",
    "PySide2.QtSql.QSqlDatabase.port(self)->int",
    "PySide2.QtSql.QSqlDatabase.primaryIndex(self,tablename:QString)->PySide2.QtSql.QSqlIndex",
    "PySide2.QtSql.QSqlDatabase.record(self,tablename:QString)->PySide2.QtSql.QSqlRecord",
    "PySide2.QtSql.QSqlDatabase.registerSqlDriver(name:QString,creator:PySide2.QtSql.QSqlDriverCreatorBase)",
    "PySide2.QtSql.QSqlDatabase.removeDatabase(connectionName:QString)",
    "PySide2.QtSql.QSqlDatabase.rollback(self)->bool",
    "PySide2.QtSql.QSqlDatabase.setConnectOptions(self,options:QString=QString())",
    "PySide2.QtSql.QSqlDatabase.setDatabaseName(self,name:QString)",
    "PySide2.QtSql.QSqlDatabase.setHostName(self,host:QString)",
    "PySide2.QtSql.QSqlDatabase.setNumericalPrecisionPolicy(self,precisionPolicy:PySide2.QtSql.QSql.NumericalPrecisionPolicy)",
    "PySide2.QtSql.QSqlDatabase.setPassword(self,password:QString)",
    "PySide2.QtSql.QSqlDatabase.setPort(self,p:int)",
    "PySide2.QtSql.QSqlDatabase.setUserName(self,name:QString)",
    "PySide2.QtSql.QSqlDatabase.tables(self,type:PySide2.QtSql.QSql.TableType=QSql.Tables)->QStringList",
    "PySide2.QtSql.QSqlDatabase.transaction(self)->bool",
    "PySide2.QtSql.QSqlDatabase.userName(self)->QString",
    "PySide2.QtSql.QSqlDatabase.__copy__()",
    nullptr}; // Sentinel

void init_QSqlDatabase(PyObject *module)
{
    _Sbk_QSqlDatabase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSqlDatabase",
        "QSqlDatabase",
        &Sbk_QSqlDatabase_spec,
        &Shiboken::callCppDestructor< ::QSqlDatabase >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSqlDatabase_Type);
    InitSignatureStrings(pyType, QSqlDatabase_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSqlDatabase_Type), Sbk_QSqlDatabase_PropertyStrings);
    SbkPySide2_QtSqlTypes[SBK_QSQLDATABASE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSqlDatabase_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSqlDatabase_TypeF(),
        QSqlDatabase_PythonToCpp_QSqlDatabase_PTR,
        is_QSqlDatabase_PythonToCpp_QSqlDatabase_PTR_Convertible,
        QSqlDatabase_PTR_CppToPython_QSqlDatabase,
        QSqlDatabase_COPY_CppToPython_QSqlDatabase);

    Shiboken::Conversions::registerConverterName(converter, "QSqlDatabase");
    Shiboken::Conversions::registerConverterName(converter, "QSqlDatabase*");
    Shiboken::Conversions::registerConverterName(converter, "QSqlDatabase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSqlDatabase).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSqlDatabase_PythonToCpp_QSqlDatabase_COPY,
        is_QSqlDatabase_PythonToCpp_QSqlDatabase_COPY_Convertible);

    qRegisterMetaType< ::QSqlDatabase >("QSqlDatabase");
}

void init_QSqlDatabaseStaticFields()
{
    auto dict = reinterpret_cast<PyTypeObject *>(Sbk_QSqlDatabase_TypeF())->tp_dict;
    PyDict_SetItemString(dict, "defaultConnection",
                         Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), QSqlDatabase::defaultConnection));

}
