/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QSQLRELATIONALTABLEMODELWRAPPER_H
#define SBK_QSQLRELATIONALTABLEMODELWRAPPER_H

#define protected public

#include <QtSql/qsqlrelationaltablemodel.h>


// Extra includes
#include <QStringList>
#include <QSize>
#include <qobject.h>
#include <QtSql/qsqldatabase.h>
#include <qabstractitemmodel.h>
#include <QtSql/qsqlrelationaltablemodel.h>
#include <QtSql/qsqltablemodel.h>
#include <QtSql/qsqlrecord.h>
#include <qcoreevent.h>
#include <QtSql/qsqlindex.h>
#include <QMap>
#include <pysideqflags.h>
#include <qbytearray.h>
#include <qmimedata.h>
#include <qsize.h>
#include <QtSql/qsqlquery.h>
#include <qmetaobject.h>
#include <qobjectdefs.h>
namespace PySide { class DynamicQMetaObject; }

class QSqlRelationalTableModelWrapper : public QSqlRelationalTableModel
{
public:
    QSqlRelationalTableModelWrapper(::QObject * parent = nullptr, ::QSqlDatabase db = QSqlDatabase());
    ::QModelIndex buddy(const ::QModelIndex & index) const override;
    bool canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const override;
    bool canFetchMore(const ::QModelIndex & parent = QModelIndex()) const override;
    void childEvent(::QChildEvent * event) override;
    void clear() override;
    int columnCount(const ::QModelIndex & parent = QModelIndex()) const override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    ::QVariant data(const ::QModelIndex & item, int role = Qt::DisplayRole) const override;
    bool deleteRowFromTable(int row) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void fetchMore(const ::QModelIndex & parent = QModelIndex()) override;
    ::QFlags<Qt::ItemFlag> flags(const ::QModelIndex & index) const override;
    ::QVariant headerData(int section, ::Qt::Orientation orientation, int role = Qt::DisplayRole) const override;
    ::QModelIndex index(int row, int column, const ::QModelIndex & parent = QModelIndex()) const override;
    ::QModelIndex indexInQuery(const ::QModelIndex & item) const override;
    bool insertColumns(int column, int count, const ::QModelIndex & parent = QModelIndex()) override;
    bool insertRowIntoTable(const ::QSqlRecord & values) override;
    bool insertRows(int row, int count, const ::QModelIndex & parent = QModelIndex()) override;
    ::QMap<int,QVariant > itemData(const ::QModelIndex & index) const override;
    ::QModelIndexList match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits = 1, ::QFlags<Qt::MatchFlag> flags = Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)) const override;
    const ::QMetaObject * metaObject() const override;
    ::QMimeData * mimeData(const ::QModelIndexList & indexes) const override;
    ::QStringList mimeTypes() const override;
    bool moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild) override;
    bool moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild) override;
    ::QString orderByClause() const override;
    void queryChange() override;
    ::QSqlTableModel * relationModel(int column) const override;
    bool removeColumns(int column, int count, const ::QModelIndex & parent = QModelIndex()) override;
    bool removeRows(int row, int count, const ::QModelIndex & parent = QModelIndex()) override;
    void revert() override;
    void revertRow(int row) override;
    ::QHash<int,QByteArray > roleNames() const override;
    int rowCount(const ::QModelIndex & parent = QModelIndex()) const override;
    bool select() override;
    bool selectRow(int row) override;
    ::QString selectStatement() const override;
    bool setData(const ::QModelIndex & item, const ::QVariant & value, int role = Qt::EditRole) override;
    void setEditStrategy(::QSqlTableModel::EditStrategy strategy) override;
    void setFilter(const ::QString & filter) override;
    bool setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role = Qt::EditRole) override;
    bool setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant > & roles) override;
    void setRelation(int column, const ::QSqlRelation & relation) override;
    void setSort(int column, ::Qt::SortOrder order) override;
    void setTable(const ::QString & tableName) override;
    ::QModelIndex sibling(int row, int column, const ::QModelIndex & idx) const override;
    void sort(int column, ::Qt::SortOrder order) override;
    ::QSize span(const ::QModelIndex & index) const override;
    bool submit() override;
    ::QFlags<Qt::DropAction> supportedDragActions() const override;
    ::QFlags<Qt::DropAction> supportedDropActions() const override;
    void timerEvent(::QTimerEvent * event) override;
    bool updateRowInTable(int row, const ::QSqlRecord & values) override;
    ~QSqlRelationalTableModelWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[59];
};

#endif // SBK_QSQLRELATIONALTABLEMODELWRAPPER_H

