/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebenginecore_python.h"

// main header
#include "qwebenginehttprequest_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QVector>
#include <QtWebEngineCore/qwebenginehttprequest.h>
#include <qbytearray.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebEngineHttpRequest_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebEngineHttpRequest >()))
        return -1;

    ::QWebEngineHttpRequest *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebEngineHttpRequest_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QWebEngineHttpRequest", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QWebEngineHttpRequest::QWebEngineHttpRequest(QUrl,QWebEngineHttpRequest::Method)
    // 1: QWebEngineHttpRequest::QWebEngineHttpRequest(QWebEngineHttpRequest)
    if (numArgs == 0) {
        overloadId = 0; // QWebEngineHttpRequest(QUrl,QWebEngineHttpRequest::Method)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QWebEngineHttpRequest(QWebEngineHttpRequest)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QWebEngineHttpRequest(QUrl,QWebEngineHttpRequest::Method)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // QWebEngineHttpRequest(QUrl,QWebEngineHttpRequest::Method)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequest_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QWebEngineHttpRequest(const QUrl & url, const QWebEngineHttpRequest::Method & method)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_url = Shiboken::String::createStaticString("url");
                if (PyDict_Contains(kwds, key_url)) {
                    value = PyDict_GetItem(kwds, key_url);
                    if (value && pyArgs[0]) {
                        errInfo = key_url;
                        Py_INCREF(errInfo);
                        goto Sbk_QWebEngineHttpRequest_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0]))))
                            goto Sbk_QWebEngineHttpRequest_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_url);
                }
                static PyObject *const key_method = Shiboken::String::createStaticString("method");
                if (PyDict_Contains(kwds, key_method)) {
                    value = PyDict_GetItem(kwds, key_method);
                    if (value && pyArgs[1]) {
                        errInfo = key_method;
                        Py_INCREF(errInfo);
                        goto Sbk_QWebEngineHttpRequest_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QWebEngineHttpRequest_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_method);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QWebEngineHttpRequest_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local = QUrl();
            ::QUrl *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }
            ::QWebEngineHttpRequest::Method cppArg1 = QWebEngineHttpRequest::Get;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QWebEngineHttpRequest(QUrl,QWebEngineHttpRequest::Method)
                cptr = new ::QWebEngineHttpRequest(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // QWebEngineHttpRequest(const QWebEngineHttpRequest & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QWebEngineHttpRequest_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWebEngineHttpRequest *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QWebEngineHttpRequest(QWebEngineHttpRequest)
                cptr = new ::QWebEngineHttpRequest(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebEngineHttpRequest >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebEngineHttpRequest_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QWebEngineHttpRequest_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_hasHeader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.hasHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHttpRequest::hasHeader(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // hasHeader(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequestFunc_hasHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // hasHeader(QByteArray)const
            bool cppResult = const_cast<const ::QWebEngineHttpRequest *>(cppSelf)->hasHeader(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineHttpRequestFunc_hasHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_header(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.header";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHttpRequest::header(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // header(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequestFunc_header_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // header(QByteArray)const
            QByteArray cppResult = const_cast<const ::QWebEngineHttpRequest *>(cppSelf)->header(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineHttpRequestFunc_header_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_headers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.headers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // headers()const
            QVector<QByteArray > cppResult = const_cast<const ::QWebEngineHttpRequest *>(cppSelf)->headers();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWebEngineCoreTypeConverters[SBK_QTWEBENGINECORE_QVECTOR_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_method(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.method";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // method()const
            QWebEngineHttpRequest::Method cppResult = const_cast<const ::QWebEngineHttpRequest *>(cppSelf)->method();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_postData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.postData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // postData()const
            QByteArray cppResult = const_cast<const ::QWebEngineHttpRequest *>(cppSelf)->postData();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_postRequest(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.postRequest";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "postRequest", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QWebEngineHttpRequest::postRequest(QUrl,QMap<QString,QString>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWebEngineCoreTypeConverters[SBK_QTWEBENGINECORE_QMAP_QSTRING_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // postRequest(QUrl,QMap<QString,QString>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequestFunc_postRequest_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QMap<QString,QString > cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // postRequest(QUrl,QMap<QString,QString>)
            QWebEngineHttpRequest* cppResult = new QWebEngineHttpRequest(::QWebEngineHttpRequest::postRequest(*cppArg0, cppArg1));
            pyResult = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX]), cppResult, true, true);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineHttpRequestFunc_postRequest_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_setHeader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.setHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setHeader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEngineHttpRequest::setHeader(QByteArray,QByteArray)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setHeader(QByteArray,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequestFunc_setHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setHeader(QByteArray,QByteArray)
            cppSelf->setHeader(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineHttpRequestFunc_setHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_setMethod(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.setMethod";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHttpRequest::setMethod(QWebEngineHttpRequest::Method)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMethod(QWebEngineHttpRequest::Method)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequestFunc_setMethod_TypeError;

    // Call function/method
    {
        ::QWebEngineHttpRequest::Method cppArg0{QWebEngineHttpRequest::Get};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMethod(QWebEngineHttpRequest::Method)
            cppSelf->setMethod(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineHttpRequestFunc_setMethod_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_setPostData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.setPostData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHttpRequest::setPostData(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setPostData(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequestFunc_setPostData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPostData(QByteArray)
            cppSelf->setPostData(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineHttpRequestFunc_setPostData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.setUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHttpRequest::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequestFunc_setUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineHttpRequestFunc_setUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHttpRequest::swap(QWebEngineHttpRequest&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QWebEngineHttpRequest&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequestFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineHttpRequest *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // swap(QWebEngineHttpRequest&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineHttpRequestFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_unsetHeader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.unsetHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHttpRequest::unsetHeader(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // unsetHeader(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHttpRequestFunc_unsetHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // unsetHeader(QByteArray)
            cppSelf->unsetHeader(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineHttpRequestFunc_unsetHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHttpRequestFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineHttpRequest.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::QWebEngineHttpRequest *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEngineHttpRequest_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineHttpRequest_methods[] = {
    {"hasHeader", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_hasHeader), METH_O},
    {"header", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_header), METH_O},
    {"headers", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_headers), METH_NOARGS},
    {"method", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_method), METH_NOARGS},
    {"postData", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_postData), METH_NOARGS},
    {"postRequest", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_postRequest), METH_VARARGS|METH_STATIC},
    {"setHeader", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_setHeader), METH_VARARGS},
    {"setMethod", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_setMethod), METH_O},
    {"setPostData", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_setPostData), METH_O},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_setUrl), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_swap), METH_O},
    {"unsetHeader", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_unsetHeader), METH_O},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHttpRequestFunc_url), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QWebEngineHttpRequest_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QWebEngineHttpRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX]), (pyArg)))) {
                // operator!=(const QWebEngineHttpRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QWebEngineHttpRequest *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX]), (pyArg)))) {
                // operator==(const QWebEngineHttpRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QWebEngineHttpRequest *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QWebEngineHttpRequest_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QWebEngineHttpRequest_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QWebEngineHttpRequest_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineHttpRequest_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineHttpRequest_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineHttpRequest_TypeF(void)
{
    return _Sbk_QWebEngineHttpRequest_Type;
}

static PyType_Slot Sbk_QWebEngineHttpRequest_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineHttpRequest_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineHttpRequest_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QWebEngineHttpRequest_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineHttpRequest_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebEngineHttpRequest_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineHttpRequest_spec = {
    "2:PySide2.QtWebEngineCore.QWebEngineHttpRequest",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineHttpRequest_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEngineHttpRequest_Method_PythonToCpp_QWebEngineHttpRequest_Method(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineHttpRequest::Method *>(cppOut) =
        static_cast<::QWebEngineHttpRequest::Method>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineHttpRequest_Method_PythonToCpp_QWebEngineHttpRequest_Method_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX]))
        return QWebEngineHttpRequest_Method_PythonToCpp_QWebEngineHttpRequest_Method;
    return {};
}
static PyObject *QWebEngineHttpRequest_Method_CppToPython_QWebEngineHttpRequest_Method(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineHttpRequest::Method *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineHttpRequest_PythonToCpp_QWebEngineHttpRequest_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineHttpRequest_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineHttpRequest_PythonToCpp_QWebEngineHttpRequest_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineHttpRequest_TypeF())))
        return QWebEngineHttpRequest_PythonToCpp_QWebEngineHttpRequest_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineHttpRequest_PTR_CppToPython_QWebEngineHttpRequest(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebEngineHttpRequest *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebEngineHttpRequest_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineHttpRequest_SignatureStrings[] = {
    "1:PySide2.QtWebEngineCore.QWebEngineHttpRequest(self,url:PySide2.QtCore.QUrl=QUrl(),method:PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method=QWebEngineHttpRequest.Get)",
    "0:PySide2.QtWebEngineCore.QWebEngineHttpRequest(self,other:PySide2.QtWebEngineCore.QWebEngineHttpRequest)",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.hasHeader(self,headerName:PySide2.QtCore.QByteArray)->bool",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.header(self,headerName:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.headers(self)->QVector[PySide2.QtCore.QByteArray]",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.method(self)->PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.postData(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.postRequest(url:PySide2.QtCore.QUrl,postData:QMap[QString, QString])->PySide2.QtWebEngineCore.QWebEngineHttpRequest",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.setHeader(self,headerName:PySide2.QtCore.QByteArray,value:PySide2.QtCore.QByteArray)",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.setMethod(self,method:PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method)",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.setPostData(self,postData:PySide2.QtCore.QByteArray)",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.setUrl(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.swap(self,other:PySide2.QtWebEngineCore.QWebEngineHttpRequest)",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.unsetHeader(self,headerName:PySide2.QtCore.QByteArray)",
    "PySide2.QtWebEngineCore.QWebEngineHttpRequest.url(self)->PySide2.QtCore.QUrl",
    nullptr}; // Sentinel

void init_QWebEngineHttpRequest(PyObject *module)
{
    _Sbk_QWebEngineHttpRequest_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineHttpRequest",
        "QWebEngineHttpRequest*",
        &Sbk_QWebEngineHttpRequest_spec,
        &Shiboken::callCppDestructor< ::QWebEngineHttpRequest >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineHttpRequest_Type);
    InitSignatureStrings(pyType, QWebEngineHttpRequest_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineHttpRequest_Type), Sbk_QWebEngineHttpRequest_PropertyStrings);
    SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineHttpRequest_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineHttpRequest_TypeF(),
        QWebEngineHttpRequest_PythonToCpp_QWebEngineHttpRequest_PTR,
        is_QWebEngineHttpRequest_PythonToCpp_QWebEngineHttpRequest_PTR_Convertible,
        QWebEngineHttpRequest_PTR_CppToPython_QWebEngineHttpRequest);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineHttpRequest");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineHttpRequest*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineHttpRequest&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineHttpRequest).name());


    // Initialization of enums.

    // Initialization of enum 'Method'.
    SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineHttpRequest_TypeF(),
        "Method",
        "2:PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method",
        "QWebEngineHttpRequest::Method");
    if (!SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX],
        Sbk_QWebEngineHttpRequest_TypeF(), "Get", (long) QWebEngineHttpRequest::Method::Get))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX],
        Sbk_QWebEngineHttpRequest_TypeF(), "Post", (long) QWebEngineHttpRequest::Method::Post))
        return;
    // Register converter for enum 'QWebEngineHttpRequest::Method'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX],
            QWebEngineHttpRequest_Method_CppToPython_QWebEngineHttpRequest_Method);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineHttpRequest_Method_PythonToCpp_QWebEngineHttpRequest_Method,
            is_QWebEngineHttpRequest_Method_PythonToCpp_QWebEngineHttpRequest_Method_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_METHOD_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineHttpRequest::Method");
        Shiboken::Conversions::registerConverterName(converter, "Method");
    }
    // End of 'Method' enum.

    qRegisterMetaType< ::QWebEngineHttpRequest::Method >("QWebEngineHttpRequest::Method");
}
