/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebenginecore_python.h"

// main header
#include "qwebengineurlrequestinfo_wrapper.h"

// inner classes

// Extra includes
#include <QtWebEngineCore/qwebengineurlrequestinfo.h>
#include <qbytearray.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_block(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.block";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineUrlRequestInfo::block(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // block(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlRequestInfoFunc_block_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // block(bool)
            cppSelf->block(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineUrlRequestInfoFunc_block_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_changed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.changed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // changed()const
            bool cppResult = const_cast<const ::QWebEngineUrlRequestInfo *>(cppSelf)->changed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_firstPartyUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.firstPartyUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // firstPartyUrl()const
            QUrl cppResult = const_cast<const ::QWebEngineUrlRequestInfo *>(cppSelf)->firstPartyUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_initiator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.initiator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initiator()const
            QUrl cppResult = const_cast<const ::QWebEngineUrlRequestInfo *>(cppSelf)->initiator();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_navigationType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.navigationType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // navigationType()const
            QWebEngineUrlRequestInfo::NavigationType cppResult = const_cast<const ::QWebEngineUrlRequestInfo *>(cppSelf)->navigationType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_redirect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.redirect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineUrlRequestInfo::redirect(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // redirect(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlRequestInfoFunc_redirect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // redirect(QUrl)
            cppSelf->redirect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineUrlRequestInfoFunc_redirect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_requestMethod(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.requestMethod";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestMethod()const
            QByteArray cppResult = const_cast<const ::QWebEngineUrlRequestInfo *>(cppSelf)->requestMethod();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_requestUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.requestUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestUrl()const
            QUrl cppResult = const_cast<const ::QWebEngineUrlRequestInfo *>(cppSelf)->requestUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_resourceType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.resourceType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resourceType()const
            QWebEngineUrlRequestInfo::ResourceType cppResult = const_cast<const ::QWebEngineUrlRequestInfo *>(cppSelf)->resourceType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlRequestInfoFunc_setHttpHeader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlRequestInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.setHttpHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setHttpHeader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEngineUrlRequestInfo::setHttpHeader(QByteArray,QByteArray)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setHttpHeader(QByteArray,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlRequestInfoFunc_setHttpHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setHttpHeader(QByteArray,QByteArray)
            cppSelf->setHttpHeader(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineUrlRequestInfoFunc_setHttpHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QWebEngineUrlRequestInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineUrlRequestInfo_methods[] = {
    {"block", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_block), METH_O},
    {"changed", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_changed), METH_NOARGS},
    {"firstPartyUrl", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_firstPartyUrl), METH_NOARGS},
    {"initiator", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_initiator), METH_NOARGS},
    {"navigationType", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_navigationType), METH_NOARGS},
    {"redirect", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_redirect), METH_O},
    {"requestMethod", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_requestMethod), METH_NOARGS},
    {"requestUrl", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_requestUrl), METH_NOARGS},
    {"resourceType", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_resourceType), METH_NOARGS},
    {"setHttpHeader", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlRequestInfoFunc_setHttpHeader), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QWebEngineUrlRequestInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineUrlRequestInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineUrlRequestInfo_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineUrlRequestInfo_TypeF(void)
{
    return _Sbk_QWebEngineUrlRequestInfo_Type;
}

static PyType_Slot Sbk_QWebEngineUrlRequestInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineUrlRequestInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineUrlRequestInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineUrlRequestInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineUrlRequestInfo_spec = {
    "2:PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineUrlRequestInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEngineUrlRequestInfo_ResourceType_PythonToCpp_QWebEngineUrlRequestInfo_ResourceType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineUrlRequestInfo::ResourceType *>(cppOut) =
        static_cast<::QWebEngineUrlRequestInfo::ResourceType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineUrlRequestInfo_ResourceType_PythonToCpp_QWebEngineUrlRequestInfo_ResourceType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX]))
        return QWebEngineUrlRequestInfo_ResourceType_PythonToCpp_QWebEngineUrlRequestInfo_ResourceType;
    return {};
}
static PyObject *QWebEngineUrlRequestInfo_ResourceType_CppToPython_QWebEngineUrlRequestInfo_ResourceType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineUrlRequestInfo::ResourceType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX], castCppIn);

}

static void QWebEngineUrlRequestInfo_NavigationType_PythonToCpp_QWebEngineUrlRequestInfo_NavigationType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineUrlRequestInfo::NavigationType *>(cppOut) =
        static_cast<::QWebEngineUrlRequestInfo::NavigationType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineUrlRequestInfo_NavigationType_PythonToCpp_QWebEngineUrlRequestInfo_NavigationType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX]))
        return QWebEngineUrlRequestInfo_NavigationType_PythonToCpp_QWebEngineUrlRequestInfo_NavigationType;
    return {};
}
static PyObject *QWebEngineUrlRequestInfo_NavigationType_CppToPython_QWebEngineUrlRequestInfo_NavigationType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineUrlRequestInfo::NavigationType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineUrlRequestInfo_PythonToCpp_QWebEngineUrlRequestInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineUrlRequestInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineUrlRequestInfo_PythonToCpp_QWebEngineUrlRequestInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineUrlRequestInfo_TypeF())))
        return QWebEngineUrlRequestInfo_PythonToCpp_QWebEngineUrlRequestInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineUrlRequestInfo_PTR_CppToPython_QWebEngineUrlRequestInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebEngineUrlRequestInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebEngineUrlRequestInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineUrlRequestInfo_SignatureStrings[] = {
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.block(self,shouldBlock:bool)",
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.changed(self)->bool",
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.firstPartyUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.initiator(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.navigationType(self)->PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.NavigationType",
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.redirect(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.requestMethod(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.requestUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.resourceType(self)->PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.ResourceType",
    "PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.setHttpHeader(self,name:PySide2.QtCore.QByteArray,value:PySide2.QtCore.QByteArray)",
    nullptr}; // Sentinel

void init_QWebEngineUrlRequestInfo(PyObject *module)
{
    _Sbk_QWebEngineUrlRequestInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineUrlRequestInfo",
        "QWebEngineUrlRequestInfo*",
        &Sbk_QWebEngineUrlRequestInfo_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineUrlRequestInfo_Type);
    InitSignatureStrings(pyType, QWebEngineUrlRequestInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineUrlRequestInfo_Type), Sbk_QWebEngineUrlRequestInfo_PropertyStrings);
    SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineUrlRequestInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineUrlRequestInfo_TypeF(),
        QWebEngineUrlRequestInfo_PythonToCpp_QWebEngineUrlRequestInfo_PTR,
        is_QWebEngineUrlRequestInfo_PythonToCpp_QWebEngineUrlRequestInfo_PTR_Convertible,
        QWebEngineUrlRequestInfo_PTR_CppToPython_QWebEngineUrlRequestInfo);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlRequestInfo");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlRequestInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlRequestInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineUrlRequestInfo).name());


    // Initialization of enums.

    // Initialization of enum 'ResourceType'.
    SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineUrlRequestInfo_TypeF(),
        "ResourceType",
        "2:PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.ResourceType",
        "QWebEngineUrlRequestInfo::ResourceType");
    if (!SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeMainFrame", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeMainFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeSubFrame", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeSubFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeStylesheet", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeStylesheet))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeScript", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeImage", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeImage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeFontResource", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeFontResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeSubResource", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeSubResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeObject", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeObject))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeMedia", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeMedia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeWorker", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeWorker))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeSharedWorker", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeSharedWorker))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypePrefetch", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypePrefetch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeFavicon", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeFavicon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeXhr", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeXhr))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypePing", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypePing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeServiceWorker", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeServiceWorker))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeCspReport", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeCspReport))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypePluginResource", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypePluginResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeNavigationPreloadMainFrame", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeNavigationPreloadMainFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeNavigationPreloadSubFrame", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeNavigationPreloadSubFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeLast", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeLast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "ResourceTypeUnknown", (long) QWebEngineUrlRequestInfo::ResourceType::ResourceTypeUnknown))
        return;
    // Register converter for enum 'QWebEngineUrlRequestInfo::ResourceType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX],
            QWebEngineUrlRequestInfo_ResourceType_CppToPython_QWebEngineUrlRequestInfo_ResourceType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineUrlRequestInfo_ResourceType_PythonToCpp_QWebEngineUrlRequestInfo_ResourceType,
            is_QWebEngineUrlRequestInfo_ResourceType_PythonToCpp_QWebEngineUrlRequestInfo_ResourceType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_RESOURCETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlRequestInfo::ResourceType");
        Shiboken::Conversions::registerConverterName(converter, "ResourceType");
    }
    // End of 'ResourceType' enum.

    // Initialization of enum 'NavigationType'.
    SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineUrlRequestInfo_TypeF(),
        "NavigationType",
        "2:PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.NavigationType",
        "QWebEngineUrlRequestInfo::NavigationType");
    if (!SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "NavigationTypeLink", (long) QWebEngineUrlRequestInfo::NavigationType::NavigationTypeLink))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "NavigationTypeTyped", (long) QWebEngineUrlRequestInfo::NavigationType::NavigationTypeTyped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "NavigationTypeFormSubmitted", (long) QWebEngineUrlRequestInfo::NavigationType::NavigationTypeFormSubmitted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "NavigationTypeBackForward", (long) QWebEngineUrlRequestInfo::NavigationType::NavigationTypeBackForward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "NavigationTypeReload", (long) QWebEngineUrlRequestInfo::NavigationType::NavigationTypeReload))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "NavigationTypeOther", (long) QWebEngineUrlRequestInfo::NavigationType::NavigationTypeOther))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX],
        Sbk_QWebEngineUrlRequestInfo_TypeF(), "NavigationTypeRedirect", (long) QWebEngineUrlRequestInfo::NavigationType::NavigationTypeRedirect))
        return;
    // Register converter for enum 'QWebEngineUrlRequestInfo::NavigationType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX],
            QWebEngineUrlRequestInfo_NavigationType_CppToPython_QWebEngineUrlRequestInfo_NavigationType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineUrlRequestInfo_NavigationType_PythonToCpp_QWebEngineUrlRequestInfo_NavigationType,
            is_QWebEngineUrlRequestInfo_NavigationType_PythonToCpp_QWebEngineUrlRequestInfo_NavigationType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINFO_NAVIGATIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlRequestInfo::NavigationType");
        Shiboken::Conversions::registerConverterName(converter, "NavigationType");
    }
    // End of 'NavigationType' enum.

    qRegisterMetaType< ::QWebEngineUrlRequestInfo::ResourceType >("QWebEngineUrlRequestInfo::ResourceType");
    qRegisterMetaType< ::QWebEngineUrlRequestInfo::NavigationType >("QWebEngineUrlRequestInfo::NavigationType");
}
