/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebenginewidgets_python.h"

// main header
#include "qwebenginecertificateerror_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtNetwork/qsslcertificate.h>
#include <QtWebEngineWidgets/qwebenginecertificateerror.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebEngineCertificateError_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebEngineCertificateError >()))
        return -1;

    ::QWebEngineCertificateError *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QWebEngineCertificateError_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QWebEngineCertificateError", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QWebEngineCertificateError::QWebEngineCertificateError(QWebEngineCertificateError)
    // 1: QWebEngineCertificateError::QWebEngineCertificateError(int,QUrl,bool,QString)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
        overloadId = 1; // QWebEngineCertificateError(int,QUrl,bool,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QWebEngineCertificateError(QWebEngineCertificateError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineCertificateError_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QWebEngineCertificateError(const QWebEngineCertificateError & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWebEngineCertificateError *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QWebEngineCertificateError(QWebEngineCertificateError)
                cptr = new ::QWebEngineCertificateError(*cppArg0);
            }
            break;
        }
        case 1: // QWebEngineCertificateError(int error, QUrl url, bool overridable, QString errorDescription)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QUrl cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            bool cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QWebEngineCertificateError(int,QUrl,bool,QString)
                cptr = new ::QWebEngineCertificateError(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebEngineCertificateError >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebEngineCertificateError_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QWebEngineCertificateError_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_answered(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.answered";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // answered()const
            bool cppResult = const_cast<const ::QWebEngineCertificateError *>(cppSelf)->answered();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_certificateChain(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.certificateChain";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // certificateChain()const
            QList<QSslCertificate > cppResult = const_cast<const ::QWebEngineCertificateError *>(cppSelf)->certificateChain();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWebEngineWidgetsTypeConverters[SBK_QTWEBENGINEWIDGETS_QLIST_QSSLCERTIFICATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_defer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.defer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defer()
            cppSelf->defer();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_deferred(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.deferred";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deferred()const
            bool cppResult = const_cast<const ::QWebEngineCertificateError *>(cppSelf)->deferred();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QWebEngineCertificateError::Error cppResult = const_cast<const ::QWebEngineCertificateError *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_errorDescription(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.errorDescription";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorDescription()const
            QString cppResult = const_cast<const ::QWebEngineCertificateError *>(cppSelf)->errorDescription();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_ignoreCertificateError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.ignoreCertificateError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ignoreCertificateError()
            cppSelf->ignoreCertificateError();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_isOverridable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.isOverridable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOverridable()const
            bool cppResult = const_cast<const ::QWebEngineCertificateError *>(cppSelf)->isOverridable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_rejectCertificate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.rejectCertificate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rejectCertificate()
            cppSelf->rejectCertificate();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineCertificateErrorFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineCertificateError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::QWebEngineCertificateError *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEngineCertificateError_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineCertificateError_methods[] = {
    {"answered", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_answered), METH_NOARGS},
    {"certificateChain", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_certificateChain), METH_NOARGS},
    {"defer", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_defer), METH_NOARGS},
    {"deferred", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_deferred), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_error), METH_NOARGS},
    {"errorDescription", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_errorDescription), METH_NOARGS},
    {"ignoreCertificateError", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_ignoreCertificateError), METH_NOARGS},
    {"isOverridable", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_isOverridable), METH_NOARGS},
    {"rejectCertificate", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_rejectCertificate), METH_NOARGS},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QWebEngineCertificateErrorFunc_url), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QWebEngineCertificateError_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineCertificateError_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineCertificateError_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineCertificateError_TypeF(void)
{
    return _Sbk_QWebEngineCertificateError_Type;
}

static PyType_Slot Sbk_QWebEngineCertificateError_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineCertificateError_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineCertificateError_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineCertificateError_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebEngineCertificateError_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineCertificateError_spec = {
    "2:PySide2.QtWebEngineWidgets.QWebEngineCertificateError",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineCertificateError_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEngineCertificateError_Error_PythonToCpp_QWebEngineCertificateError_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineCertificateError::Error *>(cppOut) =
        static_cast<::QWebEngineCertificateError::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineCertificateError_Error_PythonToCpp_QWebEngineCertificateError_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX]))
        return QWebEngineCertificateError_Error_PythonToCpp_QWebEngineCertificateError_Error;
    return {};
}
static PyObject *QWebEngineCertificateError_Error_CppToPython_QWebEngineCertificateError_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineCertificateError::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineCertificateError_PythonToCpp_QWebEngineCertificateError_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineCertificateError_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineCertificateError_PythonToCpp_QWebEngineCertificateError_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineCertificateError_TypeF())))
        return QWebEngineCertificateError_PythonToCpp_QWebEngineCertificateError_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineCertificateError_PTR_CppToPython_QWebEngineCertificateError(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebEngineCertificateError *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebEngineCertificateError_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineCertificateError_SignatureStrings[] = {
    "1:PySide2.QtWebEngineWidgets.QWebEngineCertificateError(self,other:PySide2.QtWebEngineWidgets.QWebEngineCertificateError)",
    "0:PySide2.QtWebEngineWidgets.QWebEngineCertificateError(self,error:int,url:PySide2.QtCore.QUrl,overridable:bool,errorDescription:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.answered(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.certificateChain(self)->QList[PySide2.QtNetwork.QSslCertificate]",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.defer(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.deferred(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.error(self)->PySide2.QtWebEngineWidgets.QWebEngineCertificateError.Error",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.errorDescription(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.ignoreCertificateError(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.isOverridable(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.rejectCertificate(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineCertificateError.url(self)->PySide2.QtCore.QUrl",
    nullptr}; // Sentinel

void init_QWebEngineCertificateError(PyObject *module)
{
    _Sbk_QWebEngineCertificateError_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineCertificateError",
        "QWebEngineCertificateError*",
        &Sbk_QWebEngineCertificateError_spec,
        &Shiboken::callCppDestructor< ::QWebEngineCertificateError >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineCertificateError_Type);
    InitSignatureStrings(pyType, QWebEngineCertificateError_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineCertificateError_Type), Sbk_QWebEngineCertificateError_PropertyStrings);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineCertificateError_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineCertificateError_TypeF(),
        QWebEngineCertificateError_PythonToCpp_QWebEngineCertificateError_PTR,
        is_QWebEngineCertificateError_PythonToCpp_QWebEngineCertificateError_PTR_Convertible,
        QWebEngineCertificateError_PTR_CppToPython_QWebEngineCertificateError);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineCertificateError");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineCertificateError*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineCertificateError&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineCertificateError).name());


    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineCertificateError_TypeF(),
        "Error",
        "2:PySide2.QtWebEngineWidgets.QWebEngineCertificateError.Error",
        "QWebEngineCertificateError::Error");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "SslPinnedKeyNotInCertificateChain", (long) QWebEngineCertificateError::Error::SslPinnedKeyNotInCertificateChain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateCommonNameInvalid", (long) QWebEngineCertificateError::Error::CertificateCommonNameInvalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateDateInvalid", (long) QWebEngineCertificateError::Error::CertificateDateInvalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateAuthorityInvalid", (long) QWebEngineCertificateError::Error::CertificateAuthorityInvalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateContainsErrors", (long) QWebEngineCertificateError::Error::CertificateContainsErrors))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateNoRevocationMechanism", (long) QWebEngineCertificateError::Error::CertificateNoRevocationMechanism))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateUnableToCheckRevocation", (long) QWebEngineCertificateError::Error::CertificateUnableToCheckRevocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateRevoked", (long) QWebEngineCertificateError::Error::CertificateRevoked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateInvalid", (long) QWebEngineCertificateError::Error::CertificateInvalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateWeakSignatureAlgorithm", (long) QWebEngineCertificateError::Error::CertificateWeakSignatureAlgorithm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateNonUniqueName", (long) QWebEngineCertificateError::Error::CertificateNonUniqueName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateWeakKey", (long) QWebEngineCertificateError::Error::CertificateWeakKey))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateNameConstraintViolation", (long) QWebEngineCertificateError::Error::CertificateNameConstraintViolation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateValidityTooLong", (long) QWebEngineCertificateError::Error::CertificateValidityTooLong))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateTransparencyRequired", (long) QWebEngineCertificateError::Error::CertificateTransparencyRequired))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
        Sbk_QWebEngineCertificateError_TypeF(), "CertificateKnownInterceptionBlocked", (long) QWebEngineCertificateError::Error::CertificateKnownInterceptionBlocked))
        return;
    // Register converter for enum 'QWebEngineCertificateError::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX],
            QWebEngineCertificateError_Error_CppToPython_QWebEngineCertificateError_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineCertificateError_Error_PythonToCpp_QWebEngineCertificateError_Error,
            is_QWebEngineCertificateError_Error_PythonToCpp_QWebEngineCertificateError_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineCertificateError::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    qRegisterMetaType< ::QWebEngineCertificateError::Error >("QWebEngineCertificateError::Error");
}
