/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwebenginewidgets_python.h"

// main header
#include "qwebengineprofile_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QWebEngineProfileWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QWebEngineProfileWrapper::QWebEngineProfileWrapper(::QObject * parent) : QWebEngineProfile(parent)
{
    resetPyMethodCache();
    // ... middle
}

QWebEngineProfileWrapper::QWebEngineProfileWrapper(const ::QString & name, ::QObject * parent) : QWebEngineProfile(name, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QWebEngineProfileWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebEngineProfileWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QWebEngineProfileWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebEngineProfileWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QWebEngineProfileWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEngineProfile.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QWebEngineProfileWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEngineProfile.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QWebEngineProfileWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QWebEngineProfileWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QWebEngineProfile::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QWebEngineProfileWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QWebEngineProfile::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QWebEngineProfileWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QWebEngineProfileWrapper *>(this));
        return QWebEngineProfile::qt_metacast(_clname);
}

QWebEngineProfileWrapper::~QWebEngineProfileWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebEngineProfile_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebEngineProfile >()))
        return -1;

    ::QWebEngineProfileWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QWebEngineProfile", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QWebEngineProfile::QWebEngineProfile(QObject*)
    // 1: QWebEngineProfile::QWebEngineProfile(QString,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QWebEngineProfile(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QWebEngineProfile(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QWebEngineProfile(QString,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QWebEngineProfile(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfile_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QWebEngineProfile(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QWebEngineProfile_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QWebEngineProfile_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = Q_NULLPTR;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QWebEngineProfile(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QWebEngineProfileWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QWebEngineProfileWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QWebEngineProfile(const QString & name, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QWebEngineProfile_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QWebEngineProfile_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = Q_NULLPTR;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QWebEngineProfile(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QWebEngineProfileWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QWebEngineProfileWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebEngineProfile >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebEngineProfile_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QWebEngineProfile_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QWebEngineProfile_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebEngineProfileFunc_cachePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.cachePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cachePath()const
            QString cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->cachePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_clearAllVisitedLinks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.clearAllVisitedLinks";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearAllVisitedLinks()
            cppSelf->clearAllVisitedLinks();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineProfileFunc_clearHttpCache(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.clearHttpCache";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearHttpCache()
            cppSelf->clearHttpCache();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineProfileFunc_clearVisitedLinks(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.clearVisitedLinks";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::clearVisitedLinks(QList<QUrl>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWebEngineWidgetsTypeConverters[SBK_QTWEBENGINEWIDGETS_QLIST_QURL_IDX], (pyArg)))) {
        overloadId = 0; // clearVisitedLinks(QList<QUrl>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_clearVisitedLinks_TypeError;

    // Call function/method
    {
        ::QList<QUrl > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // clearVisitedLinks(QList<QUrl>)
            cppSelf->clearVisitedLinks(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_clearVisitedLinks_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_cookieStore(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.cookieStore";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cookieStore()
            QWebEngineCookieStore * cppResult = cppSelf->cookieStore();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINECOOKIESTORE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_defaultProfile(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.defaultProfile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultProfile()
            QWebEngineProfile * cppResult = ::QWebEngineProfile::defaultProfile();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_downloadPath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.downloadPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // downloadPath()const
            QString cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->downloadPath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_httpAcceptLanguage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.httpAcceptLanguage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // httpAcceptLanguage()const
            QString cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->httpAcceptLanguage();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_httpCacheMaximumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.httpCacheMaximumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // httpCacheMaximumSize()const
            int cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->httpCacheMaximumSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_httpCacheType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.httpCacheType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // httpCacheType()const
            QWebEngineProfile::HttpCacheType cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->httpCacheType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_httpUserAgent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.httpUserAgent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // httpUserAgent()const
            QString cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->httpUserAgent();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_installUrlSchemeHandler(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.installUrlSchemeHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "installUrlSchemeHandler", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEngineProfile::installUrlSchemeHandler(QByteArray,QWebEngineUrlSchemeHandler*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEMEHANDLER_IDX]), (pyArgs[1])))) {
        overloadId = 0; // installUrlSchemeHandler(QByteArray,QWebEngineUrlSchemeHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_installUrlSchemeHandler_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWebEngineUrlSchemeHandler *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // installUrlSchemeHandler(QByteArray,QWebEngineUrlSchemeHandler*)
            cppSelf->installUrlSchemeHandler(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_installUrlSchemeHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_isOffTheRecord(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.isOffTheRecord";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOffTheRecord()const
            bool cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->isOffTheRecord();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_isSpellCheckEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.isSpellCheckEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSpellCheckEnabled()const
            bool cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->isSpellCheckEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_isUsedForGlobalCertificateVerification(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.isUsedForGlobalCertificateVerification";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUsedForGlobalCertificateVerification()const
            bool cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->isUsedForGlobalCertificateVerification();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_persistentCookiesPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.persistentCookiesPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // persistentCookiesPolicy()const
            QWebEngineProfile::PersistentCookiesPolicy cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->persistentCookiesPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_persistentStoragePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.persistentStoragePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // persistentStoragePath()const
            QString cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->persistentStoragePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_removeAllUrlSchemeHandlers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.removeAllUrlSchemeHandlers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeAllUrlSchemeHandlers()
            cppSelf->removeAllUrlSchemeHandlers();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineProfileFunc_removeUrlScheme(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.removeUrlScheme";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::removeUrlScheme(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // removeUrlScheme(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_removeUrlScheme_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeUrlScheme(QByteArray)
            cppSelf->removeUrlScheme(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_removeUrlScheme_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_removeUrlSchemeHandler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.removeUrlSchemeHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::removeUrlSchemeHandler(QWebEngineUrlSchemeHandler*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEMEHANDLER_IDX]), (pyArg)))) {
        overloadId = 0; // removeUrlSchemeHandler(QWebEngineUrlSchemeHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_removeUrlSchemeHandler_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineUrlSchemeHandler *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeUrlSchemeHandler(QWebEngineUrlSchemeHandler*)
            cppSelf->removeUrlSchemeHandler(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_removeUrlSchemeHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_scripts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.scripts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scripts()const
            QWebEngineScriptCollection * cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->scripts();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_setCachePath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setCachePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setCachePath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCachePath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setCachePath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCachePath(QString)
            cppSelf->setCachePath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setCachePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setDownloadPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setDownloadPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setDownloadPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDownloadPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setDownloadPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDownloadPath(QString)
            cppSelf->setDownloadPath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setDownloadPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setHttpAcceptLanguage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setHttpAcceptLanguage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setHttpAcceptLanguage(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setHttpAcceptLanguage(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setHttpAcceptLanguage_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHttpAcceptLanguage(QString)
            cppSelf->setHttpAcceptLanguage(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setHttpAcceptLanguage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setHttpCacheMaximumSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setHttpCacheMaximumSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setHttpCacheMaximumSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHttpCacheMaximumSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setHttpCacheMaximumSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHttpCacheMaximumSize(int)
            cppSelf->setHttpCacheMaximumSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setHttpCacheMaximumSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setHttpCacheType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setHttpCacheType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setHttpCacheType(QWebEngineProfile::HttpCacheType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setHttpCacheType(QWebEngineProfile::HttpCacheType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setHttpCacheType_TypeError;

    // Call function/method
    {
        ::QWebEngineProfile::HttpCacheType cppArg0{QWebEngineProfile::MemoryHttpCache};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHttpCacheType(QWebEngineProfile::HttpCacheType)
            cppSelf->setHttpCacheType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setHttpCacheType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setHttpUserAgent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setHttpUserAgent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setHttpUserAgent(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setHttpUserAgent(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setHttpUserAgent_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHttpUserAgent(QString)
            cppSelf->setHttpUserAgent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setHttpUserAgent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setPersistentCookiesPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setPersistentCookiesPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setPersistentCookiesPolicy(QWebEngineProfile::PersistentCookiesPolicy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPersistentCookiesPolicy(QWebEngineProfile::PersistentCookiesPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setPersistentCookiesPolicy_TypeError;

    // Call function/method
    {
        ::QWebEngineProfile::PersistentCookiesPolicy cppArg0{QWebEngineProfile::NoPersistentCookies};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPersistentCookiesPolicy(QWebEngineProfile::PersistentCookiesPolicy)
            cppSelf->setPersistentCookiesPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setPersistentCookiesPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setPersistentStoragePath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setPersistentStoragePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setPersistentStoragePath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPersistentStoragePath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setPersistentStoragePath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPersistentStoragePath(QString)
            cppSelf->setPersistentStoragePath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setPersistentStoragePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setRequestInterceptor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setRequestInterceptor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setRequestInterceptor(QWebEngineUrlRequestInterceptor*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINTERCEPTOR_IDX]), (pyArg)))) {
        overloadId = 0; // setRequestInterceptor(QWebEngineUrlRequestInterceptor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setRequestInterceptor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineUrlRequestInterceptor *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRequestInterceptor(QWebEngineUrlRequestInterceptor*)
            cppSelf->setRequestInterceptor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setRequestInterceptor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setSpellCheckEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setSpellCheckEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setSpellCheckEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSpellCheckEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setSpellCheckEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSpellCheckEnabled(bool)
            cppSelf->setSpellCheckEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setSpellCheckEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setSpellCheckLanguages(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setSpellCheckLanguages";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setSpellCheckLanguages(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setSpellCheckLanguages(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setSpellCheckLanguages_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSpellCheckLanguages(QStringList)
            cppSelf->setSpellCheckLanguages(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setSpellCheckLanguages_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setUrlRequestInterceptor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setUrlRequestInterceptor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINTERCEPTOR_IDX]), (pyArg)))) {
        overloadId = 0; // setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setUrlRequestInterceptor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineUrlRequestInterceptor *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)
            cppSelf->setUrlRequestInterceptor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setUrlRequestInterceptor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_setUseForGlobalCertificateVerification(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.setUseForGlobalCertificateVerification";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebEngineProfileFunc_setUseForGlobalCertificateVerification_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setUseForGlobalCertificateVerification", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QWebEngineProfile::setUseForGlobalCertificateVerification(bool)
    if (numArgs == 0) {
        overloadId = 0; // setUseForGlobalCertificateVerification(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setUseForGlobalCertificateVerification(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_setUseForGlobalCertificateVerification_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_enabled = Shiboken::String::createStaticString("enabled");
            if (PyDict_Contains(kwds, key_enabled)) {
                value = PyDict_GetItem(kwds, key_enabled);
                if (value && pyArgs[0]) {
                    errInfo = key_enabled;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebEngineProfileFunc_setUseForGlobalCertificateVerification_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QWebEngineProfileFunc_setUseForGlobalCertificateVerification_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_enabled);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QWebEngineProfileFunc_setUseForGlobalCertificateVerification_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setUseForGlobalCertificateVerification(bool)
            cppSelf->setUseForGlobalCertificateVerification(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineProfileFunc_setUseForGlobalCertificateVerification_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_settings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.settings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // settings()const
            QWebEngineSettings * cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->settings();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_spellCheckLanguages(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.spellCheckLanguages";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // spellCheckLanguages()const
            QStringList cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->spellCheckLanguages();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_storageName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.storageName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // storageName()const
            QString cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->storageName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineProfileFunc_urlSchemeHandler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.urlSchemeHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::urlSchemeHandler(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // urlSchemeHandler(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_urlSchemeHandler_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // urlSchemeHandler(QByteArray)const
            const QWebEngineUrlSchemeHandler * cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->urlSchemeHandler(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEMEHANDLER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineProfileFunc_urlSchemeHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineProfileFunc_visitedLinksContainsUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineProfile.visitedLinksContainsUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineProfile::visitedLinksContainsUrl(QUrl)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // visitedLinksContainsUrl(QUrl)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineProfileFunc_visitedLinksContainsUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // visitedLinksContainsUrl(QUrl)const
            bool cppResult = const_cast<const ::QWebEngineProfile *>(cppSelf)->visitedLinksContainsUrl(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineProfileFunc_visitedLinksContainsUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QWebEngineProfile_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineProfile_methods[] = {
    {"cachePath", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_cachePath), METH_NOARGS},
    {"clearAllVisitedLinks", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_clearAllVisitedLinks), METH_NOARGS},
    {"clearHttpCache", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_clearHttpCache), METH_NOARGS},
    {"clearVisitedLinks", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_clearVisitedLinks), METH_O},
    {"cookieStore", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_cookieStore), METH_NOARGS},
    {"defaultProfile", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_defaultProfile), METH_NOARGS|METH_STATIC},
    {"downloadPath", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_downloadPath), METH_NOARGS},
    {"httpAcceptLanguage", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_httpAcceptLanguage), METH_NOARGS},
    {"httpCacheMaximumSize", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_httpCacheMaximumSize), METH_NOARGS},
    {"httpCacheType", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_httpCacheType), METH_NOARGS},
    {"httpUserAgent", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_httpUserAgent), METH_NOARGS},
    {"installUrlSchemeHandler", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_installUrlSchemeHandler), METH_VARARGS},
    {"isOffTheRecord", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_isOffTheRecord), METH_NOARGS},
    {"isSpellCheckEnabled", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_isSpellCheckEnabled), METH_NOARGS},
    {"isUsedForGlobalCertificateVerification", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_isUsedForGlobalCertificateVerification), METH_NOARGS},
    {"persistentCookiesPolicy", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_persistentCookiesPolicy), METH_NOARGS},
    {"persistentStoragePath", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_persistentStoragePath), METH_NOARGS},
    {"removeAllUrlSchemeHandlers", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_removeAllUrlSchemeHandlers), METH_NOARGS},
    {"removeUrlScheme", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_removeUrlScheme), METH_O},
    {"removeUrlSchemeHandler", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_removeUrlSchemeHandler), METH_O},
    {"scripts", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_scripts), METH_NOARGS},
    {"setCachePath", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setCachePath), METH_O},
    {"setDownloadPath", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setDownloadPath), METH_O},
    {"setHttpAcceptLanguage", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setHttpAcceptLanguage), METH_O},
    {"setHttpCacheMaximumSize", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setHttpCacheMaximumSize), METH_O},
    {"setHttpCacheType", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setHttpCacheType), METH_O},
    {"setHttpUserAgent", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setHttpUserAgent), METH_O},
    {"setPersistentCookiesPolicy", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setPersistentCookiesPolicy), METH_O},
    {"setPersistentStoragePath", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setPersistentStoragePath), METH_O},
    {"setRequestInterceptor", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setRequestInterceptor), METH_O},
    {"setSpellCheckEnabled", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setSpellCheckEnabled), METH_O},
    {"setSpellCheckLanguages", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setSpellCheckLanguages), METH_O},
    {"setUrlRequestInterceptor", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setUrlRequestInterceptor), METH_O},
    {"setUseForGlobalCertificateVerification", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_setUseForGlobalCertificateVerification), METH_VARARGS|METH_KEYWORDS},
    {"settings", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_settings), METH_NOARGS},
    {"spellCheckLanguages", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_spellCheckLanguages), METH_NOARGS},
    {"storageName", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_storageName), METH_NOARGS},
    {"urlSchemeHandler", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_urlSchemeHandler), METH_O},
    {"visitedLinksContainsUrl", reinterpret_cast<PyCFunction>(Sbk_QWebEngineProfileFunc_visitedLinksContainsUrl), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QWebEngineProfile_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QWebEngineProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QWebEngineProfileWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QWebEngineProfile_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineProfile_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineProfile_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineProfile_TypeF(void)
{
    return _Sbk_QWebEngineProfile_Type;
}

static PyType_Slot Sbk_QWebEngineProfile_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QWebEngineProfile_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineProfile_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineProfile_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineProfile_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebEngineProfile_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineProfile_spec = {
    "2:PySide2.QtWebEngineWidgets.QWebEngineProfile",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineProfile_slots
};

} //extern "C"

static void *Sbk_QWebEngineProfile_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QWebEngineProfile *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEngineProfile_HttpCacheType_PythonToCpp_QWebEngineProfile_HttpCacheType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineProfile::HttpCacheType *>(cppOut) =
        static_cast<::QWebEngineProfile::HttpCacheType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineProfile_HttpCacheType_PythonToCpp_QWebEngineProfile_HttpCacheType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX]))
        return QWebEngineProfile_HttpCacheType_PythonToCpp_QWebEngineProfile_HttpCacheType;
    return {};
}
static PyObject *QWebEngineProfile_HttpCacheType_CppToPython_QWebEngineProfile_HttpCacheType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineProfile::HttpCacheType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX], castCppIn);

}

static void QWebEngineProfile_PersistentCookiesPolicy_PythonToCpp_QWebEngineProfile_PersistentCookiesPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineProfile::PersistentCookiesPolicy *>(cppOut) =
        static_cast<::QWebEngineProfile::PersistentCookiesPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineProfile_PersistentCookiesPolicy_PythonToCpp_QWebEngineProfile_PersistentCookiesPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX]))
        return QWebEngineProfile_PersistentCookiesPolicy_PythonToCpp_QWebEngineProfile_PersistentCookiesPolicy;
    return {};
}
static PyObject *QWebEngineProfile_PersistentCookiesPolicy_CppToPython_QWebEngineProfile_PersistentCookiesPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineProfile::PersistentCookiesPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineProfile_PythonToCpp_QWebEngineProfile_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineProfile_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineProfile_PythonToCpp_QWebEngineProfile_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineProfile_TypeF())))
        return QWebEngineProfile_PythonToCpp_QWebEngineProfile_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineProfile_PTR_CppToPython_QWebEngineProfile(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QWebEngineProfile *>(const_cast<void *>(cppIn)), Sbk_QWebEngineProfile_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineProfile_SignatureStrings[] = {
    "1:PySide2.QtWebEngineWidgets.QWebEngineProfile(self,parent:PySide2.QtCore.QObject=Q_NULLPTR)",
    "0:PySide2.QtWebEngineWidgets.QWebEngineProfile(self,name:QString,parent:PySide2.QtCore.QObject=Q_NULLPTR)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.cachePath(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.clearAllVisitedLinks(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.clearHttpCache(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.clearVisitedLinks(self,urls:QList[PySide2.QtCore.QUrl])",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.cookieStore(self)->PySide2.QtWebEngineCore.QWebEngineCookieStore",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.defaultProfile()->PySide2.QtWebEngineWidgets.QWebEngineProfile",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.downloadPath(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.httpAcceptLanguage(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.httpCacheMaximumSize(self)->int",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.httpCacheType(self)->PySide2.QtWebEngineWidgets.QWebEngineProfile.HttpCacheType",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.httpUserAgent(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.installUrlSchemeHandler(self,scheme:PySide2.QtCore.QByteArray,arg__2:PySide2.QtWebEngineCore.QWebEngineUrlSchemeHandler)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.isOffTheRecord(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.isSpellCheckEnabled(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.isUsedForGlobalCertificateVerification(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.persistentCookiesPolicy(self)->PySide2.QtWebEngineWidgets.QWebEngineProfile.PersistentCookiesPolicy",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.persistentStoragePath(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.removeAllUrlSchemeHandlers(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.removeUrlScheme(self,scheme:PySide2.QtCore.QByteArray)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.removeUrlSchemeHandler(self,arg__1:PySide2.QtWebEngineCore.QWebEngineUrlSchemeHandler)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.scripts(self)->PySide2.QtWebEngineWidgets.QWebEngineScriptCollection",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setCachePath(self,path:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setDownloadPath(self,path:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setHttpAcceptLanguage(self,httpAcceptLanguage:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setHttpCacheMaximumSize(self,maxSize:int)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setHttpCacheType(self,arg__1:PySide2.QtWebEngineWidgets.QWebEngineProfile.HttpCacheType)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setHttpUserAgent(self,userAgent:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setPersistentCookiesPolicy(self,arg__1:PySide2.QtWebEngineWidgets.QWebEngineProfile.PersistentCookiesPolicy)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setPersistentStoragePath(self,path:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setRequestInterceptor(self,interceptor:PySide2.QtWebEngineCore.QWebEngineUrlRequestInterceptor)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setSpellCheckEnabled(self,enabled:bool)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setSpellCheckLanguages(self,languages:QStringList)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setUrlRequestInterceptor(self,interceptor:PySide2.QtWebEngineCore.QWebEngineUrlRequestInterceptor)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.setUseForGlobalCertificateVerification(self,enabled:bool=true)",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.settings(self)->PySide2.QtWebEngineWidgets.QWebEngineSettings",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.spellCheckLanguages(self)->QStringList",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.storageName(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.urlSchemeHandler(self,arg__1:PySide2.QtCore.QByteArray)->PySide2.QtWebEngineCore.QWebEngineUrlSchemeHandler",
    "PySide2.QtWebEngineWidgets.QWebEngineProfile.visitedLinksContainsUrl(self,url:PySide2.QtCore.QUrl)->bool",
    nullptr}; // Sentinel

void init_QWebEngineProfile(PyObject *module)
{
    _Sbk_QWebEngineProfile_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineProfile",
        "QWebEngineProfile*",
        &Sbk_QWebEngineProfile_spec,
        &Shiboken::callCppDestructor< ::QWebEngineProfile >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineProfile_Type);
    InitSignatureStrings(pyType, QWebEngineProfile_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineProfile_Type), Sbk_QWebEngineProfile_PropertyStrings);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineProfile_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineProfile_TypeF(),
        QWebEngineProfile_PythonToCpp_QWebEngineProfile_PTR,
        is_QWebEngineProfile_PythonToCpp_QWebEngineProfile_PTR_Convertible,
        QWebEngineProfile_PTR_CppToPython_QWebEngineProfile);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineProfile");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineProfile*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineProfile&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineProfile).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineProfileWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QWebEngineProfile_TypeF(), &Sbk_QWebEngineProfile_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'HttpCacheType'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineProfile_TypeF(),
        "HttpCacheType",
        "2:PySide2.QtWebEngineWidgets.QWebEngineProfile.HttpCacheType",
        "QWebEngineProfile::HttpCacheType");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX],
        Sbk_QWebEngineProfile_TypeF(), "MemoryHttpCache", (long) QWebEngineProfile::HttpCacheType::MemoryHttpCache))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX],
        Sbk_QWebEngineProfile_TypeF(), "DiskHttpCache", (long) QWebEngineProfile::HttpCacheType::DiskHttpCache))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX],
        Sbk_QWebEngineProfile_TypeF(), "NoCache", (long) QWebEngineProfile::HttpCacheType::NoCache))
        return;
    // Register converter for enum 'QWebEngineProfile::HttpCacheType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX],
            QWebEngineProfile_HttpCacheType_CppToPython_QWebEngineProfile_HttpCacheType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineProfile_HttpCacheType_PythonToCpp_QWebEngineProfile_HttpCacheType,
            is_QWebEngineProfile_HttpCacheType_PythonToCpp_QWebEngineProfile_HttpCacheType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_HTTPCACHETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineProfile::HttpCacheType");
        Shiboken::Conversions::registerConverterName(converter, "HttpCacheType");
    }
    // End of 'HttpCacheType' enum.

    // Initialization of enum 'PersistentCookiesPolicy'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineProfile_TypeF(),
        "PersistentCookiesPolicy",
        "2:PySide2.QtWebEngineWidgets.QWebEngineProfile.PersistentCookiesPolicy",
        "QWebEngineProfile::PersistentCookiesPolicy");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX],
        Sbk_QWebEngineProfile_TypeF(), "NoPersistentCookies", (long) QWebEngineProfile::PersistentCookiesPolicy::NoPersistentCookies))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX],
        Sbk_QWebEngineProfile_TypeF(), "AllowPersistentCookies", (long) QWebEngineProfile::PersistentCookiesPolicy::AllowPersistentCookies))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX],
        Sbk_QWebEngineProfile_TypeF(), "ForcePersistentCookies", (long) QWebEngineProfile::PersistentCookiesPolicy::ForcePersistentCookies))
        return;
    // Register converter for enum 'QWebEngineProfile::PersistentCookiesPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX],
            QWebEngineProfile_PersistentCookiesPolicy_CppToPython_QWebEngineProfile_PersistentCookiesPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineProfile_PersistentCookiesPolicy_PythonToCpp_QWebEngineProfile_PersistentCookiesPolicy,
            is_QWebEngineProfile_PersistentCookiesPolicy_PythonToCpp_QWebEngineProfile_PersistentCookiesPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_PERSISTENTCOOKIESPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineProfile::PersistentCookiesPolicy");
        Shiboken::Conversions::registerConverterName(converter, "PersistentCookiesPolicy");
    }
    // End of 'PersistentCookiesPolicy' enum.

    PySide::Signal::registerSignals(Sbk_QWebEngineProfile_TypeF(), &::QWebEngineProfile::staticMetaObject);
    qRegisterMetaType< ::QWebEngineProfile::HttpCacheType >("QWebEngineProfile::HttpCacheType");
    qRegisterMetaType< ::QWebEngineProfile::PersistentCookiesPolicy >("QWebEngineProfile::PersistentCookiesPolicy");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QWebEngineProfile_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QWebEngineProfile_TypeF(), &::QWebEngineProfile::staticMetaObject, sizeof(QWebEngineProfileWrapper));
}
