/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebenginewidgets_python.h"

// main header
#include "qwebenginescriptcollection_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtWebEngineWidgets/qwebenginescript.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QWebEngineScriptCollectionFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineScriptCollectionFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScriptCollection::contains(QWebEngineScript)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), (pyArg)))) {
        overloadId = 0; // contains(QWebEngineScript)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptCollectionFunc_contains_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineScript cppArg0_local;
        ::QWebEngineScript *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // contains(QWebEngineScript)const
            bool cppResult = const_cast<const ::QWebEngineScriptCollection *>(cppSelf)->contains(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineScriptCollectionFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptCollectionFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QWebEngineScriptCollection *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineScriptCollectionFunc_findScript(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.findScript";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScriptCollection::findScript(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // findScript(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptCollectionFunc_findScript_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // findScript(QString)const
            QWebEngineScript cppResult = const_cast<const ::QWebEngineScriptCollection *>(cppSelf)->findScript(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineScriptCollectionFunc_findScript_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptCollectionFunc_findScripts(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.findScripts";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScriptCollection::findScripts(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // findScripts(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptCollectionFunc_findScripts_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // findScripts(QString)const
            QList<QWebEngineScript > cppResult = const_cast<const ::QWebEngineScriptCollection *>(cppSelf)->findScripts(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWebEngineWidgetsTypeConverters[SBK_QTWEBENGINEWIDGETS_QLIST_QWEBENGINESCRIPT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineScriptCollectionFunc_findScripts_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptCollectionFunc_insert(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.insert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScriptCollection::insert(QList<QWebEngineScript>)
    // 1: QWebEngineScriptCollection::insert(QWebEngineScript)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), (pyArg)))) {
        overloadId = 1; // insert(QWebEngineScript)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWebEngineWidgetsTypeConverters[SBK_QTWEBENGINEWIDGETS_QLIST_QWEBENGINESCRIPT_IDX], (pyArg)))) {
        overloadId = 0; // insert(QList<QWebEngineScript>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptCollectionFunc_insert_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insert(const QList<QWebEngineScript > & list)
        {
            ::QList<QWebEngineScript > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // insert(QList<QWebEngineScript>)
                cppSelf->insert(cppArg0);
            }
            break;
        }
        case 1: // insert(const QWebEngineScript & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QWebEngineScript cppArg0_local;
            ::QWebEngineScript *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // insert(QWebEngineScript)
                cppSelf->insert(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineScriptCollectionFunc_insert_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptCollectionFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QWebEngineScriptCollection *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineScriptCollectionFunc_remove(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScriptCollection::remove(QWebEngineScript)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), (pyArg)))) {
        overloadId = 0; // remove(QWebEngineScript)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptCollectionFunc_remove_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineScript cppArg0_local;
        ::QWebEngineScript *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // remove(QWebEngineScript)
            bool cppResult = cppSelf->remove(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineScriptCollectionFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptCollectionFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QWebEngineScriptCollection *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineScriptCollectionFunc_toList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScriptCollection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.toList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toList()const
            QList<QWebEngineScript > cppResult = const_cast<const ::QWebEngineScriptCollection *>(cppSelf)->toList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWebEngineWidgetsTypeConverters[SBK_QTWEBENGINEWIDGETS_QLIST_QWEBENGINESCRIPT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEngineScriptCollection_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineScriptCollection_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_clear), METH_NOARGS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_contains), METH_O},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_count), METH_NOARGS},
    {"findScript", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_findScript), METH_O},
    {"findScripts", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_findScripts), METH_O},
    {"insert", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_insert), METH_O},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_isEmpty), METH_NOARGS},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_remove), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_size), METH_NOARGS},
    {"toList", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptCollectionFunc_toList), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QWebEngineScriptCollection_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineScriptCollection_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineScriptCollection_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineScriptCollection_TypeF(void)
{
    return _Sbk_QWebEngineScriptCollection_Type;
}

static PyType_Slot Sbk_QWebEngineScriptCollection_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineScriptCollection_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineScriptCollection_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineScriptCollection_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineScriptCollection_spec = {
    "2:PySide2.QtWebEngineWidgets.QWebEngineScriptCollection",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineScriptCollection_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineScriptCollection_PythonToCpp_QWebEngineScriptCollection_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineScriptCollection_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineScriptCollection_PythonToCpp_QWebEngineScriptCollection_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineScriptCollection_TypeF())))
        return QWebEngineScriptCollection_PythonToCpp_QWebEngineScriptCollection_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineScriptCollection_PTR_CppToPython_QWebEngineScriptCollection(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebEngineScriptCollection *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebEngineScriptCollection_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineScriptCollection_SignatureStrings[] = {
    "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.clear(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.contains(self,value:PySide2.QtWebEngineWidgets.QWebEngineScript)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.count(self)->int",
    "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.findScript(self,name:QString)->PySide2.QtWebEngineWidgets.QWebEngineScript",
    "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.findScripts(self,name:QString)->QList[PySide2.QtWebEngineWidgets.QWebEngineScript]",
    "1:PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.insert(self,list:QList[PySide2.QtWebEngineWidgets.QWebEngineScript])",
    "0:PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.insert(self,arg__1:PySide2.QtWebEngineWidgets.QWebEngineScript)",
    "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.isEmpty(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.remove(self,arg__1:PySide2.QtWebEngineWidgets.QWebEngineScript)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.size(self)->int",
    "PySide2.QtWebEngineWidgets.QWebEngineScriptCollection.toList(self)->QList[PySide2.QtWebEngineWidgets.QWebEngineScript]",
    nullptr}; // Sentinel

void init_QWebEngineScriptCollection(PyObject *module)
{
    _Sbk_QWebEngineScriptCollection_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineScriptCollection",
        "QWebEngineScriptCollection*",
        &Sbk_QWebEngineScriptCollection_spec,
        &Shiboken::callCppDestructor< ::QWebEngineScriptCollection >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineScriptCollection_Type);
    InitSignatureStrings(pyType, QWebEngineScriptCollection_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineScriptCollection_Type), Sbk_QWebEngineScriptCollection_PropertyStrings);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineScriptCollection_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineScriptCollection_TypeF(),
        QWebEngineScriptCollection_PythonToCpp_QWebEngineScriptCollection_PTR,
        is_QWebEngineScriptCollection_PythonToCpp_QWebEngineScriptCollection_PTR_Convertible,
        QWebEngineScriptCollection_PTR_CppToPython_QWebEngineScriptCollection);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineScriptCollection");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineScriptCollection*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineScriptCollection&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineScriptCollection).name());


}
