/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qabstractitemview_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractItemViewWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractItemViewWrapper::QAbstractItemViewWrapper(::QWidget * parent) : QAbstractItemView(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QAbstractItemViewWrapper::actionEvent(::QActionEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QWidget::actionEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "actionEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QWidget::actionEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACTIONEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::changeEvent(::QEvent * arg__1)
{
    if (m_PyMethodCache[1]) {
        return this->::QFrame::changeEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "changeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::closeEditor(::QWidget * editor, ::QAbstractItemDelegate::EndEditHint hint)
{
    if (m_PyMethodCache[3]) {
        return this->::QAbstractItemView::closeEditor(editor, hint);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "closeEditor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QAbstractItemView::closeEditor(editor, hint);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), editor),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_ENDEDITHINT_IDX])->converter, &hint)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::closeEvent(::QCloseEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QWidget::closeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "closeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QWidget::closeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCLOSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::commitData(::QWidget * editor)
{
    if (m_PyMethodCache[5]) {
        return this->::QAbstractItemView::commitData(editor);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "commitData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QAbstractItemView::commitData(editor);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), editor)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    if (m_PyMethodCache[7]) {
        return this->::QAbstractScrollArea::contextMenuEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contextMenuEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::currentChanged(const ::QModelIndex & current, const ::QModelIndex & previous)
{
    if (m_PyMethodCache[8]) {
        return this->::QAbstractItemView::currentChanged(current, previous);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "currentChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QAbstractItemView::currentChanged(current, previous);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &current),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &previous)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::dataChanged(const ::QModelIndex & topLeft, const ::QModelIndex & bottomRight, const ::QVector<int > & roles)
{
    if (m_PyMethodCache[10]) {
        return this->::QAbstractItemView::dataChanged(topLeft, bottomRight, roles);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dataChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QAbstractItemView::dataChanged(topLeft, bottomRight, roles);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &topLeft),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &bottomRight),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_INT_IDX], &roles)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

int QAbstractItemViewWrapper::devType() const
{
    if (m_PyMethodCache[11])
        return this->::QWidget::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QWidget::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[12]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::doItemsLayout()
{
    if (m_PyMethodCache[13]) {
        return this->::QAbstractItemView::doItemsLayout();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "doItemsLayout";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QAbstractItemView::doItemsLayout();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    if (m_PyMethodCache[14]) {
        return this->::QAbstractItemView::dragEnterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QAbstractItemView::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    if (m_PyMethodCache[15]) {
        return this->::QAbstractItemView::dragLeaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QAbstractItemView::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    if (m_PyMethodCache[16]) {
        return this->::QAbstractItemView::dragMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QAbstractItemView::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::dropEvent(::QDropEvent * event)
{
    if (m_PyMethodCache[17]) {
        return this->::QAbstractItemView::dropEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dropEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QAbstractItemView::dropEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDROPEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractItemViewWrapper::edit(const ::QModelIndex & index, ::QAbstractItemView::EditTrigger trigger, ::QEvent * event)
{
    if (m_PyMethodCache[18])
        return this->::QAbstractItemView::edit(index, trigger, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "edit";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QAbstractItemView::edit(index, trigger, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, &trigger),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg3 = PyTuple_GET_ITEM(pyArgs, 2)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.edit", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg3)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 2));
    return cppResult;
}

void QAbstractItemViewWrapper::editorDestroyed(::QObject * editor)
{
    if (m_PyMethodCache[19]) {
        return this->::QAbstractItemView::editorDestroyed(editor);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "editorDestroyed";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QAbstractItemView::editorDestroyed(editor);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), editor)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::enterEvent(::QEvent * event)
{
    if (m_PyMethodCache[20]) {
        return this->::QWidget::enterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "enterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QWidget::enterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractItemViewWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[21])
        return this->::QAbstractItemView::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QAbstractItemView::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractItemViewWrapper::eventFilter(::QObject * object, ::QEvent * event)
{
    if (m_PyMethodCache[22])
        return this->::QAbstractItemView::eventFilter(object, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QAbstractItemView::eventFilter(object, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), object),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractItemViewWrapper::focusInEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[23]) {
        return this->::QAbstractItemView::focusInEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QAbstractItemView::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractItemViewWrapper::focusNextPrevChild(bool next)
{
    if (m_PyMethodCache[24])
        return this->::QAbstractItemView::focusNextPrevChild(next);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusNextPrevChild";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QAbstractItemView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &next)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.focusNextPrevChild", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::focusOutEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[25]) {
        return this->::QAbstractItemView::focusOutEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QAbstractItemView::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractItemViewWrapper::hasHeightForWidth() const
{
    if (m_PyMethodCache[26])
        return this->::QWidget::hasHeightForWidth();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QWidget::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.hasHeightForWidth", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QAbstractItemViewWrapper::heightForWidth(int arg__1) const
{
    if (m_PyMethodCache[27])
        return this->::QWidget::heightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "heightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.heightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::hideEvent(::QHideEvent * event)
{
    if (m_PyMethodCache[28]) {
        return this->::QWidget::hideEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hideEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QWidget::hideEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHIDEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QAbstractItemViewWrapper::horizontalOffset() const
{
    if (m_PyMethodCache[29]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.horizontalOffset()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "horizontalOffset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.horizontalOffset()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.horizontalOffset", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::horizontalScrollbarAction(int action)
{
    if (m_PyMethodCache[30]) {
        return this->::QAbstractItemView::horizontalScrollbarAction(action);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "horizontalScrollbarAction";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QAbstractItemView::horizontalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    action
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::horizontalScrollbarValueChanged(int value)
{
    if (m_PyMethodCache[31]) {
        return this->::QAbstractItemView::horizontalScrollbarValueChanged(value);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "horizontalScrollbarValueChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[31] = true;
        return this->::QAbstractItemView::horizontalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    value
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QModelIndex QAbstractItemViewWrapper::indexAt(const ::QPoint & point) const
{
    if (m_PyMethodCache[32]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.indexAt()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "indexAt";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[32] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.indexAt()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &point)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.indexAt", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[33]) {
        return this->::QWidget::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[33] = true;
        return this->::QWidget::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    if (m_PyMethodCache[34]) {
        return this->::QAbstractItemView::inputMethodEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[34] = true;
        return this->::QAbstractItemView::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QVariant QAbstractItemViewWrapper::inputMethodQuery(::Qt::InputMethodQuery query) const
{
    if (m_PyMethodCache[35])
        return this->::QAbstractItemView::inputMethodQuery(query);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodQuery";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[35] = true;
        return this->::QAbstractItemView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, &query)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.inputMethodQuery", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractItemViewWrapper::isIndexHidden(const ::QModelIndex & index) const
{
    if (m_PyMethodCache[36]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.isIndexHidden()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isIndexHidden";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[36] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.isIndexHidden()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.isIndexHidden", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::keyPressEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[37]) {
        return this->::QAbstractItemView::keyPressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[37] = true;
        return this->::QAbstractItemView::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[38]) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[38] = true;
        return this->::QWidget::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::keyboardSearch(const ::QString & search)
{
    if (m_PyMethodCache[39]) {
        return this->::QAbstractItemView::keyboardSearch(search);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyboardSearch";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[39] = true;
        return this->::QAbstractItemView::keyboardSearch(search);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &search)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::leaveEvent(::QEvent * event)
{
    if (m_PyMethodCache[40]) {
        return this->::QWidget::leaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "leaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[40] = true;
        return this->::QWidget::leaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QAbstractItemViewWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    if (m_PyMethodCache[42])
        return this->::QWidget::metric(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[42] = true;
        return this->::QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QAbstractItemViewWrapper::minimumSizeHint() const
{
    if (m_PyMethodCache[43])
        return this->::QAbstractScrollArea::minimumSizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumSizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[43] = true;
        return this->::QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.minimumSizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[44]) {
        return this->::QAbstractItemView::mouseDoubleClickEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[44] = true;
        return this->::QAbstractItemView::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[45]) {
        return this->::QAbstractItemView::mouseMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[45] = true;
        return this->::QAbstractItemView::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::mousePressEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[46]) {
        return this->::QAbstractItemView::mousePressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[46] = true;
        return this->::QAbstractItemView::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[47]) {
        return this->::QAbstractItemView::mouseReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[47] = true;
        return this->::QAbstractItemView::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QModelIndex QAbstractItemViewWrapper::moveCursor(::QAbstractItemView::CursorAction cursorAction, ::QFlags<Qt::KeyboardModifier> modifiers)
{
    if (m_PyMethodCache[48]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.moveCursor()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveCursor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[48] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.moveCursor()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX])->converter, &cursorAction),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, &modifiers)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.moveCursor", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::moveEvent(::QMoveEvent * event)
{
    if (m_PyMethodCache[49]) {
        return this->::QWidget::moveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[49] = true;
        return this->::QWidget::moveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractItemViewWrapper::nativeEvent(const ::QByteArray & eventType, void * message, long * result)
{
    if (m_PyMethodCache[50]) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nativeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[50] = true;
        return this->::QWidget::nativeEvent(eventType, message, result);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &eventType),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), message)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Begin code injection
    // TEMPLATE - return_native_eventfilter_conversion - START
    bool cppResult = false;
    if (PySequence_Check(pyResult) && (PySequence_Size(pyResult) == 2)) {
        Shiboken::AutoDecRef pyItem(PySequence_GetItem(pyResult, 0));
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyItem, &(cppResult));
        if (result) {
            Shiboken::AutoDecRef pyResultItem(PySequence_GetItem(pyResult, 1));
            Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<long>(), pyResultItem, (result));
        }
    }
    // TEMPLATE - return_native_eventfilter_conversion - END

    // End of code injection


    return cppResult;
}

::QPaintEngine * QAbstractItemViewWrapper::paintEngine() const
{
    if (m_PyMethodCache[51])
        return this->::QWidget::paintEngine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[51] = true;
        return this->::QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::paintEvent(::QPaintEvent * arg__1)
{
    if (m_PyMethodCache[52]) {
        return this->::QAbstractScrollArea::paintEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[52] = true;
        return this->::QAbstractScrollArea::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QPaintDevice * QAbstractItemViewWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[53])
        return this->::QWidget::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[53] = true;
        return this->::QWidget::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::reset()
{
    if (m_PyMethodCache[54]) {
        return this->::QAbstractItemView::reset();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[54] = true;
        return this->::QAbstractItemView::reset();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::resizeEvent(::QResizeEvent * event)
{
    if (m_PyMethodCache[55]) {
        return this->::QAbstractItemView::resizeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resizeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[55] = true;
        return this->::QAbstractItemView::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::rowsAboutToBeRemoved(const ::QModelIndex & parent, int start, int end)
{
    if (m_PyMethodCache[56]) {
        return this->::QAbstractItemView::rowsAboutToBeRemoved(parent, start, end);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "rowsAboutToBeRemoved";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[56] = true;
        return this->::QAbstractItemView::rowsAboutToBeRemoved(parent, start, end);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Nii)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent),
    start,
    end
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::rowsInserted(const ::QModelIndex & parent, int start, int end)
{
    if (m_PyMethodCache[57]) {
        return this->::QAbstractItemView::rowsInserted(parent, start, end);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "rowsInserted";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[57] = true;
        return this->::QAbstractItemView::rowsInserted(parent, start, end);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Nii)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent),
    start,
    end
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::scrollContentsBy(int dx, int dy)
{
    if (m_PyMethodCache[58]) {
        return this->::QAbstractScrollArea::scrollContentsBy(dx, dy);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "scrollContentsBy";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[58] = true;
        return this->::QAbstractScrollArea::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(ii)",
    dx,
    dy
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::scrollTo(const ::QModelIndex & index, ::QAbstractItemView::ScrollHint hint)
{
    if (m_PyMethodCache[59]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.scrollTo()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "scrollTo";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[59] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.scrollTo()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX])->converter, &hint)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::selectAll()
{
    if (m_PyMethodCache[60]) {
        return this->::QAbstractItemView::selectAll();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "selectAll";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[60] = true;
        return this->::QAbstractItemView::selectAll();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QModelIndexList QAbstractItemViewWrapper::selectedIndexes() const
{
    if (m_PyMethodCache[61])
        return this->::QAbstractItemView::selectedIndexes();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QModelIndexList();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "selectedIndexes";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[61] = true;
        return this->::QAbstractItemView::selectedIndexes();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QModelIndexList();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.selectedIndexes", "QModelIndexList", Py_TYPE(pyResult)->tp_name);
        return ::QModelIndexList();
    }
    ::QModelIndexList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::selectionChanged(const ::QItemSelection & selected, const ::QItemSelection & deselected)
{
    if (m_PyMethodCache[62]) {
        return this->::QAbstractItemView::selectionChanged(selected, deselected);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "selectionChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[62] = true;
        return this->::QAbstractItemView::selectionChanged(selected, deselected);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), &selected),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), &deselected)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QFlags<QItemSelectionModel::SelectionFlag> QAbstractItemViewWrapper::selectionCommand(const ::QModelIndex & index, const ::QEvent * event) const
{
    if (m_PyMethodCache[63])
        return this->::QAbstractItemView::selectionCommand(index, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QItemSelectionModel::SelectionFlag>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "selectionCommand";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[63] = true;
        return this->::QAbstractItemView::selectionCommand(index, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QItemSelectionModel::SelectionFlag>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QITEMSELECTIONMODEL_SELECTIONFLAG_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.selectionCommand", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QItemSelectionModel::SelectionFlag> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QItemSelectionModel::SelectionFlag>(0);
    }
    ::QFlags<QItemSelectionModel::SelectionFlag> cppResult = QFlags<QItemSelectionModel::SelectionFlag>(0);
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractItemViewWrapper::setModel(::QAbstractItemModel * model)
{
    if (m_PyMethodCache[64]) {
        return this->::QAbstractItemView::setModel(model);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setModel";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[64] = true;
        return this->::QAbstractItemView::setModel(model);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), model)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::setRootIndex(const ::QModelIndex & index)
{
    if (m_PyMethodCache[65]) {
        return this->::QAbstractItemView::setRootIndex(index);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setRootIndex";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[65] = true;
        return this->::QAbstractItemView::setRootIndex(index);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::setSelection(const ::QRect & rect, ::QFlags<QItemSelectionModel::SelectionFlag> command)
{
    if (m_PyMethodCache[66]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.setSelection()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setSelection";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[66] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.setSelection()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &rect),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QITEMSELECTIONMODEL_SELECTIONFLAG_IDX])->converter, &command)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::setSelectionModel(::QItemSelectionModel * selectionModel)
{
    if (m_PyMethodCache[67]) {
        return this->::QAbstractItemView::setSelectionModel(selectionModel);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setSelectionModel";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[67] = true;
        return this->::QAbstractItemView::setSelectionModel(selectionModel);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONMODEL_IDX]), selectionModel)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::setVisible(bool visible)
{
    if (m_PyMethodCache[68]) {
        return this->::QWidget::setVisible(visible);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[68] = true;
        return this->::QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &visible)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::setupViewport(::QWidget * viewport)
{
    if (m_PyMethodCache[69]) {
        return this->::QAbstractScrollArea::setupViewport(viewport);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setupViewport";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[69] = true;
        return this->::QAbstractScrollArea::setupViewport(viewport);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), viewport)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QPainter * QAbstractItemViewWrapper::sharedPainter() const
{
    if (m_PyMethodCache[70])
        return this->::QWidget::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[70] = true;
        return this->::QWidget::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::showEvent(::QShowEvent * event)
{
    if (m_PyMethodCache[71]) {
        return this->::QWidget::showEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "showEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[71] = true;
        return this->::QWidget::showEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSHOWEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QSize QAbstractItemViewWrapper::sizeHint() const
{
    if (m_PyMethodCache[72])
        return this->::QAbstractScrollArea::sizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[72] = true;
        return this->::QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.sizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QAbstractItemViewWrapper::sizeHintForColumn(int column) const
{
    if (m_PyMethodCache[73])
        return this->::QAbstractItemView::sizeHintForColumn(column);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHintForColumn";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[73] = true;
        return this->::QAbstractItemView::sizeHintForColumn(column);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    column
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.sizeHintForColumn", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QAbstractItemViewWrapper::sizeHintForRow(int row) const
{
    if (m_PyMethodCache[74])
        return this->::QAbstractItemView::sizeHintForRow(row);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHintForRow";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[74] = true;
        return this->::QAbstractItemView::sizeHintForRow(row);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    row
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.sizeHintForRow", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::startDrag(::QFlags<Qt::DropAction> supportedActions)
{
    if (m_PyMethodCache[75]) {
        return this->::QAbstractItemView::startDrag(supportedActions);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "startDrag";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[75] = true;
        return this->::QAbstractItemView::startDrag(supportedActions);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, &supportedActions)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::tabletEvent(::QTabletEvent * event)
{
    if (m_PyMethodCache[76]) {
        return this->::QWidget::tabletEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "tabletEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[76] = true;
        return this->::QWidget::tabletEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[77]) {
        return this->::QAbstractItemView::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[77] = true;
        return this->::QAbstractItemView::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemViewWrapper::updateEditorData()
{
    if (m_PyMethodCache[78]) {
        return this->::QAbstractItemView::updateEditorData();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateEditorData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[78] = true;
        return this->::QAbstractItemView::updateEditorData();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::updateEditorGeometries()
{
    if (m_PyMethodCache[79]) {
        return this->::QAbstractItemView::updateEditorGeometries();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateEditorGeometries";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[79] = true;
        return this->::QAbstractItemView::updateEditorGeometries();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::updateGeometries()
{
    if (m_PyMethodCache[80]) {
        return this->::QAbstractItemView::updateGeometries();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateGeometries";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[80] = true;
        return this->::QAbstractItemView::updateGeometries();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

int QAbstractItemViewWrapper::verticalOffset() const
{
    if (m_PyMethodCache[81]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.verticalOffset()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "verticalOffset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[81] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.verticalOffset()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.verticalOffset", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::verticalScrollbarAction(int action)
{
    if (m_PyMethodCache[82]) {
        return this->::QAbstractItemView::verticalScrollbarAction(action);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "verticalScrollbarAction";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[82] = true;
        return this->::QAbstractItemView::verticalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    action
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemViewWrapper::verticalScrollbarValueChanged(int value)
{
    if (m_PyMethodCache[83]) {
        return this->::QAbstractItemView::verticalScrollbarValueChanged(value);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "verticalScrollbarValueChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[83] = true;
        return this->::QAbstractItemView::verticalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    value
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QStyleOptionViewItem QAbstractItemViewWrapper::viewOptions() const
{
    if (m_PyMethodCache[84])
        return this->::QAbstractItemView::viewOptions();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QStyleOptionViewItem();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "viewOptions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[84] = true;
        return this->::QAbstractItemView::viewOptions();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QStyleOptionViewItem();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.viewOptions", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QStyleOptionViewItem >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QStyleOptionViewItem();
    }
    ::QStyleOptionViewItem cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractItemViewWrapper::viewportEvent(::QEvent * event)
{
    if (m_PyMethodCache[85])
        return this->::QAbstractItemView::viewportEvent(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "viewportEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[85] = true;
        return this->::QAbstractItemView::viewportEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.viewportEvent", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

::QSize QAbstractItemViewWrapper::viewportSizeHint() const
{
    if (m_PyMethodCache[86])
        return this->::QAbstractItemView::viewportSizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "viewportSizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[86] = true;
        return this->::QAbstractItemView::viewportSizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.viewportSizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRect QAbstractItemViewWrapper::visualRect(const ::QModelIndex & index) const
{
    if (m_PyMethodCache[87]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRect()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "visualRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[87] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRect()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.visualRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRect >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRect cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRegion QAbstractItemViewWrapper::visualRegionForSelection(const ::QItemSelection & selection) const
{
    if (m_PyMethodCache[88]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRegionForSelection()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "visualRegionForSelection";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[88] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRegionForSelection()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), &selection)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemView.visualRegionForSelection", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRegion >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRegion cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractItemViewWrapper::wheelEvent(::QWheelEvent * arg__1)
{
    if (m_PyMethodCache[89]) {
        return this->::QAbstractScrollArea::wheelEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[89] = true;
        return this->::QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAbstractItemViewWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAbstractItemView::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractItemViewWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAbstractItemView::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractItemViewWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractItemViewWrapper *>(this));
        return QAbstractItemView::qt_metacast(_clname);
}

QAbstractItemViewWrapper::~QAbstractItemViewWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractItemView_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractItemView' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractItemView >()))
        return -1;

    ::QAbstractItemViewWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QAbstractItemView", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractItemView::QAbstractItemView(QWidget*)
    if (numArgs == 0) {
        overloadId = 0; // QAbstractItemView(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAbstractItemView(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemView_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractItemView_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QAbstractItemView_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QAbstractItemView(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QAbstractItemViewWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QAbstractItemViewWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractItemView >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractItemView_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAbstractItemView_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAbstractItemView_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractItemViewFunc_alternatingRowColors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.alternatingRowColors";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alternatingRowColors()const
            bool cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->alternatingRowColors();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_autoScrollMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.autoScrollMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoScrollMargin()const
            int cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->autoScrollMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_clearSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.clearSelection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearSelection()
            cppSelf->clearSelection();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_closeEditor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.closeEditor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "closeEditor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::closeEditor(QWidget*,QAbstractItemDelegate::EndEditHint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_ENDEDITHINT_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // closeEditor(QWidget*,QAbstractItemDelegate::EndEditHint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_closeEditor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QAbstractItemDelegate::EndEditHint cppArg1{QAbstractItemDelegate::NoHint};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // closeEditor(QWidget*,QAbstractItemDelegate::EndEditHint)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::closeEditor(cppArg0, cppArg1)
                : cppSelf->closeEditor(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_closeEditor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_closePersistentEditor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.closePersistentEditor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::closePersistentEditor(QModelIndex)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // closePersistentEditor(QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_closePersistentEditor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // closePersistentEditor(QModelIndex)
            cppSelf->closePersistentEditor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_closePersistentEditor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_commitData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.commitData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::commitData(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // commitData(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_commitData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // commitData(QWidget*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::commitData(cppArg0)
                : cppSelf->commitData(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_commitData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_currentChanged(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.currentChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "currentChanged", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::currentChanged(QModelIndex,QModelIndex)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[1])))) {
        overloadId = 0; // currentChanged(QModelIndex,QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_currentChanged_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QModelIndex cppArg1_local;
        ::QModelIndex *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // currentChanged(QModelIndex,QModelIndex)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::currentChanged(*cppArg0, *cppArg1)
                : cppSelf->currentChanged(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_currentChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_currentIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.currentIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentIndex()const
            QModelIndex cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->currentIndex();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_dataChanged(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dataChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractItemViewFunc_dataChanged_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractItemViewFunc_dataChanged_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:dataChanged", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::dataChanged(QModelIndex,QModelIndex,QVector<int>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // dataChanged(QModelIndex,QModelIndex,QVector<int>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_INT_IDX], (pyArgs[2])))) {
            overloadId = 0; // dataChanged(QModelIndex,QModelIndex,QVector<int>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_dataChanged_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_roles = Shiboken::String::createStaticString("roles");
            if (PyDict_Contains(kwds, key_roles)) {
                value = PyDict_GetItem(kwds, key_roles);
                if (value && pyArgs[2]) {
                    errInfo = key_roles;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractItemViewFunc_dataChanged_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_INT_IDX], (pyArgs[2]))))
                        goto Sbk_QAbstractItemViewFunc_dataChanged_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_roles);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractItemViewFunc_dataChanged_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QModelIndex cppArg1_local;
        ::QModelIndex *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QVector<int > cppArg2;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // dataChanged(QModelIndex,QModelIndex,QVector<int>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::dataChanged(*cppArg0, *cppArg1, cppArg2)
                : cppSelf->dataChanged(*cppArg0, *cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_dataChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_defaultDropAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.defaultDropAction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultDropAction()const
            Qt::DropAction cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->defaultDropAction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_dirtyRegionOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dirtyRegionOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dirtyRegionOffset()const
            QPoint cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->dirtyRegionOffset();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_doAutoScroll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.doAutoScroll";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // doAutoScroll()
            cppSelf->doAutoScroll();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_doItemsLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.doItemsLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // doItemsLayout()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::doItemsLayout()
                : cppSelf->doItemsLayout();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_dragDropMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dragDropMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dragDropMode()const
            QAbstractItemView::DragDropMode cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->dragDropMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_dragDropOverwriteMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dragDropOverwriteMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dragDropOverwriteMode()const
            bool cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->dragDropOverwriteMode();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_dragEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dragEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dragEnabled()const
            bool cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->dragEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_dragEnterEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dragEnterEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::dragEnterEvent(QDragEnterEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dragEnterEvent(QDragEnterEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_dragEnterEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDragEnterEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dragEnterEvent(QDragEnterEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::dragEnterEvent(cppArg0)
                : cppSelf->dragEnterEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_dragEnterEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_dragLeaveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dragLeaveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::dragLeaveEvent(QDragLeaveEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dragLeaveEvent(QDragLeaveEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_dragLeaveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDragLeaveEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dragLeaveEvent(QDragLeaveEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::dragLeaveEvent(cppArg0)
                : cppSelf->dragLeaveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_dragLeaveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_dragMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dragMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::dragMoveEvent(QDragMoveEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dragMoveEvent(QDragMoveEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_dragMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDragMoveEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dragMoveEvent(QDragMoveEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::dragMoveEvent(cppArg0)
                : cppSelf->dragMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_dragMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_dropEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dropEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::dropEvent(QDropEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDROPEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dropEvent(QDropEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_dropEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDropEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dropEvent(QDropEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::dropEvent(cppArg0)
                : cppSelf->dropEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_dropEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_dropIndicatorPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.dropIndicatorPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dropIndicatorPosition()const
            QAbstractItemView::DropIndicatorPosition cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->dropIndicatorPosition();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_edit(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.edit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto Sbk_QAbstractItemViewFunc_edit_TypeError;

    if (!PyArg_UnpackTuple(args, "edit", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::edit(QModelIndex,QAbstractItemView::EditTrigger,QEvent*)
    // 1: QAbstractItemView::edit(QModelIndex)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // edit(QModelIndex)
        } else if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[2])))) {
            overloadId = 0; // edit(QModelIndex,QAbstractItemView::EditTrigger,QEvent*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_edit_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // edit(const QModelIndex & index, QAbstractItemView::EditTrigger trigger, QEvent * event)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QAbstractItemView::EditTrigger cppArg1{QAbstractItemView::NoEditTriggers};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QEvent *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // edit(QModelIndex,QAbstractItemView::EditTrigger,QEvent*)
                bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QAbstractItemView::edit(*cppArg0, cppArg1, cppArg2)
                    : cppSelf->edit(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // edit(const QModelIndex & index)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // edit(QModelIndex)
                cppSelf->edit(*cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_edit_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_editTriggers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.editTriggers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // editTriggers()const
            QFlags<QAbstractItemView::EditTrigger> cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->editTriggers();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_editorDestroyed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.editorDestroyed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::editorDestroyed(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // editorDestroyed(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_editorDestroyed_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // editorDestroyed(QObject*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::editorDestroyed(cppArg0)
                : cppSelf->editorDestroyed(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_editorDestroyed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.eventFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_eventFilter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_eventFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_executeDelayedItemsLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.executeDelayedItemsLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // executeDelayedItemsLayout()
            cppSelf->executeDelayedItemsLayout();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.focusInEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_focusInEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusInEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::focusInEvent(cppArg0)
                : cppSelf->focusInEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_focusInEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_focusNextPrevChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.focusNextPrevChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusNextPrevChild(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // focusNextPrevChild(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_focusNextPrevChild_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusNextPrevChild(bool)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::focusNextPrevChild(cppArg0)
                : cppSelf->focusNextPrevChild(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_focusNextPrevChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_focusOutEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.focusOutEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusOutEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusOutEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_focusOutEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusOutEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::focusOutEvent(cppArg0)
                : cppSelf->focusOutEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_focusOutEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_hasAutoScroll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.hasAutoScroll";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasAutoScroll()const
            bool cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->hasAutoScroll();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_horizontalOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.horizontalOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // horizontalOffset()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.horizontalOffset()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->horizontalOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_horizontalScrollMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.horizontalScrollMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // horizontalScrollMode()const
            QAbstractItemView::ScrollMode cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->horizontalScrollMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_horizontalScrollbarAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.horizontalScrollbarAction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::horizontalScrollbarAction(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // horizontalScrollbarAction(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_horizontalScrollbarAction_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // horizontalScrollbarAction(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::horizontalScrollbarAction(cppArg0)
                : cppSelf->horizontalScrollbarAction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_horizontalScrollbarAction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_horizontalScrollbarValueChanged(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.horizontalScrollbarValueChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::horizontalScrollbarValueChanged(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // horizontalScrollbarValueChanged(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_horizontalScrollbarValueChanged_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // horizontalScrollbarValueChanged(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::horizontalScrollbarValueChanged(cppArg0)
                : cppSelf->horizontalScrollbarValueChanged(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_horizontalScrollbarValueChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_horizontalStepsPerItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.horizontalStepsPerItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // horizontalStepsPerItem()const
            int cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->horizontalStepsPerItem();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_iconSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.iconSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // iconSize()const
            QSize cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->iconSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_indexAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.indexAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::indexAt(QPoint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // indexAt(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_indexAt_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // indexAt(QPoint)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.indexAt()' not implemented.");
                return {};
            }
            QModelIndex cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->indexAt(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_indexAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_indexWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.indexWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::indexWidget(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // indexWidget(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_indexWidget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // indexWidget(QModelIndex)const
            QWidget * cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->indexWidget(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_indexWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_inputMethodEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.inputMethodEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::inputMethodEvent(QInputMethodEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // inputMethodEvent(QInputMethodEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_inputMethodEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QInputMethodEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inputMethodEvent(QInputMethodEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::inputMethodEvent(cppArg0)
                : cppSelf->inputMethodEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_inputMethodEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_inputMethodQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.inputMethodQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::inputMethodQuery(Qt::InputMethodQuery)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // inputMethodQuery(Qt::InputMethodQuery)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_inputMethodQuery_TypeError;

    // Call function/method
    {
        ::Qt::InputMethodQuery cppArg0 = static_cast< ::Qt::InputMethodQuery>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inputMethodQuery(Qt::InputMethodQuery)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractItemView *>(cppSelf)->::QAbstractItemView::inputMethodQuery(cppArg0)
                : const_cast<const ::QAbstractItemView *>(cppSelf)->inputMethodQuery(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_inputMethodQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_isIndexHidden(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.isIndexHidden";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::isIndexHidden(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // isIndexHidden(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_isIndexHidden_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isIndexHidden(QModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.isIndexHidden()' not implemented.");
                return {};
            }
            bool cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->isIndexHidden(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_isIndexHidden_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_isPersistentEditorOpen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.isPersistentEditorOpen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::isPersistentEditorOpen(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // isPersistentEditorOpen(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_isPersistentEditorOpen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isPersistentEditorOpen(QModelIndex)const
            bool cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->isPersistentEditorOpen(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_isPersistentEditorOpen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_itemDelegate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.itemDelegate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "itemDelegate", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::itemDelegate()const
    // 1: QAbstractItemView::itemDelegate(QModelIndex)const
    if (numArgs == 0) {
        overloadId = 0; // itemDelegate()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        overloadId = 1; // itemDelegate(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_itemDelegate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // itemDelegate() const
        {

            if (!PyErr_Occurred()) {
                // itemDelegate()const
                QAbstractItemDelegate * cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->itemDelegate();
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // itemDelegate(const QModelIndex & index) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // itemDelegate(QModelIndex)const
                QAbstractItemDelegate * cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->itemDelegate(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_itemDelegate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_itemDelegateForColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.itemDelegateForColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::itemDelegateForColumn(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // itemDelegateForColumn(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_itemDelegateForColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // itemDelegateForColumn(int)const
            QAbstractItemDelegate * cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->itemDelegateForColumn(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_itemDelegateForColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_itemDelegateForRow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.itemDelegateForRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::itemDelegateForRow(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // itemDelegateForRow(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_itemDelegateForRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // itemDelegateForRow(int)const
            QAbstractItemDelegate * cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->itemDelegateForRow(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_itemDelegateForRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.keyPressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_keyPressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_keyPressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_keyboardSearch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.keyboardSearch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::keyboardSearch(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // keyboardSearch(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_keyboardSearch_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyboardSearch(QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::keyboardSearch(cppArg0)
                : cppSelf->keyboardSearch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_keyboardSearch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.model";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // model()const
            QAbstractItemModel * cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->model();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_mouseDoubleClickEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.mouseDoubleClickEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseDoubleClickEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseDoubleClickEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_mouseDoubleClickEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseDoubleClickEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::mouseDoubleClickEvent(cppArg0)
                : cppSelf->mouseDoubleClickEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_mouseDoubleClickEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_mouseMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.mouseMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseMoveEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseMoveEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_mouseMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseMoveEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::mouseMoveEvent(cppArg0)
                : cppSelf->mouseMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_mouseMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.mousePressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_mousePressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mousePressEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::mousePressEvent(cppArg0)
                : cppSelf->mousePressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_mousePressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.mouseReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_mouseReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseReleaseEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::mouseReleaseEvent(cppArg0)
                : cppSelf->mouseReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_mouseReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_moveCursor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.moveCursor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "moveCursor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::moveCursor(QAbstractItemView::CursorAction,QFlags<Qt::KeyboardModifier>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // moveCursor(QAbstractItemView::CursorAction,QFlags<Qt::KeyboardModifier>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_moveCursor_TypeError;

    // Call function/method
    {
        ::QAbstractItemView::CursorAction cppArg0{QAbstractItemView::MoveUp};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::KeyboardModifier> cppArg1 = QFlags<Qt::KeyboardModifier>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // moveCursor(QAbstractItemView::CursorAction,QFlags<Qt::KeyboardModifier>)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.moveCursor()' not implemented.");
                return {};
            }
            QModelIndex cppResult = cppSelf->moveCursor(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_moveCursor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_openPersistentEditor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.openPersistentEditor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::openPersistentEditor(QModelIndex)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // openPersistentEditor(QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_openPersistentEditor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // openPersistentEditor(QModelIndex)
            cppSelf->openPersistentEditor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_openPersistentEditor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::reset()
                : cppSelf->reset();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_resetHorizontalScrollMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.resetHorizontalScrollMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetHorizontalScrollMode()
            cppSelf->resetHorizontalScrollMode();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_resetVerticalScrollMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.resetVerticalScrollMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetVerticalScrollMode()
            cppSelf->resetVerticalScrollMode();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.resizeEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_resizeEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_resizeEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_rootIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.rootIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rootIndex()const
            QModelIndex cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->rootIndex();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_rowsAboutToBeRemoved(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.rowsAboutToBeRemoved";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "rowsAboutToBeRemoved", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::rowsAboutToBeRemoved(QModelIndex,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // rowsAboutToBeRemoved(QModelIndex,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_rowsAboutToBeRemoved_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // rowsAboutToBeRemoved(QModelIndex,int,int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::rowsAboutToBeRemoved(*cppArg0, cppArg1, cppArg2)
                : cppSelf->rowsAboutToBeRemoved(*cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_rowsAboutToBeRemoved_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_rowsInserted(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.rowsInserted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "rowsInserted", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::rowsInserted(QModelIndex,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // rowsInserted(QModelIndex,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_rowsInserted_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // rowsInserted(QModelIndex,int,int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::rowsInserted(*cppArg0, cppArg1, cppArg2)
                : cppSelf->rowsInserted(*cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_rowsInserted_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_scheduleDelayedItemsLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.scheduleDelayedItemsLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scheduleDelayedItemsLayout()
            cppSelf->scheduleDelayedItemsLayout();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_scrollDirtyRegion(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.scrollDirtyRegion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "scrollDirtyRegion", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::scrollDirtyRegion(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // scrollDirtyRegion(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_scrollDirtyRegion_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // scrollDirtyRegion(int,int)
            cppSelf->scrollDirtyRegion(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_scrollDirtyRegion_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_scrollTo(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.scrollTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractItemViewFunc_scrollTo_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractItemViewFunc_scrollTo_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:scrollTo", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_scrollTo_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_hint = Shiboken::String::createStaticString("hint");
            if (PyDict_Contains(kwds, key_hint)) {
                value = PyDict_GetItem(kwds, key_hint);
                if (value && pyArgs[1]) {
                    errInfo = key_hint;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractItemViewFunc_scrollTo_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QAbstractItemViewFunc_scrollTo_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_hint);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractItemViewFunc_scrollTo_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QAbstractItemView::ScrollHint cppArg1 = QAbstractItemView::ScrollHint::EnsureVisible;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.scrollTo()' not implemented.");
                return {};
            }
            cppSelf->scrollTo(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_scrollTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_scrollToBottom(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.scrollToBottom";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scrollToBottom()
            cppSelf->scrollToBottom();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_scrollToTop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.scrollToTop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scrollToTop()
            cppSelf->scrollToTop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_selectAll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.selectAll";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectAll()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::selectAll()
                : cppSelf->selectAll();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_selectedIndexes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.selectedIndexes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedIndexes()const
            QModelIndexList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractItemView *>(cppSelf)->::QAbstractItemView::selectedIndexes()
                : const_cast<const ::QAbstractItemView *>(cppSelf)->selectedIndexes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_selectionBehavior(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.selectionBehavior";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectionBehavior()const
            QAbstractItemView::SelectionBehavior cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->selectionBehavior();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_selectionChanged(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.selectionChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "selectionChanged", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::selectionChanged(QItemSelection,QItemSelection)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), (pyArgs[1])))) {
        overloadId = 0; // selectionChanged(QItemSelection,QItemSelection)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_selectionChanged_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QItemSelection cppArg0_local;
        ::QItemSelection *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QItemSelection cppArg1_local;
        ::QItemSelection *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // selectionChanged(QItemSelection,QItemSelection)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::selectionChanged(*cppArg0, *cppArg1)
                : cppSelf->selectionChanged(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_selectionChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_selectionCommand(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.selectionCommand";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractItemViewFunc_selectionCommand_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractItemViewFunc_selectionCommand_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:selectionCommand", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::selectionCommand(QModelIndex,const QEvent*)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // selectionCommand(QModelIndex,const QEvent*)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // selectionCommand(QModelIndex,const QEvent*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_selectionCommand_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_event = Shiboken::String::createStaticString("event");
            if (PyDict_Contains(kwds, key_event)) {
                value = PyDict_GetItem(kwds, key_event);
                if (value && pyArgs[1]) {
                    errInfo = key_event;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractItemViewFunc_selectionCommand_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1]))))
                        goto Sbk_QAbstractItemViewFunc_selectionCommand_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_event);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractItemViewFunc_selectionCommand_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // selectionCommand(QModelIndex,const QEvent*)const
            QFlags<QItemSelectionModel::SelectionFlag> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractItemView *>(cppSelf)->::QAbstractItemView::selectionCommand(*cppArg0, cppArg1)
                : const_cast<const ::QAbstractItemView *>(cppSelf)->selectionCommand(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QITEMSELECTIONMODEL_SELECTIONFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_selectionCommand_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_selectionMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.selectionMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectionMode()const
            QAbstractItemView::SelectionMode cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->selectionMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_selectionModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.selectionModel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectionModel()const
            QItemSelectionModel * cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->selectionModel();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONMODEL_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_setAlternatingRowColors(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setAlternatingRowColors";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setAlternatingRowColors(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAlternatingRowColors(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setAlternatingRowColors_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlternatingRowColors(bool)
            cppSelf->setAlternatingRowColors(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setAlternatingRowColors_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setAutoScroll(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setAutoScroll";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setAutoScroll(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoScroll(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setAutoScroll_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoScroll(bool)
            cppSelf->setAutoScroll(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setAutoScroll_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setAutoScrollMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setAutoScrollMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setAutoScrollMargin(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setAutoScrollMargin(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setAutoScrollMargin_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoScrollMargin(int)
            cppSelf->setAutoScrollMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setAutoScrollMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setCurrentIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setCurrentIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setCurrentIndex(QModelIndex)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // setCurrentIndex(QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setCurrentIndex_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setCurrentIndex(QModelIndex)
            cppSelf->setCurrentIndex(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setCurrentIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setDefaultDropAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setDefaultDropAction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setDefaultDropAction(Qt::DropAction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDefaultDropAction(Qt::DropAction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setDefaultDropAction_TypeError;

    // Call function/method
    {
        ::Qt::DropAction cppArg0{Qt::IgnoreAction};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultDropAction(Qt::DropAction)
            cppSelf->setDefaultDropAction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setDefaultDropAction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setDirtyRegion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setDirtyRegion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setDirtyRegion(QRegion)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), (pyArg)))) {
        overloadId = 0; // setDirtyRegion(QRegion)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setDirtyRegion_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegion cppArg0_local;
        ::QRegion *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDirtyRegion(QRegion)
            cppSelf->setDirtyRegion(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setDirtyRegion_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setDragDropMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setDragDropMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setDragDropMode(QAbstractItemView::DragDropMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDragDropMode(QAbstractItemView::DragDropMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setDragDropMode_TypeError;

    // Call function/method
    {
        ::QAbstractItemView::DragDropMode cppArg0{QAbstractItemView::NoDragDrop};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDragDropMode(QAbstractItemView::DragDropMode)
            cppSelf->setDragDropMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setDragDropMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setDragDropOverwriteMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setDragDropOverwriteMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setDragDropOverwriteMode(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDragDropOverwriteMode(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setDragDropOverwriteMode_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDragDropOverwriteMode(bool)
            cppSelf->setDragDropOverwriteMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setDragDropOverwriteMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setDragEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setDragEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setDragEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDragEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setDragEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDragEnabled(bool)
            cppSelf->setDragEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setDragEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setDropIndicatorShown(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setDropIndicatorShown";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setDropIndicatorShown(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDropIndicatorShown(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setDropIndicatorShown_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDropIndicatorShown(bool)
            cppSelf->setDropIndicatorShown(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setDropIndicatorShown_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setEditTriggers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setEditTriggers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setEditTriggers(QFlags<QAbstractItemView::EditTrigger>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setEditTriggers(QFlags<QAbstractItemView::EditTrigger>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setEditTriggers_TypeError;

    // Call function/method
    {
        ::QFlags<QAbstractItemView::EditTrigger> cppArg0 = QFlags<QAbstractItemView::EditTrigger>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEditTriggers(QFlags<QAbstractItemView::EditTrigger>)
            cppSelf->setEditTriggers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setEditTriggers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setHorizontalScrollMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setHorizontalScrollMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setHorizontalScrollMode(QAbstractItemView::ScrollMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setHorizontalScrollMode(QAbstractItemView::ScrollMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setHorizontalScrollMode_TypeError;

    // Call function/method
    {
        ::QAbstractItemView::ScrollMode cppArg0{QAbstractItemView::ScrollPerItem};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHorizontalScrollMode(QAbstractItemView::ScrollMode)
            cppSelf->setHorizontalScrollMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setHorizontalScrollMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setHorizontalStepsPerItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setHorizontalStepsPerItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setHorizontalStepsPerItem(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHorizontalStepsPerItem(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setHorizontalStepsPerItem_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHorizontalStepsPerItem(int)
            cppSelf->setHorizontalStepsPerItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setHorizontalStepsPerItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setIconSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setIconSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setIconSize(QSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
        overloadId = 0; // setIconSize(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setIconSize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setIconSize(QSize)
            cppSelf->setIconSize(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setIconSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setIndexWidget(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setIndexWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setIndexWidget", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::setIndexWidget(QModelIndex,QWidget*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setIndexWidget(QModelIndex,QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setIndexWidget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setIndexWidget(QModelIndex,QWidget*)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->setIndexWidget(*cppArg0, cppArg1);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            Shiboken::Object::setParent(self, pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setIndexWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setItemDelegate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setItemDelegate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setItemDelegate(QAbstractItemDelegate*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_IDX]), (pyArg)))) {
        overloadId = 0; // setItemDelegate(QAbstractItemDelegate*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setItemDelegate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemDelegate *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setItemDelegate(QAbstractItemDelegate*)
            cppSelf->setItemDelegate(cppArg0);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "setItemDelegate(QAbstractItemDelegate*)1", pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setItemDelegate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setItemDelegateForColumn(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setItemDelegateForColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setItemDelegateForColumn", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::setItemDelegateForColumn(int,QAbstractItemDelegate*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setItemDelegateForColumn(int,QAbstractItemDelegate*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setItemDelegateForColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAbstractItemDelegate *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setItemDelegateForColumn(int,QAbstractItemDelegate*)
            cppSelf->setItemDelegateForColumn(cppArg0, cppArg1);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "setItemDelegateForColumn(int,QAbstractItemDelegate*)2", pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setItemDelegateForColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setItemDelegateForRow(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setItemDelegateForRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setItemDelegateForRow", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::setItemDelegateForRow(int,QAbstractItemDelegate*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setItemDelegateForRow(int,QAbstractItemDelegate*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setItemDelegateForRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAbstractItemDelegate *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setItemDelegateForRow(int,QAbstractItemDelegate*)
            cppSelf->setItemDelegateForRow(cppArg0, cppArg1);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "setItemDelegateForRow(int,QAbstractItemDelegate*)2", pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setItemDelegateForRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setModel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setModel(QAbstractItemModel*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArg)))) {
        overloadId = 0; // setModel(QAbstractItemModel*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setModel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemModel *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setModel(QAbstractItemModel*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::setModel(cppArg0)
                : cppSelf->setModel(cppArg0);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "setModel(QAbstractItemModel*)1", pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setModel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setRootIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setRootIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setRootIndex(QModelIndex)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // setRootIndex(QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setRootIndex_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setRootIndex(QModelIndex)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::setRootIndex(*cppArg0)
                : cppSelf->setRootIndex(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setRootIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setSelection(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setSelection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSelection", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::setSelection(QRect,QFlags<QItemSelectionModel::SelectionFlag>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QITEMSELECTIONMODEL_SELECTIONFLAG_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // setSelection(QRect,QFlags<QItemSelectionModel::SelectionFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setSelection_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<QItemSelectionModel::SelectionFlag> cppArg1 = QFlags<QItemSelectionModel::SelectionFlag>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setSelection(QRect,QFlags<QItemSelectionModel::SelectionFlag>)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.setSelection()' not implemented.");
                return {};
            }
            cppSelf->setSelection(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setSelection_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setSelectionBehavior(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setSelectionBehavior";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setSelectionBehavior(QAbstractItemView::SelectionBehavior)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSelectionBehavior(QAbstractItemView::SelectionBehavior)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setSelectionBehavior_TypeError;

    // Call function/method
    {
        ::QAbstractItemView::SelectionBehavior cppArg0{QAbstractItemView::SelectItems};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSelectionBehavior(QAbstractItemView::SelectionBehavior)
            cppSelf->setSelectionBehavior(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setSelectionBehavior_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setSelectionMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setSelectionMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setSelectionMode(QAbstractItemView::SelectionMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSelectionMode(QAbstractItemView::SelectionMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setSelectionMode_TypeError;

    // Call function/method
    {
        ::QAbstractItemView::SelectionMode cppArg0{QAbstractItemView::NoSelection};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSelectionMode(QAbstractItemView::SelectionMode)
            cppSelf->setSelectionMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setSelectionMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setSelectionModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setSelectionModel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setSelectionModel(QItemSelectionModel*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONMODEL_IDX]), (pyArg)))) {
        overloadId = 0; // setSelectionModel(QItemSelectionModel*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setSelectionModel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionModel *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSelectionModel(QItemSelectionModel*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::setSelectionModel(cppArg0)
                : cppSelf->setSelectionModel(cppArg0);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "setSelectionModel(QItemSelectionModel*)1", pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setSelectionModel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setState(QAbstractItemView::State)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setState(QAbstractItemView::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setState_TypeError;

    // Call function/method
    {
        ::QAbstractItemView::State cppArg0{QAbstractItemView::NoState};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setState(QAbstractItemView::State)
            cppSelf->setState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setTabKeyNavigation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setTabKeyNavigation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setTabKeyNavigation(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setTabKeyNavigation(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setTabKeyNavigation_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTabKeyNavigation(bool)
            cppSelf->setTabKeyNavigation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setTabKeyNavigation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setTextElideMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setTextElideMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setTextElideMode(Qt::TextElideMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTextElideMode(Qt::TextElideMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setTextElideMode_TypeError;

    // Call function/method
    {
        ::Qt::TextElideMode cppArg0{Qt::ElideLeft};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextElideMode(Qt::TextElideMode)
            cppSelf->setTextElideMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setTextElideMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setVerticalScrollMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setVerticalScrollMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setVerticalScrollMode(QAbstractItemView::ScrollMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setVerticalScrollMode(QAbstractItemView::ScrollMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setVerticalScrollMode_TypeError;

    // Call function/method
    {
        ::QAbstractItemView::ScrollMode cppArg0{QAbstractItemView::ScrollPerItem};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVerticalScrollMode(QAbstractItemView::ScrollMode)
            cppSelf->setVerticalScrollMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setVerticalScrollMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_setVerticalStepsPerItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.setVerticalStepsPerItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::setVerticalStepsPerItem(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setVerticalStepsPerItem(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_setVerticalStepsPerItem_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVerticalStepsPerItem(int)
            cppSelf->setVerticalStepsPerItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_setVerticalStepsPerItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_showDropIndicator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.showDropIndicator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // showDropIndicator()const
            bool cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->showDropIndicator();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_sizeHintForColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.sizeHintForColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::sizeHintForColumn(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // sizeHintForColumn(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_sizeHintForColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // sizeHintForColumn(int)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractItemView *>(cppSelf)->::QAbstractItemView::sizeHintForColumn(cppArg0)
                : const_cast<const ::QAbstractItemView *>(cppSelf)->sizeHintForColumn(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_sizeHintForColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_sizeHintForIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.sizeHintForIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::sizeHintForIndex(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // sizeHintForIndex(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_sizeHintForIndex_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // sizeHintForIndex(QModelIndex)const
            QSize cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->sizeHintForIndex(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_sizeHintForIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_sizeHintForRow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.sizeHintForRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::sizeHintForRow(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // sizeHintForRow(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_sizeHintForRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // sizeHintForRow(int)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractItemView *>(cppSelf)->::QAbstractItemView::sizeHintForRow(cppArg0)
                : const_cast<const ::QAbstractItemView *>(cppSelf)->sizeHintForRow(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_sizeHintForRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_startAutoScroll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.startAutoScroll";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startAutoScroll()
            cppSelf->startAutoScroll();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_startDrag(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.startDrag";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::startDrag(QFlags<Qt::DropAction>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // startDrag(QFlags<Qt::DropAction>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_startDrag_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::DropAction> cppArg0 = QFlags<Qt::DropAction>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // startDrag(QFlags<Qt::DropAction>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::startDrag(cppArg0)
                : cppSelf->startDrag(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_startDrag_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QAbstractItemView::State cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_stopAutoScroll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.stopAutoScroll";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stopAutoScroll()
            cppSelf->stopAutoScroll();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_tabKeyNavigation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.tabKeyNavigation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tabKeyNavigation()const
            bool cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->tabKeyNavigation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_textElideMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.textElideMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textElideMode()const
            Qt::TextElideMode cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->textElideMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_timerEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.timerEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::timerEvent(QTimerEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), (pyArg)))) {
        overloadId = 0; // timerEvent(QTimerEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_timerEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimerEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // timerEvent(QTimerEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::timerEvent(cppArg0)
                : cppSelf->timerEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_timerEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_update(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.update";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "update", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemView::update(QModelIndex)
    // 1: QWidget::update()
    if (numArgs == 0) {
        overloadId = 1; // update()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        overloadId = 0; // update(QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_update_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // update(const QModelIndex & index)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // update(QModelIndex)
                cppSelf->update(*cppArg0);
            }
            break;
        }
        case 1: // update()
        {

            if (!PyErr_Occurred()) {
                // update()
                reinterpret_cast<QFrame *>(cppSelf)->update();
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_update_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_updateEditorData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.updateEditorData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateEditorData()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::updateEditorData()
                : cppSelf->updateEditorData();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_updateEditorGeometries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.updateEditorGeometries";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateEditorGeometries()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::updateEditorGeometries()
                : cppSelf->updateEditorGeometries();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_updateGeometries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.updateGeometries";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateGeometries()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::updateGeometries()
                : cppSelf->updateGeometries();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractItemViewFunc_verticalOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.verticalOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // verticalOffset()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.verticalOffset()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->verticalOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_verticalScrollMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.verticalScrollMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // verticalScrollMode()const
            QAbstractItemView::ScrollMode cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->verticalScrollMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_verticalScrollbarAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.verticalScrollbarAction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::verticalScrollbarAction(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // verticalScrollbarAction(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_verticalScrollbarAction_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // verticalScrollbarAction(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::verticalScrollbarAction(cppArg0)
                : cppSelf->verticalScrollbarAction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_verticalScrollbarAction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_verticalScrollbarValueChanged(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.verticalScrollbarValueChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::verticalScrollbarValueChanged(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // verticalScrollbarValueChanged(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_verticalScrollbarValueChanged_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // verticalScrollbarValueChanged(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::verticalScrollbarValueChanged(cppArg0)
                : cppSelf->verticalScrollbarValueChanged(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractItemViewFunc_verticalScrollbarValueChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_verticalStepsPerItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.verticalStepsPerItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // verticalStepsPerItem()const
            int cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->verticalStepsPerItem();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_viewOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.viewOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewOptions()const
            QStyleOptionViewItem cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractItemView *>(cppSelf)->::QAbstractItemView::viewOptions()
                : const_cast<const ::QAbstractItemView *>(cppSelf)->viewOptions();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_viewportEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.viewportEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractScrollArea::viewportEvent(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // viewportEvent(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_viewportEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // viewportEvent(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractItemView::viewportEvent(cppArg0)
                : cppSelf->viewportEvent(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_viewportEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_viewportSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.viewportSizeHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewportSizeHint()const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractItemView *>(cppSelf)->::QAbstractItemView::viewportSizeHint()
                : const_cast<const ::QAbstractItemView *>(cppSelf)->viewportSizeHint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemViewFunc_visualRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.visualRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::visualRect(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // visualRect(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_visualRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // visualRect(QModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRect()' not implemented.");
                return {};
            }
            QRect cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->visualRect(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_visualRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractItemViewFunc_visualRegionForSelection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractItemView.visualRegionForSelection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemView::visualRegionForSelection(QItemSelection)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), (pyArg)))) {
        overloadId = 0; // visualRegionForSelection(QItemSelection)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemViewFunc_visualRegionForSelection_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelection cppArg0_local;
        ::QItemSelection *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // visualRegionForSelection(QItemSelection)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRegionForSelection()' not implemented.");
                return {};
            }
            QRegion cppResult = const_cast<const ::QAbstractItemView *>(cppSelf)->visualRegionForSelection(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractItemViewFunc_visualRegionForSelection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QAbstractItemView_PropertyStrings[] = {
    "alternatingRowColors::",
    "autoScroll:hasAutoScroll:",
    "autoScrollMargin::",
    "defaultDropAction::",
    "dragDropMode::",
    "dragDropOverwriteMode::",
    "dragEnabled::",
    "editTriggers::",
    "horizontalScrollMode::",
    "iconSize::",
    "selectionBehavior::",
    "selectionMode::",
    "showDropIndicator::setDropIndicatorShown",
    "tabKeyNavigation::",
    "textElideMode::",
    "verticalScrollMode::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractItemView_methods[] = {
    {"alternatingRowColors", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_alternatingRowColors), METH_NOARGS},
    {"autoScrollMargin", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_autoScrollMargin), METH_NOARGS},
    {"clearSelection", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_clearSelection), METH_NOARGS},
    {"closeEditor", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_closeEditor), METH_VARARGS},
    {"closePersistentEditor", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_closePersistentEditor), METH_O},
    {"commitData", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_commitData), METH_O},
    {"currentChanged", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_currentChanged), METH_VARARGS},
    {"currentIndex", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_currentIndex), METH_NOARGS},
    {"dataChanged", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dataChanged), METH_VARARGS|METH_KEYWORDS},
    {"defaultDropAction", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_defaultDropAction), METH_NOARGS},
    {"dirtyRegionOffset", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dirtyRegionOffset), METH_NOARGS},
    {"doAutoScroll", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_doAutoScroll), METH_NOARGS},
    {"doItemsLayout", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_doItemsLayout), METH_NOARGS},
    {"dragDropMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dragDropMode), METH_NOARGS},
    {"dragDropOverwriteMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dragDropOverwriteMode), METH_NOARGS},
    {"dragEnabled", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dragEnabled), METH_NOARGS},
    {"dragEnterEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dragEnterEvent), METH_O},
    {"dragLeaveEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dragLeaveEvent), METH_O},
    {"dragMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dragMoveEvent), METH_O},
    {"dropEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dropEvent), METH_O},
    {"dropIndicatorPosition", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_dropIndicatorPosition), METH_NOARGS},
    {"edit", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_edit), METH_VARARGS},
    {"editTriggers", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_editTriggers), METH_NOARGS},
    {"editorDestroyed", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_editorDestroyed), METH_O},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_event), METH_O},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_eventFilter), METH_VARARGS},
    {"executeDelayedItemsLayout", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_executeDelayedItemsLayout), METH_NOARGS},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_focusInEvent), METH_O},
    {"focusNextPrevChild", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_focusNextPrevChild), METH_O},
    {"focusOutEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_focusOutEvent), METH_O},
    {"hasAutoScroll", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_hasAutoScroll), METH_NOARGS},
    {"horizontalOffset", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_horizontalOffset), METH_NOARGS},
    {"horizontalScrollMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_horizontalScrollMode), METH_NOARGS},
    {"horizontalScrollbarAction", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_horizontalScrollbarAction), METH_O},
    {"horizontalScrollbarValueChanged", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_horizontalScrollbarValueChanged), METH_O},
    {"horizontalStepsPerItem", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_horizontalStepsPerItem), METH_NOARGS},
    {"iconSize", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_iconSize), METH_NOARGS},
    {"indexAt", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_indexAt), METH_O},
    {"indexWidget", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_indexWidget), METH_O},
    {"inputMethodEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_inputMethodEvent), METH_O},
    {"inputMethodQuery", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_inputMethodQuery), METH_O},
    {"isIndexHidden", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_isIndexHidden), METH_O},
    {"isPersistentEditorOpen", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_isPersistentEditorOpen), METH_O},
    {"itemDelegate", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_itemDelegate), METH_VARARGS},
    {"itemDelegateForColumn", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_itemDelegateForColumn), METH_O},
    {"itemDelegateForRow", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_itemDelegateForRow), METH_O},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_keyPressEvent), METH_O},
    {"keyboardSearch", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_keyboardSearch), METH_O},
    {"model", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_model), METH_NOARGS},
    {"mouseDoubleClickEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_mouseDoubleClickEvent), METH_O},
    {"mouseMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_mouseMoveEvent), METH_O},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_mousePressEvent), METH_O},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_mouseReleaseEvent), METH_O},
    {"moveCursor", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_moveCursor), METH_VARARGS},
    {"openPersistentEditor", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_openPersistentEditor), METH_O},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_reset), METH_NOARGS},
    {"resetHorizontalScrollMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_resetHorizontalScrollMode), METH_NOARGS},
    {"resetVerticalScrollMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_resetVerticalScrollMode), METH_NOARGS},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_resizeEvent), METH_O},
    {"rootIndex", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_rootIndex), METH_NOARGS},
    {"rowsAboutToBeRemoved", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_rowsAboutToBeRemoved), METH_VARARGS},
    {"rowsInserted", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_rowsInserted), METH_VARARGS},
    {"scheduleDelayedItemsLayout", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_scheduleDelayedItemsLayout), METH_NOARGS},
    {"scrollDirtyRegion", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_scrollDirtyRegion), METH_VARARGS},
    {"scrollTo", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_scrollTo), METH_VARARGS|METH_KEYWORDS},
    {"scrollToBottom", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_scrollToBottom), METH_NOARGS},
    {"scrollToTop", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_scrollToTop), METH_NOARGS},
    {"selectAll", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_selectAll), METH_NOARGS},
    {"selectedIndexes", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_selectedIndexes), METH_NOARGS},
    {"selectionBehavior", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_selectionBehavior), METH_NOARGS},
    {"selectionChanged", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_selectionChanged), METH_VARARGS},
    {"selectionCommand", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_selectionCommand), METH_VARARGS|METH_KEYWORDS},
    {"selectionMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_selectionMode), METH_NOARGS},
    {"selectionModel", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_selectionModel), METH_NOARGS},
    {"setAlternatingRowColors", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setAlternatingRowColors), METH_O},
    {"setAutoScroll", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setAutoScroll), METH_O},
    {"setAutoScrollMargin", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setAutoScrollMargin), METH_O},
    {"setCurrentIndex", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setCurrentIndex), METH_O},
    {"setDefaultDropAction", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setDefaultDropAction), METH_O},
    {"setDirtyRegion", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setDirtyRegion), METH_O},
    {"setDragDropMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setDragDropMode), METH_O},
    {"setDragDropOverwriteMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setDragDropOverwriteMode), METH_O},
    {"setDragEnabled", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setDragEnabled), METH_O},
    {"setDropIndicatorShown", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setDropIndicatorShown), METH_O},
    {"setEditTriggers", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setEditTriggers), METH_O},
    {"setHorizontalScrollMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setHorizontalScrollMode), METH_O},
    {"setHorizontalStepsPerItem", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setHorizontalStepsPerItem), METH_O},
    {"setIconSize", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setIconSize), METH_O},
    {"setIndexWidget", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setIndexWidget), METH_VARARGS},
    {"setItemDelegate", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setItemDelegate), METH_O},
    {"setItemDelegateForColumn", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setItemDelegateForColumn), METH_VARARGS},
    {"setItemDelegateForRow", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setItemDelegateForRow), METH_VARARGS},
    {"setModel", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setModel), METH_O},
    {"setRootIndex", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setRootIndex), METH_O},
    {"setSelection", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setSelection), METH_VARARGS},
    {"setSelectionBehavior", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setSelectionBehavior), METH_O},
    {"setSelectionMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setSelectionMode), METH_O},
    {"setSelectionModel", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setSelectionModel), METH_O},
    {"setState", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setState), METH_O},
    {"setTabKeyNavigation", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setTabKeyNavigation), METH_O},
    {"setTextElideMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setTextElideMode), METH_O},
    {"setVerticalScrollMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setVerticalScrollMode), METH_O},
    {"setVerticalStepsPerItem", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_setVerticalStepsPerItem), METH_O},
    {"showDropIndicator", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_showDropIndicator), METH_NOARGS},
    {"sizeHintForColumn", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_sizeHintForColumn), METH_O},
    {"sizeHintForIndex", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_sizeHintForIndex), METH_O},
    {"sizeHintForRow", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_sizeHintForRow), METH_O},
    {"startAutoScroll", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_startAutoScroll), METH_NOARGS},
    {"startDrag", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_startDrag), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_state), METH_NOARGS},
    {"stopAutoScroll", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_stopAutoScroll), METH_NOARGS},
    {"tabKeyNavigation", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_tabKeyNavigation), METH_NOARGS},
    {"textElideMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_textElideMode), METH_NOARGS},
    {"timerEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_timerEvent), METH_O},
    {"update", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_update), METH_VARARGS},
    {"updateEditorData", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_updateEditorData), METH_NOARGS},
    {"updateEditorGeometries", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_updateEditorGeometries), METH_NOARGS},
    {"updateGeometries", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_updateGeometries), METH_NOARGS},
    {"verticalOffset", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_verticalOffset), METH_NOARGS},
    {"verticalScrollMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_verticalScrollMode), METH_NOARGS},
    {"verticalScrollbarAction", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_verticalScrollbarAction), METH_O},
    {"verticalScrollbarValueChanged", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_verticalScrollbarValueChanged), METH_O},
    {"verticalStepsPerItem", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_verticalStepsPerItem), METH_NOARGS},
    {"viewOptions", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_viewOptions), METH_NOARGS},
    {"viewportEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_viewportEvent), METH_O},
    {"viewportSizeHint", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_viewportSizeHint), METH_NOARGS},
    {"visualRect", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_visualRect), METH_O},
    {"visualRegionForSelection", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemViewFunc_visualRegionForSelection), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractItemView_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractItemView *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractItemViewWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAbstractItemView_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractItemView_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static void * Sbk_QAbstractItemViewSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QAbstractItemView *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast< ::QAbstractScrollArea *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QFRAME_IDX]))
        return static_cast< ::QFrame *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractItemView_Type = nullptr;
static SbkObjectType *Sbk_QAbstractItemView_TypeF(void)
{
    return _Sbk_QAbstractItemView_Type;
}

static PyType_Slot Sbk_QAbstractItemView_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractItemView_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractItemView_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractItemView_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractItemView_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractItemView_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractItemView_spec = {
    "2:PySide2.QtWidgets.QAbstractItemView",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractItemView_slots
};

} //extern "C"

static void *Sbk_QAbstractItemView_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QAbstractItemView *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QAbstractItemView *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger___and__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractItemView::EditTriggers cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractItemView::EditTriggers>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractItemView::EditTriggers>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractItemView::EditTriggers>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractItemView::EditTriggers>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger___or__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractItemView::EditTriggers cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractItemView::EditTriggers>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractItemView::EditTriggers>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractItemView::EditTriggers>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractItemView::EditTriggers>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger___xor__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractItemView::EditTriggers cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractItemView::EditTriggers>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractItemView::EditTriggers>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractItemView::EditTriggers>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractItemView::EditTriggers>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger___invert__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractItemView::EditTriggers cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, self, &cppSelf);
    ::QAbstractItemView::EditTriggers cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QAbstractItemView_SelectionMode_PythonToCpp_QAbstractItemView_SelectionMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemView::SelectionMode *>(cppOut) =
        static_cast<::QAbstractItemView::SelectionMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemView_SelectionMode_PythonToCpp_QAbstractItemView_SelectionMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX]))
        return QAbstractItemView_SelectionMode_PythonToCpp_QAbstractItemView_SelectionMode;
    return {};
}
static PyObject *QAbstractItemView_SelectionMode_CppToPython_QAbstractItemView_SelectionMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemView::SelectionMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX], castCppIn);

}

static void QAbstractItemView_SelectionBehavior_PythonToCpp_QAbstractItemView_SelectionBehavior(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemView::SelectionBehavior *>(cppOut) =
        static_cast<::QAbstractItemView::SelectionBehavior>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemView_SelectionBehavior_PythonToCpp_QAbstractItemView_SelectionBehavior_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX]))
        return QAbstractItemView_SelectionBehavior_PythonToCpp_QAbstractItemView_SelectionBehavior;
    return {};
}
static PyObject *QAbstractItemView_SelectionBehavior_CppToPython_QAbstractItemView_SelectionBehavior(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemView::SelectionBehavior *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX], castCppIn);

}

static void QAbstractItemView_ScrollHint_PythonToCpp_QAbstractItemView_ScrollHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemView::ScrollHint *>(cppOut) =
        static_cast<::QAbstractItemView::ScrollHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemView_ScrollHint_PythonToCpp_QAbstractItemView_ScrollHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX]))
        return QAbstractItemView_ScrollHint_PythonToCpp_QAbstractItemView_ScrollHint;
    return {};
}
static PyObject *QAbstractItemView_ScrollHint_CppToPython_QAbstractItemView_ScrollHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemView::ScrollHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX], castCppIn);

}

static void QAbstractItemView_EditTrigger_PythonToCpp_QAbstractItemView_EditTrigger(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemView::EditTrigger *>(cppOut) =
        static_cast<::QAbstractItemView::EditTrigger>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemView_EditTrigger_PythonToCpp_QAbstractItemView_EditTrigger_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX]))
        return QAbstractItemView_EditTrigger_PythonToCpp_QAbstractItemView_EditTrigger;
    return {};
}
static PyObject *QAbstractItemView_EditTrigger_CppToPython_QAbstractItemView_EditTrigger(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemView::EditTrigger *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX], castCppIn);

}

static void QFlags_QAbstractItemView_EditTrigger__PythonToCpp_QFlags_QAbstractItemView_EditTrigger_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractItemView::EditTrigger> *>(cppOut) =
        ::QFlags<QAbstractItemView::EditTrigger>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QAbstractItemView_EditTrigger__PythonToCpp_QFlags_QAbstractItemView_EditTrigger__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX]))
        return QFlags_QAbstractItemView_EditTrigger__PythonToCpp_QFlags_QAbstractItemView_EditTrigger_;
    return {};
}
static PyObject *QFlags_QAbstractItemView_EditTrigger__CppToPython_QFlags_QAbstractItemView_EditTrigger_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QAbstractItemView::EditTrigger> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX]));

}

static void QAbstractItemView_EditTrigger_PythonToCpp_QFlags_QAbstractItemView_EditTrigger_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractItemView::EditTrigger> *>(cppOut) =
        ::QFlags<QAbstractItemView::EditTrigger>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QAbstractItemView_EditTrigger_PythonToCpp_QFlags_QAbstractItemView_EditTrigger__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX]))
        return QAbstractItemView_EditTrigger_PythonToCpp_QFlags_QAbstractItemView_EditTrigger_;
    return {};
}
static void number_PythonToCpp_QFlags_QAbstractItemView_EditTrigger_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QAbstractItemView::EditTrigger> *>(cppOut) =
        ::QFlags<QAbstractItemView::EditTrigger>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QAbstractItemView_EditTrigger__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX]))
        return number_PythonToCpp_QFlags_QAbstractItemView_EditTrigger_;
    return {};
}
static void QAbstractItemView_ScrollMode_PythonToCpp_QAbstractItemView_ScrollMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemView::ScrollMode *>(cppOut) =
        static_cast<::QAbstractItemView::ScrollMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemView_ScrollMode_PythonToCpp_QAbstractItemView_ScrollMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX]))
        return QAbstractItemView_ScrollMode_PythonToCpp_QAbstractItemView_ScrollMode;
    return {};
}
static PyObject *QAbstractItemView_ScrollMode_CppToPython_QAbstractItemView_ScrollMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemView::ScrollMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX], castCppIn);

}

static void QAbstractItemView_DragDropMode_PythonToCpp_QAbstractItemView_DragDropMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemView::DragDropMode *>(cppOut) =
        static_cast<::QAbstractItemView::DragDropMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemView_DragDropMode_PythonToCpp_QAbstractItemView_DragDropMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX]))
        return QAbstractItemView_DragDropMode_PythonToCpp_QAbstractItemView_DragDropMode;
    return {};
}
static PyObject *QAbstractItemView_DragDropMode_CppToPython_QAbstractItemView_DragDropMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemView::DragDropMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX], castCppIn);

}

static void QAbstractItemView_CursorAction_PythonToCpp_QAbstractItemView_CursorAction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemView::CursorAction *>(cppOut) =
        static_cast<::QAbstractItemView::CursorAction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemView_CursorAction_PythonToCpp_QAbstractItemView_CursorAction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX]))
        return QAbstractItemView_CursorAction_PythonToCpp_QAbstractItemView_CursorAction;
    return {};
}
static PyObject *QAbstractItemView_CursorAction_CppToPython_QAbstractItemView_CursorAction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemView::CursorAction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX], castCppIn);

}

static void QAbstractItemView_State_PythonToCpp_QAbstractItemView_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemView::State *>(cppOut) =
        static_cast<::QAbstractItemView::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemView_State_PythonToCpp_QAbstractItemView_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX]))
        return QAbstractItemView_State_PythonToCpp_QAbstractItemView_State;
    return {};
}
static PyObject *QAbstractItemView_State_CppToPython_QAbstractItemView_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemView::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX], castCppIn);

}

static void QAbstractItemView_DropIndicatorPosition_PythonToCpp_QAbstractItemView_DropIndicatorPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemView::DropIndicatorPosition *>(cppOut) =
        static_cast<::QAbstractItemView::DropIndicatorPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemView_DropIndicatorPosition_PythonToCpp_QAbstractItemView_DropIndicatorPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX]))
        return QAbstractItemView_DropIndicatorPosition_PythonToCpp_QAbstractItemView_DropIndicatorPosition;
    return {};
}
static PyObject *QAbstractItemView_DropIndicatorPosition_CppToPython_QAbstractItemView_DropIndicatorPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemView::DropIndicatorPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractItemView_PythonToCpp_QAbstractItemView_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractItemView_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractItemView_PythonToCpp_QAbstractItemView_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractItemView_TypeF())))
        return QAbstractItemView_PythonToCpp_QAbstractItemView_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractItemView_PTR_CppToPython_QAbstractItemView(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAbstractItemView *>(const_cast<void *>(cppIn)), Sbk_QAbstractItemView_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractItemView_SignatureStrings[] = {
    "PySide2.QtWidgets.QAbstractItemView(self,parent:PySide2.QtWidgets.QWidget=nullptr)",
    "PySide2.QtWidgets.QAbstractItemView.alternatingRowColors(self)->bool",
    "PySide2.QtWidgets.QAbstractItemView.autoScrollMargin(self)->int",
    "PySide2.QtWidgets.QAbstractItemView.clearSelection(self)",
    "PySide2.QtWidgets.QAbstractItemView.closeEditor(self,editor:PySide2.QtWidgets.QWidget,hint:PySide2.QtWidgets.QAbstractItemDelegate.EndEditHint)",
    "PySide2.QtWidgets.QAbstractItemView.closePersistentEditor(self,index:PySide2.QtCore.QModelIndex)",
    "PySide2.QtWidgets.QAbstractItemView.commitData(self,editor:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QAbstractItemView.currentChanged(self,current:PySide2.QtCore.QModelIndex,previous:PySide2.QtCore.QModelIndex)",
    "PySide2.QtWidgets.QAbstractItemView.currentIndex(self)->PySide2.QtCore.QModelIndex",
    "PySide2.QtWidgets.QAbstractItemView.dataChanged(self,topLeft:PySide2.QtCore.QModelIndex,bottomRight:PySide2.QtCore.QModelIndex,roles:QVector[int]=QVector< int >())",
    "PySide2.QtWidgets.QAbstractItemView.defaultDropAction(self)->PySide2.QtCore.Qt.DropAction",
    "PySide2.QtWidgets.QAbstractItemView.dirtyRegionOffset(self)->PySide2.QtCore.QPoint",
    "PySide2.QtWidgets.QAbstractItemView.doAutoScroll(self)",
    "PySide2.QtWidgets.QAbstractItemView.doItemsLayout(self)",
    "PySide2.QtWidgets.QAbstractItemView.dragDropMode(self)->PySide2.QtWidgets.QAbstractItemView.DragDropMode",
    "PySide2.QtWidgets.QAbstractItemView.dragDropOverwriteMode(self)->bool",
    "PySide2.QtWidgets.QAbstractItemView.dragEnabled(self)->bool",
    "PySide2.QtWidgets.QAbstractItemView.dragEnterEvent(self,event:PySide2.QtGui.QDragEnterEvent)",
    "PySide2.QtWidgets.QAbstractItemView.dragLeaveEvent(self,event:PySide2.QtGui.QDragLeaveEvent)",
    "PySide2.QtWidgets.QAbstractItemView.dragMoveEvent(self,event:PySide2.QtGui.QDragMoveEvent)",
    "PySide2.QtWidgets.QAbstractItemView.dropEvent(self,event:PySide2.QtGui.QDropEvent)",
    "PySide2.QtWidgets.QAbstractItemView.dropIndicatorPosition(self)->PySide2.QtWidgets.QAbstractItemView.DropIndicatorPosition",
    "1:PySide2.QtWidgets.QAbstractItemView.edit(self,index:PySide2.QtCore.QModelIndex,trigger:PySide2.QtWidgets.QAbstractItemView.EditTrigger,event:PySide2.QtCore.QEvent)->bool",
    "0:PySide2.QtWidgets.QAbstractItemView.edit(self,index:PySide2.QtCore.QModelIndex)",
    "PySide2.QtWidgets.QAbstractItemView.editTriggers(self)->PySide2.QtWidgets.QAbstractItemView.EditTriggers",
    "PySide2.QtWidgets.QAbstractItemView.editorDestroyed(self,editor:PySide2.QtCore.QObject)",
    "PySide2.QtWidgets.QAbstractItemView.event(self,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QAbstractItemView.eventFilter(self,object:PySide2.QtCore.QObject,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QAbstractItemView.executeDelayedItemsLayout(self)",
    "PySide2.QtWidgets.QAbstractItemView.focusInEvent(self,event:PySide2.QtGui.QFocusEvent)",
    "PySide2.QtWidgets.QAbstractItemView.focusNextPrevChild(self,next:bool)->bool",
    "PySide2.QtWidgets.QAbstractItemView.focusOutEvent(self,event:PySide2.QtGui.QFocusEvent)",
    "PySide2.QtWidgets.QAbstractItemView.hasAutoScroll(self)->bool",
    "PySide2.QtWidgets.QAbstractItemView.horizontalOffset(self)->int",
    "PySide2.QtWidgets.QAbstractItemView.horizontalScrollMode(self)->PySide2.QtWidgets.QAbstractItemView.ScrollMode",
    "PySide2.QtWidgets.QAbstractItemView.horizontalScrollbarAction(self,action:int)",
    "PySide2.QtWidgets.QAbstractItemView.horizontalScrollbarValueChanged(self,value:int)",
    "PySide2.QtWidgets.QAbstractItemView.horizontalStepsPerItem(self)->int",
    "PySide2.QtWidgets.QAbstractItemView.iconSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QAbstractItemView.indexAt(self,point:PySide2.QtCore.QPoint)->PySide2.QtCore.QModelIndex",
    "PySide2.QtWidgets.QAbstractItemView.indexWidget(self,index:PySide2.QtCore.QModelIndex)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QAbstractItemView.inputMethodEvent(self,event:PySide2.QtGui.QInputMethodEvent)",
    "PySide2.QtWidgets.QAbstractItemView.inputMethodQuery(self,query:PySide2.QtCore.Qt.InputMethodQuery)->QVariant",
    "PySide2.QtWidgets.QAbstractItemView.isIndexHidden(self,index:PySide2.QtCore.QModelIndex)->bool",
    "PySide2.QtWidgets.QAbstractItemView.isPersistentEditorOpen(self,index:PySide2.QtCore.QModelIndex)->bool",
    "1:PySide2.QtWidgets.QAbstractItemView.itemDelegate(self)->PySide2.QtWidgets.QAbstractItemDelegate",
    "0:PySide2.QtWidgets.QAbstractItemView.itemDelegate(self,index:PySide2.QtCore.QModelIndex)->PySide2.QtWidgets.QAbstractItemDelegate",
    "PySide2.QtWidgets.QAbstractItemView.itemDelegateForColumn(self,column:int)->PySide2.QtWidgets.QAbstractItemDelegate",
    "PySide2.QtWidgets.QAbstractItemView.itemDelegateForRow(self,row:int)->PySide2.QtWidgets.QAbstractItemDelegate",
    "PySide2.QtWidgets.QAbstractItemView.keyPressEvent(self,event:PySide2.QtGui.QKeyEvent)",
    "PySide2.QtWidgets.QAbstractItemView.keyboardSearch(self,search:QString)",
    "PySide2.QtWidgets.QAbstractItemView.model(self)->PySide2.QtCore.QAbstractItemModel",
    "PySide2.QtWidgets.QAbstractItemView.mouseDoubleClickEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtWidgets.QAbstractItemView.mouseMoveEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtWidgets.QAbstractItemView.mousePressEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtWidgets.QAbstractItemView.mouseReleaseEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtWidgets.QAbstractItemView.moveCursor(self,cursorAction:PySide2.QtWidgets.QAbstractItemView.CursorAction,modifiers:PySide2.QtCore.Qt.KeyboardModifiers)->PySide2.QtCore.QModelIndex",
    "PySide2.QtWidgets.QAbstractItemView.openPersistentEditor(self,index:PySide2.QtCore.QModelIndex)",
    "PySide2.QtWidgets.QAbstractItemView.reset(self)",
    "PySide2.QtWidgets.QAbstractItemView.resetHorizontalScrollMode(self)",
    "PySide2.QtWidgets.QAbstractItemView.resetVerticalScrollMode(self)",
    "PySide2.QtWidgets.QAbstractItemView.resizeEvent(self,event:PySide2.QtGui.QResizeEvent)",
    "PySide2.QtWidgets.QAbstractItemView.rootIndex(self)->PySide2.QtCore.QModelIndex",
    "PySide2.QtWidgets.QAbstractItemView.rowsAboutToBeRemoved(self,parent:PySide2.QtCore.QModelIndex,start:int,end:int)",
    "PySide2.QtWidgets.QAbstractItemView.rowsInserted(self,parent:PySide2.QtCore.QModelIndex,start:int,end:int)",
    "PySide2.QtWidgets.QAbstractItemView.scheduleDelayedItemsLayout(self)",
    "PySide2.QtWidgets.QAbstractItemView.scrollDirtyRegion(self,dx:int,dy:int)",
    "PySide2.QtWidgets.QAbstractItemView.scrollTo(self,index:PySide2.QtCore.QModelIndex,hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint=EnsureVisible)",
    "PySide2.QtWidgets.QAbstractItemView.scrollToBottom(self)",
    "PySide2.QtWidgets.QAbstractItemView.scrollToTop(self)",
    "PySide2.QtWidgets.QAbstractItemView.selectAll(self)",
    "PySide2.QtWidgets.QAbstractItemView.selectedIndexes(self)->QModelIndexList",
    "PySide2.QtWidgets.QAbstractItemView.selectionBehavior(self)->PySide2.QtWidgets.QAbstractItemView.SelectionBehavior",
    "PySide2.QtWidgets.QAbstractItemView.selectionChanged(self,selected:PySide2.QtCore.QItemSelection,deselected:PySide2.QtCore.QItemSelection)",
    "PySide2.QtWidgets.QAbstractItemView.selectionCommand(self,index:PySide2.QtCore.QModelIndex,event:PySide2.QtCore.QEvent=nullptr)->PySide2.QtCore.QItemSelectionModel.SelectionFlags",
    "PySide2.QtWidgets.QAbstractItemView.selectionMode(self)->PySide2.QtWidgets.QAbstractItemView.SelectionMode",
    "PySide2.QtWidgets.QAbstractItemView.selectionModel(self)->PySide2.QtCore.QItemSelectionModel",
    "PySide2.QtWidgets.QAbstractItemView.setAlternatingRowColors(self,enable:bool)",
    "PySide2.QtWidgets.QAbstractItemView.setAutoScroll(self,enable:bool)",
    "PySide2.QtWidgets.QAbstractItemView.setAutoScrollMargin(self,margin:int)",
    "PySide2.QtWidgets.QAbstractItemView.setCurrentIndex(self,index:PySide2.QtCore.QModelIndex)",
    "PySide2.QtWidgets.QAbstractItemView.setDefaultDropAction(self,dropAction:PySide2.QtCore.Qt.DropAction)",
    "PySide2.QtWidgets.QAbstractItemView.setDirtyRegion(self,region:PySide2.QtGui.QRegion)",
    "PySide2.QtWidgets.QAbstractItemView.setDragDropMode(self,behavior:PySide2.QtWidgets.QAbstractItemView.DragDropMode)",
    "PySide2.QtWidgets.QAbstractItemView.setDragDropOverwriteMode(self,overwrite:bool)",
    "PySide2.QtWidgets.QAbstractItemView.setDragEnabled(self,enable:bool)",
    "PySide2.QtWidgets.QAbstractItemView.setDropIndicatorShown(self,enable:bool)",
    "PySide2.QtWidgets.QAbstractItemView.setEditTriggers(self,triggers:PySide2.QtWidgets.QAbstractItemView.EditTriggers)",
    "PySide2.QtWidgets.QAbstractItemView.setHorizontalScrollMode(self,mode:PySide2.QtWidgets.QAbstractItemView.ScrollMode)",
    "PySide2.QtWidgets.QAbstractItemView.setHorizontalStepsPerItem(self,steps:int)",
    "PySide2.QtWidgets.QAbstractItemView.setIconSize(self,size:PySide2.QtCore.QSize)",
    "PySide2.QtWidgets.QAbstractItemView.setIndexWidget(self,index:PySide2.QtCore.QModelIndex,widget:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QAbstractItemView.setItemDelegate(self,delegate:PySide2.QtWidgets.QAbstractItemDelegate)",
    "PySide2.QtWidgets.QAbstractItemView.setItemDelegateForColumn(self,column:int,delegate:PySide2.QtWidgets.QAbstractItemDelegate)",
    "PySide2.QtWidgets.QAbstractItemView.setItemDelegateForRow(self,row:int,delegate:PySide2.QtWidgets.QAbstractItemDelegate)",
    "PySide2.QtWidgets.QAbstractItemView.setModel(self,model:PySide2.QtCore.QAbstractItemModel)",
    "PySide2.QtWidgets.QAbstractItemView.setRootIndex(self,index:PySide2.QtCore.QModelIndex)",
    "PySide2.QtWidgets.QAbstractItemView.setSelection(self,rect:PySide2.QtCore.QRect,command:PySide2.QtCore.QItemSelectionModel.SelectionFlags)",
    "PySide2.QtWidgets.QAbstractItemView.setSelectionBehavior(self,behavior:PySide2.QtWidgets.QAbstractItemView.SelectionBehavior)",
    "PySide2.QtWidgets.QAbstractItemView.setSelectionMode(self,mode:PySide2.QtWidgets.QAbstractItemView.SelectionMode)",
    "PySide2.QtWidgets.QAbstractItemView.setSelectionModel(self,selectionModel:PySide2.QtCore.QItemSelectionModel)",
    "PySide2.QtWidgets.QAbstractItemView.setState(self,state:PySide2.QtWidgets.QAbstractItemView.State)",
    "PySide2.QtWidgets.QAbstractItemView.setTabKeyNavigation(self,enable:bool)",
    "PySide2.QtWidgets.QAbstractItemView.setTextElideMode(self,mode:PySide2.QtCore.Qt.TextElideMode)",
    "PySide2.QtWidgets.QAbstractItemView.setVerticalScrollMode(self,mode:PySide2.QtWidgets.QAbstractItemView.ScrollMode)",
    "PySide2.QtWidgets.QAbstractItemView.setVerticalStepsPerItem(self,steps:int)",
    "PySide2.QtWidgets.QAbstractItemView.showDropIndicator(self)->bool",
    "PySide2.QtWidgets.QAbstractItemView.sizeHintForColumn(self,column:int)->int",
    "PySide2.QtWidgets.QAbstractItemView.sizeHintForIndex(self,index:PySide2.QtCore.QModelIndex)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QAbstractItemView.sizeHintForRow(self,row:int)->int",
    "PySide2.QtWidgets.QAbstractItemView.startAutoScroll(self)",
    "PySide2.QtWidgets.QAbstractItemView.startDrag(self,supportedActions:PySide2.QtCore.Qt.DropActions)",
    "PySide2.QtWidgets.QAbstractItemView.state(self)->PySide2.QtWidgets.QAbstractItemView.State",
    "PySide2.QtWidgets.QAbstractItemView.stopAutoScroll(self)",
    "PySide2.QtWidgets.QAbstractItemView.tabKeyNavigation(self)->bool",
    "PySide2.QtWidgets.QAbstractItemView.textElideMode(self)->PySide2.QtCore.Qt.TextElideMode",
    "PySide2.QtWidgets.QAbstractItemView.timerEvent(self,event:PySide2.QtCore.QTimerEvent)",
    "1:PySide2.QtWidgets.QAbstractItemView.update(self,index:PySide2.QtCore.QModelIndex)",
    "0:PySide2.QtWidgets.QAbstractItemView.update(self)",
    "PySide2.QtWidgets.QAbstractItemView.updateEditorData(self)",
    "PySide2.QtWidgets.QAbstractItemView.updateEditorGeometries(self)",
    "PySide2.QtWidgets.QAbstractItemView.updateGeometries(self)",
    "PySide2.QtWidgets.QAbstractItemView.verticalOffset(self)->int",
    "PySide2.QtWidgets.QAbstractItemView.verticalScrollMode(self)->PySide2.QtWidgets.QAbstractItemView.ScrollMode",
    "PySide2.QtWidgets.QAbstractItemView.verticalScrollbarAction(self,action:int)",
    "PySide2.QtWidgets.QAbstractItemView.verticalScrollbarValueChanged(self,value:int)",
    "PySide2.QtWidgets.QAbstractItemView.verticalStepsPerItem(self)->int",
    "PySide2.QtWidgets.QAbstractItemView.viewOptions(self)->PySide2.QtWidgets.QStyleOptionViewItem",
    "PySide2.QtWidgets.QAbstractItemView.viewportEvent(self,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QAbstractItemView.viewportSizeHint(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QAbstractItemView.visualRect(self,index:PySide2.QtCore.QModelIndex)->PySide2.QtCore.QRect",
    "PySide2.QtWidgets.QAbstractItemView.visualRegionForSelection(self,selection:PySide2.QtCore.QItemSelection)->PySide2.QtGui.QRegion",
    nullptr}; // Sentinel

void init_QAbstractItemView(PyObject *module)
{
    _Sbk_QAbstractItemView_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractItemView",
        "QAbstractItemView*",
        &Sbk_QAbstractItemView_spec,
        &Shiboken::callCppDestructor< ::QAbstractItemView >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSCROLLAREA_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractItemView_Type);
    InitSignatureStrings(pyType, QAbstractItemView_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractItemView_Type), Sbk_QAbstractItemView_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractItemView_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractItemView_TypeF(),
        QAbstractItemView_PythonToCpp_QAbstractItemView_PTR,
        is_QAbstractItemView_PythonToCpp_QAbstractItemView_PTR_Convertible,
        QAbstractItemView_PTR_CppToPython_QAbstractItemView);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractItemView).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractItemViewWrapper).name());


    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QAbstractItemView_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QAbstractItemView_TypeF(), &Sbk_QAbstractItemViewSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAbstractItemView_TypeF(), &Sbk_QAbstractItemView_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'SelectionMode'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemView_TypeF(),
        "SelectionMode",
        "2:PySide2.QtWidgets.QAbstractItemView.SelectionMode",
        "QAbstractItemView::SelectionMode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "NoSelection", (long) QAbstractItemView::SelectionMode::NoSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "SingleSelection", (long) QAbstractItemView::SelectionMode::SingleSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "MultiSelection", (long) QAbstractItemView::SelectionMode::MultiSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "ExtendedSelection", (long) QAbstractItemView::SelectionMode::ExtendedSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "ContiguousSelection", (long) QAbstractItemView::SelectionMode::ContiguousSelection))
        return;
    // Register converter for enum 'QAbstractItemView::SelectionMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX],
            QAbstractItemView_SelectionMode_CppToPython_QAbstractItemView_SelectionMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_SelectionMode_PythonToCpp_QAbstractItemView_SelectionMode,
            is_QAbstractItemView_SelectionMode_PythonToCpp_QAbstractItemView_SelectionMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::SelectionMode");
        Shiboken::Conversions::registerConverterName(converter, "SelectionMode");
    }
    // End of 'SelectionMode' enum.

    // Initialization of enum 'SelectionBehavior'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemView_TypeF(),
        "SelectionBehavior",
        "2:PySide2.QtWidgets.QAbstractItemView.SelectionBehavior",
        "QAbstractItemView::SelectionBehavior");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX],
        Sbk_QAbstractItemView_TypeF(), "SelectItems", (long) QAbstractItemView::SelectionBehavior::SelectItems))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX],
        Sbk_QAbstractItemView_TypeF(), "SelectRows", (long) QAbstractItemView::SelectionBehavior::SelectRows))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX],
        Sbk_QAbstractItemView_TypeF(), "SelectColumns", (long) QAbstractItemView::SelectionBehavior::SelectColumns))
        return;
    // Register converter for enum 'QAbstractItemView::SelectionBehavior'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX],
            QAbstractItemView_SelectionBehavior_CppToPython_QAbstractItemView_SelectionBehavior);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_SelectionBehavior_PythonToCpp_QAbstractItemView_SelectionBehavior,
            is_QAbstractItemView_SelectionBehavior_PythonToCpp_QAbstractItemView_SelectionBehavior_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::SelectionBehavior");
        Shiboken::Conversions::registerConverterName(converter, "SelectionBehavior");
    }
    // End of 'SelectionBehavior' enum.

    // Initialization of enum 'ScrollHint'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemView_TypeF(),
        "ScrollHint",
        "2:PySide2.QtWidgets.QAbstractItemView.ScrollHint",
        "QAbstractItemView::ScrollHint");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX],
        Sbk_QAbstractItemView_TypeF(), "EnsureVisible", (long) QAbstractItemView::ScrollHint::EnsureVisible))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX],
        Sbk_QAbstractItemView_TypeF(), "PositionAtTop", (long) QAbstractItemView::ScrollHint::PositionAtTop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX],
        Sbk_QAbstractItemView_TypeF(), "PositionAtBottom", (long) QAbstractItemView::ScrollHint::PositionAtBottom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX],
        Sbk_QAbstractItemView_TypeF(), "PositionAtCenter", (long) QAbstractItemView::ScrollHint::PositionAtCenter))
        return;
    // Register converter for enum 'QAbstractItemView::ScrollHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX],
            QAbstractItemView_ScrollHint_CppToPython_QAbstractItemView_ScrollHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_ScrollHint_PythonToCpp_QAbstractItemView_ScrollHint,
            is_QAbstractItemView_ScrollHint_PythonToCpp_QAbstractItemView_ScrollHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::ScrollHint");
        Shiboken::Conversions::registerConverterName(converter, "ScrollHint");
    }
    // End of 'ScrollHint' enum.

    // Initialization of enum 'EditTrigger'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QAbstractItemView.EditTriggers", SbkPySide2_QtWidgets_QAbstractItemView_EditTrigger_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemView_TypeF(),
        "EditTrigger",
        "2:PySide2.QtWidgets.QAbstractItemView.EditTrigger",
        "QAbstractItemView::EditTrigger",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX],
        Sbk_QAbstractItemView_TypeF(), "NoEditTriggers", (long) QAbstractItemView::EditTrigger::NoEditTriggers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX],
        Sbk_QAbstractItemView_TypeF(), "CurrentChanged", (long) QAbstractItemView::EditTrigger::CurrentChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX],
        Sbk_QAbstractItemView_TypeF(), "DoubleClicked", (long) QAbstractItemView::EditTrigger::DoubleClicked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX],
        Sbk_QAbstractItemView_TypeF(), "SelectedClicked", (long) QAbstractItemView::EditTrigger::SelectedClicked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX],
        Sbk_QAbstractItemView_TypeF(), "EditKeyPressed", (long) QAbstractItemView::EditTrigger::EditKeyPressed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX],
        Sbk_QAbstractItemView_TypeF(), "AnyKeyPressed", (long) QAbstractItemView::EditTrigger::AnyKeyPressed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX],
        Sbk_QAbstractItemView_TypeF(), "AllEditTriggers", (long) QAbstractItemView::EditTrigger::AllEditTriggers))
        return;
    // Register converter for enum 'QAbstractItemView::EditTrigger'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX],
            QAbstractItemView_EditTrigger_CppToPython_QAbstractItemView_EditTrigger);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_EditTrigger_PythonToCpp_QAbstractItemView_EditTrigger,
            is_QAbstractItemView_EditTrigger_PythonToCpp_QAbstractItemView_EditTrigger_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::EditTrigger");
        Shiboken::Conversions::registerConverterName(converter, "EditTrigger");
    }
    // Register converter for flag 'QFlags<QAbstractItemView::EditTrigger>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX],
            QFlags_QAbstractItemView_EditTrigger__CppToPython_QFlags_QAbstractItemView_EditTrigger_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_EditTrigger_PythonToCpp_QFlags_QAbstractItemView_EditTrigger_,
            is_QAbstractItemView_EditTrigger_PythonToCpp_QFlags_QAbstractItemView_EditTrigger__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QAbstractItemView_EditTrigger__PythonToCpp_QFlags_QAbstractItemView_EditTrigger_,
            is_QFlags_QAbstractItemView_EditTrigger__PythonToCpp_QFlags_QAbstractItemView_EditTrigger__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QAbstractItemView_EditTrigger_,
            is_number_PythonToCpp_QFlags_QAbstractItemView_EditTrigger__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::EditTriggers");
        Shiboken::Conversions::registerConverterName(converter, "EditTriggers");
    }
    // End of 'EditTrigger' enum/flags.

    // Initialization of enum 'ScrollMode'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemView_TypeF(),
        "ScrollMode",
        "2:PySide2.QtWidgets.QAbstractItemView.ScrollMode",
        "QAbstractItemView::ScrollMode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "ScrollPerItem", (long) QAbstractItemView::ScrollMode::ScrollPerItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "ScrollPerPixel", (long) QAbstractItemView::ScrollMode::ScrollPerPixel))
        return;
    // Register converter for enum 'QAbstractItemView::ScrollMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX],
            QAbstractItemView_ScrollMode_CppToPython_QAbstractItemView_ScrollMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_ScrollMode_PythonToCpp_QAbstractItemView_ScrollMode,
            is_QAbstractItemView_ScrollMode_PythonToCpp_QAbstractItemView_ScrollMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::ScrollMode");
        Shiboken::Conversions::registerConverterName(converter, "ScrollMode");
    }
    // End of 'ScrollMode' enum.

    // Initialization of enum 'DragDropMode'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemView_TypeF(),
        "DragDropMode",
        "2:PySide2.QtWidgets.QAbstractItemView.DragDropMode",
        "QAbstractItemView::DragDropMode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "NoDragDrop", (long) QAbstractItemView::DragDropMode::NoDragDrop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "DragOnly", (long) QAbstractItemView::DragDropMode::DragOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "DropOnly", (long) QAbstractItemView::DragDropMode::DropOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "DragDrop", (long) QAbstractItemView::DragDropMode::DragDrop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX],
        Sbk_QAbstractItemView_TypeF(), "InternalMove", (long) QAbstractItemView::DragDropMode::InternalMove))
        return;
    // Register converter for enum 'QAbstractItemView::DragDropMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX],
            QAbstractItemView_DragDropMode_CppToPython_QAbstractItemView_DragDropMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_DragDropMode_PythonToCpp_QAbstractItemView_DragDropMode,
            is_QAbstractItemView_DragDropMode_PythonToCpp_QAbstractItemView_DragDropMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::DragDropMode");
        Shiboken::Conversions::registerConverterName(converter, "DragDropMode");
    }
    // End of 'DragDropMode' enum.

    // Initialization of enum 'CursorAction'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemView_TypeF(),
        "CursorAction",
        "2:PySide2.QtWidgets.QAbstractItemView.CursorAction",
        "QAbstractItemView::CursorAction");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MoveUp", (long) QAbstractItemView::CursorAction::MoveUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MoveDown", (long) QAbstractItemView::CursorAction::MoveDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MoveLeft", (long) QAbstractItemView::CursorAction::MoveLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MoveRight", (long) QAbstractItemView::CursorAction::MoveRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MoveHome", (long) QAbstractItemView::CursorAction::MoveHome))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MoveEnd", (long) QAbstractItemView::CursorAction::MoveEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MovePageUp", (long) QAbstractItemView::CursorAction::MovePageUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MovePageDown", (long) QAbstractItemView::CursorAction::MovePageDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MoveNext", (long) QAbstractItemView::CursorAction::MoveNext))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
        Sbk_QAbstractItemView_TypeF(), "MovePrevious", (long) QAbstractItemView::CursorAction::MovePrevious))
        return;
    // Register converter for enum 'QAbstractItemView::CursorAction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX],
            QAbstractItemView_CursorAction_CppToPython_QAbstractItemView_CursorAction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_CursorAction_PythonToCpp_QAbstractItemView_CursorAction,
            is_QAbstractItemView_CursorAction_PythonToCpp_QAbstractItemView_CursorAction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::CursorAction");
        Shiboken::Conversions::registerConverterName(converter, "CursorAction");
    }
    // End of 'CursorAction' enum.

    // Initialization of enum 'State'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemView_TypeF(),
        "State",
        "2:PySide2.QtWidgets.QAbstractItemView.State",
        "QAbstractItemView::State");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX],
        Sbk_QAbstractItemView_TypeF(), "NoState", (long) QAbstractItemView::State::NoState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX],
        Sbk_QAbstractItemView_TypeF(), "DraggingState", (long) QAbstractItemView::State::DraggingState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX],
        Sbk_QAbstractItemView_TypeF(), "DragSelectingState", (long) QAbstractItemView::State::DragSelectingState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX],
        Sbk_QAbstractItemView_TypeF(), "EditingState", (long) QAbstractItemView::State::EditingState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX],
        Sbk_QAbstractItemView_TypeF(), "ExpandingState", (long) QAbstractItemView::State::ExpandingState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX],
        Sbk_QAbstractItemView_TypeF(), "CollapsingState", (long) QAbstractItemView::State::CollapsingState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX],
        Sbk_QAbstractItemView_TypeF(), "AnimatingState", (long) QAbstractItemView::State::AnimatingState))
        return;
    // Register converter for enum 'QAbstractItemView::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX],
            QAbstractItemView_State_CppToPython_QAbstractItemView_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_State_PythonToCpp_QAbstractItemView_State,
            is_QAbstractItemView_State_PythonToCpp_QAbstractItemView_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'DropIndicatorPosition'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemView_TypeF(),
        "DropIndicatorPosition",
        "2:PySide2.QtWidgets.QAbstractItemView.DropIndicatorPosition",
        "QAbstractItemView::DropIndicatorPosition");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX],
        Sbk_QAbstractItemView_TypeF(), "OnItem", (long) QAbstractItemView::DropIndicatorPosition::OnItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX],
        Sbk_QAbstractItemView_TypeF(), "AboveItem", (long) QAbstractItemView::DropIndicatorPosition::AboveItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX],
        Sbk_QAbstractItemView_TypeF(), "BelowItem", (long) QAbstractItemView::DropIndicatorPosition::BelowItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX],
        Sbk_QAbstractItemView_TypeF(), "OnViewport", (long) QAbstractItemView::DropIndicatorPosition::OnViewport))
        return;
    // Register converter for enum 'QAbstractItemView::DropIndicatorPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX],
            QAbstractItemView_DropIndicatorPosition_CppToPython_QAbstractItemView_DropIndicatorPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemView_DropIndicatorPosition_PythonToCpp_QAbstractItemView_DropIndicatorPosition,
            is_QAbstractItemView_DropIndicatorPosition_PythonToCpp_QAbstractItemView_DropIndicatorPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemView::DropIndicatorPosition");
        Shiboken::Conversions::registerConverterName(converter, "DropIndicatorPosition");
    }
    // End of 'DropIndicatorPosition' enum.

    PySide::Signal::registerSignals(Sbk_QAbstractItemView_TypeF(), &::QAbstractItemView::staticMetaObject);
    qRegisterMetaType< ::QAbstractItemView::SelectionMode >("QAbstractItemView::SelectionMode");
    qRegisterMetaType< ::QAbstractItemView::SelectionBehavior >("QAbstractItemView::SelectionBehavior");
    qRegisterMetaType< ::QAbstractItemView::ScrollHint >("QAbstractItemView::ScrollHint");
    qRegisterMetaType< ::QAbstractItemView::EditTrigger >("QAbstractItemView::EditTrigger");
    qRegisterMetaType< ::QAbstractItemView::EditTriggers >("QAbstractItemView::EditTriggers");
    qRegisterMetaType< ::QAbstractItemView::ScrollMode >("QAbstractItemView::ScrollMode");
    qRegisterMetaType< ::QAbstractItemView::DragDropMode >("QAbstractItemView::DragDropMode");
    qRegisterMetaType< ::QAbstractItemView::CursorAction >("QAbstractItemView::CursorAction");
    qRegisterMetaType< ::QAbstractItemView::State >("QAbstractItemView::State");
    qRegisterMetaType< ::QAbstractItemView::DropIndicatorPosition >("QAbstractItemView::DropIndicatorPosition");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAbstractItemView_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAbstractItemView_TypeF(), &::QAbstractItemView::staticMetaObject, sizeof(QAbstractItemViewWrapper));
}
