/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QAPPLICATIONWRAPPER_H
#define SBK_QAPPLICATIONWRAPPER_H

#define protected public

#include <QtWidgets/qapplication.h>


// Extra includes
#include <QBasicTimer>
#include <QFont>
#include <QFontMetrics>
#include <QPalette>
#include <QIcon>
#include <QLocale>
#include <QStyle>
#include <qobject.h>
#include <QtWidgets/qstyle.h>
#include <QtGui/qpalette.h>
#include <QtWidgets/qwidget.h>
#include <QtGui/qfont.h>
#include <QtGui/qfontmetrics.h>
#include <QtGui/qicon.h>
#include <QList>
#include <QtWidgets/qdesktopwidget.h>
#include <qpoint.h>
#include <qsize.h>
#include <qcoreevent.h>
#include <QtGui/qwindow.h>
#include <QtGui/qinputmethod.h>
#include <qobjectdefs.h>
#include <qmetaobject.h>
#include <QtGui/qscreen.h>
#include <QtGui/qclipboard.h>
#include <QtGui/qcursor.h>
#include <QtGui/qsessionmanager.h>
#include <QtGui/qstylehints.h>
namespace PySide { class DynamicQMetaObject; }

class QApplicationWrapper : public QApplication
{
public:
    QApplicationWrapper(int & argc, char ** argv, int arg__3 = ApplicationFlags);
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    const ::QMetaObject * metaObject() const override;
    bool notify(::QObject * arg__1, ::QEvent * arg__2) override;
    void timerEvent(::QTimerEvent * event) override;
    ~QApplicationWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[9];
};

#endif // SBK_QAPPLICATIONWRAPPER_H

