/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qboxlayout_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtwidgets.cpp (qlayout-help-functions)]
void addLayoutOwnership(QLayout *layout, QLayoutItem *item);
void removeLayoutOwnership(QLayout *layout, QWidget *widget);

inline QByteArray retrieveObjectName(PyObject *obj)
{
    Shiboken::AutoDecRef objName(PyObject_Str(obj));
    return Shiboken::String::toCString(objName);
}

inline void addLayoutOwnership(QLayout *layout, QWidget *widget)
{
    //transfer ownership to parent widget
    QWidget *lw = layout->parentWidget();
    QWidget *pw = widget->parentWidget();

   Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget));

    //Transfer parent to layout widget
    if (pw && lw && pw != lw)
        Shiboken::Object::setParent(0, pyChild);

    if (!lw && !pw) {
        //keep the reference while the layout is orphan
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), layout));
        Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(pyParent.object()), retrieveObjectName(pyParent).data(), pyChild, true);
    } else {
        if (!lw)
            lw = pw;
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), lw));
        Shiboken::Object::setParent(pyParent, pyChild);
    }
}

inline void addLayoutOwnership(QLayout *layout, QLayout *other)
{
    //transfer all children widgets from other to layout parent widget
    QWidget *parent = layout->parentWidget();
    if (!parent) {
        //keep the reference while the layout is orphan
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), layout));
        Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), other));
        Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(pyParent.object()),
                                        retrieveObjectName(pyParent).data(), pyChild, true);
        return;
    }

    for (int i=0, i_max=other->count(); i < i_max; i++) {
        QLayoutItem *item = other->itemAt(i);
        if (PyErr_Occurred() || !item)
            return;
        addLayoutOwnership(layout, item);
    }

    Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), layout));
    Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), other));
    Shiboken::Object::setParent(pyParent, pyChild);
}

inline void addLayoutOwnership(QLayout *layout, QLayoutItem *item)
{
    if (!item)
        return;

    if (QWidget *w = item->widget()) {
        addLayoutOwnership(layout, w);
    } else {
        if (QLayout *l = item->layout())
            addLayoutOwnership(layout, l);
    }

    Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), layout));
    Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), item));
    Shiboken::Object::setParent(pyParent, pyChild);
}

static void removeWidgetFromLayout(QLayout *layout, QWidget *widget)
{
    QWidget *parent = widget->parentWidget();

    if (!parent) {
        //remove reference on layout
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), layout));
        Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget));
        Shiboken::Object::removeReference(reinterpret_cast<SbkObject *>(pyParent.object()),
                                          retrieveObjectName(pyParent).data(), pyChild);
    } else {
        //give the ownership to parent
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), parent));
        Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget));
        Shiboken::Object::setParent(pyParent, pyChild);
    }
}

inline void removeLayoutOwnership(QLayout *layout, QLayoutItem *item)
{
    if (QWidget *w = item->widget()) {
        removeWidgetFromLayout(layout, w);
    } else {
        QLayout *l = item->layout();
        if (l && item != l)
            removeLayoutOwnership(layout, l);
    }

    Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), item));
    Shiboken::Object::invalidate(pyChild);
    Shiboken::Object::setParent(0, pyChild);
}

inline void removeLayoutOwnership(QLayout *layout, QWidget *widget)
{
    if (!widget)
        return;

    for (int i=0, i_max=layout->count(); i < i_max; i++) {
        QLayoutItem *item = layout->itemAt(i);
        if (PyErr_Occurred() || !item)
            return;
        if (item->widget() == widget)
            removeLayoutOwnership(layout, item);
    }
}
// END of custom code block [file: ../glue/qtwidgets.cpp (qlayout-help-functions)]
// ========================================================================

// End of code injection


// Native ---------------------------------------------------------

void QBoxLayoutWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QBoxLayoutWrapper::QBoxLayoutWrapper(::QBoxLayout::Direction arg__1, ::QWidget * parent) : QBoxLayout(arg__1, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QBoxLayoutWrapper::addItem(::QLayoutItem * arg__1)
{
    if (m_PyMethodCache[0]) {
        return this->::QBoxLayout::addItem(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "addItem";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QBoxLayout::addItem(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }

}

void QBoxLayoutWrapper::childEvent(::QChildEvent * e)
{
    if (m_PyMethodCache[1]) {
        return this->::QLayout::childEvent(e);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QLayout::childEvent(e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), e)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBoxLayoutWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QFlags<QSizePolicy::ControlType> QBoxLayoutWrapper::controlTypes() const
{
    if (m_PyMethodCache[3])
        return this->::QLayout::controlTypes();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QSizePolicy::ControlType>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "controlTypes";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QLayout::controlTypes();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QSizePolicy::ControlType>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.controlTypes", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QSizePolicy::ControlType> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QSizePolicy::ControlType>(0);
    }
    ::QFlags<QSizePolicy::ControlType> cppResult = QFlags<QSizePolicy::ControlType>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QBoxLayoutWrapper::count() const
{
    if (m_PyMethodCache[4])
        return this->::QBoxLayout::count();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "count";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QBoxLayout::count();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.count", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QBoxLayoutWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBoxLayoutWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QBoxLayoutWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QBoxLayoutWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[8])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QFlags<Qt::Orientation> QBoxLayoutWrapper::expandingDirections() const
{
    if (m_PyMethodCache[9])
        return this->::QBoxLayout::expandingDirections();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<Qt::Orientation>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "expandingDirections";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QBoxLayout::expandingDirections();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.expandingDirections", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<Qt::Orientation> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<Qt::Orientation>(0);
    }
    ::QFlags<Qt::Orientation> cppResult = QFlags<Qt::Orientation>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRect QBoxLayoutWrapper::geometry() const
{
    if (m_PyMethodCache[10])
        return this->::QLayout::geometry();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "geometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QLayout::geometry();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.geometry", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRect >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRect cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QBoxLayoutWrapper::hasHeightForWidth() const
{
    if (m_PyMethodCache[11])
        return this->::QBoxLayout::hasHeightForWidth();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QBoxLayout::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.hasHeightForWidth", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QBoxLayoutWrapper::heightForWidth(int arg__1) const
{
    if (m_PyMethodCache[12])
        return this->::QBoxLayout::heightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "heightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QBoxLayout::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.heightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QBoxLayoutWrapper::indexOf(::QWidget * arg__1) const
{
    if (m_PyMethodCache[13])
        return this->::QLayout::indexOf(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "indexOf";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QLayout::indexOf(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.indexOf", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QBoxLayoutWrapper::invalidate()
{
    if (m_PyMethodCache[14]) {
        return this->::QBoxLayout::invalidate();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "invalidate";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QBoxLayout::invalidate();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QBoxLayoutWrapper::isEmpty() const
{
    if (m_PyMethodCache[15])
        return this->::QLayout::isEmpty();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isEmpty";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QLayout::isEmpty();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.isEmpty", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QLayoutItem * QBoxLayoutWrapper::itemAt(int arg__1) const
{
    if (m_PyMethodCache[16]) {
        return this->::QBoxLayout::itemAt(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "itemAt";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QBoxLayout::itemAt(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.itemAt", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QLayoutItem >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QLayoutItem *cppResult;
    pythonToCpp(pyResult, &cppResult);

    return cppResult;
}

::QLayout * QBoxLayoutWrapper::layout()
{
    if (m_PyMethodCache[17])
        return this->::QLayout::layout();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "layout";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QLayout::layout();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.layout", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QLayout >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QLayout *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QBoxLayoutWrapper::maximumSize() const
{
    if (m_PyMethodCache[18])
        return this->::QBoxLayout::maximumSize();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "maximumSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QBoxLayout::maximumSize();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.maximumSize", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QBoxLayoutWrapper::minimumHeightForWidth(int arg__1) const
{
    if (m_PyMethodCache[20])
        return this->::QBoxLayout::minimumHeightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QBoxLayout::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.minimumHeightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QBoxLayoutWrapper::minimumSize() const
{
    if (m_PyMethodCache[21])
        return this->::QBoxLayout::minimumSize();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QBoxLayout::minimumSize();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.minimumSize", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QBoxLayoutWrapper::setGeometry(const ::QRect & arg__1)
{
    if (m_PyMethodCache[22]) {
        return this->::QBoxLayout::setGeometry(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setGeometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QBoxLayout::setGeometry(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSize QBoxLayoutWrapper::sizeHint() const
{
    if (m_PyMethodCache[23])
        return this->::QBoxLayout::sizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QBoxLayout::sizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.sizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSpacerItem * QBoxLayoutWrapper::spacerItem()
{
    if (m_PyMethodCache[24])
        return this->::QLayoutItem::spacerItem();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "spacerItem";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QLayoutItem::spacerItem();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSPACERITEM_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.spacerItem", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSpacerItem >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSpacerItem *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QLayoutItem * QBoxLayoutWrapper::takeAt(int arg__1)
{
    if (m_PyMethodCache[25])
        return this->::QBoxLayout::takeAt(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "takeAt";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QBoxLayout::takeAt(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.takeAt", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QLayoutItem >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QLayoutItem *cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (Shiboken::Object::checkType(pyResult))
        Shiboken::Object::releaseOwnership(pyResult);
    return cppResult;
}

void QBoxLayoutWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[26]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QWidget * QBoxLayoutWrapper::widget()
{
    if (m_PyMethodCache[27])
        return this->::QLayoutItem::widget();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "widget";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QLayoutItem::widget();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxLayout.widget", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QWidget >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWidget *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QBoxLayoutWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QBoxLayout::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QBoxLayoutWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QBoxLayout::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QBoxLayoutWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QBoxLayoutWrapper *>(this));
        return QBoxLayout::qt_metacast(_clname);
}

QBoxLayoutWrapper::~QBoxLayoutWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QBoxLayout_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QBoxLayout >()))
        return -1;

    ::QBoxLayoutWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayout_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QBoxLayout", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QBoxLayout::QBoxLayout(QBoxLayout::Direction,QWidget*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QBoxLayout(QBoxLayout::Direction,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QBoxLayout(QBoxLayout::Direction,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayout_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QBoxLayout_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1]))))
                        goto Sbk_QBoxLayout_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        ::QBoxLayout::Direction cppArg0{QBoxLayout::LeftToRight};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QBoxLayout(QBoxLayout::Direction,QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QBoxLayoutWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QBoxLayoutWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QBoxLayout >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QBoxLayout_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QBoxLayout_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QBoxLayout_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QBoxLayoutFunc_addItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.addItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::addItem(QLayoutItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), (pyArg)))) {
        overloadId = 0; // addItem(QLayoutItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_addItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLayoutItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addItem(QLayoutItem*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            addLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            // ========================================================================

            // End of code injection

            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QBoxLayout::addItem(cppArg0)
                : cppSelf->addItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_addItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_addLayout(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.addLayout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_addLayout_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_addLayout_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:addLayout", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::addLayout(QLayout*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addLayout(QLayout*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // addLayout(QLayout*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_addLayout_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_stretch = Shiboken::String::createStaticString("stretch");
            if (PyDict_Contains(kwds, key_stretch)) {
                value = PyDict_GetItem(kwds, key_stretch);
                if (value && pyArgs[1]) {
                    errInfo = key_stretch;
                    Py_INCREF(errInfo);
                    goto Sbk_QBoxLayoutFunc_addLayout_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QBoxLayoutFunc_addLayout_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_stretch);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QBoxLayoutFunc_addLayout_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QLayout *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addLayout(QLayout*,int)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            addLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            // ========================================================================

            // End of code injection

            cppSelf->addLayout(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_addLayout_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_addSpacerItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.addSpacerItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxLayout::addSpacerItem(QSpacerItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSPACERITEM_IDX]), (pyArg)))) {
        overloadId = 0; // addSpacerItem(QSpacerItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_addSpacerItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSpacerItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addSpacerItem(QSpacerItem*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            addLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            // ========================================================================

            // End of code injection

            cppSelf->addSpacerItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_addSpacerItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_addSpacing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.addSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxLayout::addSpacing(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // addSpacing(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_addSpacing_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addSpacing(int)
            cppSelf->addSpacing(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_addSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_addStretch(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.addStretch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_addStretch_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:addStretch", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::addStretch(int)
    if (numArgs == 0) {
        overloadId = 0; // addStretch(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // addStretch(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_addStretch_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_stretch = Shiboken::String::createStaticString("stretch");
            if (PyDict_Contains(kwds, key_stretch)) {
                value = PyDict_GetItem(kwds, key_stretch);
                if (value && pyArgs[0]) {
                    errInfo = key_stretch;
                    Py_INCREF(errInfo);
                    goto Sbk_QBoxLayoutFunc_addStretch_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QBoxLayoutFunc_addStretch_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_stretch);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QBoxLayoutFunc_addStretch_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // addStretch(int)
            cppSelf->addStretch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_addStretch_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_addStrut(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.addStrut";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxLayout::addStrut(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // addStrut(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_addStrut_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addStrut(int)
            cppSelf->addStrut(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_addStrut_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_addWidget(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.addWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_addWidget_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_addWidget_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:addWidget", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::addWidget(QWidget*,int,QFlags<Qt::AlignmentFlag>)
    // 1: QLayout::addWidget(QWidget*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addWidget(QWidget*,int,QFlags<Qt::AlignmentFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // addWidget(QWidget*,int,QFlags<Qt::AlignmentFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // addWidget(QWidget*,int,QFlags<Qt::AlignmentFlag>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_addWidget_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addWidget(QWidget * arg__1, int stretch, QFlags<Qt::AlignmentFlag> alignment)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stretch = Shiboken::String::createStaticString("stretch");
                if (PyDict_Contains(kwds, key_stretch)) {
                    value = PyDict_GetItem(kwds, key_stretch);
                    if (value && pyArgs[1]) {
                        errInfo = key_stretch;
                        Py_INCREF(errInfo);
                        goto Sbk_QBoxLayoutFunc_addWidget_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QBoxLayoutFunc_addWidget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stretch);
                }
                static PyObject *const key_alignment = Shiboken::String::createStaticString("alignment");
                if (PyDict_Contains(kwds, key_alignment)) {
                    value = PyDict_GetItem(kwds, key_alignment);
                    if (value && pyArgs[2]) {
                        errInfo = key_alignment;
                        Py_INCREF(errInfo);
                        goto Sbk_QBoxLayoutFunc_addWidget_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QBoxLayoutFunc_addWidget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_alignment);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QBoxLayoutFunc_addWidget_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::AlignmentFlag> cppArg2 = Qt::Alignment();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // addWidget(QWidget*,int,QFlags<Qt::AlignmentFlag>)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
                addLayoutOwnership(cppSelf, cppArg0);
                // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
                // ========================================================================

                // End of code injection

                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                cppSelf->addWidget(cppArg0, cppArg1, cppArg2);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            }
            break;
        }
        case 1: // addWidget(QWidget * w)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QBoxLayoutFunc_addWidget_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // addWidget(QWidget*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
                addLayoutOwnership(cppSelf, cppArg0);
                // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
                // ========================================================================

                // End of code injection

                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                reinterpret_cast<QLayout *>(cppSelf)->addWidget(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_addWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QBoxLayout *>(cppSelf)->::QBoxLayout::count()
                : const_cast<const ::QBoxLayout *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBoxLayoutFunc_direction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.direction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // direction()const
            QBoxLayout::Direction cppResult = const_cast<const ::QBoxLayout *>(cppSelf)->direction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBoxLayoutFunc_expandingDirections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.expandingDirections";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // expandingDirections()const
            QFlags<Qt::Orientation> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QBoxLayout *>(cppSelf)->::QBoxLayout::expandingDirections()
                : const_cast<const ::QBoxLayout *>(cppSelf)->expandingDirections();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBoxLayoutFunc_hasHeightForWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.hasHeightForWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasHeightForWidth()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QBoxLayout *>(cppSelf)->::QBoxLayout::hasHeightForWidth()
                : const_cast<const ::QBoxLayout *>(cppSelf)->hasHeightForWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBoxLayoutFunc_heightForWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.heightForWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayoutItem::heightForWidth(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // heightForWidth(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_heightForWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // heightForWidth(int)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QBoxLayout *>(cppSelf)->::QBoxLayout::heightForWidth(cppArg0)
                : const_cast<const ::QBoxLayout *>(cppSelf)->heightForWidth(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QBoxLayoutFunc_heightForWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_insertItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.insertItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::insertItem(int,QLayoutItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertItem(int,QLayoutItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_insertItem_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QLayoutItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertItem(int,QLayoutItem*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            addLayoutOwnership(cppSelf, cppArg1);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            // ========================================================================

            // End of code injection

            cppSelf->insertItem(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_insertItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_insertLayout(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.insertLayout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_insertLayout_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_insertLayout_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:insertLayout", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::insertLayout(int,QLayout*,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // insertLayout(int,QLayout*,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // insertLayout(int,QLayout*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_insertLayout_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_stretch = Shiboken::String::createStaticString("stretch");
            if (PyDict_Contains(kwds, key_stretch)) {
                value = PyDict_GetItem(kwds, key_stretch);
                if (value && pyArgs[2]) {
                    errInfo = key_stretch;
                    Py_INCREF(errInfo);
                    goto Sbk_QBoxLayoutFunc_insertLayout_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QBoxLayoutFunc_insertLayout_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_stretch);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QBoxLayoutFunc_insertLayout_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QLayout *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // insertLayout(int,QLayout*,int)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            addLayoutOwnership(cppSelf, cppArg1);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            // ========================================================================

            // End of code injection

            cppSelf->insertLayout(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_insertLayout_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_insertSpacerItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.insertSpacerItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertSpacerItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::insertSpacerItem(int,QSpacerItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSPACERITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertSpacerItem(int,QSpacerItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_insertSpacerItem_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSpacerItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertSpacerItem(int,QSpacerItem*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            addLayoutOwnership(cppSelf, cppArg1);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            // ========================================================================

            // End of code injection

            cppSelf->insertSpacerItem(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_insertSpacerItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_insertSpacing(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.insertSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertSpacing", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::insertSpacing(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // insertSpacing(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_insertSpacing_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertSpacing(int,int)
            cppSelf->insertSpacing(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_insertSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_insertStretch(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.insertStretch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_insertStretch_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_insertStretch_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:insertStretch", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::insertStretch(int,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // insertStretch(int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // insertStretch(int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_insertStretch_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_stretch = Shiboken::String::createStaticString("stretch");
            if (PyDict_Contains(kwds, key_stretch)) {
                value = PyDict_GetItem(kwds, key_stretch);
                if (value && pyArgs[1]) {
                    errInfo = key_stretch;
                    Py_INCREF(errInfo);
                    goto Sbk_QBoxLayoutFunc_insertStretch_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QBoxLayoutFunc_insertStretch_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_stretch);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QBoxLayoutFunc_insertStretch_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertStretch(int,int)
            cppSelf->insertStretch(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_insertStretch_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_insertWidget(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.insertWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_insertWidget_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QBoxLayoutFunc_insertWidget_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:insertWidget", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::insertWidget(int,QWidget*,int,QFlags<Qt::AlignmentFlag>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // insertWidget(int,QWidget*,int,QFlags<Qt::AlignmentFlag>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // insertWidget(int,QWidget*,int,QFlags<Qt::AlignmentFlag>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[3])))) {
                overloadId = 0; // insertWidget(int,QWidget*,int,QFlags<Qt::AlignmentFlag>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_insertWidget_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_stretch = Shiboken::String::createStaticString("stretch");
            if (PyDict_Contains(kwds, key_stretch)) {
                value = PyDict_GetItem(kwds, key_stretch);
                if (value && pyArgs[2]) {
                    errInfo = key_stretch;
                    Py_INCREF(errInfo);
                    goto Sbk_QBoxLayoutFunc_insertWidget_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QBoxLayoutFunc_insertWidget_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_stretch);
            }
            static PyObject *const key_alignment = Shiboken::String::createStaticString("alignment");
            if (PyDict_Contains(kwds, key_alignment)) {
                value = PyDict_GetItem(kwds, key_alignment);
                if (value && pyArgs[3]) {
                    errInfo = key_alignment;
                    Py_INCREF(errInfo);
                    goto Sbk_QBoxLayoutFunc_insertWidget_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QBoxLayoutFunc_insertWidget_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_alignment);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QBoxLayoutFunc_insertWidget_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QFlags<Qt::AlignmentFlag> cppArg3 = Qt::Alignment();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // insertWidget(int,QWidget*,int,QFlags<Qt::AlignmentFlag>)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            addLayoutOwnership(cppSelf, cppArg1);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            // ========================================================================

            // End of code injection

            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->insertWidget(cppArg0, cppArg1, cppArg2, cppArg3);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_insertWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_invalidate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.invalidate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // invalidate()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QBoxLayout::invalidate()
                : cppSelf->invalidate();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QBoxLayoutFunc_itemAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.itemAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::itemAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // itemAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_itemAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // itemAt(int)const
            QLayoutItem * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QBoxLayout *>(cppSelf)->::QBoxLayout::itemAt(cppArg0)
                : const_cast<const ::QBoxLayout *>(cppSelf)->itemAt(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), cppResult);
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-0)]
            addLayoutOwnership(cppSelf, cppResult);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-0)]
            // ========================================================================

            // End of code injection


            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QBoxLayoutFunc_itemAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_maximumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.maximumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumSize()const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QBoxLayout *>(cppSelf)->::QBoxLayout::maximumSize()
                : const_cast<const ::QBoxLayout *>(cppSelf)->maximumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBoxLayoutFunc_minimumHeightForWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.minimumHeightForWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayoutItem::minimumHeightForWidth(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // minimumHeightForWidth(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_minimumHeightForWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // minimumHeightForWidth(int)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QBoxLayout *>(cppSelf)->::QBoxLayout::minimumHeightForWidth(cppArg0)
                : const_cast<const ::QBoxLayout *>(cppSelf)->minimumHeightForWidth(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QBoxLayoutFunc_minimumHeightForWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_minimumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.minimumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumSize()const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QBoxLayout *>(cppSelf)->::QBoxLayout::minimumSize()
                : const_cast<const ::QBoxLayout *>(cppSelf)->minimumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBoxLayoutFunc_setDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.setDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxLayout::setDirection(QBoxLayout::Direction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDirection(QBoxLayout::Direction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_setDirection_TypeError;

    // Call function/method
    {
        ::QBoxLayout::Direction cppArg0{QBoxLayout::LeftToRight};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDirection(QBoxLayout::Direction)
            cppSelf->setDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_setDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_setGeometry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.setGeometry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayoutItem::setGeometry(QRect)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // setGeometry(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_setGeometry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGeometry(QRect)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QBoxLayout::setGeometry(*cppArg0)
                : cppSelf->setGeometry(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_setGeometry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_setSpacing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.setSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::setSpacing(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSpacing(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_setSpacing_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSpacing(int)
            cppSelf->setSpacing(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_setSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_setStretch(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.setStretch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setStretch", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::setStretch(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setStretch(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_setStretch_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setStretch(int,int)
            cppSelf->setStretch(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBoxLayoutFunc_setStretch_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_setStretchFactor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.setStretchFactor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setStretchFactor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBoxLayout::setStretchFactor(QLayout*,int)
    // 1: QBoxLayout::setStretchFactor(QWidget*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // setStretchFactor(QWidget*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setStretchFactor(QLayout*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_setStretchFactor_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setStretchFactor(QLayout * l, int stretch)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QLayout *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setStretchFactor(QLayout*,int)
                bool cppResult = cppSelf->setStretchFactor(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // setStretchFactor(QWidget * w, int stretch)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setStretchFactor(QWidget*,int)
                bool cppResult = cppSelf->setStretchFactor(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QBoxLayoutFunc_setStretchFactor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.sizeHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizeHint()const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QBoxLayout *>(cppSelf)->::QBoxLayout::sizeHint()
                : const_cast<const ::QBoxLayout *>(cppSelf)->sizeHint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBoxLayoutFunc_spacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.spacing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // spacing()const
            int cppResult = const_cast<const ::QBoxLayout *>(cppSelf)->spacing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBoxLayoutFunc_stretch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.stretch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxLayout::stretch(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // stretch(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_stretch_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // stretch(int)const
            int cppResult = const_cast<const ::QBoxLayout *>(cppSelf)->stretch(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QBoxLayoutFunc_stretch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBoxLayoutFunc_takeAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QBoxLayout.takeAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::takeAt(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // takeAt(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBoxLayoutFunc_takeAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // takeAt(int)
            QLayoutItem * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QBoxLayout::takeAt(cppArg0)
                : cppSelf->takeAt(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), cppResult);
            Shiboken::Object::setParent(Py_None, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QBoxLayoutFunc_takeAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QBoxLayout_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QBoxLayout_methods[] = {
    {"addItem", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_addItem), METH_O},
    {"addLayout", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_addLayout), METH_VARARGS|METH_KEYWORDS},
    {"addSpacerItem", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_addSpacerItem), METH_O},
    {"addSpacing", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_addSpacing), METH_O},
    {"addStretch", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_addStretch), METH_VARARGS|METH_KEYWORDS},
    {"addStrut", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_addStrut), METH_O},
    {"addWidget", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_addWidget), METH_VARARGS|METH_KEYWORDS},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_count), METH_NOARGS},
    {"direction", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_direction), METH_NOARGS},
    {"expandingDirections", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_expandingDirections), METH_NOARGS},
    {"hasHeightForWidth", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_hasHeightForWidth), METH_NOARGS},
    {"heightForWidth", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_heightForWidth), METH_O},
    {"insertItem", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_insertItem), METH_VARARGS},
    {"insertLayout", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_insertLayout), METH_VARARGS|METH_KEYWORDS},
    {"insertSpacerItem", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_insertSpacerItem), METH_VARARGS},
    {"insertSpacing", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_insertSpacing), METH_VARARGS},
    {"insertStretch", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_insertStretch), METH_VARARGS|METH_KEYWORDS},
    {"insertWidget", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_insertWidget), METH_VARARGS|METH_KEYWORDS},
    {"invalidate", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_invalidate), METH_NOARGS},
    {"itemAt", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_itemAt), METH_O},
    {"maximumSize", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_maximumSize), METH_NOARGS},
    {"minimumHeightForWidth", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_minimumHeightForWidth), METH_O},
    {"minimumSize", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_minimumSize), METH_NOARGS},
    {"setDirection", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_setDirection), METH_O},
    {"setGeometry", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_setGeometry), METH_O},
    {"setSpacing", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_setSpacing), METH_O},
    {"setStretch", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_setStretch), METH_VARARGS},
    {"setStretchFactor", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_setStretchFactor), METH_VARARGS},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_sizeHint), METH_NOARGS},
    {"spacing", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_spacing), METH_NOARGS},
    {"stretch", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_stretch), METH_O},
    {"takeAt", reinterpret_cast<PyCFunction>(Sbk_QBoxLayoutFunc_takeAt), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QBoxLayout_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QBoxLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QBoxLayoutWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QBoxLayout_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QBoxLayout_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static void * Sbk_QBoxLayoutSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QBoxLayout *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]))
        return static_cast< ::QLayout *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]))
        return static_cast< ::QLayoutItem *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QBoxLayout_Type = nullptr;
static SbkObjectType *Sbk_QBoxLayout_TypeF(void)
{
    return _Sbk_QBoxLayout_Type;
}

static PyType_Slot Sbk_QBoxLayout_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QBoxLayout_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QBoxLayout_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QBoxLayout_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QBoxLayout_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QBoxLayout_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QBoxLayout_spec = {
    "2:PySide2.QtWidgets.QBoxLayout",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QBoxLayout_slots
};

} //extern "C"

static void *Sbk_QBoxLayout_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QBoxLayout *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QLayoutItem >()))
        return dynamic_cast< ::QBoxLayout *>(reinterpret_cast< ::QLayoutItem *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QBoxLayout_Direction_PythonToCpp_QBoxLayout_Direction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QBoxLayout::Direction *>(cppOut) =
        static_cast<::QBoxLayout::Direction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QBoxLayout_Direction_PythonToCpp_QBoxLayout_Direction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX]))
        return QBoxLayout_Direction_PythonToCpp_QBoxLayout_Direction;
    return {};
}
static PyObject *QBoxLayout_Direction_CppToPython_QBoxLayout_Direction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QBoxLayout::Direction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBoxLayout_PythonToCpp_QBoxLayout_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QBoxLayout_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBoxLayout_PythonToCpp_QBoxLayout_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QBoxLayout_TypeF())))
        return QBoxLayout_PythonToCpp_QBoxLayout_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBoxLayout_PTR_CppToPython_QBoxLayout(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QBoxLayout *>(const_cast<void *>(cppIn)), Sbk_QBoxLayout_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QBoxLayout_SignatureStrings[] = {
    "PySide2.QtWidgets.QBoxLayout(self,arg__1:PySide2.QtWidgets.QBoxLayout.Direction,parent:PySide2.QtWidgets.QWidget=nullptr)",
    "PySide2.QtWidgets.QBoxLayout.addItem(self,arg__1:PySide2.QtWidgets.QLayoutItem)",
    "PySide2.QtWidgets.QBoxLayout.addLayout(self,layout:PySide2.QtWidgets.QLayout,stretch:int=0)",
    "PySide2.QtWidgets.QBoxLayout.addSpacerItem(self,spacerItem:PySide2.QtWidgets.QSpacerItem)",
    "PySide2.QtWidgets.QBoxLayout.addSpacing(self,size:int)",
    "PySide2.QtWidgets.QBoxLayout.addStretch(self,stretch:int=0)",
    "PySide2.QtWidgets.QBoxLayout.addStrut(self,arg__1:int)",
    "1:PySide2.QtWidgets.QBoxLayout.addWidget(self,arg__1:PySide2.QtWidgets.QWidget,stretch:int=0,alignment:PySide2.QtCore.Qt.Alignment=Qt.Alignment())",
    "0:PySide2.QtWidgets.QBoxLayout.addWidget(self,w:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QBoxLayout.count(self)->int",
    "PySide2.QtWidgets.QBoxLayout.direction(self)->PySide2.QtWidgets.QBoxLayout.Direction",
    "PySide2.QtWidgets.QBoxLayout.expandingDirections(self)->PySide2.QtCore.Qt.Orientations",
    "PySide2.QtWidgets.QBoxLayout.hasHeightForWidth(self)->bool",
    "PySide2.QtWidgets.QBoxLayout.heightForWidth(self,arg__1:int)->int",
    "PySide2.QtWidgets.QBoxLayout.insertItem(self,index:int,arg__2:PySide2.QtWidgets.QLayoutItem)",
    "PySide2.QtWidgets.QBoxLayout.insertLayout(self,index:int,layout:PySide2.QtWidgets.QLayout,stretch:int=0)",
    "PySide2.QtWidgets.QBoxLayout.insertSpacerItem(self,index:int,spacerItem:PySide2.QtWidgets.QSpacerItem)",
    "PySide2.QtWidgets.QBoxLayout.insertSpacing(self,index:int,size:int)",
    "PySide2.QtWidgets.QBoxLayout.insertStretch(self,index:int,stretch:int=0)",
    "PySide2.QtWidgets.QBoxLayout.insertWidget(self,index:int,widget:PySide2.QtWidgets.QWidget,stretch:int=0,alignment:PySide2.QtCore.Qt.Alignment=Qt.Alignment())",
    "PySide2.QtWidgets.QBoxLayout.invalidate(self)",
    "PySide2.QtWidgets.QBoxLayout.itemAt(self,arg__1:int)->PySide2.QtWidgets.QLayoutItem",
    "PySide2.QtWidgets.QBoxLayout.maximumSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QBoxLayout.minimumHeightForWidth(self,arg__1:int)->int",
    "PySide2.QtWidgets.QBoxLayout.minimumSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QBoxLayout.setDirection(self,arg__1:PySide2.QtWidgets.QBoxLayout.Direction)",
    "PySide2.QtWidgets.QBoxLayout.setGeometry(self,arg__1:PySide2.QtCore.QRect)",
    "PySide2.QtWidgets.QBoxLayout.setSpacing(self,spacing:int)",
    "PySide2.QtWidgets.QBoxLayout.setStretch(self,index:int,stretch:int)",
    "1:PySide2.QtWidgets.QBoxLayout.setStretchFactor(self,l:PySide2.QtWidgets.QLayout,stretch:int)->bool",
    "0:PySide2.QtWidgets.QBoxLayout.setStretchFactor(self,w:PySide2.QtWidgets.QWidget,stretch:int)->bool",
    "PySide2.QtWidgets.QBoxLayout.sizeHint(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QBoxLayout.spacing(self)->int",
    "PySide2.QtWidgets.QBoxLayout.stretch(self,index:int)->int",
    "PySide2.QtWidgets.QBoxLayout.takeAt(self,arg__1:int)->PySide2.QtWidgets.QLayoutItem",
    nullptr}; // Sentinel

void init_QBoxLayout(PyObject *module)
{
    _Sbk_QBoxLayout_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QBoxLayout",
        "QBoxLayout*",
        &Sbk_QBoxLayout_spec,
        &Shiboken::callCppDestructor< ::QBoxLayout >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QBoxLayout_Type);
    InitSignatureStrings(pyType, QBoxLayout_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QBoxLayout_Type), Sbk_QBoxLayout_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QBoxLayout_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QBoxLayout_TypeF(),
        QBoxLayout_PythonToCpp_QBoxLayout_PTR,
        is_QBoxLayout_PythonToCpp_QBoxLayout_PTR_Convertible,
        QBoxLayout_PTR_CppToPython_QBoxLayout);

    Shiboken::Conversions::registerConverterName(converter, "QBoxLayout");
    Shiboken::Conversions::registerConverterName(converter, "QBoxLayout*");
    Shiboken::Conversions::registerConverterName(converter, "QBoxLayout&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBoxLayout).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBoxLayoutWrapper).name());



    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QBoxLayout_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QBoxLayout_TypeF(), &Sbk_QBoxLayoutSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QBoxLayout_TypeF(), &Sbk_QBoxLayout_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Direction'.
    SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QBoxLayout_TypeF(),
        "Direction",
        "2:PySide2.QtWidgets.QBoxLayout.Direction",
        "QBoxLayout::Direction");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX],
        Sbk_QBoxLayout_TypeF(), "LeftToRight", (long) QBoxLayout::Direction::LeftToRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX],
        Sbk_QBoxLayout_TypeF(), "RightToLeft", (long) QBoxLayout::Direction::RightToLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX],
        Sbk_QBoxLayout_TypeF(), "TopToBottom", (long) QBoxLayout::Direction::TopToBottom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX],
        Sbk_QBoxLayout_TypeF(), "BottomToTop", (long) QBoxLayout::Direction::BottomToTop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX],
        Sbk_QBoxLayout_TypeF(), "Down", (long) QBoxLayout::Direction::Down))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX],
        Sbk_QBoxLayout_TypeF(), "Up", (long) QBoxLayout::Direction::Up))
        return;
    // Register converter for enum 'QBoxLayout::Direction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX],
            QBoxLayout_Direction_CppToPython_QBoxLayout_Direction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QBoxLayout_Direction_PythonToCpp_QBoxLayout_Direction,
            is_QBoxLayout_Direction_PythonToCpp_QBoxLayout_Direction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QBOXLAYOUT_DIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QBoxLayout::Direction");
        Shiboken::Conversions::registerConverterName(converter, "Direction");
    }
    // End of 'Direction' enum.


    qRegisterMetaType< ::QBoxLayout::Direction >("QBoxLayout::Direction");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QBoxLayout_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QBoxLayout_TypeF(), &::QBoxLayout::staticMetaObject, sizeof(QBoxLayoutWrapper));
}

