/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qfileiconprovider_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QFileIconProviderWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QFileIconProviderWrapper::QFileIconProviderWrapper() : QFileIconProvider()
{
    resetPyMethodCache();
    // ... middle
}

::QIcon QFileIconProviderWrapper::icon(::QFileIconProvider::IconType type) const
{
    if (m_PyMethodCache[0])
        return this->::QFileIconProvider::icon(type);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "icon";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QFileIconProvider::icon(type);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX])->converter, &type)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileIconProvider.icon", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QIcon >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QIcon cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QIcon QFileIconProviderWrapper::icon(const ::QFileInfo & info) const
{
    if (m_PyMethodCache[1])
        return this->::QFileIconProvider::icon(info);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "icon";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QFileIconProvider::icon(info);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), &info)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileIconProvider.icon", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QIcon >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QIcon cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString QFileIconProviderWrapper::type(const ::QFileInfo & info) const
{
    if (m_PyMethodCache[2])
        return this->::QFileIconProvider::type(info);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "type";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QFileIconProvider::type(info);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), &info)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileIconProvider.type", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QFileIconProviderWrapper::~QFileIconProviderWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFileIconProvider_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFileIconProvider >()))
        return -1;

    ::QFileIconProviderWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileIconProvider.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QFileIconProvider()
            cptr = new ::QFileIconProviderWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFileIconProvider >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QFileIconProviderFunc_icon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileIconProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileIconProvider.icon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileIconProvider::icon(QFileInfo)const
    // 1: QFileIconProvider::icon(QFileIconProvider::IconType)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 1; // icon(QFileIconProvider::IconType)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), (pyArg)))) {
        overloadId = 0; // icon(QFileInfo)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileIconProviderFunc_icon_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // icon(const QFileInfo & info) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QFileInfo cppArg0_local;
            ::QFileInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // icon(QFileInfo)const
                QIcon cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const ::QFileIconProvider *>(cppSelf)->::QFileIconProvider::icon(*cppArg0)
                    : const_cast<const ::QFileIconProvider *>(cppSelf)->icon(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
            }
            break;
        }
        case 1: // icon(QFileIconProvider::IconType type) const
        {
            ::QFileIconProvider::IconType cppArg0{QFileIconProvider::Computer};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // icon(QFileIconProvider::IconType)const
                QIcon cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const ::QFileIconProvider *>(cppSelf)->::QFileIconProvider::icon(cppArg0)
                    : const_cast<const ::QFileIconProvider *>(cppSelf)->icon(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileIconProviderFunc_icon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileIconProviderFunc_options(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileIconProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileIconProvider.options";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // options()const
            QFlags<QFileIconProvider::Option> cppResult = const_cast<const ::QFileIconProvider *>(cppSelf)->options();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileIconProviderFunc_setOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileIconProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileIconProvider.setOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileIconProvider::setOptions(QFlags<QFileIconProvider::Option>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOptions(QFlags<QFileIconProvider::Option>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileIconProviderFunc_setOptions_TypeError;

    // Call function/method
    {
        ::QFlags<QFileIconProvider::Option> cppArg0 = QFlags<QFileIconProvider::Option>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOptions(QFlags<QFileIconProvider::Option>)
            cppSelf->setOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileIconProviderFunc_setOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileIconProviderFunc_type(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileIconProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileIconProvider.type";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileIconProvider::type(QFileInfo)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), (pyArg)))) {
        overloadId = 0; // type(QFileInfo)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileIconProviderFunc_type_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFileInfo cppArg0_local;
        ::QFileInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // type(QFileInfo)const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QFileIconProvider *>(cppSelf)->::QFileIconProvider::type(*cppArg0)
                : const_cast<const ::QFileIconProvider *>(cppSelf)->type(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileIconProviderFunc_type_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QFileIconProvider_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFileIconProvider_methods[] = {
    {"icon", reinterpret_cast<PyCFunction>(Sbk_QFileIconProviderFunc_icon), METH_O},
    {"options", reinterpret_cast<PyCFunction>(Sbk_QFileIconProviderFunc_options), METH_NOARGS},
    {"setOptions", reinterpret_cast<PyCFunction>(Sbk_QFileIconProviderFunc_setOptions), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QFileIconProviderFunc_type), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QFileIconProvider_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QFileIconProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QFileIconProviderWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QFileIconProvider_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFileIconProvider_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFileIconProvider_Type = nullptr;
static SbkObjectType *Sbk_QFileIconProvider_TypeF(void)
{
    return _Sbk_QFileIconProvider_Type;
}

static PyType_Slot Sbk_QFileIconProvider_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QFileIconProvider_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFileIconProvider_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFileIconProvider_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFileIconProvider_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFileIconProvider_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFileIconProvider_spec = {
    "2:PySide2.QtWidgets.QFileIconProvider",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFileIconProvider_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWidgets_QFileIconProvider_Option___and__(PyObject *self, PyObject *pyArg)
{
    ::QFileIconProvider::Options cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileIconProvider::Options>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileIconProvider::Options>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileIconProvider::Options>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileIconProvider::Options>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QFileIconProvider_Option___or__(PyObject *self, PyObject *pyArg)
{
    ::QFileIconProvider::Options cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileIconProvider::Options>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileIconProvider::Options>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileIconProvider::Options>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileIconProvider::Options>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QFileIconProvider_Option___xor__(PyObject *self, PyObject *pyArg)
{
    ::QFileIconProvider::Options cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileIconProvider::Options>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileIconProvider::Options>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileIconProvider::Options>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileIconProvider::Options>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QFileIconProvider_Option___invert__(PyObject *self, PyObject *pyArg)
{
    ::QFileIconProvider::Options cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX])->converter, self, &cppSelf);
    ::QFileIconProvider::Options cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QFileIconProvider_Option_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QFileIconProvider_Option__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QFileIconProvider_Option_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileIconProvider_Option_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QFileIconProvider_IconType_PythonToCpp_QFileIconProvider_IconType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileIconProvider::IconType *>(cppOut) =
        static_cast<::QFileIconProvider::IconType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileIconProvider_IconType_PythonToCpp_QFileIconProvider_IconType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX]))
        return QFileIconProvider_IconType_PythonToCpp_QFileIconProvider_IconType;
    return {};
}
static PyObject *QFileIconProvider_IconType_CppToPython_QFileIconProvider_IconType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileIconProvider::IconType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX], castCppIn);

}

static void QFileIconProvider_Option_PythonToCpp_QFileIconProvider_Option(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileIconProvider::Option *>(cppOut) =
        static_cast<::QFileIconProvider::Option>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileIconProvider_Option_PythonToCpp_QFileIconProvider_Option_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_OPTION_IDX]))
        return QFileIconProvider_Option_PythonToCpp_QFileIconProvider_Option;
    return {};
}
static PyObject *QFileIconProvider_Option_CppToPython_QFileIconProvider_Option(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileIconProvider::Option *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_OPTION_IDX], castCppIn);

}

static void QFlags_QFileIconProvider_Option__PythonToCpp_QFlags_QFileIconProvider_Option_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QFileIconProvider::Option> *>(cppOut) =
        ::QFlags<QFileIconProvider::Option>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QFileIconProvider_Option__PythonToCpp_QFlags_QFileIconProvider_Option__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX]))
        return QFlags_QFileIconProvider_Option__PythonToCpp_QFlags_QFileIconProvider_Option_;
    return {};
}
static PyObject *QFlags_QFileIconProvider_Option__CppToPython_QFlags_QFileIconProvider_Option_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QFileIconProvider::Option> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX]));

}

static void QFileIconProvider_Option_PythonToCpp_QFlags_QFileIconProvider_Option_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QFileIconProvider::Option> *>(cppOut) =
        ::QFlags<QFileIconProvider::Option>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QFileIconProvider_Option_PythonToCpp_QFlags_QFileIconProvider_Option__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_OPTION_IDX]))
        return QFileIconProvider_Option_PythonToCpp_QFlags_QFileIconProvider_Option_;
    return {};
}
static void number_PythonToCpp_QFlags_QFileIconProvider_Option_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QFileIconProvider::Option> *>(cppOut) =
        ::QFlags<QFileIconProvider::Option>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QFileIconProvider_Option__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_OPTION_IDX]))
        return number_PythonToCpp_QFlags_QFileIconProvider_Option_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFileIconProvider_PythonToCpp_QFileIconProvider_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFileIconProvider_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFileIconProvider_PythonToCpp_QFileIconProvider_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFileIconProvider_TypeF())))
        return QFileIconProvider_PythonToCpp_QFileIconProvider_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFileIconProvider_PTR_CppToPython_QFileIconProvider(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFileIconProvider *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFileIconProvider_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFileIconProvider_SignatureStrings[] = {
    "PySide2.QtWidgets.QFileIconProvider(self)",
    "1:PySide2.QtWidgets.QFileIconProvider.icon(self,info:PySide2.QtCore.QFileInfo)->PySide2.QtGui.QIcon",
    "0:PySide2.QtWidgets.QFileIconProvider.icon(self,type:PySide2.QtWidgets.QFileIconProvider.IconType)->PySide2.QtGui.QIcon",
    "PySide2.QtWidgets.QFileIconProvider.options(self)->PySide2.QtWidgets.QFileIconProvider.Options",
    "PySide2.QtWidgets.QFileIconProvider.setOptions(self,options:PySide2.QtWidgets.QFileIconProvider.Options)",
    "PySide2.QtWidgets.QFileIconProvider.type(self,info:PySide2.QtCore.QFileInfo)->QString",
    nullptr}; // Sentinel

void init_QFileIconProvider(PyObject *module)
{
    _Sbk_QFileIconProvider_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFileIconProvider",
        "QFileIconProvider*",
        &Sbk_QFileIconProvider_spec,
        &Shiboken::callCppDestructor< ::QFileIconProvider >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFileIconProvider_Type);
    InitSignatureStrings(pyType, QFileIconProvider_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFileIconProvider_Type), Sbk_QFileIconProvider_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFileIconProvider_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFileIconProvider_TypeF(),
        QFileIconProvider_PythonToCpp_QFileIconProvider_PTR,
        is_QFileIconProvider_PythonToCpp_QFileIconProvider_PTR_Convertible,
        QFileIconProvider_PTR_CppToPython_QFileIconProvider);

    Shiboken::Conversions::registerConverterName(converter, "QFileIconProvider");
    Shiboken::Conversions::registerConverterName(converter, "QFileIconProvider*");
    Shiboken::Conversions::registerConverterName(converter, "QFileIconProvider&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFileIconProvider).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFileIconProviderWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'IconType'.
    SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileIconProvider_TypeF(),
        "IconType",
        "2:PySide2.QtWidgets.QFileIconProvider.IconType",
        "QFileIconProvider::IconType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX],
        Sbk_QFileIconProvider_TypeF(), "Computer", (long) QFileIconProvider::IconType::Computer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX],
        Sbk_QFileIconProvider_TypeF(), "Desktop", (long) QFileIconProvider::IconType::Desktop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX],
        Sbk_QFileIconProvider_TypeF(), "Trashcan", (long) QFileIconProvider::IconType::Trashcan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX],
        Sbk_QFileIconProvider_TypeF(), "Network", (long) QFileIconProvider::IconType::Network))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX],
        Sbk_QFileIconProvider_TypeF(), "Drive", (long) QFileIconProvider::IconType::Drive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX],
        Sbk_QFileIconProvider_TypeF(), "Folder", (long) QFileIconProvider::IconType::Folder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX],
        Sbk_QFileIconProvider_TypeF(), "File", (long) QFileIconProvider::IconType::File))
        return;
    // Register converter for enum 'QFileIconProvider::IconType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX],
            QFileIconProvider_IconType_CppToPython_QFileIconProvider_IconType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileIconProvider_IconType_PythonToCpp_QFileIconProvider_IconType,
            is_QFileIconProvider_IconType_PythonToCpp_QFileIconProvider_IconType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileIconProvider::IconType");
        Shiboken::Conversions::registerConverterName(converter, "IconType");
    }
    // End of 'IconType' enum.

    // Initialization of enum 'Option'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QFileIconProvider.Options", SbkPySide2_QtWidgets_QFileIconProvider_Option_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_OPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileIconProvider_TypeF(),
        "Option",
        "2:PySide2.QtWidgets.QFileIconProvider.Option",
        "QFileIconProvider::Option",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_OPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_OPTION_IDX],
        Sbk_QFileIconProvider_TypeF(), "DontUseCustomDirectoryIcons", (long) QFileIconProvider::Option::DontUseCustomDirectoryIcons))
        return;
    // Register converter for enum 'QFileIconProvider::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_OPTION_IDX],
            QFileIconProvider_Option_CppToPython_QFileIconProvider_Option);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileIconProvider_Option_PythonToCpp_QFileIconProvider_Option,
            is_QFileIconProvider_Option_PythonToCpp_QFileIconProvider_Option_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_OPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileIconProvider::Option");
        Shiboken::Conversions::registerConverterName(converter, "Option");
    }
    // Register converter for flag 'QFlags<QFileIconProvider::Option>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX],
            QFlags_QFileIconProvider_Option__CppToPython_QFlags_QFileIconProvider_Option_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileIconProvider_Option_PythonToCpp_QFlags_QFileIconProvider_Option_,
            is_QFileIconProvider_Option_PythonToCpp_QFlags_QFileIconProvider_Option__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QFileIconProvider_Option__PythonToCpp_QFlags_QFileIconProvider_Option_,
            is_QFlags_QFileIconProvider_Option__PythonToCpp_QFlags_QFileIconProvider_Option__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QFileIconProvider_Option_,
            is_number_PythonToCpp_QFlags_QFileIconProvider_Option__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEICONPROVIDER_OPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileIconProvider::Options");
        Shiboken::Conversions::registerConverterName(converter, "Options");
    }
    // End of 'Option' enum/flags.

    qRegisterMetaType< ::QFileIconProvider::IconType >("QFileIconProvider::IconType");
    qRegisterMetaType< ::QFileIconProvider::Option >("QFileIconProvider::Option");
    qRegisterMetaType< ::QFileIconProvider::Options >("QFileIconProvider::Options");
}
