/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qgesturerecognizer_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGestureRecognizerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGestureRecognizerWrapper::QGestureRecognizerWrapper() : QGestureRecognizer()
{
    resetPyMethodCache();
    // ... middle
}

::QGesture * QGestureRecognizerWrapper::create(::QObject * target)
{
    if (m_PyMethodCache[0])
        return this->::QGestureRecognizer::create(target);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "create";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGestureRecognizer::create(target);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), target)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGestureRecognizer.create", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGesture >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGesture *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<QGestureRecognizer::ResultFlag> QGestureRecognizerWrapper::recognize(::QGesture * state, ::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGestureRecognizer.recognize()' not implemented.");
        return QFlags<QGestureRecognizer::ResultFlag>(0);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QGestureRecognizer::ResultFlag>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "recognize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGestureRecognizer.recognize()' not implemented.");
        return QFlags<QGestureRecognizer::ResultFlag>(0);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), state),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QGestureRecognizer::ResultFlag>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGestureRecognizer.recognize", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QGestureRecognizer::ResultFlag> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QGestureRecognizer::ResultFlag>(0);
    }
    ::QFlags<QGestureRecognizer::ResultFlag> cppResult = QFlags<QGestureRecognizer::ResultFlag>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGestureRecognizerWrapper::reset(::QGesture * state)
{
    if (m_PyMethodCache[2]) {
        return this->::QGestureRecognizer::reset(state);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QGestureRecognizer::reset(state);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), state)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QGestureRecognizerWrapper::~QGestureRecognizerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGestureRecognizer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGestureRecognizer' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGestureRecognizer >()))
        return -1;

    ::QGestureRecognizerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureRecognizer.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QGestureRecognizer()
            cptr = new ::QGestureRecognizerWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGestureRecognizer >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QGestureRecognizerFunc_create(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureRecognizer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureRecognizer.create";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGestureRecognizer::create(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // create(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureRecognizerFunc_create_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // create(QObject*)
            QGesture * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGestureRecognizer::create(cppArg0)
                : cppSelf->create(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGestureRecognizerFunc_create_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureRecognizerFunc_recognize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureRecognizer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureRecognizer.recognize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "recognize", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGestureRecognizer::recognize(QGesture*,QObject*,QEvent*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // recognize(QGesture*,QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureRecognizerFunc_recognize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGesture *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // recognize(QGesture*,QObject*,QEvent*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGestureRecognizer.recognize()' not implemented.");
                return {};
            }
            QFlags<QGestureRecognizer::ResultFlag> cppResult = cppSelf->recognize(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGestureRecognizerFunc_recognize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureRecognizerFunc_registerRecognizer(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureRecognizer.registerRecognizer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGestureRecognizer::registerRecognizer(QGestureRecognizer*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_IDX]), (pyArg)))) {
        overloadId = 0; // registerRecognizer(QGestureRecognizer*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureRecognizerFunc_registerRecognizer_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGestureRecognizer *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // registerRecognizer(QGestureRecognizer*)
            Qt::GestureType cppResult = ::QGestureRecognizer::registerRecognizer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGestureRecognizerFunc_registerRecognizer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureRecognizerFunc_reset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureRecognizer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureRecognizer.reset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGestureRecognizer::reset(QGesture*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), (pyArg)))) {
        overloadId = 0; // reset(QGesture*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureRecognizerFunc_reset_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGesture *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // reset(QGesture*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGestureRecognizer::reset(cppArg0)
                : cppSelf->reset(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGestureRecognizerFunc_reset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureRecognizerFunc_unregisterRecognizer(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureRecognizer.unregisterRecognizer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGestureRecognizer::unregisterRecognizer(Qt::GestureType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // unregisterRecognizer(Qt::GestureType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureRecognizerFunc_unregisterRecognizer_TypeError;

    // Call function/method
    {
        ::Qt::GestureType cppArg0 = static_cast< ::Qt::GestureType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // unregisterRecognizer(Qt::GestureType)
            ::QGestureRecognizer::unregisterRecognizer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGestureRecognizerFunc_unregisterRecognizer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGestureRecognizer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGestureRecognizer_methods[] = {
    {"create", reinterpret_cast<PyCFunction>(Sbk_QGestureRecognizerFunc_create), METH_O},
    {"recognize", reinterpret_cast<PyCFunction>(Sbk_QGestureRecognizerFunc_recognize), METH_VARARGS},
    {"registerRecognizer", reinterpret_cast<PyCFunction>(Sbk_QGestureRecognizerFunc_registerRecognizer), METH_O|METH_STATIC},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QGestureRecognizerFunc_reset), METH_O},
    {"unregisterRecognizer", reinterpret_cast<PyCFunction>(Sbk_QGestureRecognizerFunc_unregisterRecognizer), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGestureRecognizer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGestureRecognizer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGestureRecognizerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGestureRecognizer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGestureRecognizer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGestureRecognizer_Type = nullptr;
static SbkObjectType *Sbk_QGestureRecognizer_TypeF(void)
{
    return _Sbk_QGestureRecognizer_Type;
}

static PyType_Slot Sbk_QGestureRecognizer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGestureRecognizer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGestureRecognizer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGestureRecognizer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGestureRecognizer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGestureRecognizer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGestureRecognizer_spec = {
    "2:PySide2.QtWidgets.QGestureRecognizer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGestureRecognizer_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QGestureRecognizer::Result cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGestureRecognizer::Result>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGestureRecognizer::Result>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGestureRecognizer::Result>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGestureRecognizer::Result>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QGestureRecognizer::Result cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGestureRecognizer::Result>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGestureRecognizer::Result>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGestureRecognizer::Result>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGestureRecognizer::Result>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGestureRecognizer::Result cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGestureRecognizer::Result>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGestureRecognizer::Result>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGestureRecognizer::Result>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGestureRecognizer::Result>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGestureRecognizer::Result cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX])->converter, self, &cppSelf);
    ::QGestureRecognizer::Result cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGestureRecognizer_ResultFlag_PythonToCpp_QGestureRecognizer_ResultFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGestureRecognizer::ResultFlag *>(cppOut) =
        static_cast<::QGestureRecognizer::ResultFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGestureRecognizer_ResultFlag_PythonToCpp_QGestureRecognizer_ResultFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX]))
        return QGestureRecognizer_ResultFlag_PythonToCpp_QGestureRecognizer_ResultFlag;
    return {};
}
static PyObject *QGestureRecognizer_ResultFlag_CppToPython_QGestureRecognizer_ResultFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGestureRecognizer::ResultFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX], castCppIn);

}

static void QFlags_QGestureRecognizer_ResultFlag__PythonToCpp_QFlags_QGestureRecognizer_ResultFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGestureRecognizer::ResultFlag> *>(cppOut) =
        ::QFlags<QGestureRecognizer::ResultFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGestureRecognizer_ResultFlag__PythonToCpp_QFlags_QGestureRecognizer_ResultFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX]))
        return QFlags_QGestureRecognizer_ResultFlag__PythonToCpp_QFlags_QGestureRecognizer_ResultFlag_;
    return {};
}
static PyObject *QFlags_QGestureRecognizer_ResultFlag__CppToPython_QFlags_QGestureRecognizer_ResultFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGestureRecognizer::ResultFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX]));

}

static void QGestureRecognizer_ResultFlag_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGestureRecognizer::ResultFlag> *>(cppOut) =
        ::QFlags<QGestureRecognizer::ResultFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGestureRecognizer_ResultFlag_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX]))
        return QGestureRecognizer_ResultFlag_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGestureRecognizer::ResultFlag> *>(cppOut) =
        ::QFlags<QGestureRecognizer::ResultFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX]))
        return number_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGestureRecognizer_PythonToCpp_QGestureRecognizer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGestureRecognizer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGestureRecognizer_PythonToCpp_QGestureRecognizer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGestureRecognizer_TypeF())))
        return QGestureRecognizer_PythonToCpp_QGestureRecognizer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGestureRecognizer_PTR_CppToPython_QGestureRecognizer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGestureRecognizer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGestureRecognizer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGestureRecognizer_SignatureStrings[] = {
    "PySide2.QtWidgets.QGestureRecognizer(self)",
    "PySide2.QtWidgets.QGestureRecognizer.create(self,target:PySide2.QtCore.QObject)->PySide2.QtWidgets.QGesture",
    "PySide2.QtWidgets.QGestureRecognizer.recognize(self,state:PySide2.QtWidgets.QGesture,watched:PySide2.QtCore.QObject,event:PySide2.QtCore.QEvent)->PySide2.QtWidgets.QGestureRecognizer.Result",
    "PySide2.QtWidgets.QGestureRecognizer.registerRecognizer(recognizer:PySide2.QtWidgets.QGestureRecognizer)->PySide2.QtCore.Qt.GestureType",
    "PySide2.QtWidgets.QGestureRecognizer.reset(self,state:PySide2.QtWidgets.QGesture)",
    "PySide2.QtWidgets.QGestureRecognizer.unregisterRecognizer(type:PySide2.QtCore.Qt.GestureType)",
    nullptr}; // Sentinel

void init_QGestureRecognizer(PyObject *module)
{
    _Sbk_QGestureRecognizer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGestureRecognizer",
        "QGestureRecognizer*",
        &Sbk_QGestureRecognizer_spec,
        &Shiboken::callCppDestructor< ::QGestureRecognizer >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGestureRecognizer_Type);
    InitSignatureStrings(pyType, QGestureRecognizer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGestureRecognizer_Type), Sbk_QGestureRecognizer_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGestureRecognizer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGestureRecognizer_TypeF(),
        QGestureRecognizer_PythonToCpp_QGestureRecognizer_PTR,
        is_QGestureRecognizer_PythonToCpp_QGestureRecognizer_PTR_Convertible,
        QGestureRecognizer_PTR_CppToPython_QGestureRecognizer);

    Shiboken::Conversions::registerConverterName(converter, "QGestureRecognizer");
    Shiboken::Conversions::registerConverterName(converter, "QGestureRecognizer*");
    Shiboken::Conversions::registerConverterName(converter, "QGestureRecognizer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGestureRecognizer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGestureRecognizerWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'ResultFlag'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QGestureRecognizer.Result", SbkPySide2_QtWidgets_QGestureRecognizer_ResultFlag_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGestureRecognizer_TypeF(),
        "ResultFlag",
        "2:PySide2.QtWidgets.QGestureRecognizer.ResultFlag",
        "QGestureRecognizer::ResultFlag",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX],
        Sbk_QGestureRecognizer_TypeF(), "Ignore", (long) QGestureRecognizer::ResultFlag::Ignore))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX],
        Sbk_QGestureRecognizer_TypeF(), "MayBeGesture", (long) QGestureRecognizer::ResultFlag::MayBeGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX],
        Sbk_QGestureRecognizer_TypeF(), "TriggerGesture", (long) QGestureRecognizer::ResultFlag::TriggerGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX],
        Sbk_QGestureRecognizer_TypeF(), "FinishGesture", (long) QGestureRecognizer::ResultFlag::FinishGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX],
        Sbk_QGestureRecognizer_TypeF(), "CancelGesture", (long) QGestureRecognizer::ResultFlag::CancelGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX],
        Sbk_QGestureRecognizer_TypeF(), "ResultState_Mask", (long) QGestureRecognizer::ResultFlag::ResultState_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX],
        Sbk_QGestureRecognizer_TypeF(), "ConsumeEventHint", (long) QGestureRecognizer::ResultFlag::ConsumeEventHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX],
        Sbk_QGestureRecognizer_TypeF(), "ResultHint_Mask", (long) QGestureRecognizer::ResultFlag::ResultHint_Mask))
        return;
    // Register converter for enum 'QGestureRecognizer::ResultFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX],
            QGestureRecognizer_ResultFlag_CppToPython_QGestureRecognizer_ResultFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGestureRecognizer_ResultFlag_PythonToCpp_QGestureRecognizer_ResultFlag,
            is_QGestureRecognizer_ResultFlag_PythonToCpp_QGestureRecognizer_ResultFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGestureRecognizer::ResultFlag");
        Shiboken::Conversions::registerConverterName(converter, "ResultFlag");
    }
    // Register converter for flag 'QFlags<QGestureRecognizer::ResultFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX],
            QFlags_QGestureRecognizer_ResultFlag__CppToPython_QFlags_QGestureRecognizer_ResultFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGestureRecognizer_ResultFlag_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag_,
            is_QGestureRecognizer_ResultFlag_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGestureRecognizer_ResultFlag__PythonToCpp_QFlags_QGestureRecognizer_ResultFlag_,
            is_QFlags_QGestureRecognizer_ResultFlag__PythonToCpp_QFlags_QGestureRecognizer_ResultFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag_,
            is_number_PythonToCpp_QFlags_QGestureRecognizer_ResultFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGestureRecognizer::Result");
        Shiboken::Conversions::registerConverterName(converter, "Result");
    }
    // End of 'ResultFlag' enum/flags.

    qRegisterMetaType< ::QGestureRecognizer::ResultFlag >("QGestureRecognizer::ResultFlag");
    qRegisterMetaType< ::QGestureRecognizer::Result >("QGestureRecognizer::Result");
}
