/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qgraphicsscene_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGraphicsSceneWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGraphicsSceneWrapper::QGraphicsSceneWrapper(::QObject * parent) : QGraphicsScene(parent)
{
    resetPyMethodCache();
    // ... middle
}

QGraphicsSceneWrapper::QGraphicsSceneWrapper(const ::QRectF & sceneRect, ::QObject * parent) : QGraphicsScene(sceneRect, parent)
{
    resetPyMethodCache();
    // ... middle
}

QGraphicsSceneWrapper::QGraphicsSceneWrapper(qreal x, qreal y, qreal width, qreal height, ::QObject * parent) : QGraphicsScene(x, y, width, height, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QGraphicsSceneWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsSceneWrapper::contextMenuEvent(::QGraphicsSceneContextMenuEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QGraphicsScene::contextMenuEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contextMenuEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QGraphicsScene::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENECONTEXTMENUEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsSceneWrapper::dragEnterEvent(::QGraphicsSceneDragDropEvent * event)
{
    if (m_PyMethodCache[5]) {
        return this->::QGraphicsScene::dragEnterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QGraphicsScene::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::dragLeaveEvent(::QGraphicsSceneDragDropEvent * event)
{
    if (m_PyMethodCache[6]) {
        return this->::QGraphicsScene::dragLeaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QGraphicsScene::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::dragMoveEvent(::QGraphicsSceneDragDropEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QGraphicsScene::dragMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QGraphicsScene::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::drawBackground(::QPainter * painter, const ::QRectF & rect)
{
    if (m_PyMethodCache[8]) {
        return this->::QGraphicsScene::drawBackground(painter, rect);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawBackground";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QGraphicsScene::drawBackground(painter, rect);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &rect)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::drawForeground(::QPainter * painter, const ::QRectF & rect)
{
    if (m_PyMethodCache[9]) {
        return this->::QGraphicsScene::drawForeground(painter, rect);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawForeground";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QGraphicsScene::drawForeground(painter, rect);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &rect)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::dropEvent(::QGraphicsSceneDragDropEvent * event)
{
    if (m_PyMethodCache[10]) {
        return this->::QGraphicsScene::dropEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dropEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QGraphicsScene::dropEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QGraphicsSceneWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[11])
        return this->::QGraphicsScene::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QGraphicsScene::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsScene.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGraphicsSceneWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[12])
        return this->::QGraphicsScene::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QGraphicsScene::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsScene.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGraphicsSceneWrapper::focusInEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[13]) {
        return this->::QGraphicsScene::focusInEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QGraphicsScene::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::focusOutEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[14]) {
        return this->::QGraphicsScene::focusOutEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QGraphicsScene::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::helpEvent(::QGraphicsSceneHelpEvent * event)
{
    if (m_PyMethodCache[15]) {
        return this->::QGraphicsScene::helpEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "helpEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QGraphicsScene::helpEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEHELPEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    if (m_PyMethodCache[16]) {
        return this->::QGraphicsScene::inputMethodEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QGraphicsScene::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QVariant QGraphicsSceneWrapper::inputMethodQuery(::Qt::InputMethodQuery query) const
{
    if (m_PyMethodCache[17])
        return this->::QGraphicsScene::inputMethodQuery(query);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodQuery";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QGraphicsScene::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, &query)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsScene.inputMethodQuery", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGraphicsSceneWrapper::keyPressEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[18]) {
        return this->::QGraphicsScene::keyPressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QGraphicsScene::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[19]) {
        return this->::QGraphicsScene::keyReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QGraphicsScene::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::mouseDoubleClickEvent(::QGraphicsSceneMouseEvent * event)
{
    if (m_PyMethodCache[21]) {
        return this->::QGraphicsScene::mouseDoubleClickEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QGraphicsScene::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::mouseMoveEvent(::QGraphicsSceneMouseEvent * event)
{
    if (m_PyMethodCache[22]) {
        return this->::QGraphicsScene::mouseMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QGraphicsScene::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::mousePressEvent(::QGraphicsSceneMouseEvent * event)
{
    if (m_PyMethodCache[23]) {
        return this->::QGraphicsScene::mousePressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QGraphicsScene::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::mouseReleaseEvent(::QGraphicsSceneMouseEvent * event)
{
    if (m_PyMethodCache[24]) {
        return this->::QGraphicsScene::mouseReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QGraphicsScene::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[25]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsSceneWrapper::wheelEvent(::QGraphicsSceneWheelEvent * event)
{
    if (m_PyMethodCache[26]) {
        return this->::QGraphicsScene::wheelEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QGraphicsScene::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEWHEELEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGraphicsSceneWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGraphicsScene::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGraphicsSceneWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGraphicsScene::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGraphicsSceneWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGraphicsSceneWrapper *>(this));
        return QGraphicsScene::qt_metacast(_clname);
}

QGraphicsSceneWrapper::~QGraphicsSceneWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGraphicsScene_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGraphicsScene >()))
        return -1;

    ::QGraphicsSceneWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto Sbk_QGraphicsScene_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOO:QGraphicsScene", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QGraphicsScene::QGraphicsScene(QObject*)
    // 1: QGraphicsScene::QGraphicsScene(QRectF,QObject*)
    // 2: QGraphicsScene::QGraphicsScene(qreal,qreal,qreal,qreal,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QGraphicsScene(QObject*)
    } else if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 2; // QGraphicsScene(qreal,qreal,qreal,qreal,QObject*)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4])))) {
            overloadId = 2; // QGraphicsScene(qreal,qreal,qreal,qreal,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QGraphicsScene(QRectF,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QGraphicsScene(QRectF,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGraphicsScene(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsScene_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGraphicsScene(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsScene_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QGraphicsScene_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGraphicsScene(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QGraphicsSceneWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QGraphicsSceneWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QGraphicsScene(const QRectF & sceneRect, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsScene_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QGraphicsScene_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QGraphicsScene(QRectF,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QGraphicsSceneWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QGraphicsSceneWrapper(*cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 2: // QGraphicsScene(qreal x, qreal y, qreal width, qreal height, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[4]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsScene_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4]))))
                            goto Sbk_QGraphicsScene_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QObject *cppArg4 = nullptr;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QGraphicsScene(qreal,qreal,qreal,qreal,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QGraphicsSceneWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QGraphicsSceneWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                }

                Shiboken::Object::setParent(pyArgs[4], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGraphicsScene >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGraphicsScene_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGraphicsScene_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGraphicsScene_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGraphicsSceneFunc_activePanel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.activePanel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activePanel()const
            QGraphicsItem * cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->activePanel();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_activeWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.activeWindow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeWindow()const
            QGraphicsWidget * cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->activeWindow();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_addEllipse(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addEllipse";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:addEllipse", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::addEllipse(QRectF,QPen,QBrush)
    // 1: QGraphicsScene::addEllipse(qreal,qreal,qreal,qreal,QPen,QBrush)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 1; // addEllipse(qreal,qreal,qreal,qreal,QPen,QBrush)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 1; // addEllipse(qreal,qreal,qreal,qreal,QPen,QBrush)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[5])))) {
                overloadId = 1; // addEllipse(qreal,qreal,qreal,qreal,QPen,QBrush)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addEllipse(QRectF,QPen,QBrush)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // addEllipse(QRectF,QPen,QBrush)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2])))) {
                overloadId = 0; // addEllipse(QRectF,QPen,QBrush)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addEllipse(const QRectF & rect, const QPen & pen, const QBrush & brush)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pen = Shiboken::String::createStaticString("pen");
                if (PyDict_Contains(kwds, key_pen)) {
                    value = PyDict_GetItem(kwds, key_pen);
                    if (value && pyArgs[1]) {
                        errInfo = key_pen;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1]))))
                            goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pen);
                }
                static PyObject *const key_brush = Shiboken::String::createStaticString("brush");
                if (PyDict_Contains(kwds, key_brush)) {
                    value = PyDict_GetItem(kwds, key_brush);
                    if (value && pyArgs[2]) {
                        errInfo = key_brush;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2]))))
                            goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_brush);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPen cppArg1_local = QPen();
            ::QPen *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QBrush cppArg2_local = QBrush();
            ::QBrush *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // addEllipse(QRectF,QPen,QBrush)
                QGraphicsEllipseItem * cppResult = cppSelf->addEllipse(*cppArg0, *cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSELLIPSEITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // addEllipse(qreal x, qreal y, qreal w, qreal h, const QPen & pen, const QBrush & brush)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pen = Shiboken::String::createStaticString("pen");
                if (PyDict_Contains(kwds, key_pen)) {
                    value = PyDict_GetItem(kwds, key_pen);
                    if (value && pyArgs[4]) {
                        errInfo = key_pen;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[4]))))
                            goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pen);
                }
                static PyObject *const key_brush = Shiboken::String::createStaticString("brush");
                if (PyDict_Contains(kwds, key_brush)) {
                    value = PyDict_GetItem(kwds, key_brush);
                    if (value && pyArgs[5]) {
                        errInfo = key_brush;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[5]))))
                            goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_brush);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_addEllipse_TypeError;
                }
            }
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QPen cppArg4_local = QPen();
            ::QPen *cppArg4 = &cppArg4_local;
            if (pythonToCpp[4]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);
            }
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QBrush cppArg5_local = QBrush();
            ::QBrush *cppArg5 = &cppArg5_local;
            if (pythonToCpp[5]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[5]))
                pythonToCpp[5](pyArgs[5], &cppArg5_local);
            else
                pythonToCpp[5](pyArgs[5], &cppArg5);
            }

            if (!PyErr_Occurred()) {
                // addEllipse(qreal,qreal,qreal,qreal,QPen,QBrush)
                QGraphicsEllipseItem * cppResult = cppSelf->addEllipse(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSELLIPSEITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_addEllipse_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_addItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::addItem(QGraphicsItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArg)))) {
        overloadId = 0; // addItem(QGraphicsItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addItem(QGraphicsItem*)
            cppSelf->addItem(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_addItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_addLine(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addLine_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addLine_TypeError;
    } else if (numArgs == 3)
        goto Sbk_QGraphicsSceneFunc_addLine_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOO:addLine", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::addLine(QLineF,QPen)
    // 1: QGraphicsScene::addLine(qreal,qreal,qreal,qreal,QPen)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 1; // addLine(qreal,qreal,qreal,qreal,QPen)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[4])))) {
            overloadId = 1; // addLine(qreal,qreal,qreal,qreal,QPen)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addLine(QLineF,QPen)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addLine(QLineF,QPen)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addLine_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addLine(const QLineF & line, const QPen & pen)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pen = Shiboken::String::createStaticString("pen");
                if (PyDict_Contains(kwds, key_pen)) {
                    value = PyDict_GetItem(kwds, key_pen);
                    if (value && pyArgs[1]) {
                        errInfo = key_pen;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addLine_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1]))))
                            goto Sbk_QGraphicsSceneFunc_addLine_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pen);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_addLine_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QLineF cppArg0_local;
            ::QLineF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPen cppArg1_local = QPen();
            ::QPen *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // addLine(QLineF,QPen)
                QGraphicsLineItem * cppResult = cppSelf->addLine(*cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLINEITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // addLine(qreal x1, qreal y1, qreal x2, qreal y2, const QPen & pen)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pen = Shiboken::String::createStaticString("pen");
                if (PyDict_Contains(kwds, key_pen)) {
                    value = PyDict_GetItem(kwds, key_pen);
                    if (value && pyArgs[4]) {
                        errInfo = key_pen;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addLine_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[4]))))
                            goto Sbk_QGraphicsSceneFunc_addLine_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pen);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_addLine_TypeError;
                }
            }
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QPen cppArg4_local = QPen();
            ::QPen *cppArg4 = &cppArg4_local;
            if (pythonToCpp[4]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);
            }

            if (!PyErr_Occurred()) {
                // addLine(qreal,qreal,qreal,qreal,QPen)
                QGraphicsLineItem * cppResult = cppSelf->addLine(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLINEITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_addLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_addPath(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addPath_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addPath_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:addPath", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::addPath(QPainterPath,QPen,QBrush)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addPath(QPainterPath,QPen,QBrush)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // addPath(QPainterPath,QPen,QBrush)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2])))) {
                overloadId = 0; // addPath(QPainterPath,QPen,QBrush)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addPath_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_pen = Shiboken::String::createStaticString("pen");
            if (PyDict_Contains(kwds, key_pen)) {
                value = PyDict_GetItem(kwds, key_pen);
                if (value && pyArgs[1]) {
                    errInfo = key_pen;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_addPath_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1]))))
                        goto Sbk_QGraphicsSceneFunc_addPath_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_pen);
            }
            static PyObject *const key_brush = Shiboken::String::createStaticString("brush");
            if (PyDict_Contains(kwds, key_brush)) {
                value = PyDict_GetItem(kwds, key_brush);
                if (value && pyArgs[2]) {
                    errInfo = key_brush;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_addPath_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2]))))
                        goto Sbk_QGraphicsSceneFunc_addPath_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_brush);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneFunc_addPath_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainterPath cppArg0_local;
        ::QPainterPath *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPen cppArg1_local = QPen();
        ::QPen *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QBrush cppArg2_local = QBrush();
        ::QBrush *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }

        if (!PyErr_Occurred()) {
            // addPath(QPainterPath,QPen,QBrush)
            QGraphicsPathItem * cppResult = cppSelf->addPath(*cppArg0, *cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSPATHITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_addPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_addPixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::addPixmap(QPixmap)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArg)))) {
        overloadId = 0; // addPixmap(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addPixmap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addPixmap(QPixmap)
            QGraphicsPixmapItem * cppResult = cppSelf->addPixmap(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSPIXMAPITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_addPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_addPolygon(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addPolygon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addPolygon_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addPolygon_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:addPolygon", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::addPolygon(QPolygonF,QPen,QBrush)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addPolygon(QPolygonF,QPen,QBrush)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // addPolygon(QPolygonF,QPen,QBrush)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2])))) {
                overloadId = 0; // addPolygon(QPolygonF,QPen,QBrush)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addPolygon_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_pen = Shiboken::String::createStaticString("pen");
            if (PyDict_Contains(kwds, key_pen)) {
                value = PyDict_GetItem(kwds, key_pen);
                if (value && pyArgs[1]) {
                    errInfo = key_pen;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_addPolygon_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1]))))
                        goto Sbk_QGraphicsSceneFunc_addPolygon_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_pen);
            }
            static PyObject *const key_brush = Shiboken::String::createStaticString("brush");
            if (PyDict_Contains(kwds, key_brush)) {
                value = PyDict_GetItem(kwds, key_brush);
                if (value && pyArgs[2]) {
                    errInfo = key_brush;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_addPolygon_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2]))))
                        goto Sbk_QGraphicsSceneFunc_addPolygon_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_brush);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneFunc_addPolygon_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPolygonF cppArg0_local;
        ::QPolygonF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPen cppArg1_local = QPen();
        ::QPen *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QBrush cppArg2_local = QBrush();
        ::QBrush *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }

        if (!PyErr_Occurred()) {
            // addPolygon(QPolygonF,QPen,QBrush)
            QGraphicsPolygonItem * cppResult = cppSelf->addPolygon(*cppArg0, *cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSPOLYGONITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_addPolygon_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_addRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:addRect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::addRect(QRectF,QPen,QBrush)
    // 1: QGraphicsScene::addRect(qreal,qreal,qreal,qreal,QPen,QBrush)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 1; // addRect(qreal,qreal,qreal,qreal,QPen,QBrush)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 1; // addRect(qreal,qreal,qreal,qreal,QPen,QBrush)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[5])))) {
                overloadId = 1; // addRect(qreal,qreal,qreal,qreal,QPen,QBrush)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addRect(QRectF,QPen,QBrush)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // addRect(QRectF,QPen,QBrush)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2])))) {
                overloadId = 0; // addRect(QRectF,QPen,QBrush)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addRect(const QRectF & rect, const QPen & pen, const QBrush & brush)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pen = Shiboken::String::createStaticString("pen");
                if (PyDict_Contains(kwds, key_pen)) {
                    value = PyDict_GetItem(kwds, key_pen);
                    if (value && pyArgs[1]) {
                        errInfo = key_pen;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1]))))
                            goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pen);
                }
                static PyObject *const key_brush = Shiboken::String::createStaticString("brush");
                if (PyDict_Contains(kwds, key_brush)) {
                    value = PyDict_GetItem(kwds, key_brush);
                    if (value && pyArgs[2]) {
                        errInfo = key_brush;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2]))))
                            goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_brush);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPen cppArg1_local = QPen();
            ::QPen *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QBrush cppArg2_local = QBrush();
            ::QBrush *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // addRect(QRectF,QPen,QBrush)
                QGraphicsRectItem * cppResult = cppSelf->addRect(*cppArg0, *cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSRECTITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // addRect(qreal x, qreal y, qreal w, qreal h, const QPen & pen, const QBrush & brush)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pen = Shiboken::String::createStaticString("pen");
                if (PyDict_Contains(kwds, key_pen)) {
                    value = PyDict_GetItem(kwds, key_pen);
                    if (value && pyArgs[4]) {
                        errInfo = key_pen;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[4]))))
                            goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pen);
                }
                static PyObject *const key_brush = Shiboken::String::createStaticString("brush");
                if (PyDict_Contains(kwds, key_brush)) {
                    value = PyDict_GetItem(kwds, key_brush);
                    if (value && pyArgs[5]) {
                        errInfo = key_brush;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[5]))))
                            goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_brush);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_addRect_TypeError;
                }
            }
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QPen cppArg4_local = QPen();
            ::QPen *cppArg4 = &cppArg4_local;
            if (pythonToCpp[4]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);
            }
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QBrush cppArg5_local = QBrush();
            ::QBrush *cppArg5 = &cppArg5_local;
            if (pythonToCpp[5]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[5]))
                pythonToCpp[5](pyArgs[5], &cppArg5_local);
            else
                pythonToCpp[5](pyArgs[5], &cppArg5);
            }

            if (!PyErr_Occurred()) {
                // addRect(qreal,qreal,qreal,qreal,QPen,QBrush)
                QGraphicsRectItem * cppResult = cppSelf->addRect(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSRECTITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_addRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_addSimpleText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addSimpleText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addSimpleText_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addSimpleText_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:addSimpleText", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::addSimpleText(QString,QFont)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addSimpleText(QString,QFont)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addSimpleText(QString,QFont)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addSimpleText_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_font = Shiboken::String::createStaticString("font");
            if (PyDict_Contains(kwds, key_font)) {
                value = PyDict_GetItem(kwds, key_font);
                if (value && pyArgs[1]) {
                    errInfo = key_font;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_addSimpleText_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[1]))))
                        goto Sbk_QGraphicsSceneFunc_addSimpleText_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_font);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneFunc_addSimpleText_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QFont cppArg1_local = QFont();
        ::QFont *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // addSimpleText(QString,QFont)
            QGraphicsSimpleTextItem * cppResult = cppSelf->addSimpleText(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSIMPLETEXTITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_addSimpleText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_addText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addText_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addText_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:addText", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::addText(QString,QFont)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addText(QString,QFont)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addText(QString,QFont)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addText_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_font = Shiboken::String::createStaticString("font");
            if (PyDict_Contains(kwds, key_font)) {
                value = PyDict_GetItem(kwds, key_font);
                if (value && pyArgs[1]) {
                    errInfo = key_font;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_addText_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[1]))))
                        goto Sbk_QGraphicsSceneFunc_addText_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_font);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneFunc_addText_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QFont cppArg1_local = QFont();
        ::QFont *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // addText(QString,QFont)
            QGraphicsTextItem * cppResult = cppSelf->addText(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSTEXTITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_addText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_addWidget(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.addWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addWidget_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_addWidget_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:addWidget", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::addWidget(QWidget*,QFlags<Qt::WindowType>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addWidget(QWidget*,QFlags<Qt::WindowType>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // addWidget(QWidget*,QFlags<Qt::WindowType>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_addWidget_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_wFlags = Shiboken::String::createStaticString("wFlags");
            if (PyDict_Contains(kwds, key_wFlags)) {
                value = PyDict_GetItem(kwds, key_wFlags);
                if (value && pyArgs[1]) {
                    errInfo = key_wFlags;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_addWidget_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QGraphicsSceneFunc_addWidget_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_wFlags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneFunc_addWidget_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::WindowType> cppArg1 = Qt::WindowFlags();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addWidget(QWidget*,QFlags<Qt::WindowType>)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qgraphicsscene-addwidget)]
            ::QGraphicsProxyWidget * cppResult = cppSelf->addWidget(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSPROXYWIDGET_IDX]), cppResult);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(pyResult), "setWidget(QWidget*)1", pyArgs[1-1]);
            // END of custom code block [file: ../glue/qtwidgets.cpp (qgraphicsscene-addwidget)]
            // ========================================================================

            // End of code injection

            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_addWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_advance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.advance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // advance()
            cppSelf->advance();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGraphicsSceneFunc_backgroundBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.backgroundBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backgroundBrush()const
            QBrush cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->backgroundBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_bspTreeDepth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.bspTreeDepth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bspTreeDepth()const
            int cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->bspTreeDepth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qgraphicsscene-clear)]
            const QList<QGraphicsItem *> items = cppSelf->items();
            Shiboken::BindingManager &bm = Shiboken::BindingManager::instance();
            for (auto *item : items) {
                SbkObject *obj = bm.retrieveWrapper(item);
                if (obj) {
                    if (reinterpret_cast<PyObject *>(obj)->ob_refcnt > 1) // If the refcnt is 1 the object will vannish anyway.
                        Shiboken::Object::invalidate(obj);
                    Shiboken::Object::removeParent(obj);
                }
            }
            cppSelf->clear();
            // END of custom code block [file: ../glue/qtwidgets.cpp (qgraphicsscene-clear)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGraphicsSceneFunc_clearFocus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.clearFocus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearFocus()
            cppSelf->clearFocus();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGraphicsSceneFunc_clearSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.clearSelection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearSelection()
            cppSelf->clearSelection();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGraphicsSceneFunc_collidingItems(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.collidingItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_collidingItems_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_collidingItems_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:collidingItems", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::collidingItems(const QGraphicsItem*,Qt::ItemSelectionMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // collidingItems(const QGraphicsItem*,Qt::ItemSelectionMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // collidingItems(const QGraphicsItem*,Qt::ItemSelectionMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_collidingItems_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_collidingItems_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QGraphicsSceneFunc_collidingItems_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneFunc_collidingItems_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGraphicsItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::ItemSelectionMode cppArg1 = Qt::IntersectsItemShape;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // collidingItems(const QGraphicsItem*,Qt::ItemSelectionMode)const
            QList<QGraphicsItem* > cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->collidingItems(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_collidingItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_contextMenuEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.contextMenuEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENECONTEXTMENUEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_contextMenuEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneContextMenuEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // contextMenuEvent(QGraphicsSceneContextMenuEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::contextMenuEvent(cppArg0)
                : cppSelf->contextMenuEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_contextMenuEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_createItemGroup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.createItemGroup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::createItemGroup(QList<QGraphicsItem*>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], (pyArg)))) {
        overloadId = 0; // createItemGroup(QList<QGraphicsItem*>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_createItemGroup_TypeError;

    // Call function/method
    {
        ::QList<QGraphicsItem* > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createItemGroup(QList<QGraphicsItem*>)
            QGraphicsItemGroup * cppResult = cppSelf->createItemGroup(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMGROUP_IDX]), cppResult);

            // Ownership transferences.
            Shiboken::Object::setParent(pyResult, pyArg);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_createItemGroup_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_destroyItemGroup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.destroyItemGroup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::destroyItemGroup(QGraphicsItemGroup*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMGROUP_IDX]), (pyArg)))) {
        overloadId = 0; // destroyItemGroup(QGraphicsItemGroup*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_destroyItemGroup_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsItemGroup *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // destroyItemGroup(QGraphicsItemGroup*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qgraphicsscene-destroyitemgroup)]
            QGraphicsItem *parentItem = cppArg0->parentItem();
            Shiboken::AutoDecRef parent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), parentItem));
            const auto &childItems = cppArg0->childItems();
            for (auto *item : childItems)
                Shiboken::Object::setParent(parent, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), item));
            cppSelf->destroyItemGroup(cppArg0);
            // the arg was destroyed by Qt.
            Shiboken::Object::invalidate(pyArg);
            // END of custom code block [file: ../glue/qtwidgets.cpp (qgraphicsscene-destroyitemgroup)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_destroyItemGroup_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_dragEnterEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.dragEnterEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dragEnterEvent(QGraphicsSceneDragDropEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_dragEnterEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneDragDropEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dragEnterEvent(QGraphicsSceneDragDropEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::dragEnterEvent(cppArg0)
                : cppSelf->dragEnterEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_dragEnterEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_dragLeaveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.dragLeaveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_dragLeaveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneDragDropEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dragLeaveEvent(QGraphicsSceneDragDropEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::dragLeaveEvent(cppArg0)
                : cppSelf->dragLeaveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_dragLeaveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_dragMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.dragMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::dragMoveEvent(QGraphicsSceneDragDropEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dragMoveEvent(QGraphicsSceneDragDropEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_dragMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneDragDropEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dragMoveEvent(QGraphicsSceneDragDropEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::dragMoveEvent(cppArg0)
                : cppSelf->dragMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_dragMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_drawBackground(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.drawBackground";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawBackground", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::drawBackground(QPainter*,QRectF)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // drawBackground(QPainter*,QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_drawBackground_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // drawBackground(QPainter*,QRectF)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::drawBackground(cppArg0, *cppArg1)
                : cppSelf->drawBackground(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_drawBackground_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_drawForeground(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.drawForeground";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawForeground", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::drawForeground(QPainter*,QRectF)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // drawForeground(QPainter*,QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_drawForeground_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // drawForeground(QPainter*,QRectF)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::drawForeground(cppArg0, *cppArg1)
                : cppSelf->drawForeground(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_drawForeground_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_dropEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.dropEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::dropEvent(QGraphicsSceneDragDropEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dropEvent(QGraphicsSceneDragDropEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_dropEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneDragDropEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dropEvent(QGraphicsSceneDragDropEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::dropEvent(cppArg0)
                : cppSelf->dropEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_dropEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.eventFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_eventFilter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_eventFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.focusInEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_focusInEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusInEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::focusInEvent(cppArg0)
                : cppSelf->focusInEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_focusInEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_focusItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.focusItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focusItem()const
            QGraphicsItem * cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->focusItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_focusNextPrevChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.focusNextPrevChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::focusNextPrevChild(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // focusNextPrevChild(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_focusNextPrevChild_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusNextPrevChild(bool)
            bool cppResult = cppSelf->focusNextPrevChild(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_focusNextPrevChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_focusOnTouch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.focusOnTouch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focusOnTouch()const
            bool cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->focusOnTouch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_focusOutEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.focusOutEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::focusOutEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusOutEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_focusOutEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusOutEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::focusOutEvent(cppArg0)
                : cppSelf->focusOutEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_focusOutEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_font(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.font";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // font()const
            QFont cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->font();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_foregroundBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.foregroundBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // foregroundBrush()const
            QBrush cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->foregroundBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_hasFocus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.hasFocus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasFocus()const
            bool cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->hasFocus();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            qreal cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_helpEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.helpEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::helpEvent(QGraphicsSceneHelpEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEHELPEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // helpEvent(QGraphicsSceneHelpEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_helpEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneHelpEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // helpEvent(QGraphicsSceneHelpEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::helpEvent(cppArg0)
                : cppSelf->helpEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_helpEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_inputMethodEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.inputMethodEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::inputMethodEvent(QInputMethodEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // inputMethodEvent(QInputMethodEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_inputMethodEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QInputMethodEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inputMethodEvent(QInputMethodEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::inputMethodEvent(cppArg0)
                : cppSelf->inputMethodEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_inputMethodEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_inputMethodQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.inputMethodQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // inputMethodQuery(Qt::InputMethodQuery)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_inputMethodQuery_TypeError;

    // Call function/method
    {
        ::Qt::InputMethodQuery cppArg0 = static_cast< ::Qt::InputMethodQuery>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inputMethodQuery(Qt::InputMethodQuery)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGraphicsScene *>(cppSelf)->::QGraphicsScene::inputMethodQuery(cppArg0)
                : const_cast<const ::QGraphicsScene *>(cppSelf)->inputMethodQuery(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_inputMethodQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_invalidate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.invalidate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;
    } else if (numArgs == 3)
        goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOO:invalidate", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::invalidate(QRectF,QFlags<QGraphicsScene::SceneLayer>)
    // 1: QGraphicsScene::invalidate(qreal,qreal,qreal,qreal,QFlags<QGraphicsScene::SceneLayer>)
    if (numArgs == 0) {
        overloadId = 0; // invalidate(QRectF,QFlags<QGraphicsScene::SceneLayer>)
    } else if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 1; // invalidate(qreal,qreal,qreal,qreal,QFlags<QGraphicsScene::SceneLayer>)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, (pyArgs[4])))) {
            overloadId = 1; // invalidate(qreal,qreal,qreal,qreal,QFlags<QGraphicsScene::SceneLayer>)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // invalidate(QRectF,QFlags<QGraphicsScene::SceneLayer>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // invalidate(QRectF,QFlags<QGraphicsScene::SceneLayer>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // invalidate(const QRectF & rect, QFlags<QGraphicsScene::SceneLayer> layers)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_rect = Shiboken::String::createStaticString("rect");
                if (PyDict_Contains(kwds, key_rect)) {
                    value = PyDict_GetItem(kwds, key_rect);
                    if (value && pyArgs[0]) {
                        errInfo = key_rect;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0]))))
                            goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_rect);
                }
                static PyObject *const key_layers = Shiboken::String::createStaticString("layers");
                if (PyDict_Contains(kwds, key_layers)) {
                    value = PyDict_GetItem(kwds, key_layers);
                    if (value && pyArgs[1]) {
                        errInfo = key_layers;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_layers);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local = QRectF();
            ::QRectF *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }
            ::QFlags<QGraphicsScene::SceneLayer> cppArg1 = QGraphicsScene::AllLayers;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // invalidate(QRectF,QFlags<QGraphicsScene::SceneLayer>)
                cppSelf->invalidate(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // invalidate(qreal x, qreal y, qreal w, qreal h, QFlags<QGraphicsScene::SceneLayer> layers)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_layers = Shiboken::String::createStaticString("layers");
                if (PyDict_Contains(kwds, key_layers)) {
                    value = PyDict_GetItem(kwds, key_layers);
                    if (value && pyArgs[4]) {
                        errInfo = key_layers;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, (pyArgs[4]))))
                            goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_layers);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_invalidate_TypeError;
                }
            }
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<QGraphicsScene::SceneLayer> cppArg4 = QGraphicsScene::AllLayers;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // invalidate(qreal,qreal,qreal,qreal,QFlags<QGraphicsScene::SceneLayer>)
                cppSelf->invalidate(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_invalidate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.isActive";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isActive()const
            bool cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->isActive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_isSortCacheEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.isSortCacheEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSortCacheEnabled()const
            bool cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->isSortCacheEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_itemAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.itemAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "itemAt", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::itemAt(QPointF,QTransform)const
    // 1: QGraphicsScene::itemAt(qreal,qreal,QTransform)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[2])))) {
        overloadId = 1; // itemAt(qreal,qreal,QTransform)const
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // itemAt(QPointF,QTransform)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_itemAt_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // itemAt(const QPointF & pos, const QTransform & deviceTransform) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTransform cppArg1_local;
            ::QTransform *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // itemAt(QPointF,QTransform)const
                QGraphicsItem * cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->itemAt(*cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // itemAt(qreal x, qreal y, const QTransform & deviceTransform) const
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QTransform cppArg2_local;
            ::QTransform *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // itemAt(qreal,qreal,QTransform)const
                QGraphicsItem * cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->itemAt(cppArg0, cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_itemAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_itemIndexMethod(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.itemIndexMethod";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // itemIndexMethod()const
            QGraphicsScene::ItemIndexMethod cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->itemIndexMethod();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_items(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.items";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_items_TypeError;
    } else if (numArgs == 5)
        goto Sbk_QGraphicsSceneFunc_items_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOO:items", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::items(Qt::SortOrder)const
    // 1: QGraphicsScene::items(QPainterPath,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
    // 2: QGraphicsScene::items(QPointF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
    // 3: QGraphicsScene::items(QPolygonF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
    // 4: QGraphicsScene::items(QRectF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
    // 5: QGraphicsScene::items(qreal,qreal,qreal,qreal,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
    if (numArgs == 0) {
        overloadId = 0; // items(Qt::SortOrder)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 4; // items(QRectF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 4; // items(QRectF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 4; // items(QRectF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3])))) {
                    overloadId = 4; // items(QRectF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // items(QPolygonF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // items(QPolygonF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // items(QPolygonF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3])))) {
                    overloadId = 3; // items(QPolygonF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // items(QPointF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // items(QPointF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // items(QPointF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3])))) {
                    overloadId = 2; // items(QPointF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // items(QPainterPath,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // items(QPainterPath,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // items(QPainterPath,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3])))) {
                    overloadId = 1; // items(QPainterPath,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // items(Qt::SortOrder)const
    } else if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 5; // items(qreal,qreal,qreal,qreal,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[6])))) {
            overloadId = 5; // items(qreal,qreal,qreal,qreal,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_items_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // items(Qt::SortOrder order) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_order = Shiboken::String::createStaticString("order");
                if (PyDict_Contains(kwds, key_order)) {
                    value = PyDict_GetItem(kwds, key_order);
                    if (value && pyArgs[0]) {
                        errInfo = key_order;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_order);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_items_TypeError;
                }
            }
            ::Qt::SortOrder cppArg0 = Qt::DescendingOrder;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // items(Qt::SortOrder)const
                QList<QGraphicsItem* > cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->items(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], &cppResult);
            }
            break;
        }
        case 1: // items(const QPainterPath & path, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform & deviceTransform) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_order = Shiboken::String::createStaticString("order");
                if (PyDict_Contains(kwds, key_order)) {
                    value = PyDict_GetItem(kwds, key_order);
                    if (value && pyArgs[2]) {
                        errInfo = key_order;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_order);
                }
                static PyObject *const key_deviceTransform = Shiboken::String::createStaticString("deviceTransform");
                if (PyDict_Contains(kwds, key_deviceTransform)) {
                    value = PyDict_GetItem(kwds, key_deviceTransform);
                    if (value && pyArgs[3]) {
                        errInfo = key_deviceTransform;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deviceTransform);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_items_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainterPath cppArg0_local;
            ::QPainterPath *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::ItemSelectionMode cppArg1 = Qt::IntersectsItemShape;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::SortOrder cppArg2 = Qt::DescendingOrder;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QTransform cppArg3_local = QTransform();
            ::QTransform *cppArg3 = &cppArg3_local;
            if (pythonToCpp[3]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);
            }

            if (!PyErr_Occurred()) {
                // items(QPainterPath,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                QList<QGraphicsItem* > cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->items(*cppArg0, cppArg1, cppArg2, *cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], &cppResult);
            }
            break;
        }
        case 2: // items(const QPointF & pos, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform & deviceTransform) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_order = Shiboken::String::createStaticString("order");
                if (PyDict_Contains(kwds, key_order)) {
                    value = PyDict_GetItem(kwds, key_order);
                    if (value && pyArgs[2]) {
                        errInfo = key_order;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_order);
                }
                static PyObject *const key_deviceTransform = Shiboken::String::createStaticString("deviceTransform");
                if (PyDict_Contains(kwds, key_deviceTransform)) {
                    value = PyDict_GetItem(kwds, key_deviceTransform);
                    if (value && pyArgs[3]) {
                        errInfo = key_deviceTransform;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deviceTransform);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_items_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::ItemSelectionMode cppArg1 = Qt::IntersectsItemShape;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::SortOrder cppArg2 = Qt::DescendingOrder;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QTransform cppArg3_local = QTransform();
            ::QTransform *cppArg3 = &cppArg3_local;
            if (pythonToCpp[3]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);
            }

            if (!PyErr_Occurred()) {
                // items(QPointF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                QList<QGraphicsItem* > cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->items(*cppArg0, cppArg1, cppArg2, *cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], &cppResult);
            }
            break;
        }
        case 3: // items(const QPolygonF & polygon, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform & deviceTransform) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_order = Shiboken::String::createStaticString("order");
                if (PyDict_Contains(kwds, key_order)) {
                    value = PyDict_GetItem(kwds, key_order);
                    if (value && pyArgs[2]) {
                        errInfo = key_order;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_order);
                }
                static PyObject *const key_deviceTransform = Shiboken::String::createStaticString("deviceTransform");
                if (PyDict_Contains(kwds, key_deviceTransform)) {
                    value = PyDict_GetItem(kwds, key_deviceTransform);
                    if (value && pyArgs[3]) {
                        errInfo = key_deviceTransform;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deviceTransform);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_items_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPolygonF cppArg0_local;
            ::QPolygonF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::ItemSelectionMode cppArg1 = Qt::IntersectsItemShape;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::SortOrder cppArg2 = Qt::DescendingOrder;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QTransform cppArg3_local = QTransform();
            ::QTransform *cppArg3 = &cppArg3_local;
            if (pythonToCpp[3]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);
            }

            if (!PyErr_Occurred()) {
                // items(QPolygonF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                QList<QGraphicsItem* > cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->items(*cppArg0, cppArg1, cppArg2, *cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], &cppResult);
            }
            break;
        }
        case 4: // items(const QRectF & rect, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform & deviceTransform) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_order = Shiboken::String::createStaticString("order");
                if (PyDict_Contains(kwds, key_order)) {
                    value = PyDict_GetItem(kwds, key_order);
                    if (value && pyArgs[2]) {
                        errInfo = key_order;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_order);
                }
                static PyObject *const key_deviceTransform = Shiboken::String::createStaticString("deviceTransform");
                if (PyDict_Contains(kwds, key_deviceTransform)) {
                    value = PyDict_GetItem(kwds, key_deviceTransform);
                    if (value && pyArgs[3]) {
                        errInfo = key_deviceTransform;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deviceTransform);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_items_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::ItemSelectionMode cppArg1 = Qt::IntersectsItemShape;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::SortOrder cppArg2 = Qt::DescendingOrder;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QTransform cppArg3_local = QTransform();
            ::QTransform *cppArg3 = &cppArg3_local;
            if (pythonToCpp[3]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);
            }

            if (!PyErr_Occurred()) {
                // items(QRectF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                QList<QGraphicsItem* > cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->items(*cppArg0, cppArg1, cppArg2, *cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], &cppResult);
            }
            break;
        }
        case 5: // items(qreal x, qreal y, qreal w, qreal h, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform & deviceTransform) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_deviceTransform = Shiboken::String::createStaticString("deviceTransform");
                if (PyDict_Contains(kwds, key_deviceTransform)) {
                    value = PyDict_GetItem(kwds, key_deviceTransform);
                    if (value && pyArgs[6]) {
                        errInfo = key_deviceTransform;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[6]))))
                            goto Sbk_QGraphicsSceneFunc_items_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deviceTransform);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_items_TypeError;
                }
            }
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::Qt::ItemSelectionMode cppArg4{Qt::ContainsItemShape};
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::Qt::SortOrder cppArg5{Qt::AscendingOrder};
            pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QTransform cppArg6_local = QTransform();
            ::QTransform *cppArg6 = &cppArg6_local;
            if (pythonToCpp[6]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[6]))
                pythonToCpp[6](pyArgs[6], &cppArg6_local);
            else
                pythonToCpp[6](pyArgs[6], &cppArg6);
            }

            if (!PyErr_Occurred()) {
                // items(qreal,qreal,qreal,qreal,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                QList<QGraphicsItem* > cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->items(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, *cppArg6);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_items_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_itemsBoundingRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.itemsBoundingRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // itemsBoundingRect()const
            QRectF cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->itemsBoundingRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.keyPressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_keyPressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_keyPressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_keyReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.keyReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::keyReleaseEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // keyReleaseEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_keyReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyReleaseEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::keyReleaseEvent(cppArg0)
                : cppSelf->keyReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_keyReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_minimumRenderSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.minimumRenderSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumRenderSize()const
            qreal cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->minimumRenderSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_mouseDoubleClickEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.mouseDoubleClickEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_mouseDoubleClickEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::mouseDoubleClickEvent(cppArg0)
                : cppSelf->mouseDoubleClickEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_mouseDoubleClickEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_mouseGrabberItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.mouseGrabberItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mouseGrabberItem()const
            QGraphicsItem * cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->mouseGrabberItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_mouseMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.mouseMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseMoveEvent(QGraphicsSceneMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_mouseMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseMoveEvent(QGraphicsSceneMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::mouseMoveEvent(cppArg0)
                : cppSelf->mouseMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_mouseMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.mousePressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QGraphicsSceneMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_mousePressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mousePressEvent(QGraphicsSceneMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::mousePressEvent(cppArg0)
                : cppSelf->mousePressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_mousePressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.mouseReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_mouseReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseReleaseEvent(QGraphicsSceneMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::mouseReleaseEvent(cppArg0)
                : cppSelf->mouseReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_mouseReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_palette(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.palette";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // palette()const
            QPalette cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->palette();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_removeItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.removeItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::removeItem(QGraphicsItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArg)))) {
        overloadId = 0; // removeItem(QGraphicsItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_removeItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeItem(QGraphicsItem*)
            cppSelf->removeItem(cppArg0);
            Shiboken::Object::setParent(Py_None, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_removeItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_render(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.render";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_render_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_render_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:render", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 0; // render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_render_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_target = Shiboken::String::createStaticString("target");
            if (PyDict_Contains(kwds, key_target)) {
                value = PyDict_GetItem(kwds, key_target);
                if (value && pyArgs[1]) {
                    errInfo = key_target;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_render_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1]))))
                        goto Sbk_QGraphicsSceneFunc_render_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_target);
            }
            static PyObject *const key_source = Shiboken::String::createStaticString("source");
            if (PyDict_Contains(kwds, key_source)) {
                value = PyDict_GetItem(kwds, key_source);
                if (value && pyArgs[2]) {
                    errInfo = key_source;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_render_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[2]))))
                        goto Sbk_QGraphicsSceneFunc_render_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_source);
            }
            static PyObject *const key_aspectRatioMode = Shiboken::String::createStaticString("aspectRatioMode");
            if (PyDict_Contains(kwds, key_aspectRatioMode)) {
                value = PyDict_GetItem(kwds, key_aspectRatioMode);
                if (value && pyArgs[3]) {
                    errInfo = key_aspectRatioMode;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_render_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QGraphicsSceneFunc_render_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_aspectRatioMode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneFunc_render_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local = QRectF();
        ::QRectF *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QRectF cppArg2_local = QRectF();
        ::QRectF *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }
        ::Qt::AspectRatioMode cppArg3 = Qt::KeepAspectRatio;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
            cppSelf->render(cppArg0, *cppArg1, *cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_render_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_sceneRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.sceneRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sceneRect()const
            QRectF cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->sceneRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_selectedItems(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.selectedItems";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedItems()const
            QList<QGraphicsItem* > cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->selectedItems();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_selectionArea(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.selectionArea";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectionArea()const
            QPainterPath cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->selectionArea();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_sendEvent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.sendEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sendEvent", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::sendEvent(QGraphicsItem*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // sendEvent(QGraphicsItem*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_sendEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGraphicsItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // sendEvent(QGraphicsItem*,QEvent*)
            bool cppResult = cppSelf->sendEvent(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsSceneFunc_sendEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setActivePanel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setActivePanel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setActivePanel(QGraphicsItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArg)))) {
        overloadId = 0; // setActivePanel(QGraphicsItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setActivePanel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActivePanel(QGraphicsItem*)
            cppSelf->setActivePanel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setActivePanel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setActiveWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setActiveWindow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setActiveWindow(QGraphicsWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // setActiveWindow(QGraphicsWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setActiveWindow_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActiveWindow(QGraphicsWidget*)
            cppSelf->setActiveWindow(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setActiveWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setBackgroundBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setBackgroundBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setBackgroundBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setBackgroundBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setBackgroundBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBackgroundBrush(QBrush)
            cppSelf->setBackgroundBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setBackgroundBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setBspTreeDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setBspTreeDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setBspTreeDepth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBspTreeDepth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setBspTreeDepth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBspTreeDepth(int)
            cppSelf->setBspTreeDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setBspTreeDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setFocus(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setFocus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_setFocus_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setFocus", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::setFocus(Qt::FocusReason)
    if (numArgs == 0) {
        overloadId = 0; // setFocus(Qt::FocusReason)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // setFocus(Qt::FocusReason)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setFocus_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_focusReason = Shiboken::String::createStaticString("focusReason");
            if (PyDict_Contains(kwds, key_focusReason)) {
                value = PyDict_GetItem(kwds, key_focusReason);
                if (value && pyArgs[0]) {
                    errInfo = key_focusReason;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_setFocus_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QGraphicsSceneFunc_setFocus_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_focusReason);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneFunc_setFocus_TypeError;
            }
        }
        ::Qt::FocusReason cppArg0 = Qt::OtherFocusReason;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setFocus(Qt::FocusReason)
            cppSelf->setFocus(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setFocus_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setFocusItem(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setFocusItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_setFocusItem_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_setFocusItem_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setFocusItem", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::setFocusItem(QGraphicsItem*,Qt::FocusReason)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFocusItem(QGraphicsItem*,Qt::FocusReason)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setFocusItem(QGraphicsItem*,Qt::FocusReason)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setFocusItem_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_focusReason = Shiboken::String::createStaticString("focusReason");
            if (PyDict_Contains(kwds, key_focusReason)) {
                value = PyDict_GetItem(kwds, key_focusReason);
                if (value && pyArgs[1]) {
                    errInfo = key_focusReason;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneFunc_setFocusItem_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QGraphicsSceneFunc_setFocusItem_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_focusReason);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneFunc_setFocusItem_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGraphicsItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::FocusReason cppArg1 = Qt::OtherFocusReason;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFocusItem(QGraphicsItem*,Qt::FocusReason)
            cppSelf->setFocusItem(cppArg0, cppArg1);
            Shiboken::Object::setParent(self, pyArgs[0]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setFocusItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setFocusOnTouch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setFocusOnTouch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setFocusOnTouch(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFocusOnTouch(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setFocusOnTouch_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFocusOnTouch(bool)
            cppSelf->setFocusOnTouch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setFocusOnTouch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // setFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setFont_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFont(QFont)
            cppSelf->setFont(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setForegroundBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setForegroundBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setForegroundBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setForegroundBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setForegroundBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setForegroundBrush(QBrush)
            cppSelf->setForegroundBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setForegroundBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setItemIndexMethod(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setItemIndexMethod";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setItemIndexMethod(QGraphicsScene::ItemIndexMethod)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setItemIndexMethod(QGraphicsScene::ItemIndexMethod)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setItemIndexMethod_TypeError;

    // Call function/method
    {
        ::QGraphicsScene::ItemIndexMethod cppArg0{QGraphicsScene::BspTreeIndex};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setItemIndexMethod(QGraphicsScene::ItemIndexMethod)
            cppSelf->setItemIndexMethod(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setItemIndexMethod_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setMinimumRenderSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setMinimumRenderSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setMinimumRenderSize(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMinimumRenderSize(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setMinimumRenderSize_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinimumRenderSize(qreal)
            cppSelf->setMinimumRenderSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setMinimumRenderSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setPalette(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setPalette";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setPalette(QPalette)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArg)))) {
        overloadId = 0; // setPalette(QPalette)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setPalette_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPalette cppArg0_local;
        ::QPalette *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPalette(QPalette)
            cppSelf->setPalette(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setPalette_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setSceneRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setSceneRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QGraphicsSceneFunc_setSceneRect_TypeError;

    if (!PyArg_UnpackTuple(args, "setSceneRect", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::setSceneRect(QRectF)
    // 1: QGraphicsScene::setSceneRect(qreal,qreal,qreal,qreal)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 1; // setSceneRect(qreal,qreal,qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setSceneRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setSceneRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setSceneRect(const QRectF & rect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setSceneRect(QRectF)
                cppSelf->setSceneRect(*cppArg0);
            }
            break;
        }
        case 1: // setSceneRect(qreal x, qreal y, qreal w, qreal h)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setSceneRect(qreal,qreal,qreal,qreal)
                cppSelf->setSceneRect(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setSceneRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setSelectionArea(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setSelectionArea";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:setSelectionArea", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::setSelectionArea(QPainterPath,Qt::ItemSelectionMode,QTransform)
    // 1: QGraphicsScene::setSelectionArea(QPainterPath,Qt::ItemSelectionOperation,Qt::ItemSelectionMode,QTransform)
    // 2: QGraphicsScene::setSelectionArea(QPainterPath,QTransform)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setSelectionArea(QPainterPath,Qt::ItemSelectionMode,QTransform)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[1])))) {
            overloadId = 2; // setSelectionArea(QPainterPath,QTransform)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONOPERATION_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // setSelectionArea(QPainterPath,Qt::ItemSelectionOperation,Qt::ItemSelectionMode,QTransform)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // setSelectionArea(QPainterPath,Qt::ItemSelectionOperation,Qt::ItemSelectionMode,QTransform)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3])))) {
                    overloadId = 1; // setSelectionArea(QPainterPath,Qt::ItemSelectionOperation,Qt::ItemSelectionMode,QTransform)
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setSelectionArea(QPainterPath,Qt::ItemSelectionMode,QTransform)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[2])))) {
                overloadId = 0; // setSelectionArea(QPainterPath,Qt::ItemSelectionMode,QTransform)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setSelectionArea(const QPainterPath & path, Qt::ItemSelectionMode mode, const QTransform & deviceTransform)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_deviceTransform = Shiboken::String::createStaticString("deviceTransform");
                if (PyDict_Contains(kwds, key_deviceTransform)) {
                    value = PyDict_GetItem(kwds, key_deviceTransform);
                    if (value && pyArgs[2]) {
                        errInfo = key_deviceTransform;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[2]))))
                            goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deviceTransform);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainterPath cppArg0_local;
            ::QPainterPath *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::ItemSelectionMode cppArg1 = Qt::IntersectsItemShape;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QTransform cppArg2_local = QTransform();
            ::QTransform *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // setSelectionArea(QPainterPath,Qt::ItemSelectionMode,QTransform)
                cppSelf->setSelectionArea(*cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 1: // setSelectionArea(const QPainterPath & path, Qt::ItemSelectionOperation selectionOperation, Qt::ItemSelectionMode mode, const QTransform & deviceTransform)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_deviceTransform = Shiboken::String::createStaticString("deviceTransform");
                if (PyDict_Contains(kwds, key_deviceTransform)) {
                    value = PyDict_GetItem(kwds, key_deviceTransform);
                    if (value && pyArgs[3]) {
                        errInfo = key_deviceTransform;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[3]))))
                            goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deviceTransform);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainterPath cppArg0_local;
            ::QPainterPath *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::ItemSelectionOperation cppArg1{Qt::ReplaceSelection};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::ItemSelectionMode cppArg2 = Qt::IntersectsItemShape;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QTransform cppArg3_local = QTransform();
            ::QTransform *cppArg3 = &cppArg3_local;
            if (pythonToCpp[3]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);
            }

            if (!PyErr_Occurred()) {
                // setSelectionArea(QPainterPath,Qt::ItemSelectionOperation,Qt::ItemSelectionMode,QTransform)
                cppSelf->setSelectionArea(*cppArg0, cppArg1, cppArg2, *cppArg3);
            }
            break;
        }
        case 2: // setSelectionArea(const QPainterPath & path, const QTransform & deviceTransform)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainterPath cppArg0_local;
            ::QPainterPath *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTransform cppArg1_local;
            ::QTransform *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setSelectionArea(QPainterPath,QTransform)
                cppSelf->setSelectionArea(*cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setSelectionArea_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setSortCacheEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setSortCacheEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setSortCacheEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSortCacheEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setSortCacheEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSortCacheEnabled(bool)
            cppSelf->setSortCacheEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setSortCacheEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setStickyFocus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setStickyFocus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setStickyFocus(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setStickyFocus(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setStickyFocus_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStickyFocus(bool)
            cppSelf->setStickyFocus(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setStickyFocus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_setStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.setStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::setStyle(QStyle*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX]), (pyArg)))) {
        overloadId = 0; // setStyle(QStyle*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_setStyle_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QStyle *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStyle(QStyle*)
            cppSelf->setStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_setStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_stickyFocus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.stickyFocus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stickyFocus()const
            bool cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->stickyFocus();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_style(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.style";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // style()const
            QStyle * cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->style();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_update(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.update";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneFunc_update_TypeError;
    } else if (numArgs == 2 || numArgs == 3)
        goto Sbk_QGraphicsSceneFunc_update_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOO:update", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsScene::update(QRectF)
    // 1: QGraphicsScene::update(qreal,qreal,qreal,qreal)
    if (numArgs == 0) {
        overloadId = 0; // update(QRectF)
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 1; // update(qreal,qreal,qreal,qreal)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // update(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_update_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // update(const QRectF & rect)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_rect = Shiboken::String::createStaticString("rect");
                if (PyDict_Contains(kwds, key_rect)) {
                    value = PyDict_GetItem(kwds, key_rect);
                    if (value && pyArgs[0]) {
                        errInfo = key_rect;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsSceneFunc_update_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0]))))
                            goto Sbk_QGraphicsSceneFunc_update_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_rect);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsSceneFunc_update_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local = QRectF();
            ::QRectF *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

            if (!PyErr_Occurred()) {
                // update(QRectF)
                cppSelf->update(*cppArg0);
            }
            break;
        }
        case 1: // update(qreal x, qreal y, qreal w, qreal h)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGraphicsSceneFunc_update_TypeError;
            }
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // update(qreal,qreal,qreal,qreal)
                cppSelf->update(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_update_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_views(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.views";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // views()const
            QList<QGraphicsView* > cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->views();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSVIEWPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneFunc_wheelEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.wheelEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsScene::wheelEvent(QGraphicsSceneWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEWHEELEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // wheelEvent(QGraphicsSceneWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneFunc_wheelEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsSceneWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // wheelEvent(QGraphicsSceneWheelEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsScene::wheelEvent(cppArg0)
                : cppSelf->wheelEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneFunc_wheelEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsScene.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            qreal cppResult = const_cast<const ::QGraphicsScene *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGraphicsScene_PropertyStrings[] = {
    "backgroundBrush::",
    "bspTreeDepth::",
    "focusOnTouch::",
    "font::",
    "foregroundBrush::",
    "itemIndexMethod::",
    "minimumRenderSize::",
    "palette::",
    "sceneRect::",
    "sortCacheEnabled:isSortCacheEnabled:",
    "stickyFocus::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGraphicsScene_methods[] = {
    {"activePanel", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_activePanel), METH_NOARGS},
    {"activeWindow", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_activeWindow), METH_NOARGS},
    {"addEllipse", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addEllipse), METH_VARARGS|METH_KEYWORDS},
    {"addItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addItem), METH_O},
    {"addLine", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addLine), METH_VARARGS|METH_KEYWORDS},
    {"addPath", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addPath), METH_VARARGS|METH_KEYWORDS},
    {"addPixmap", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addPixmap), METH_O},
    {"addPolygon", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addPolygon), METH_VARARGS|METH_KEYWORDS},
    {"addRect", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addRect), METH_VARARGS|METH_KEYWORDS},
    {"addSimpleText", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addSimpleText), METH_VARARGS|METH_KEYWORDS},
    {"addText", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addText), METH_VARARGS|METH_KEYWORDS},
    {"addWidget", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_addWidget), METH_VARARGS|METH_KEYWORDS},
    {"advance", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_advance), METH_NOARGS},
    {"backgroundBrush", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_backgroundBrush), METH_NOARGS},
    {"bspTreeDepth", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_bspTreeDepth), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_clear), METH_NOARGS},
    {"clearFocus", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_clearFocus), METH_NOARGS},
    {"clearSelection", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_clearSelection), METH_NOARGS},
    {"collidingItems", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_collidingItems), METH_VARARGS|METH_KEYWORDS},
    {"contextMenuEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_contextMenuEvent), METH_O},
    {"createItemGroup", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_createItemGroup), METH_O},
    {"destroyItemGroup", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_destroyItemGroup), METH_O},
    {"dragEnterEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_dragEnterEvent), METH_O},
    {"dragLeaveEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_dragLeaveEvent), METH_O},
    {"dragMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_dragMoveEvent), METH_O},
    {"drawBackground", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_drawBackground), METH_VARARGS},
    {"drawForeground", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_drawForeground), METH_VARARGS},
    {"dropEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_dropEvent), METH_O},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_event), METH_O},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_eventFilter), METH_VARARGS},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_focusInEvent), METH_O},
    {"focusItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_focusItem), METH_NOARGS},
    {"focusNextPrevChild", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_focusNextPrevChild), METH_O},
    {"focusOnTouch", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_focusOnTouch), METH_NOARGS},
    {"focusOutEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_focusOutEvent), METH_O},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_font), METH_NOARGS},
    {"foregroundBrush", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_foregroundBrush), METH_NOARGS},
    {"hasFocus", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_hasFocus), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_height), METH_NOARGS},
    {"helpEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_helpEvent), METH_O},
    {"inputMethodEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_inputMethodEvent), METH_O},
    {"inputMethodQuery", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_inputMethodQuery), METH_O},
    {"invalidate", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_invalidate), METH_VARARGS|METH_KEYWORDS},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_isActive), METH_NOARGS},
    {"isSortCacheEnabled", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_isSortCacheEnabled), METH_NOARGS},
    {"itemAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_itemAt), METH_VARARGS},
    {"itemIndexMethod", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_itemIndexMethod), METH_NOARGS},
    {"items", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_items), METH_VARARGS|METH_KEYWORDS},
    {"itemsBoundingRect", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_itemsBoundingRect), METH_NOARGS},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_keyPressEvent), METH_O},
    {"keyReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_keyReleaseEvent), METH_O},
    {"minimumRenderSize", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_minimumRenderSize), METH_NOARGS},
    {"mouseDoubleClickEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_mouseDoubleClickEvent), METH_O},
    {"mouseGrabberItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_mouseGrabberItem), METH_NOARGS},
    {"mouseMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_mouseMoveEvent), METH_O},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_mousePressEvent), METH_O},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_mouseReleaseEvent), METH_O},
    {"palette", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_palette), METH_NOARGS},
    {"removeItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_removeItem), METH_O},
    {"render", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_render), METH_VARARGS|METH_KEYWORDS},
    {"sceneRect", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_sceneRect), METH_NOARGS},
    {"selectedItems", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_selectedItems), METH_NOARGS},
    {"selectionArea", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_selectionArea), METH_NOARGS},
    {"sendEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_sendEvent), METH_VARARGS},
    {"setActivePanel", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setActivePanel), METH_O},
    {"setActiveWindow", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setActiveWindow), METH_O},
    {"setBackgroundBrush", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setBackgroundBrush), METH_O},
    {"setBspTreeDepth", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setBspTreeDepth), METH_O},
    {"setFocus", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setFocus), METH_VARARGS|METH_KEYWORDS},
    {"setFocusItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setFocusItem), METH_VARARGS|METH_KEYWORDS},
    {"setFocusOnTouch", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setFocusOnTouch), METH_O},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setFont), METH_O},
    {"setForegroundBrush", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setForegroundBrush), METH_O},
    {"setItemIndexMethod", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setItemIndexMethod), METH_O},
    {"setMinimumRenderSize", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setMinimumRenderSize), METH_O},
    {"setPalette", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setPalette), METH_O},
    {"setSceneRect", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setSceneRect), METH_VARARGS},
    {"setSelectionArea", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setSelectionArea), METH_VARARGS|METH_KEYWORDS},
    {"setSortCacheEnabled", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setSortCacheEnabled), METH_O},
    {"setStickyFocus", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setStickyFocus), METH_O},
    {"setStyle", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_setStyle), METH_O},
    {"stickyFocus", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_stickyFocus), METH_NOARGS},
    {"style", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_style), METH_NOARGS},
    {"update", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_update), METH_VARARGS|METH_KEYWORDS},
    {"views", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_views), METH_NOARGS},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_wheelEvent), METH_O},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneFunc_width), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGraphicsScene_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGraphicsScene *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGraphicsSceneWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGraphicsScene_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGraphicsScene_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGraphicsScene_Type = nullptr;
static SbkObjectType *Sbk_QGraphicsScene_TypeF(void)
{
    return _Sbk_QGraphicsScene_Type;
}

static PyType_Slot Sbk_QGraphicsScene_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGraphicsScene_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGraphicsScene_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGraphicsScene_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGraphicsScene_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGraphicsScene_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGraphicsScene_spec = {
    "2:PySide2.QtWidgets.QGraphicsScene",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGraphicsScene_slots
};

} //extern "C"

static void *Sbk_QGraphicsScene_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGraphicsScene *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer___and__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsScene::SceneLayers cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGraphicsScene::SceneLayers>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGraphicsScene::SceneLayers>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGraphicsScene::SceneLayers>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGraphicsScene::SceneLayers>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer___or__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsScene::SceneLayers cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGraphicsScene::SceneLayers>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGraphicsScene::SceneLayers>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGraphicsScene::SceneLayers>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGraphicsScene::SceneLayers>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsScene::SceneLayers cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGraphicsScene::SceneLayers>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGraphicsScene::SceneLayers>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGraphicsScene::SceneLayers>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGraphicsScene::SceneLayers>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsScene::SceneLayers cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, self, &cppSelf);
    ::QGraphicsScene::SceneLayers cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGraphicsScene_ItemIndexMethod_PythonToCpp_QGraphicsScene_ItemIndexMethod(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGraphicsScene::ItemIndexMethod *>(cppOut) =
        static_cast<::QGraphicsScene::ItemIndexMethod>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGraphicsScene_ItemIndexMethod_PythonToCpp_QGraphicsScene_ItemIndexMethod_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX]))
        return QGraphicsScene_ItemIndexMethod_PythonToCpp_QGraphicsScene_ItemIndexMethod;
    return {};
}
static PyObject *QGraphicsScene_ItemIndexMethod_CppToPython_QGraphicsScene_ItemIndexMethod(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGraphicsScene::ItemIndexMethod *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX], castCppIn);

}

static void QGraphicsScene_SceneLayer_PythonToCpp_QGraphicsScene_SceneLayer(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGraphicsScene::SceneLayer *>(cppOut) =
        static_cast<::QGraphicsScene::SceneLayer>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGraphicsScene_SceneLayer_PythonToCpp_QGraphicsScene_SceneLayer_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX]))
        return QGraphicsScene_SceneLayer_PythonToCpp_QGraphicsScene_SceneLayer;
    return {};
}
static PyObject *QGraphicsScene_SceneLayer_CppToPython_QGraphicsScene_SceneLayer(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGraphicsScene::SceneLayer *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX], castCppIn);

}

static void QFlags_QGraphicsScene_SceneLayer__PythonToCpp_QFlags_QGraphicsScene_SceneLayer_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGraphicsScene::SceneLayer> *>(cppOut) =
        ::QFlags<QGraphicsScene::SceneLayer>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGraphicsScene_SceneLayer__PythonToCpp_QFlags_QGraphicsScene_SceneLayer__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX]))
        return QFlags_QGraphicsScene_SceneLayer__PythonToCpp_QFlags_QGraphicsScene_SceneLayer_;
    return {};
}
static PyObject *QFlags_QGraphicsScene_SceneLayer__CppToPython_QFlags_QGraphicsScene_SceneLayer_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGraphicsScene::SceneLayer> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX]));

}

static void QGraphicsScene_SceneLayer_PythonToCpp_QFlags_QGraphicsScene_SceneLayer_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGraphicsScene::SceneLayer> *>(cppOut) =
        ::QFlags<QGraphicsScene::SceneLayer>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGraphicsScene_SceneLayer_PythonToCpp_QFlags_QGraphicsScene_SceneLayer__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX]))
        return QGraphicsScene_SceneLayer_PythonToCpp_QFlags_QGraphicsScene_SceneLayer_;
    return {};
}
static void number_PythonToCpp_QFlags_QGraphicsScene_SceneLayer_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGraphicsScene::SceneLayer> *>(cppOut) =
        ::QFlags<QGraphicsScene::SceneLayer>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGraphicsScene_SceneLayer__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX]))
        return number_PythonToCpp_QFlags_QGraphicsScene_SceneLayer_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGraphicsScene_PythonToCpp_QGraphicsScene_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGraphicsScene_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGraphicsScene_PythonToCpp_QGraphicsScene_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsScene_TypeF())))
        return QGraphicsScene_PythonToCpp_QGraphicsScene_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGraphicsScene_PTR_CppToPython_QGraphicsScene(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGraphicsScene *>(const_cast<void *>(cppIn)), Sbk_QGraphicsScene_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGraphicsScene_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QGraphicsScene(self,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtWidgets.QGraphicsScene(self,sceneRect:PySide2.QtCore.QRectF,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtWidgets.QGraphicsScene(self,x:qreal,y:qreal,width:qreal,height:qreal,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtWidgets.QGraphicsScene.activePanel(self)->PySide2.QtWidgets.QGraphicsItem",
    "PySide2.QtWidgets.QGraphicsScene.activeWindow(self)->PySide2.QtWidgets.QGraphicsWidget",
    "1:PySide2.QtWidgets.QGraphicsScene.addEllipse(self,rect:PySide2.QtCore.QRectF,pen:PySide2.QtGui.QPen=QPen(),brush:PySide2.QtGui.QBrush=QBrush())->PySide2.QtWidgets.QGraphicsEllipseItem",
    "0:PySide2.QtWidgets.QGraphicsScene.addEllipse(self,x:qreal,y:qreal,w:qreal,h:qreal,pen:PySide2.QtGui.QPen=QPen(),brush:PySide2.QtGui.QBrush=QBrush())->PySide2.QtWidgets.QGraphicsEllipseItem",
    "PySide2.QtWidgets.QGraphicsScene.addItem(self,item:PySide2.QtWidgets.QGraphicsItem)",
    "1:PySide2.QtWidgets.QGraphicsScene.addLine(self,line:PySide2.QtCore.QLineF,pen:PySide2.QtGui.QPen=QPen())->PySide2.QtWidgets.QGraphicsLineItem",
    "0:PySide2.QtWidgets.QGraphicsScene.addLine(self,x1:qreal,y1:qreal,x2:qreal,y2:qreal,pen:PySide2.QtGui.QPen=QPen())->PySide2.QtWidgets.QGraphicsLineItem",
    "PySide2.QtWidgets.QGraphicsScene.addPath(self,path:PySide2.QtGui.QPainterPath,pen:PySide2.QtGui.QPen=QPen(),brush:PySide2.QtGui.QBrush=QBrush())->PySide2.QtWidgets.QGraphicsPathItem",
    "PySide2.QtWidgets.QGraphicsScene.addPixmap(self,pixmap:PySide2.QtGui.QPixmap)->PySide2.QtWidgets.QGraphicsPixmapItem",
    "PySide2.QtWidgets.QGraphicsScene.addPolygon(self,polygon:PySide2.QtGui.QPolygonF,pen:PySide2.QtGui.QPen=QPen(),brush:PySide2.QtGui.QBrush=QBrush())->PySide2.QtWidgets.QGraphicsPolygonItem",
    "1:PySide2.QtWidgets.QGraphicsScene.addRect(self,rect:PySide2.QtCore.QRectF,pen:PySide2.QtGui.QPen=QPen(),brush:PySide2.QtGui.QBrush=QBrush())->PySide2.QtWidgets.QGraphicsRectItem",
    "0:PySide2.QtWidgets.QGraphicsScene.addRect(self,x:qreal,y:qreal,w:qreal,h:qreal,pen:PySide2.QtGui.QPen=QPen(),brush:PySide2.QtGui.QBrush=QBrush())->PySide2.QtWidgets.QGraphicsRectItem",
    "PySide2.QtWidgets.QGraphicsScene.addSimpleText(self,text:QString,font:PySide2.QtGui.QFont=QFont())->PySide2.QtWidgets.QGraphicsSimpleTextItem",
    "PySide2.QtWidgets.QGraphicsScene.addText(self,text:QString,font:PySide2.QtGui.QFont=QFont())->PySide2.QtWidgets.QGraphicsTextItem",
    "PySide2.QtWidgets.QGraphicsScene.addWidget(self,widget:PySide2.QtWidgets.QWidget,wFlags:PySide2.QtCore.Qt.WindowFlags=Qt.WindowFlags())->PySide2.QtWidgets.QGraphicsProxyWidget",
    "PySide2.QtWidgets.QGraphicsScene.advance(self)",
    "PySide2.QtWidgets.QGraphicsScene.backgroundBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtWidgets.QGraphicsScene.bspTreeDepth(self)->int",
    "PySide2.QtWidgets.QGraphicsScene.clear(self)",
    "PySide2.QtWidgets.QGraphicsScene.clearFocus(self)",
    "PySide2.QtWidgets.QGraphicsScene.clearSelection(self)",
    "PySide2.QtWidgets.QGraphicsScene.collidingItems(self,item:PySide2.QtWidgets.QGraphicsItem,mode:PySide2.QtCore.Qt.ItemSelectionMode=Qt.IntersectsItemShape)->QList[PySide2.QtWidgets.QGraphicsItem]",
    "PySide2.QtWidgets.QGraphicsScene.contextMenuEvent(self,event:PySide2.QtWidgets.QGraphicsSceneContextMenuEvent)",
    "PySide2.QtWidgets.QGraphicsScene.createItemGroup(self,items:QList[PySide2.QtWidgets.QGraphicsItem])->PySide2.QtWidgets.QGraphicsItemGroup",
    "PySide2.QtWidgets.QGraphicsScene.destroyItemGroup(self,group:PySide2.QtWidgets.QGraphicsItemGroup)",
    "PySide2.QtWidgets.QGraphicsScene.dragEnterEvent(self,event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent)",
    "PySide2.QtWidgets.QGraphicsScene.dragLeaveEvent(self,event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent)",
    "PySide2.QtWidgets.QGraphicsScene.dragMoveEvent(self,event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent)",
    "PySide2.QtWidgets.QGraphicsScene.drawBackground(self,painter:PySide2.QtGui.QPainter,rect:PySide2.QtCore.QRectF)",
    "PySide2.QtWidgets.QGraphicsScene.drawForeground(self,painter:PySide2.QtGui.QPainter,rect:PySide2.QtCore.QRectF)",
    "PySide2.QtWidgets.QGraphicsScene.dropEvent(self,event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent)",
    "PySide2.QtWidgets.QGraphicsScene.event(self,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QGraphicsScene.eventFilter(self,watched:PySide2.QtCore.QObject,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QGraphicsScene.focusInEvent(self,event:PySide2.QtGui.QFocusEvent)",
    "PySide2.QtWidgets.QGraphicsScene.focusItem(self)->PySide2.QtWidgets.QGraphicsItem",
    "PySide2.QtWidgets.QGraphicsScene.focusNextPrevChild(self,next:bool)->bool",
    "PySide2.QtWidgets.QGraphicsScene.focusOnTouch(self)->bool",
    "PySide2.QtWidgets.QGraphicsScene.focusOutEvent(self,event:PySide2.QtGui.QFocusEvent)",
    "PySide2.QtWidgets.QGraphicsScene.font(self)->PySide2.QtGui.QFont",
    "PySide2.QtWidgets.QGraphicsScene.foregroundBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtWidgets.QGraphicsScene.hasFocus(self)->bool",
    "PySide2.QtWidgets.QGraphicsScene.height(self)->qreal",
    "PySide2.QtWidgets.QGraphicsScene.helpEvent(self,event:PySide2.QtWidgets.QGraphicsSceneHelpEvent)",
    "PySide2.QtWidgets.QGraphicsScene.inputMethodEvent(self,event:PySide2.QtGui.QInputMethodEvent)",
    "PySide2.QtWidgets.QGraphicsScene.inputMethodQuery(self,query:PySide2.QtCore.Qt.InputMethodQuery)->QVariant",
    "1:PySide2.QtWidgets.QGraphicsScene.invalidate(self,rect:PySide2.QtCore.QRectF=QRectF(),layers:PySide2.QtWidgets.QGraphicsScene.SceneLayers=QGraphicsScene.AllLayers)",
    "0:PySide2.QtWidgets.QGraphicsScene.invalidate(self,x:qreal,y:qreal,w:qreal,h:qreal,layers:PySide2.QtWidgets.QGraphicsScene.SceneLayers=QGraphicsScene.AllLayers)",
    "PySide2.QtWidgets.QGraphicsScene.isActive(self)->bool",
    "PySide2.QtWidgets.QGraphicsScene.isSortCacheEnabled(self)->bool",
    "1:PySide2.QtWidgets.QGraphicsScene.itemAt(self,pos:PySide2.QtCore.QPointF,deviceTransform:PySide2.QtGui.QTransform)->PySide2.QtWidgets.QGraphicsItem",
    "0:PySide2.QtWidgets.QGraphicsScene.itemAt(self,x:qreal,y:qreal,deviceTransform:PySide2.QtGui.QTransform)->PySide2.QtWidgets.QGraphicsItem",
    "PySide2.QtWidgets.QGraphicsScene.itemIndexMethod(self)->PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod",
    "5:PySide2.QtWidgets.QGraphicsScene.items(self,order:PySide2.QtCore.Qt.SortOrder=Qt.DescendingOrder)->QList[PySide2.QtWidgets.QGraphicsItem]",
    "4:PySide2.QtWidgets.QGraphicsScene.items(self,path:PySide2.QtGui.QPainterPath,mode:PySide2.QtCore.Qt.ItemSelectionMode=Qt.IntersectsItemShape,order:PySide2.QtCore.Qt.SortOrder=Qt.DescendingOrder,deviceTransform:PySide2.QtGui.QTransform=QTransform())->QList[PySide2.QtWidgets.QGraphicsItem]",
    "3:PySide2.QtWidgets.QGraphicsScene.items(self,pos:PySide2.QtCore.QPointF,mode:PySide2.QtCore.Qt.ItemSelectionMode=Qt.IntersectsItemShape,order:PySide2.QtCore.Qt.SortOrder=Qt.DescendingOrder,deviceTransform:PySide2.QtGui.QTransform=QTransform())->QList[PySide2.QtWidgets.QGraphicsItem]",
    "2:PySide2.QtWidgets.QGraphicsScene.items(self,polygon:PySide2.QtGui.QPolygonF,mode:PySide2.QtCore.Qt.ItemSelectionMode=Qt.IntersectsItemShape,order:PySide2.QtCore.Qt.SortOrder=Qt.DescendingOrder,deviceTransform:PySide2.QtGui.QTransform=QTransform())->QList[PySide2.QtWidgets.QGraphicsItem]",
    "1:PySide2.QtWidgets.QGraphicsScene.items(self,rect:PySide2.QtCore.QRectF,mode:PySide2.QtCore.Qt.ItemSelectionMode=Qt.IntersectsItemShape,order:PySide2.QtCore.Qt.SortOrder=Qt.DescendingOrder,deviceTransform:PySide2.QtGui.QTransform=QTransform())->QList[PySide2.QtWidgets.QGraphicsItem]",
    "0:PySide2.QtWidgets.QGraphicsScene.items(self,x:qreal,y:qreal,w:qreal,h:qreal,mode:PySide2.QtCore.Qt.ItemSelectionMode,order:PySide2.QtCore.Qt.SortOrder,deviceTransform:PySide2.QtGui.QTransform=QTransform())->QList[PySide2.QtWidgets.QGraphicsItem]",
    "PySide2.QtWidgets.QGraphicsScene.itemsBoundingRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtWidgets.QGraphicsScene.keyPressEvent(self,event:PySide2.QtGui.QKeyEvent)",
    "PySide2.QtWidgets.QGraphicsScene.keyReleaseEvent(self,event:PySide2.QtGui.QKeyEvent)",
    "PySide2.QtWidgets.QGraphicsScene.minimumRenderSize(self)->qreal",
    "PySide2.QtWidgets.QGraphicsScene.mouseDoubleClickEvent(self,event:PySide2.QtWidgets.QGraphicsSceneMouseEvent)",
    "PySide2.QtWidgets.QGraphicsScene.mouseGrabberItem(self)->PySide2.QtWidgets.QGraphicsItem",
    "PySide2.QtWidgets.QGraphicsScene.mouseMoveEvent(self,event:PySide2.QtWidgets.QGraphicsSceneMouseEvent)",
    "PySide2.QtWidgets.QGraphicsScene.mousePressEvent(self,event:PySide2.QtWidgets.QGraphicsSceneMouseEvent)",
    "PySide2.QtWidgets.QGraphicsScene.mouseReleaseEvent(self,event:PySide2.QtWidgets.QGraphicsSceneMouseEvent)",
    "PySide2.QtWidgets.QGraphicsScene.palette(self)->PySide2.QtGui.QPalette",
    "PySide2.QtWidgets.QGraphicsScene.removeItem(self,item:PySide2.QtWidgets.QGraphicsItem)",
    "PySide2.QtWidgets.QGraphicsScene.render(self,painter:PySide2.QtGui.QPainter,target:PySide2.QtCore.QRectF=QRectF(),source:PySide2.QtCore.QRectF=QRectF(),aspectRatioMode:PySide2.QtCore.Qt.AspectRatioMode=Qt.KeepAspectRatio)",
    "PySide2.QtWidgets.QGraphicsScene.sceneRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtWidgets.QGraphicsScene.selectedItems(self)->QList[PySide2.QtWidgets.QGraphicsItem]",
    "PySide2.QtWidgets.QGraphicsScene.selectionArea(self)->PySide2.QtGui.QPainterPath",
    "PySide2.QtWidgets.QGraphicsScene.sendEvent(self,item:PySide2.QtWidgets.QGraphicsItem,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QGraphicsScene.setActivePanel(self,item:PySide2.QtWidgets.QGraphicsItem)",
    "PySide2.QtWidgets.QGraphicsScene.setActiveWindow(self,widget:PySide2.QtWidgets.QGraphicsWidget)",
    "PySide2.QtWidgets.QGraphicsScene.setBackgroundBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtWidgets.QGraphicsScene.setBspTreeDepth(self,depth:int)",
    "PySide2.QtWidgets.QGraphicsScene.setFocus(self,focusReason:PySide2.QtCore.Qt.FocusReason=Qt.OtherFocusReason)",
    "PySide2.QtWidgets.QGraphicsScene.setFocusItem(self,item:PySide2.QtWidgets.QGraphicsItem,focusReason:PySide2.QtCore.Qt.FocusReason=Qt.OtherFocusReason)",
    "PySide2.QtWidgets.QGraphicsScene.setFocusOnTouch(self,enabled:bool)",
    "PySide2.QtWidgets.QGraphicsScene.setFont(self,font:PySide2.QtGui.QFont)",
    "PySide2.QtWidgets.QGraphicsScene.setForegroundBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtWidgets.QGraphicsScene.setItemIndexMethod(self,method:PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod)",
    "PySide2.QtWidgets.QGraphicsScene.setMinimumRenderSize(self,minSize:qreal)",
    "PySide2.QtWidgets.QGraphicsScene.setPalette(self,palette:PySide2.QtGui.QPalette)",
    "1:PySide2.QtWidgets.QGraphicsScene.setSceneRect(self,rect:PySide2.QtCore.QRectF)",
    "0:PySide2.QtWidgets.QGraphicsScene.setSceneRect(self,x:qreal,y:qreal,w:qreal,h:qreal)",
    "2:PySide2.QtWidgets.QGraphicsScene.setSelectionArea(self,path:PySide2.QtGui.QPainterPath,mode:PySide2.QtCore.Qt.ItemSelectionMode=Qt.IntersectsItemShape,deviceTransform:PySide2.QtGui.QTransform=QTransform())",
    "1:PySide2.QtWidgets.QGraphicsScene.setSelectionArea(self,path:PySide2.QtGui.QPainterPath,selectionOperation:PySide2.QtCore.Qt.ItemSelectionOperation,mode:PySide2.QtCore.Qt.ItemSelectionMode=Qt.IntersectsItemShape,deviceTransform:PySide2.QtGui.QTransform=QTransform())",
    "0:PySide2.QtWidgets.QGraphicsScene.setSelectionArea(self,path:PySide2.QtGui.QPainterPath,deviceTransform:PySide2.QtGui.QTransform)",
    "PySide2.QtWidgets.QGraphicsScene.setSortCacheEnabled(self,enabled:bool)",
    "PySide2.QtWidgets.QGraphicsScene.setStickyFocus(self,enabled:bool)",
    "PySide2.QtWidgets.QGraphicsScene.setStyle(self,style:PySide2.QtWidgets.QStyle)",
    "PySide2.QtWidgets.QGraphicsScene.stickyFocus(self)->bool",
    "PySide2.QtWidgets.QGraphicsScene.style(self)->PySide2.QtWidgets.QStyle",
    "1:PySide2.QtWidgets.QGraphicsScene.update(self,rect:PySide2.QtCore.QRectF=QRectF())",
    "0:PySide2.QtWidgets.QGraphicsScene.update(self,x:qreal,y:qreal,w:qreal,h:qreal)",
    "PySide2.QtWidgets.QGraphicsScene.views(self)->QList[PySide2.QtWidgets.QGraphicsView]",
    "PySide2.QtWidgets.QGraphicsScene.wheelEvent(self,event:PySide2.QtWidgets.QGraphicsSceneWheelEvent)",
    "PySide2.QtWidgets.QGraphicsScene.width(self)->qreal",
    nullptr}; // Sentinel

void init_QGraphicsScene(PyObject *module)
{
    _Sbk_QGraphicsScene_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGraphicsScene",
        "QGraphicsScene*",
        &Sbk_QGraphicsScene_spec,
        &Shiboken::callCppDestructor< ::QGraphicsScene >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsScene_Type);
    InitSignatureStrings(pyType, QGraphicsScene_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsScene_Type), Sbk_QGraphicsScene_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsScene_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGraphicsScene_TypeF(),
        QGraphicsScene_PythonToCpp_QGraphicsScene_PTR,
        is_QGraphicsScene_PythonToCpp_QGraphicsScene_PTR_Convertible,
        QGraphicsScene_PTR_CppToPython_QGraphicsScene);

    Shiboken::Conversions::registerConverterName(converter, "QGraphicsScene");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsScene*");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsScene&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsScene).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsSceneWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGraphicsScene_TypeF(), &Sbk_QGraphicsScene_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ItemIndexMethod'.
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGraphicsScene_TypeF(),
        "ItemIndexMethod",
        "2:PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod",
        "QGraphicsScene::ItemIndexMethod");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX],
        Sbk_QGraphicsScene_TypeF(), "BspTreeIndex", (long) QGraphicsScene::ItemIndexMethod::BspTreeIndex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX],
        Sbk_QGraphicsScene_TypeF(), "NoIndex", (long) QGraphicsScene::ItemIndexMethod::NoIndex))
        return;
    // Register converter for enum 'QGraphicsScene::ItemIndexMethod'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX],
            QGraphicsScene_ItemIndexMethod_CppToPython_QGraphicsScene_ItemIndexMethod);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGraphicsScene_ItemIndexMethod_PythonToCpp_QGraphicsScene_ItemIndexMethod,
            is_QGraphicsScene_ItemIndexMethod_PythonToCpp_QGraphicsScene_ItemIndexMethod_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsScene::ItemIndexMethod");
        Shiboken::Conversions::registerConverterName(converter, "ItemIndexMethod");
    }
    // End of 'ItemIndexMethod' enum.

    // Initialization of enum 'SceneLayer'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QGraphicsScene.SceneLayers", SbkPySide2_QtWidgets_QGraphicsScene_SceneLayer_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGraphicsScene_TypeF(),
        "SceneLayer",
        "2:PySide2.QtWidgets.QGraphicsScene.SceneLayer",
        "QGraphicsScene::SceneLayer",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX],
        Sbk_QGraphicsScene_TypeF(), "ItemLayer", (long) QGraphicsScene::SceneLayer::ItemLayer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX],
        Sbk_QGraphicsScene_TypeF(), "BackgroundLayer", (long) QGraphicsScene::SceneLayer::BackgroundLayer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX],
        Sbk_QGraphicsScene_TypeF(), "ForegroundLayer", (long) QGraphicsScene::SceneLayer::ForegroundLayer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX],
        Sbk_QGraphicsScene_TypeF(), "AllLayers", (long) QGraphicsScene::SceneLayer::AllLayers))
        return;
    // Register converter for enum 'QGraphicsScene::SceneLayer'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX],
            QGraphicsScene_SceneLayer_CppToPython_QGraphicsScene_SceneLayer);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGraphicsScene_SceneLayer_PythonToCpp_QGraphicsScene_SceneLayer,
            is_QGraphicsScene_SceneLayer_PythonToCpp_QGraphicsScene_SceneLayer_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsScene::SceneLayer");
        Shiboken::Conversions::registerConverterName(converter, "SceneLayer");
    }
    // Register converter for flag 'QFlags<QGraphicsScene::SceneLayer>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX],
            QFlags_QGraphicsScene_SceneLayer__CppToPython_QFlags_QGraphicsScene_SceneLayer_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGraphicsScene_SceneLayer_PythonToCpp_QFlags_QGraphicsScene_SceneLayer_,
            is_QGraphicsScene_SceneLayer_PythonToCpp_QFlags_QGraphicsScene_SceneLayer__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGraphicsScene_SceneLayer__PythonToCpp_QFlags_QGraphicsScene_SceneLayer_,
            is_QFlags_QGraphicsScene_SceneLayer__PythonToCpp_QFlags_QGraphicsScene_SceneLayer__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGraphicsScene_SceneLayer_,
            is_number_PythonToCpp_QFlags_QGraphicsScene_SceneLayer__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsScene::SceneLayers");
        Shiboken::Conversions::registerConverterName(converter, "SceneLayers");
    }
    // End of 'SceneLayer' enum/flags.

    PySide::Signal::registerSignals(Sbk_QGraphicsScene_TypeF(), &::QGraphicsScene::staticMetaObject);
    qRegisterMetaType< ::QGraphicsScene::ItemIndexMethod >("QGraphicsScene::ItemIndexMethod");
    qRegisterMetaType< ::QGraphicsScene::SceneLayer >("QGraphicsScene::SceneLayer");
    qRegisterMetaType< ::QGraphicsScene::SceneLayers >("QGraphicsScene::SceneLayers");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGraphicsScene_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGraphicsScene_TypeF(), &::QGraphicsScene::staticMetaObject, sizeof(QGraphicsSceneWrapper));
}
