/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QHEADERVIEWWRAPPER_H
#define SBK_QHEADERVIEWWRAPPER_H

#define protected public

#include <QtWidgets/qheaderview.h>


// Extra includes
#include <qobject.h>
#include <QtWidgets/qwidget.h>
#include <qabstractitemmodel.h>
#include <qsize.h>
#include <qpoint.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <QtGui/qevent.h>
#include <QtGui/qpainter.h>
#include <qrect.h>
#include <QVector>
#include <QtGui/qregion.h>
#include <QList>
#include <QtWidgets/qstyleoption.h>
#include <QtGui/qpaintengine.h>
#include <QtWidgets/qabstractitemdelegate.h>
#include <qobjectdefs.h>
#include <qmetaobject.h>
#include <QtGui/qpaintdevice.h>
#include <qitemselectionmodel.h>
namespace PySide { class DynamicQMetaObject; }

class QHeaderViewWrapper : public QHeaderView
{
public:
    QHeaderViewWrapper(::Qt::Orientation orientation, ::QWidget * parent = nullptr);
    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * arg__1) override;
    void childEvent(::QChildEvent * event) override;
    void closeEditor(::QWidget * editor, ::QAbstractItemDelegate::EndEditHint hint) override;
    void closeEvent(::QCloseEvent * event) override;
    void commitData(::QWidget * editor) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * arg__1) override;
    void currentChanged(const ::QModelIndex & current, const ::QModelIndex & old) override;
    void customEvent(::QEvent * event) override;
    void dataChanged(const ::QModelIndex & topLeft, const ::QModelIndex & bottomRight, const ::QVector<int > & roles = QVector< int >()) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void doItemsLayout() override;
    void dragEnterEvent(::QDragEnterEvent * event) override;
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    void dragMoveEvent(::QDragMoveEvent * event) override;
    void dropEvent(::QDropEvent * event) override;
    bool edit(const ::QModelIndex & index, ::QAbstractItemView::EditTrigger trigger, ::QEvent * event) override;
    void editorDestroyed(::QObject * editor) override;
    void enterEvent(::QEvent * event) override;
    bool event(::QEvent * e) override;
    bool eventFilter(::QObject * object, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * event) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * event) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * event) override;
    int horizontalOffset() const override;
    void horizontalScrollbarAction(int action) override;
    void horizontalScrollbarValueChanged(int value) override;
    ::QModelIndex indexAt(const ::QPoint & p) const override;
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery query) const override;
    bool isIndexHidden(const ::QModelIndex & index) const override;
    void keyPressEvent(::QKeyEvent * event) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    void keyboardSearch(const ::QString & search) override;
    void leaveEvent(::QEvent * event) override;
    const ::QMetaObject * metaObject() const override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * e) override;
    void mouseMoveEvent(::QMouseEvent * e) override;
    void mousePressEvent(::QMouseEvent * e) override;
    void mouseReleaseEvent(::QMouseEvent * e) override;
    ::QModelIndex moveCursor(::QAbstractItemView::CursorAction arg__1, ::QFlags<Qt::KeyboardModifier> arg__2) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, long * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * e) override;
    void paintSection(::QPainter * painter, const ::QRect & rect, int logicalIndex) const override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void reset() override;
    void resizeEvent(::QResizeEvent * event) override;
    void rowsAboutToBeRemoved(const ::QModelIndex & parent, int start, int end) override;
    void rowsInserted(const ::QModelIndex & parent, int start, int end) override;
    void scrollContentsBy(int dx, int dy) override;
    void scrollTo(const ::QModelIndex & index, ::QAbstractItemView::ScrollHint hint) override;
    ::QSize sectionSizeFromContents(int logicalIndex) const override;
    void selectAll() override;
    ::QModelIndexList selectedIndexes() const override;
    void selectionChanged(const ::QItemSelection & selected, const ::QItemSelection & deselected) override;
    ::QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const ::QModelIndex & index, const ::QEvent * event = nullptr) const override;
    void setModel(::QAbstractItemModel * model) override;
    void setRootIndex(const ::QModelIndex & index) override;
    void setSelection(const ::QRect & rect, ::QFlags<QItemSelectionModel::SelectionFlag> flags) override;
    void setSelectionModel(::QItemSelectionModel * selectionModel) override;
    void setVisible(bool v) override;
    void setupViewport(::QWidget * viewport) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * event) override;
    ::QSize sizeHint() const override;
    int sizeHintForColumn(int column) const override;
    int sizeHintForRow(int row) const override;
    void startDrag(::QFlags<Qt::DropAction> supportedActions) override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;
    void updateEditorData() override;
    void updateEditorGeometries() override;
    void updateGeometries() override;
    int verticalOffset() const override;
    void verticalScrollbarAction(int action) override;
    void verticalScrollbarValueChanged(int value) override;
    ::QStyleOptionViewItem viewOptions() const override;
    bool viewportEvent(::QEvent * e) override;
    ::QSize viewportSizeHint() const override;
    ::QRect visualRect(const ::QModelIndex & index) const override;
    ::QRegion visualRegionForSelection(const ::QItemSelection & selection) const override;
    void wheelEvent(::QWheelEvent * arg__1) override;
    ~QHeaderViewWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    // Inherited overloads, because the using keyword sux
    inline void edit(const ::QModelIndex & index) { QHeaderView::edit(index); }
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[92];
};

#endif // SBK_QHEADERVIEWWRAPPER_H

