/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qscroller_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtWidgets/qscroller.h>
#include <QtWidgets/qscrollerproperties.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>
#include <qrect.h>
#include <qthread.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QScrollerFunc_activeScrollers(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.activeScrollers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeScrollers()
            QList<QScroller* > cppResult = ::QScroller::activeScrollers();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSCROLLERPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScrollerFunc_ensureVisible(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.ensureVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "ensureVisible", 3, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QScroller::ensureVisible(QRectF,qreal,qreal)
    // 1: QScroller::ensureVisible(QRectF,qreal,qreal,int)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // ensureVisible(QRectF,qreal,qreal)
        } else if (numArgs == 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 1; // ensureVisible(QRectF,qreal,qreal,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_ensureVisible_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // ensureVisible(const QRectF & rect, qreal xmargin, qreal ymargin)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // ensureVisible(QRectF,qreal,qreal)
                cppSelf->ensureVisible(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // ensureVisible(const QRectF & rect, qreal xmargin, qreal ymargin, int scrollTime)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // ensureVisible(QRectF,qreal,qreal,int)
                cppSelf->ensureVisible(*cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScrollerFunc_ensureVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_finalPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.finalPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // finalPosition()const
            QPointF cppResult = const_cast<const ::QScroller *>(cppSelf)->finalPosition();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScrollerFunc_grabGesture(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.grabGesture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScrollerFunc_grabGesture_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScrollerFunc_grabGesture_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:grabGesture", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QScroller::grabGesture(QObject*,QScroller::ScrollerGestureType)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // grabGesture(QObject*,QScroller::ScrollerGestureType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // grabGesture(QObject*,QScroller::ScrollerGestureType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_grabGesture_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_gestureType = Shiboken::String::createStaticString("gestureType");
            if (PyDict_Contains(kwds, key_gestureType)) {
                value = PyDict_GetItem(kwds, key_gestureType);
                if (value && pyArgs[1]) {
                    errInfo = key_gestureType;
                    Py_INCREF(errInfo);
                    goto Sbk_QScrollerFunc_grabGesture_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QScrollerFunc_grabGesture_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_gestureType);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QScrollerFunc_grabGesture_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QScroller::ScrollerGestureType cppArg1 = QScroller::ScrollerGestureType::TouchGesture;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // grabGesture(QObject*,QScroller::ScrollerGestureType)
            Qt::GestureType cppResult = ::QScroller::grabGesture(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScrollerFunc_grabGesture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_grabbedGesture(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.grabbedGesture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QScroller::grabbedGesture(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // grabbedGesture(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_grabbedGesture_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // grabbedGesture(QObject*)
            Qt::GestureType cppResult = ::QScroller::grabbedGesture(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScrollerFunc_grabbedGesture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_handleInput(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.handleInput";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScrollerFunc_handleInput_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScrollerFunc_handleInput_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:handleInput", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QScroller::handleInput(QScroller::Input,QPointF,qint64)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // handleInput(QScroller::Input,QPointF,qint64)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[2])))) {
            overloadId = 0; // handleInput(QScroller::Input,QPointF,qint64)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_handleInput_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timestamp = Shiboken::String::createStaticString("timestamp");
            if (PyDict_Contains(kwds, key_timestamp)) {
                value = PyDict_GetItem(kwds, key_timestamp);
                if (value && pyArgs[2]) {
                    errInfo = key_timestamp;
                    Py_INCREF(errInfo);
                    goto Sbk_QScrollerFunc_handleInput_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[2]))))
                        goto Sbk_QScrollerFunc_handleInput_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timestamp);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QScrollerFunc_handleInput_TypeError;
            }
        }
        ::QScroller::Input cppArg0 = static_cast< ::QScroller::Input>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPointF cppArg1_local;
        ::QPointF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        qint64 cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // handleInput(QScroller::Input,QPointF,qint64)
            bool cppResult = cppSelf->handleInput(cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScrollerFunc_handleInput_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_hasScroller(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.hasScroller";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QScroller::hasScroller(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // hasScroller(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_hasScroller_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasScroller(QObject*)
            bool cppResult = ::QScroller::hasScroller(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScrollerFunc_hasScroller_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_pixelPerMeter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.pixelPerMeter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelPerMeter()const
            QPointF cppResult = const_cast<const ::QScroller *>(cppSelf)->pixelPerMeter();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScrollerFunc_resendPrepareEvent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.resendPrepareEvent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resendPrepareEvent()
            cppSelf->resendPrepareEvent();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScrollerFunc_scrollTo(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.scrollTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "scrollTo", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScroller::scrollTo(QPointF)
    // 1: QScroller::scrollTo(QPointF,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // scrollTo(QPointF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // scrollTo(QPointF,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_scrollTo_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // scrollTo(const QPointF & pos)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // scrollTo(QPointF)
                cppSelf->scrollTo(*cppArg0);
            }
            break;
        }
        case 1: // scrollTo(const QPointF & pos, int scrollTime)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // scrollTo(QPointF,int)
                cppSelf->scrollTo(*cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScrollerFunc_scrollTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_scroller(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.scroller";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QScroller::scroller(QObject*)
    // 1: static QScroller::scroller(const QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // scroller(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_scroller_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // scroller(QObject * target)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QObject *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // scroller(QObject*)
                QScroller * cppResult = ::QScroller::scroller(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX]), cppResult);
            }
            break;
        }
        case 1: // scroller(const QObject * target)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QObject *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // scroller(const QObject*)
                const QScroller * cppResult = ::QScroller::scroller(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScrollerFunc_scroller_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_scrollerProperties(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.scrollerProperties";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scrollerProperties()const
            QScrollerProperties cppResult = const_cast<const ::QScroller *>(cppSelf)->scrollerProperties();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScrollerFunc_setScrollerProperties(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.setScrollerProperties";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScroller::setScrollerProperties(QScrollerProperties)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), (pyArg)))) {
        overloadId = 0; // setScrollerProperties(QScrollerProperties)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_setScrollerProperties_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScrollerProperties cppArg0_local;
        ::QScrollerProperties *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScrollerProperties(QScrollerProperties)
            cppSelf->setScrollerProperties(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScrollerFunc_setScrollerProperties_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_setSnapPositionsX(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.setSnapPositionsX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSnapPositionsX", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScroller::setSnapPositionsX(QList<qreal>)
    // 1: QScroller::setSnapPositionsX(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // setSnapPositionsX(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QREAL_IDX], (pyArgs[0])))) {
        overloadId = 0; // setSnapPositionsX(QList<qreal>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_setSnapPositionsX_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setSnapPositionsX(const QList<qreal > & positions)
        {
            ::QList<qreal > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setSnapPositionsX(QList<qreal>)
                cppSelf->setSnapPositionsX(cppArg0);
            }
            break;
        }
        case 1: // setSnapPositionsX(qreal first, qreal interval)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setSnapPositionsX(qreal,qreal)
                cppSelf->setSnapPositionsX(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScrollerFunc_setSnapPositionsX_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_setSnapPositionsY(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.setSnapPositionsY";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSnapPositionsY", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScroller::setSnapPositionsY(QList<qreal>)
    // 1: QScroller::setSnapPositionsY(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // setSnapPositionsY(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QREAL_IDX], (pyArgs[0])))) {
        overloadId = 0; // setSnapPositionsY(QList<qreal>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_setSnapPositionsY_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setSnapPositionsY(const QList<qreal > & positions)
        {
            ::QList<qreal > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setSnapPositionsY(QList<qreal>)
                cppSelf->setSnapPositionsY(cppArg0);
            }
            break;
        }
        case 1: // setSnapPositionsY(qreal first, qreal interval)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setSnapPositionsY(qreal,qreal)
                cppSelf->setSnapPositionsY(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScrollerFunc_setSnapPositionsY_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QScroller::State cppResult = const_cast<const ::QScroller *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScrollerFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScrollerFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            QObject * cppResult = const_cast<const ::QScroller *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScrollerFunc_ungrabGesture(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.ungrabGesture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QScroller::ungrabGesture(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // ungrabGesture(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerFunc_ungrabGesture_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // ungrabGesture(QObject*)
            ::QScroller::ungrabGesture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScrollerFunc_ungrabGesture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerFunc_velocity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScroller *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScroller.velocity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // velocity()const
            QPointF cppResult = const_cast<const ::QScroller *>(cppSelf)->velocity();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScroller_PropertyStrings[] = {
    "scrollerProperties::",
    "state:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScroller_methods[] = {
    {"activeScrollers", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_activeScrollers), METH_NOARGS|METH_STATIC},
    {"ensureVisible", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_ensureVisible), METH_VARARGS},
    {"finalPosition", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_finalPosition), METH_NOARGS},
    {"grabGesture", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_grabGesture), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"grabbedGesture", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_grabbedGesture), METH_O|METH_STATIC},
    {"handleInput", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_handleInput), METH_VARARGS|METH_KEYWORDS},
    {"hasScroller", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_hasScroller), METH_O|METH_STATIC},
    {"pixelPerMeter", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_pixelPerMeter), METH_NOARGS},
    {"resendPrepareEvent", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_resendPrepareEvent), METH_NOARGS},
    {"scrollTo", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_scrollTo), METH_VARARGS},
    {"scroller", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_scroller), METH_O|METH_STATIC},
    {"scrollerProperties", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_scrollerProperties), METH_NOARGS},
    {"setScrollerProperties", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_setScrollerProperties), METH_O},
    {"setSnapPositionsX", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_setSnapPositionsX), METH_VARARGS},
    {"setSnapPositionsY", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_setSnapPositionsY), METH_VARARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_state), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_stop), METH_NOARGS},
    {"target", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_target), METH_NOARGS},
    {"ungrabGesture", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_ungrabGesture), METH_O|METH_STATIC},
    {"velocity", reinterpret_cast<PyCFunction>(Sbk_QScrollerFunc_velocity), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScroller_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QScroller_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScroller_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScroller_Type = nullptr;
static SbkObjectType *Sbk_QScroller_TypeF(void)
{
    return _Sbk_QScroller_Type;
}

static PyType_Slot Sbk_QScroller_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScroller_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScroller_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScroller_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScroller_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScroller_spec = {
    "2:PySide2.QtWidgets.QScroller",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScroller_slots
};

} //extern "C"

static void *Sbk_QScroller_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QScroller *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QScroller_State_PythonToCpp_QScroller_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScroller::State *>(cppOut) =
        static_cast<::QScroller::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScroller_State_PythonToCpp_QScroller_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX]))
        return QScroller_State_PythonToCpp_QScroller_State;
    return {};
}
static PyObject *QScroller_State_CppToPython_QScroller_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScroller::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX], castCppIn);

}

static void QScroller_ScrollerGestureType_PythonToCpp_QScroller_ScrollerGestureType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScroller::ScrollerGestureType *>(cppOut) =
        static_cast<::QScroller::ScrollerGestureType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScroller_ScrollerGestureType_PythonToCpp_QScroller_ScrollerGestureType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX]))
        return QScroller_ScrollerGestureType_PythonToCpp_QScroller_ScrollerGestureType;
    return {};
}
static PyObject *QScroller_ScrollerGestureType_CppToPython_QScroller_ScrollerGestureType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScroller::ScrollerGestureType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX], castCppIn);

}

static void QScroller_Input_PythonToCpp_QScroller_Input(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScroller::Input *>(cppOut) =
        static_cast<::QScroller::Input>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScroller_Input_PythonToCpp_QScroller_Input_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX]))
        return QScroller_Input_PythonToCpp_QScroller_Input;
    return {};
}
static PyObject *QScroller_Input_CppToPython_QScroller_Input(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScroller::Input *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScroller_PythonToCpp_QScroller_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScroller_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScroller_PythonToCpp_QScroller_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScroller_TypeF())))
        return QScroller_PythonToCpp_QScroller_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScroller_PTR_CppToPython_QScroller(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QScroller *>(const_cast<void *>(cppIn)), Sbk_QScroller_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScroller_SignatureStrings[] = {
    "PySide2.QtWidgets.QScroller.activeScrollers()->QList[PySide2.QtWidgets.QScroller]",
    "1:PySide2.QtWidgets.QScroller.ensureVisible(self,rect:PySide2.QtCore.QRectF,xmargin:qreal,ymargin:qreal)",
    "0:PySide2.QtWidgets.QScroller.ensureVisible(self,rect:PySide2.QtCore.QRectF,xmargin:qreal,ymargin:qreal,scrollTime:int)",
    "PySide2.QtWidgets.QScroller.finalPosition(self)->PySide2.QtCore.QPointF",
    "PySide2.QtWidgets.QScroller.grabGesture(target:PySide2.QtCore.QObject,gestureType:PySide2.QtWidgets.QScroller.ScrollerGestureType=TouchGesture)->PySide2.QtCore.Qt.GestureType",
    "PySide2.QtWidgets.QScroller.grabbedGesture(target:PySide2.QtCore.QObject)->PySide2.QtCore.Qt.GestureType",
    "PySide2.QtWidgets.QScroller.handleInput(self,input:PySide2.QtWidgets.QScroller.Input,position:PySide2.QtCore.QPointF,timestamp:qint64=0)->bool",
    "PySide2.QtWidgets.QScroller.hasScroller(target:PySide2.QtCore.QObject)->bool",
    "PySide2.QtWidgets.QScroller.pixelPerMeter(self)->PySide2.QtCore.QPointF",
    "PySide2.QtWidgets.QScroller.resendPrepareEvent(self)",
    "1:PySide2.QtWidgets.QScroller.scrollTo(self,pos:PySide2.QtCore.QPointF)",
    "0:PySide2.QtWidgets.QScroller.scrollTo(self,pos:PySide2.QtCore.QPointF,scrollTime:int)",
    "1:PySide2.QtWidgets.QScroller.scroller(target:PySide2.QtCore.QObject)->PySide2.QtWidgets.QScroller",
    "0:PySide2.QtWidgets.QScroller.scroller(target:PySide2.QtCore.QObject)->PySide2.QtWidgets.QScroller",
    "PySide2.QtWidgets.QScroller.scrollerProperties(self)->PySide2.QtWidgets.QScrollerProperties",
    "PySide2.QtWidgets.QScroller.setScrollerProperties(self,prop:PySide2.QtWidgets.QScrollerProperties)",
    "1:PySide2.QtWidgets.QScroller.setSnapPositionsX(self,positions:QList[qreal])",
    "0:PySide2.QtWidgets.QScroller.setSnapPositionsX(self,first:qreal,interval:qreal)",
    "1:PySide2.QtWidgets.QScroller.setSnapPositionsY(self,positions:QList[qreal])",
    "0:PySide2.QtWidgets.QScroller.setSnapPositionsY(self,first:qreal,interval:qreal)",
    "PySide2.QtWidgets.QScroller.state(self)->PySide2.QtWidgets.QScroller.State",
    "PySide2.QtWidgets.QScroller.stop(self)",
    "PySide2.QtWidgets.QScroller.target(self)->PySide2.QtCore.QObject",
    "PySide2.QtWidgets.QScroller.ungrabGesture(target:PySide2.QtCore.QObject)",
    "PySide2.QtWidgets.QScroller.velocity(self)->PySide2.QtCore.QPointF",
    nullptr}; // Sentinel

void init_QScroller(PyObject *module)
{
    _Sbk_QScroller_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScroller",
        "QScroller*",
        &Sbk_QScroller_spec,
        0,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScroller_Type);
    InitSignatureStrings(pyType, QScroller_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScroller_Type), Sbk_QScroller_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScroller_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScroller_TypeF(),
        QScroller_PythonToCpp_QScroller_PTR,
        is_QScroller_PythonToCpp_QScroller_PTR_Convertible,
        QScroller_PTR_CppToPython_QScroller);

    Shiboken::Conversions::registerConverterName(converter, "QScroller");
    Shiboken::Conversions::registerConverterName(converter, "QScroller*");
    Shiboken::Conversions::registerConverterName(converter, "QScroller&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScroller).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QScroller_TypeF(), &Sbk_QScroller_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'State'.
    SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScroller_TypeF(),
        "State",
        "2:PySide2.QtWidgets.QScroller.State",
        "QScroller::State");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX],
        Sbk_QScroller_TypeF(), "Inactive", (long) QScroller::State::Inactive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX],
        Sbk_QScroller_TypeF(), "Pressed", (long) QScroller::State::Pressed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX],
        Sbk_QScroller_TypeF(), "Dragging", (long) QScroller::State::Dragging))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX],
        Sbk_QScroller_TypeF(), "Scrolling", (long) QScroller::State::Scrolling))
        return;
    // Register converter for enum 'QScroller::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX],
            QScroller_State_CppToPython_QScroller_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScroller_State_PythonToCpp_QScroller_State,
            is_QScroller_State_PythonToCpp_QScroller_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScroller::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'ScrollerGestureType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScroller_TypeF(),
        "ScrollerGestureType",
        "2:PySide2.QtWidgets.QScroller.ScrollerGestureType",
        "QScroller::ScrollerGestureType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX],
        Sbk_QScroller_TypeF(), "TouchGesture", (long) QScroller::ScrollerGestureType::TouchGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX],
        Sbk_QScroller_TypeF(), "LeftMouseButtonGesture", (long) QScroller::ScrollerGestureType::LeftMouseButtonGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX],
        Sbk_QScroller_TypeF(), "RightMouseButtonGesture", (long) QScroller::ScrollerGestureType::RightMouseButtonGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX],
        Sbk_QScroller_TypeF(), "MiddleMouseButtonGesture", (long) QScroller::ScrollerGestureType::MiddleMouseButtonGesture))
        return;
    // Register converter for enum 'QScroller::ScrollerGestureType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX],
            QScroller_ScrollerGestureType_CppToPython_QScroller_ScrollerGestureType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScroller_ScrollerGestureType_PythonToCpp_QScroller_ScrollerGestureType,
            is_QScroller_ScrollerGestureType_PythonToCpp_QScroller_ScrollerGestureType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_SCROLLERGESTURETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScroller::ScrollerGestureType");
        Shiboken::Conversions::registerConverterName(converter, "ScrollerGestureType");
    }
    // End of 'ScrollerGestureType' enum.

    // Initialization of enum 'Input'.
    SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScroller_TypeF(),
        "Input",
        "2:PySide2.QtWidgets.QScroller.Input",
        "QScroller::Input");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX],
        Sbk_QScroller_TypeF(), "InputPress", (long) QScroller::Input::InputPress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX],
        Sbk_QScroller_TypeF(), "InputMove", (long) QScroller::Input::InputMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX],
        Sbk_QScroller_TypeF(), "InputRelease", (long) QScroller::Input::InputRelease))
        return;
    // Register converter for enum 'QScroller::Input'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX],
            QScroller_Input_CppToPython_QScroller_Input);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScroller_Input_PythonToCpp_QScroller_Input,
            is_QScroller_Input_PythonToCpp_QScroller_Input_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_INPUT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScroller::Input");
        Shiboken::Conversions::registerConverterName(converter, "Input");
    }
    // End of 'Input' enum.

    PySide::Signal::registerSignals(Sbk_QScroller_TypeF(), &::QScroller::staticMetaObject);
    qRegisterMetaType< ::QScroller::State >("QScroller::State");
    qRegisterMetaType< ::QScroller::ScrollerGestureType >("QScroller::ScrollerGestureType");
    qRegisterMetaType< ::QScroller::Input >("QScroller::Input");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QScroller_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QScroller_TypeF(), &::QScroller::staticMetaObject, sizeof(::QScroller));
}
