/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qshortcut_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QShortcutWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QShortcutWrapper::QShortcutWrapper(::QWidget * parent) : QShortcut(parent)
{
    resetPyMethodCache();
    // ... middle
}

QShortcutWrapper::QShortcutWrapper(const ::QKeySequence & key, ::QWidget * parent, const char * member, const char * ambiguousMember, ::Qt::ShortcutContext shortcutContext) : QShortcut(key, parent, member, ambiguousMember, shortcutContext)
{
    resetPyMethodCache();
    // ... middle
}

void QShortcutWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QShortcutWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QShortcutWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QShortcutWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QShortcutWrapper::event(::QEvent * e)
{
    if (m_PyMethodCache[4])
        return this->::QShortcut::event(e);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QShortcut::event(e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), e)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QShortcut.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QShortcutWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QShortcut.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QShortcutWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QShortcutWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QShortcut::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QShortcutWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QShortcut::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QShortcutWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QShortcutWrapper *>(this));
        return QShortcut::qt_metacast(_clname);
}

QShortcutWrapper::~QShortcutWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QShortcut_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QShortcut >()))
        return -1;

    ::QShortcutWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QShortcut_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:QShortcut", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QShortcut::QShortcut(QKeySequence&,QWidget*,PyCallable*,Qt::ShortcutContext)
    // 1: QShortcut::QShortcut(QWidget*)
    // 2: QShortcut::QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QShortcut(QWidget*)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
        } else if (numArgs >= 3
            && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 2; // QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
            } else if (numArgs >= 4
                && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 2; // QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])->converter, (pyArgs[4])))) {
                    overloadId = 2; // QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
                }
            }
        } else if (numArgs >= 3
            && PyCallable_Check(pyArgs[2])) {
            if (numArgs == 3) {
                overloadId = 0; // QShortcut(QKeySequence&,QWidget*,PyCallable*,Qt::ShortcutContext)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])->converter, (pyArgs[3])))) {
                overloadId = 0; // QShortcut(QKeySequence&,QWidget*,PyCallable*,Qt::ShortcutContext)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QShortcut_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QShortcut(QKeySequence & arg__1, QWidget * arg__2, PyCallable * arg__3, Qt::ShortcutContext arg__4)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_arg__4 = Shiboken::String::createStaticString("arg__4");
                if (PyDict_Contains(kwds, key_arg__4)) {
                    value = PyDict_GetItem(kwds, key_arg__4);
                    if (value && pyArgs[3]) {
                        errInfo = key_arg__4;
                        Py_INCREF(errInfo);
                        goto Sbk_QShortcut_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QShortcut_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_arg__4);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QKeySequence cppArg0_local;
            ::QKeySequence *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            SBK_UNUSED(cppArg0)
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)
            ::Qt::ShortcutContext cppArg3 = Qt::WindowShortcut;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            SBK_UNUSED(cppArg3)

            if (!PyErr_Occurred()) {
                // QShortcut(QKeySequence&,QWidget*,PyCallable*,Qt::ShortcutContext)
                overloadId = 0;
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwidgets.cpp (qshortcut-1)]
                cptr = new QShortcutWrapper(*cppArg0, cppArg1);
                // END of custom code block [file: ../glue/qtwidgets.cpp (qshortcut-1)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // QShortcut(QWidget * parent)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QShortcut_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QShortcut(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QShortcutWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QShortcutWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 2: // QShortcut(const QKeySequence & key, QWidget * parent, const char * member, const char * ambiguousMember, Qt::ShortcutContext shortcutContext)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_member = Shiboken::String::createStaticString("member");
                if (PyDict_Contains(kwds, key_member)) {
                    value = PyDict_GetItem(kwds, key_member);
                    if (value && pyArgs[2]) {
                        errInfo = key_member;
                        Py_INCREF(errInfo);
                        goto Sbk_QShortcut_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2]))))
                            goto Sbk_QShortcut_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_member);
                }
                static PyObject *const key_ambiguousMember = Shiboken::String::createStaticString("ambiguousMember");
                if (PyDict_Contains(kwds, key_ambiguousMember)) {
                    value = PyDict_GetItem(kwds, key_ambiguousMember);
                    if (value && pyArgs[3]) {
                        errInfo = key_ambiguousMember;
                        Py_INCREF(errInfo);
                        goto Sbk_QShortcut_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3]))))
                            goto Sbk_QShortcut_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_ambiguousMember);
                }
                static PyObject *const key_shortcutContext = Shiboken::String::createStaticString("shortcutContext");
                if (PyDict_Contains(kwds, key_shortcutContext)) {
                    value = PyDict_GetItem(kwds, key_shortcutContext);
                    if (value && pyArgs[4]) {
                        errInfo = key_shortcutContext;
                        Py_INCREF(errInfo);
                        goto Sbk_QShortcut_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])->converter, (pyArgs[4]))))
                            goto Sbk_QShortcut_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_shortcutContext);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QKeySequence cppArg0_local;
            ::QKeySequence *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            const char* cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            const char* cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            ::Qt::ShortcutContext cppArg4 = Qt::WindowShortcut;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QShortcutWrapper(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QShortcutWrapper(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QShortcut >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QShortcut_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QShortcut_Init_TypeError;
        Py_DECREF(errInfo);
    };
    switch (overloadId) {
        case 0:
        {
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qshortcut-2)]
            Shiboken::AutoDecRef result(PyObject_CallMethod(self,
                const_cast<char *>("connect"),
                const_cast<char *>("OsO"),
                self, SIGNAL(activated()), pyArgs[3-1])
            );
            if (!result.isNull())
                Shiboken::Object::setParent(pyArgs[2-1], self);
            // END of custom code block [file: ../glue/qtwidgets.cpp (qshortcut-2)]
            // ========================================================================

            // End of code injection

        }
        break;
}


    return 1;

    Sbk_QShortcut_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QShortcutFunc_autoRepeat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.autoRepeat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoRepeat()const
            bool cppResult = const_cast<const ::QShortcut *>(cppSelf)->autoRepeat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QShortcutFunc_context(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.context";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // context()const
            Qt::ShortcutContext cppResult = const_cast<const ::QShortcut *>(cppSelf)->context();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QShortcutFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QShortcutFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QShortcut::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QShortcutFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QShortcutFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.id";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // id()const
            int cppResult = const_cast<const ::QShortcut *>(cppSelf)->id();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QShortcutFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.isEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEnabled()const
            bool cppResult = const_cast<const ::QShortcut *>(cppSelf)->isEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QShortcutFunc_key(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.key";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // key()const
            QKeySequence cppResult = const_cast<const ::QShortcut *>(cppSelf)->key();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QShortcutFunc_parentWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.parentWidget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentWidget()const
            QWidget * cppResult = const_cast<const ::QShortcut *>(cppSelf)->parentWidget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QShortcutFunc_setAutoRepeat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.setAutoRepeat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShortcut::setAutoRepeat(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoRepeat(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QShortcutFunc_setAutoRepeat_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoRepeat(bool)
            cppSelf->setAutoRepeat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QShortcutFunc_setAutoRepeat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QShortcutFunc_setContext(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.setContext";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShortcut::setContext(Qt::ShortcutContext)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setContext(Qt::ShortcutContext)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QShortcutFunc_setContext_TypeError;

    // Call function/method
    {
        ::Qt::ShortcutContext cppArg0{Qt::WidgetShortcut};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setContext(Qt::ShortcutContext)
            cppSelf->setContext(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QShortcutFunc_setContext_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QShortcutFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.setEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShortcut::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QShortcutFunc_setEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QShortcutFunc_setEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QShortcutFunc_setKey(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.setKey";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShortcut::setKey(QKeySequence)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
        overloadId = 0; // setKey(QKeySequence)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QShortcutFunc_setKey_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeySequence cppArg0_local;
        ::QKeySequence *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setKey(QKeySequence)
            cppSelf->setKey(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QShortcutFunc_setKey_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QShortcutFunc_setWhatsThis(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.setWhatsThis";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShortcut::setWhatsThis(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setWhatsThis(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QShortcutFunc_setWhatsThis_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWhatsThis(QString)
            cppSelf->setWhatsThis(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QShortcutFunc_setWhatsThis_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QShortcutFunc_whatsThis(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QShortcut.whatsThis";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // whatsThis()const
            QString cppResult = const_cast<const ::QShortcut *>(cppSelf)->whatsThis();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QShortcut_PropertyStrings[] = {
    "autoRepeat::",
    "context::",
    "enabled:isEnabled:",
    "key::",
    "whatsThis::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QShortcut_methods[] = {
    {"autoRepeat", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_autoRepeat), METH_NOARGS},
    {"context", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_context), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_event), METH_O},
    {"id", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_id), METH_NOARGS},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_isEnabled), METH_NOARGS},
    {"key", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_key), METH_NOARGS},
    {"parentWidget", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_parentWidget), METH_NOARGS},
    {"setAutoRepeat", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_setAutoRepeat), METH_O},
    {"setContext", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_setContext), METH_O},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_setEnabled), METH_O},
    {"setKey", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_setKey), METH_O},
    {"setWhatsThis", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_setWhatsThis), METH_O},
    {"whatsThis", reinterpret_cast<PyCFunction>(Sbk_QShortcutFunc_whatsThis), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QShortcut_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QShortcut *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QShortcutWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QShortcut_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QShortcut_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QShortcut_Type = nullptr;
static SbkObjectType *Sbk_QShortcut_TypeF(void)
{
    return _Sbk_QShortcut_Type;
}

static PyType_Slot Sbk_QShortcut_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QShortcut_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QShortcut_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QShortcut_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QShortcut_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QShortcut_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QShortcut_spec = {
    "2:PySide2.QtWidgets.QShortcut",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QShortcut_slots
};

} //extern "C"

static void *Sbk_QShortcut_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QShortcut *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QShortcut_PythonToCpp_QShortcut_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QShortcut_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QShortcut_PythonToCpp_QShortcut_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QShortcut_TypeF())))
        return QShortcut_PythonToCpp_QShortcut_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QShortcut_PTR_CppToPython_QShortcut(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QShortcut *>(const_cast<void *>(cppIn)), Sbk_QShortcut_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QShortcut_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QShortcut(self,arg__1:PySide2.QtGui.QKeySequence,arg__2:PySide2.QtWidgets.QWidget,arg__3:PyCallable,arg__4:PySide2.QtCore.Qt.ShortcutContext=Qt.WindowShortcut)",
    "1:PySide2.QtWidgets.QShortcut(self,parent:PySide2.QtWidgets.QWidget)",
    "0:PySide2.QtWidgets.QShortcut(self,key:PySide2.QtGui.QKeySequence,parent:PySide2.QtWidgets.QWidget,member:char*=nullptr,ambiguousMember:char*=nullptr,shortcutContext:PySide2.QtCore.Qt.ShortcutContext=Qt.WindowShortcut)",
    "PySide2.QtWidgets.QShortcut.autoRepeat(self)->bool",
    "PySide2.QtWidgets.QShortcut.context(self)->PySide2.QtCore.Qt.ShortcutContext",
    "PySide2.QtWidgets.QShortcut.event(self,e:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QShortcut.id(self)->int",
    "PySide2.QtWidgets.QShortcut.isEnabled(self)->bool",
    "PySide2.QtWidgets.QShortcut.key(self)->PySide2.QtGui.QKeySequence",
    "PySide2.QtWidgets.QShortcut.parentWidget(self)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QShortcut.setAutoRepeat(self,on:bool)",
    "PySide2.QtWidgets.QShortcut.setContext(self,context:PySide2.QtCore.Qt.ShortcutContext)",
    "PySide2.QtWidgets.QShortcut.setEnabled(self,enable:bool)",
    "PySide2.QtWidgets.QShortcut.setKey(self,key:PySide2.QtGui.QKeySequence)",
    "PySide2.QtWidgets.QShortcut.setWhatsThis(self,text:QString)",
    "PySide2.QtWidgets.QShortcut.whatsThis(self)->QString",
    nullptr}; // Sentinel

void init_QShortcut(PyObject *module)
{
    _Sbk_QShortcut_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QShortcut",
        "QShortcut*",
        &Sbk_QShortcut_spec,
        &Shiboken::callCppDestructor< ::QShortcut >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QShortcut_Type);
    InitSignatureStrings(pyType, QShortcut_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QShortcut_Type), Sbk_QShortcut_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSHORTCUT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QShortcut_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QShortcut_TypeF(),
        QShortcut_PythonToCpp_QShortcut_PTR,
        is_QShortcut_PythonToCpp_QShortcut_PTR_Convertible,
        QShortcut_PTR_CppToPython_QShortcut);

    Shiboken::Conversions::registerConverterName(converter, "QShortcut");
    Shiboken::Conversions::registerConverterName(converter, "QShortcut*");
    Shiboken::Conversions::registerConverterName(converter, "QShortcut&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QShortcut).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QShortcutWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QShortcut_TypeF(), &Sbk_QShortcut_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QShortcut_TypeF(), &::QShortcut::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QShortcut_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QShortcut_TypeF(), &::QShortcut::staticMetaObject, sizeof(QShortcutWrapper));
}
