/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptiongraphicsitem_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qtransform.h>
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionGraphicsItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionGraphicsItem >()))
        return -1;

    ::QStyleOptionGraphicsItem *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionGraphicsItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionGraphicsItem", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionGraphicsItem::QStyleOptionGraphicsItem()
    // 1: QStyleOptionGraphicsItem::QStyleOptionGraphicsItem(QStyleOptionGraphicsItem)
    // 2: QStyleOptionGraphicsItem::QStyleOptionGraphicsItem(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionGraphicsItem()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionGraphicsItem(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionGraphicsItem(QStyleOptionGraphicsItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionGraphicsItem_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionGraphicsItem()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionGraphicsItem()
                cptr = new ::QStyleOptionGraphicsItem();
            }
            break;
        }
        case 1: // QStyleOptionGraphicsItem(const QStyleOptionGraphicsItem & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionGraphicsItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionGraphicsItem(QStyleOptionGraphicsItem)
                cptr = new ::QStyleOptionGraphicsItem(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionGraphicsItem(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionGraphicsItem(int)
                cptr = new ::QStyleOptionGraphicsItem(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionGraphicsItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionGraphicsItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionGraphicsItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QStyleOptionGraphicsItemFunc_levelOfDetailFromTransform(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionGraphicsItem.levelOfDetailFromTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QStyleOptionGraphicsItem::levelOfDetailFromTransform(QTransform)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArg)))) {
        overloadId = 0; // levelOfDetailFromTransform(QTransform)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionGraphicsItemFunc_levelOfDetailFromTransform_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTransform cppArg0_local;
        ::QTransform *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // levelOfDetailFromTransform(QTransform)
            qreal cppResult = ::QStyleOptionGraphicsItem::levelOfDetailFromTransform(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleOptionGraphicsItemFunc_levelOfDetailFromTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QStyleOptionGraphicsItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionGraphicsItem_methods[] = {
    {"levelOfDetailFromTransform", reinterpret_cast<PyCFunction>(Sbk_QStyleOptionGraphicsItemFunc_levelOfDetailFromTransform), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionGraphicsItem_get_exposedRect(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionGraphicsItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->exposedRect)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->exposedRect))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->exposedRect)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &(cppSelf->exposedRect), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionGraphicsItem_set_exposedRect(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionGraphicsItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'exposedRect' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'exposedRect', 'QRectF' or convertible type expected");
        return -1;
    }

    ::QRectF& cppOut_ptr = cppSelf->exposedRect;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionGraphicsItem_get_matrix(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionGraphicsItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->matrix)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->matrix))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->matrix)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &(cppSelf->matrix), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionGraphicsItem_set_matrix(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionGraphicsItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'matrix' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'matrix', 'QMatrix' or convertible type expected");
        return -1;
    }

    ::QMatrix& cppOut_ptr = cppSelf->matrix;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionGraphicsItem_get_levelOfDetail(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionGraphicsItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->levelOfDetail);
    return pyOut;
}
static int Sbk_QStyleOptionGraphicsItem_set_levelOfDetail(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionGraphicsItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'levelOfDetail' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'levelOfDetail', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->levelOfDetail;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for QStyleOptionGraphicsItem
static PyGetSetDef Sbk_QStyleOptionGraphicsItem_getsetlist[] = {
    {const_cast<char *>("exposedRect"), Sbk_QStyleOptionGraphicsItem_get_exposedRect, Sbk_QStyleOptionGraphicsItem_set_exposedRect},
    {const_cast<char *>("matrix"), Sbk_QStyleOptionGraphicsItem_get_matrix, Sbk_QStyleOptionGraphicsItem_set_matrix},
    {const_cast<char *>("levelOfDetail"), Sbk_QStyleOptionGraphicsItem_get_levelOfDetail, Sbk_QStyleOptionGraphicsItem_set_levelOfDetail},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionGraphicsItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionGraphicsItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionGraphicsItem_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionGraphicsItem_TypeF(void)
{
    return _Sbk_QStyleOptionGraphicsItem_Type;
}

static PyType_Slot Sbk_QStyleOptionGraphicsItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionGraphicsItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionGraphicsItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionGraphicsItem_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionGraphicsItem_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionGraphicsItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionGraphicsItem_spec = {
    "2:PySide2.QtWidgets.QStyleOptionGraphicsItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionGraphicsItem_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionGraphicsItem_StyleOptionType_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionGraphicsItem::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionGraphicsItem::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionGraphicsItem_StyleOptionType_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionGraphicsItem_StyleOptionType_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionGraphicsItem_StyleOptionType_CppToPython_QStyleOptionGraphicsItem_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionGraphicsItem::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionGraphicsItem_StyleOptionVersion_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionGraphicsItem::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionGraphicsItem::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionGraphicsItem_StyleOptionVersion_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionGraphicsItem_StyleOptionVersion_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionGraphicsItem_StyleOptionVersion_CppToPython_QStyleOptionGraphicsItem_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionGraphicsItem::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionGraphicsItem_PythonToCpp_QStyleOptionGraphicsItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionGraphicsItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionGraphicsItem_PythonToCpp_QStyleOptionGraphicsItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionGraphicsItem_TypeF())))
        return QStyleOptionGraphicsItem_PythonToCpp_QStyleOptionGraphicsItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionGraphicsItem_PTR_CppToPython_QStyleOptionGraphicsItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionGraphicsItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionGraphicsItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionGraphicsItem_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionGraphicsItem(self)",
    "1:PySide2.QtWidgets.QStyleOptionGraphicsItem(self,other:PySide2.QtWidgets.QStyleOptionGraphicsItem)",
    "0:PySide2.QtWidgets.QStyleOptionGraphicsItem(self,version:int)",
    "PySide2.QtWidgets.QStyleOptionGraphicsItem.levelOfDetailFromTransform(worldTransform:PySide2.QtGui.QTransform)->qreal",
    nullptr}; // Sentinel

void init_QStyleOptionGraphicsItem(PyObject *module)
{
    _Sbk_QStyleOptionGraphicsItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionGraphicsItem",
        "QStyleOptionGraphicsItem*",
        &Sbk_QStyleOptionGraphicsItem_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionGraphicsItem >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionGraphicsItem_Type);
    InitSignatureStrings(pyType, QStyleOptionGraphicsItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionGraphicsItem_Type), Sbk_QStyleOptionGraphicsItem_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionGraphicsItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionGraphicsItem_TypeF(),
        QStyleOptionGraphicsItem_PythonToCpp_QStyleOptionGraphicsItem_PTR,
        is_QStyleOptionGraphicsItem_PythonToCpp_QStyleOptionGraphicsItem_PTR_Convertible,
        QStyleOptionGraphicsItem_PTR_CppToPython_QStyleOptionGraphicsItem);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionGraphicsItem");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionGraphicsItem*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionGraphicsItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionGraphicsItem).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionGraphicsItem_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionGraphicsItem.StyleOptionType",
        "QStyleOptionGraphicsItem::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionGraphicsItem_TypeF(), "Type", (long) QStyleOptionGraphicsItem::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionGraphicsItem::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX],
            QStyleOptionGraphicsItem_StyleOptionType_CppToPython_QStyleOptionGraphicsItem_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionGraphicsItem_StyleOptionType_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionType,
            is_QStyleOptionGraphicsItem_StyleOptionType_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionGraphicsItem::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionGraphicsItem_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionGraphicsItem.StyleOptionVersion",
        "QStyleOptionGraphicsItem::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionGraphicsItem_TypeF(), "Version", (long) QStyleOptionGraphicsItem::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionGraphicsItem::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX],
            QStyleOptionGraphicsItem_StyleOptionVersion_CppToPython_QStyleOptionGraphicsItem_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionGraphicsItem_StyleOptionVersion_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionVersion,
            is_QStyleOptionGraphicsItem_StyleOptionVersion_PythonToCpp_QStyleOptionGraphicsItem_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionGraphicsItem::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    qRegisterMetaType< ::QStyleOptionGraphicsItem::StyleOptionType >("QStyleOptionGraphicsItem::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionGraphicsItem::StyleOptionVersion >("QStyleOptionGraphicsItem::StyleOptionVersion");
}
