/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptiontab_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionTab_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionTab >()))
        return -1;

    ::QStyleOptionTab *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionTab.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionTab", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionTab::QStyleOptionTab()
    // 1: QStyleOptionTab::QStyleOptionTab(QStyleOptionTab)
    // 2: QStyleOptionTab::QStyleOptionTab(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionTab()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionTab(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionTab(QStyleOptionTab)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionTab_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionTab()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionTab()
                cptr = new ::QStyleOptionTab();
            }
            break;
        }
        case 1: // QStyleOptionTab(const QStyleOptionTab & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionTab *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionTab(QStyleOptionTab)
                cptr = new ::QStyleOptionTab(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionTab(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionTab(int)
                cptr = new ::QStyleOptionTab(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionTab >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionTab_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionTab_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionTab_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionTab_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionTab_get_shape(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QTabBar::Shape cppOut_local = cppSelf->shape;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QTABBAR_SHAPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_shape(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'shape' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QTABBAR_SHAPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'shape', 'Shape' or convertible type expected");
        return -1;
    }

    ::QTabBar::Shape cppOut_local = cppSelf->shape;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->shape = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_text(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->text);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_text(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->text;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_icon(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->icon)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->icon))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &(cppSelf->icon), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_icon(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    ::QIcon& cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_row(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->row;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_row(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'row' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'row', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->row;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->row = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_position(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionTab::TabPosition cppOut_local = cppSelf->position;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_position(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'position' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'position', 'TabPosition' or convertible type expected");
        return -1;
    }

    ::QStyleOptionTab::TabPosition cppOut_local = cppSelf->position;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->position = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_selectedPosition(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionTab::SelectedPosition cppOut_local = cppSelf->selectedPosition;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_selectedPosition(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selectedPosition' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectedPosition', 'SelectedPosition' or convertible type expected");
        return -1;
    }

    ::QStyleOptionTab::SelectedPosition cppOut_local = cppSelf->selectedPosition;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selectedPosition = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_cornerWidgets(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])->converter, &cppSelf->cornerWidgets);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_cornerWidgets(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'cornerWidgets' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'cornerWidgets', 'CornerWidgets' or convertible type expected");
        return -1;
    }

    ::QFlags<QStyleOptionTab::CornerWidget> cppOut_local = cppSelf->cornerWidgets;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->cornerWidgets = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_iconSize(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->iconSize)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->iconSize))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->iconSize)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &(cppSelf->iconSize), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_iconSize(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'iconSize' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'iconSize', 'QSize' or convertible type expected");
        return -1;
    }

    ::QSize& cppOut_ptr = cppSelf->iconSize;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_documentMode(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->documentMode;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_documentMode(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'documentMode' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'documentMode', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->documentMode;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->documentMode = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_leftButtonSize(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->leftButtonSize)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->leftButtonSize))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->leftButtonSize)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &(cppSelf->leftButtonSize), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_leftButtonSize(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'leftButtonSize' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'leftButtonSize', 'QSize' or convertible type expected");
        return -1;
    }

    ::QSize& cppOut_ptr = cppSelf->leftButtonSize;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_rightButtonSize(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->rightButtonSize)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->rightButtonSize))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->rightButtonSize)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &(cppSelf->rightButtonSize), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_rightButtonSize(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'rightButtonSize' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'rightButtonSize', 'QSize' or convertible type expected");
        return -1;
    }

    ::QSize& cppOut_ptr = cppSelf->rightButtonSize;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionTab_get_features(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX])->converter, &cppSelf->features);
    return pyOut;
}
static int Sbk_QStyleOptionTab_set_features(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionTab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'features' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'features', 'TabFeatures' or convertible type expected");
        return -1;
    }

    ::QFlags<QStyleOptionTab::TabFeature> cppOut_local = cppSelf->features;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->features = cppOut_local;

    return 0;
}

// Getters and Setters for QStyleOptionTab
static PyGetSetDef Sbk_QStyleOptionTab_getsetlist[] = {
    {const_cast<char *>("shape"), Sbk_QStyleOptionTab_get_shape, Sbk_QStyleOptionTab_set_shape},
    {const_cast<char *>("text"), Sbk_QStyleOptionTab_get_text, Sbk_QStyleOptionTab_set_text},
    {const_cast<char *>("icon"), Sbk_QStyleOptionTab_get_icon, Sbk_QStyleOptionTab_set_icon},
    {const_cast<char *>("row"), Sbk_QStyleOptionTab_get_row, Sbk_QStyleOptionTab_set_row},
    {const_cast<char *>("position"), Sbk_QStyleOptionTab_get_position, Sbk_QStyleOptionTab_set_position},
    {const_cast<char *>("selectedPosition"), Sbk_QStyleOptionTab_get_selectedPosition, Sbk_QStyleOptionTab_set_selectedPosition},
    {const_cast<char *>("cornerWidgets"), Sbk_QStyleOptionTab_get_cornerWidgets, Sbk_QStyleOptionTab_set_cornerWidgets},
    {const_cast<char *>("iconSize"), Sbk_QStyleOptionTab_get_iconSize, Sbk_QStyleOptionTab_set_iconSize},
    {const_cast<char *>("documentMode"), Sbk_QStyleOptionTab_get_documentMode, Sbk_QStyleOptionTab_set_documentMode},
    {const_cast<char *>("leftButtonSize"), Sbk_QStyleOptionTab_get_leftButtonSize, Sbk_QStyleOptionTab_set_leftButtonSize},
    {const_cast<char *>("rightButtonSize"), Sbk_QStyleOptionTab_get_rightButtonSize, Sbk_QStyleOptionTab_set_rightButtonSize},
    {const_cast<char *>("features"), Sbk_QStyleOptionTab_get_features, Sbk_QStyleOptionTab_set_features},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionTab_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionTab_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionTab_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionTab_TypeF(void)
{
    return _Sbk_QStyleOptionTab_Type;
}

static PyType_Slot Sbk_QStyleOptionTab_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionTab_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionTab_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionTab_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionTab_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionTab_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionTab_spec = {
    "2:PySide2.QtWidgets.QStyleOptionTab",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionTab_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget___and__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionTab::CornerWidgets cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionTab::CornerWidgets>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::CornerWidgets>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionTab::CornerWidgets>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::CornerWidgets>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget___or__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionTab::CornerWidgets cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionTab::CornerWidgets>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::CornerWidgets>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionTab::CornerWidgets>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::CornerWidgets>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget___xor__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionTab::CornerWidgets cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionTab::CornerWidgets>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::CornerWidgets>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionTab::CornerWidgets>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::CornerWidgets>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget___invert__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionTab::CornerWidgets cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])->converter, self, &cppSelf);
    ::QStyleOptionTab::CornerWidgets cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionTab::TabFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionTab::TabFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::TabFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionTab::TabFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::TabFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionTab::TabFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionTab::TabFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::TabFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionTab::TabFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::TabFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionTab::TabFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionTab::TabFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::TabFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionTab::TabFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionTab::TabFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionTab::TabFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX])->converter, self, &cppSelf);
    ::QStyleOptionTab::TabFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionTab_StyleOptionType_PythonToCpp_QStyleOptionTab_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionTab::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionTab::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionTab_StyleOptionType_PythonToCpp_QStyleOptionTab_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionTab_StyleOptionType_PythonToCpp_QStyleOptionTab_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionTab_StyleOptionType_CppToPython_QStyleOptionTab_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionTab::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionTab_StyleOptionVersion_PythonToCpp_QStyleOptionTab_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionTab::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionTab::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionTab_StyleOptionVersion_PythonToCpp_QStyleOptionTab_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionTab_StyleOptionVersion_PythonToCpp_QStyleOptionTab_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionTab_StyleOptionVersion_CppToPython_QStyleOptionTab_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionTab::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX], castCppIn);

}

static void QStyleOptionTab_TabPosition_PythonToCpp_QStyleOptionTab_TabPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionTab::TabPosition *>(cppOut) =
        static_cast<::QStyleOptionTab::TabPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionTab_TabPosition_PythonToCpp_QStyleOptionTab_TabPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX]))
        return QStyleOptionTab_TabPosition_PythonToCpp_QStyleOptionTab_TabPosition;
    return {};
}
static PyObject *QStyleOptionTab_TabPosition_CppToPython_QStyleOptionTab_TabPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionTab::TabPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX], castCppIn);

}

static void QStyleOptionTab_SelectedPosition_PythonToCpp_QStyleOptionTab_SelectedPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionTab::SelectedPosition *>(cppOut) =
        static_cast<::QStyleOptionTab::SelectedPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionTab_SelectedPosition_PythonToCpp_QStyleOptionTab_SelectedPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX]))
        return QStyleOptionTab_SelectedPosition_PythonToCpp_QStyleOptionTab_SelectedPosition;
    return {};
}
static PyObject *QStyleOptionTab_SelectedPosition_CppToPython_QStyleOptionTab_SelectedPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionTab::SelectedPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX], castCppIn);

}

static void QStyleOptionTab_CornerWidget_PythonToCpp_QStyleOptionTab_CornerWidget(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionTab::CornerWidget *>(cppOut) =
        static_cast<::QStyleOptionTab::CornerWidget>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionTab_CornerWidget_PythonToCpp_QStyleOptionTab_CornerWidget_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX]))
        return QStyleOptionTab_CornerWidget_PythonToCpp_QStyleOptionTab_CornerWidget;
    return {};
}
static PyObject *QStyleOptionTab_CornerWidget_CppToPython_QStyleOptionTab_CornerWidget(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionTab::CornerWidget *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX], castCppIn);

}

static void QFlags_QStyleOptionTab_CornerWidget__PythonToCpp_QFlags_QStyleOptionTab_CornerWidget_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionTab::CornerWidget> *>(cppOut) =
        ::QFlags<QStyleOptionTab::CornerWidget>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QStyleOptionTab_CornerWidget__PythonToCpp_QFlags_QStyleOptionTab_CornerWidget__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX]))
        return QFlags_QStyleOptionTab_CornerWidget__PythonToCpp_QFlags_QStyleOptionTab_CornerWidget_;
    return {};
}
static PyObject *QFlags_QStyleOptionTab_CornerWidget__CppToPython_QFlags_QStyleOptionTab_CornerWidget_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QStyleOptionTab::CornerWidget> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX]));

}

static void QStyleOptionTab_CornerWidget_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionTab::CornerWidget> *>(cppOut) =
        ::QFlags<QStyleOptionTab::CornerWidget>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QStyleOptionTab_CornerWidget_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX]))
        return QStyleOptionTab_CornerWidget_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget_;
    return {};
}
static void number_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QStyleOptionTab::CornerWidget> *>(cppOut) =
        ::QFlags<QStyleOptionTab::CornerWidget>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX]))
        return number_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget_;
    return {};
}
static void QStyleOptionTab_TabFeature_PythonToCpp_QStyleOptionTab_TabFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionTab::TabFeature *>(cppOut) =
        static_cast<::QStyleOptionTab::TabFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionTab_TabFeature_PythonToCpp_QStyleOptionTab_TabFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX]))
        return QStyleOptionTab_TabFeature_PythonToCpp_QStyleOptionTab_TabFeature;
    return {};
}
static PyObject *QStyleOptionTab_TabFeature_CppToPython_QStyleOptionTab_TabFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionTab::TabFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX], castCppIn);

}

static void QFlags_QStyleOptionTab_TabFeature__PythonToCpp_QFlags_QStyleOptionTab_TabFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionTab::TabFeature> *>(cppOut) =
        ::QFlags<QStyleOptionTab::TabFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QStyleOptionTab_TabFeature__PythonToCpp_QFlags_QStyleOptionTab_TabFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX]))
        return QFlags_QStyleOptionTab_TabFeature__PythonToCpp_QFlags_QStyleOptionTab_TabFeature_;
    return {};
}
static PyObject *QFlags_QStyleOptionTab_TabFeature__CppToPython_QFlags_QStyleOptionTab_TabFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QStyleOptionTab::TabFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX]));

}

static void QStyleOptionTab_TabFeature_PythonToCpp_QFlags_QStyleOptionTab_TabFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionTab::TabFeature> *>(cppOut) =
        ::QFlags<QStyleOptionTab::TabFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QStyleOptionTab_TabFeature_PythonToCpp_QFlags_QStyleOptionTab_TabFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX]))
        return QStyleOptionTab_TabFeature_PythonToCpp_QFlags_QStyleOptionTab_TabFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QStyleOptionTab_TabFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QStyleOptionTab::TabFeature> *>(cppOut) =
        ::QFlags<QStyleOptionTab::TabFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QStyleOptionTab_TabFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QStyleOptionTab_TabFeature_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionTab_PythonToCpp_QStyleOptionTab_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionTab_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionTab_PythonToCpp_QStyleOptionTab_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionTab_TypeF())))
        return QStyleOptionTab_PythonToCpp_QStyleOptionTab_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionTab_PTR_CppToPython_QStyleOptionTab(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionTab *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionTab_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionTab_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionTab(self)",
    "1:PySide2.QtWidgets.QStyleOptionTab(self,other:PySide2.QtWidgets.QStyleOptionTab)",
    "0:PySide2.QtWidgets.QStyleOptionTab(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionTab(PyObject *module)
{
    _Sbk_QStyleOptionTab_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionTab",
        "QStyleOptionTab*",
        &Sbk_QStyleOptionTab_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionTab >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionTab_Type);
    InitSignatureStrings(pyType, QStyleOptionTab_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionTab_Type), Sbk_QStyleOptionTab_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionTab_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionTab_TypeF(),
        QStyleOptionTab_PythonToCpp_QStyleOptionTab_PTR,
        is_QStyleOptionTab_PythonToCpp_QStyleOptionTab_PTR_Convertible,
        QStyleOptionTab_PTR_CppToPython_QStyleOptionTab);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionTab).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionTab_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionTab.StyleOptionType",
        "QStyleOptionTab::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionTab_TypeF(), "Type", (long) QStyleOptionTab::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionTab::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX],
            QStyleOptionTab_StyleOptionType_CppToPython_QStyleOptionTab_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionTab_StyleOptionType_PythonToCpp_QStyleOptionTab_StyleOptionType,
            is_QStyleOptionTab_StyleOptionType_PythonToCpp_QStyleOptionTab_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionTab_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionTab.StyleOptionVersion",
        "QStyleOptionTab::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionTab_TypeF(), "Version", (long) QStyleOptionTab::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionTab::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX],
            QStyleOptionTab_StyleOptionVersion_CppToPython_QStyleOptionTab_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionTab_StyleOptionVersion_PythonToCpp_QStyleOptionTab_StyleOptionVersion,
            is_QStyleOptionTab_StyleOptionVersion_PythonToCpp_QStyleOptionTab_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    // Initialization of enum 'TabPosition'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionTab_TypeF(),
        "TabPosition",
        "2:PySide2.QtWidgets.QStyleOptionTab.TabPosition",
        "QStyleOptionTab::TabPosition");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX],
        Sbk_QStyleOptionTab_TypeF(), "Beginning", (long) QStyleOptionTab::TabPosition::Beginning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX],
        Sbk_QStyleOptionTab_TypeF(), "Middle", (long) QStyleOptionTab::TabPosition::Middle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX],
        Sbk_QStyleOptionTab_TypeF(), "End", (long) QStyleOptionTab::TabPosition::End))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX],
        Sbk_QStyleOptionTab_TypeF(), "OnlyOneTab", (long) QStyleOptionTab::TabPosition::OnlyOneTab))
        return;
    // Register converter for enum 'QStyleOptionTab::TabPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX],
            QStyleOptionTab_TabPosition_CppToPython_QStyleOptionTab_TabPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionTab_TabPosition_PythonToCpp_QStyleOptionTab_TabPosition,
            is_QStyleOptionTab_TabPosition_PythonToCpp_QStyleOptionTab_TabPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab::TabPosition");
        Shiboken::Conversions::registerConverterName(converter, "TabPosition");
    }
    // End of 'TabPosition' enum.

    // Initialization of enum 'SelectedPosition'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionTab_TypeF(),
        "SelectedPosition",
        "2:PySide2.QtWidgets.QStyleOptionTab.SelectedPosition",
        "QStyleOptionTab::SelectedPosition");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionTab_TypeF(), "NotAdjacent", (long) QStyleOptionTab::SelectedPosition::NotAdjacent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionTab_TypeF(), "NextIsSelected", (long) QStyleOptionTab::SelectedPosition::NextIsSelected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionTab_TypeF(), "PreviousIsSelected", (long) QStyleOptionTab::SelectedPosition::PreviousIsSelected))
        return;
    // Register converter for enum 'QStyleOptionTab::SelectedPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX],
            QStyleOptionTab_SelectedPosition_CppToPython_QStyleOptionTab_SelectedPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionTab_SelectedPosition_PythonToCpp_QStyleOptionTab_SelectedPosition,
            is_QStyleOptionTab_SelectedPosition_PythonToCpp_QStyleOptionTab_SelectedPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab::SelectedPosition");
        Shiboken::Conversions::registerConverterName(converter, "SelectedPosition");
    }
    // End of 'SelectedPosition' enum.

    // Initialization of enum 'CornerWidget'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QStyleOptionTab.CornerWidgets", SbkPySide2_QtWidgets_QStyleOptionTab_CornerWidget_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionTab_TypeF(),
        "CornerWidget",
        "2:PySide2.QtWidgets.QStyleOptionTab.CornerWidget",
        "QStyleOptionTab::CornerWidget",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX],
        Sbk_QStyleOptionTab_TypeF(), "NoCornerWidgets", (long) QStyleOptionTab::CornerWidget::NoCornerWidgets))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX],
        Sbk_QStyleOptionTab_TypeF(), "LeftCornerWidget", (long) QStyleOptionTab::CornerWidget::LeftCornerWidget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX],
        Sbk_QStyleOptionTab_TypeF(), "RightCornerWidget", (long) QStyleOptionTab::CornerWidget::RightCornerWidget))
        return;
    // Register converter for enum 'QStyleOptionTab::CornerWidget'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX],
            QStyleOptionTab_CornerWidget_CppToPython_QStyleOptionTab_CornerWidget);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionTab_CornerWidget_PythonToCpp_QStyleOptionTab_CornerWidget,
            is_QStyleOptionTab_CornerWidget_PythonToCpp_QStyleOptionTab_CornerWidget_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab::CornerWidget");
        Shiboken::Conversions::registerConverterName(converter, "CornerWidget");
    }
    // Register converter for flag 'QFlags<QStyleOptionTab::CornerWidget>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX],
            QFlags_QStyleOptionTab_CornerWidget__CppToPython_QFlags_QStyleOptionTab_CornerWidget_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionTab_CornerWidget_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget_,
            is_QStyleOptionTab_CornerWidget_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QStyleOptionTab_CornerWidget__PythonToCpp_QFlags_QStyleOptionTab_CornerWidget_,
            is_QFlags_QStyleOptionTab_CornerWidget__PythonToCpp_QFlags_QStyleOptionTab_CornerWidget__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget_,
            is_number_PythonToCpp_QFlags_QStyleOptionTab_CornerWidget__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab::CornerWidgets");
        Shiboken::Conversions::registerConverterName(converter, "CornerWidgets");
    }
    // End of 'CornerWidget' enum/flags.

    // Initialization of enum 'TabFeature'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QStyleOptionTab.TabFeatures", SbkPySide2_QtWidgets_QStyleOptionTab_TabFeature_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionTab_TypeF(),
        "TabFeature",
        "2:PySide2.QtWidgets.QStyleOptionTab.TabFeature",
        "QStyleOptionTab::TabFeature",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX],
        Sbk_QStyleOptionTab_TypeF(), "None_", (long) QStyleOptionTab::TabFeature::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX],
        Sbk_QStyleOptionTab_TypeF(), "HasFrame", (long) QStyleOptionTab::TabFeature::HasFrame))
        return;
    // Register converter for enum 'QStyleOptionTab::TabFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX],
            QStyleOptionTab_TabFeature_CppToPython_QStyleOptionTab_TabFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionTab_TabFeature_PythonToCpp_QStyleOptionTab_TabFeature,
            is_QStyleOptionTab_TabFeature_PythonToCpp_QStyleOptionTab_TabFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTAB_TABFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab::TabFeature");
        Shiboken::Conversions::registerConverterName(converter, "TabFeature");
    }
    // Register converter for flag 'QFlags<QStyleOptionTab::TabFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX],
            QFlags_QStyleOptionTab_TabFeature__CppToPython_QFlags_QStyleOptionTab_TabFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionTab_TabFeature_PythonToCpp_QFlags_QStyleOptionTab_TabFeature_,
            is_QStyleOptionTab_TabFeature_PythonToCpp_QFlags_QStyleOptionTab_TabFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QStyleOptionTab_TabFeature__PythonToCpp_QFlags_QStyleOptionTab_TabFeature_,
            is_QFlags_QStyleOptionTab_TabFeature__PythonToCpp_QFlags_QStyleOptionTab_TabFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QStyleOptionTab_TabFeature_,
            is_number_PythonToCpp_QFlags_QStyleOptionTab_TabFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_TABFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionTab::TabFeatures");
        Shiboken::Conversions::registerConverterName(converter, "TabFeatures");
    }
    // End of 'TabFeature' enum/flags.

    qRegisterMetaType< ::QStyleOptionTab::StyleOptionType >("QStyleOptionTab::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionTab::StyleOptionVersion >("QStyleOptionTab::StyleOptionVersion");
    qRegisterMetaType< ::QStyleOptionTab::TabPosition >("QStyleOptionTab::TabPosition");
    qRegisterMetaType< ::QStyleOptionTab::SelectedPosition >("QStyleOptionTab::SelectedPosition");
    qRegisterMetaType< ::QStyleOptionTab::CornerWidget >("QStyleOptionTab::CornerWidget");
    qRegisterMetaType< ::QStyleOptionTab::CornerWidgets >("QStyleOptionTab::CornerWidgets");
    qRegisterMetaType< ::QStyleOptionTab::TabFeature >("QStyleOptionTab::TabFeature");
    qRegisterMetaType< ::QStyleOptionTab::TabFeatures >("QStyleOptionTab::TabFeatures");
}
