/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qtreewidgetitemiterator_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qtreewidget.h>
#include <QtWidgets/qtreewidgetitemiterator.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTreeWidgetItemIterator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTreeWidgetItemIterator >()))
        return -1;

    ::QTreeWidgetItemIterator *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTreeWidgetItemIterator.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTreeWidgetItemIterator_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTreeWidgetItemIterator_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QTreeWidgetItemIterator", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QTreeWidgetItemIterator::QTreeWidgetItemIterator(QTreeWidget*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
    // 1: QTreeWidgetItemIterator::QTreeWidgetItemIterator(QTreeWidgetItem*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
    // 2: QTreeWidgetItemIterator::QTreeWidgetItemIterator(QTreeWidgetItemIterator)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QTreeWidgetItemIterator(QTreeWidgetItem*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // QTreeWidgetItemIterator(QTreeWidgetItem*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QTreeWidgetItemIterator(QTreeWidget*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // QTreeWidgetItemIterator(QTreeWidget*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTreeWidgetItemIterator(QTreeWidgetItemIterator)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTreeWidgetItemIterator_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTreeWidgetItemIterator(QTreeWidget * widget, QFlags<QTreeWidgetItemIterator::IteratorFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[1]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QTreeWidgetItemIterator_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QTreeWidgetItemIterator_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTreeWidgetItemIterator_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTreeWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QTreeWidgetItemIterator::IteratorFlag> cppArg1 = QTreeWidgetItemIterator::All;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QTreeWidgetItemIterator(QTreeWidget*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
                cptr = new ::QTreeWidgetItemIterator(cppArg0, cppArg1);
                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QTreeWidgetItemIterator(QTreeWidgetItem * item, QFlags<QTreeWidgetItemIterator::IteratorFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[1]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QTreeWidgetItemIterator_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QTreeWidgetItemIterator_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTreeWidgetItemIterator_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTreeWidgetItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QTreeWidgetItemIterator::IteratorFlag> cppArg1 = QTreeWidgetItemIterator::All;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QTreeWidgetItemIterator(QTreeWidgetItem*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
                cptr = new ::QTreeWidgetItemIterator(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QTreeWidgetItemIterator(const QTreeWidgetItemIterator & it)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTreeWidgetItemIterator_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTreeWidgetItemIterator cppArg0_local = ::QTreeWidgetItemIterator(static_cast<::QTreeWidgetItem*>(nullptr));
            ::QTreeWidgetItemIterator *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTreeWidgetItemIterator(QTreeWidgetItemIterator)
                cptr = new ::QTreeWidgetItemIterator(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTreeWidgetItemIterator >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTreeWidgetItemIterator_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTreeWidgetItemIterator_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTreeWidgetItemIteratorFunc___iter__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTreeWidgetItemIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTreeWidgetItemIterator.__iter__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __iter__()
            // Begin code injection
            // TEMPLATE - __iter__ - START
            Py_INCREF(self);
            pyResult = self;
            // TEMPLATE - __iter__ - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTreeWidgetItemIteratorFunc___next__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTreeWidgetItemIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTreeWidgetItemIterator.__next__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __next__()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qtreewidgetitemiterator-next)]
            if (**cppSelf) {
                QTreeWidgetItemIterator *cppResult = new QTreeWidgetItemIterator((*cppSelf)++);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX]), cppResult);
            }
            // END of custom code block [file: ../glue/qtwidgets.cpp (qtreewidgetitemiterator-next)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTreeWidgetItemIteratorFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTreeWidgetItemIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTreeWidgetItemIterator.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qtreewidgetitemiterator-value)]
            QTreeWidgetItem *cppResult = cppSelf->operator *();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEM_IDX]), cppResult);
            Shiboken::Object::releaseOwnership(pyResult);
            // END of custom code block [file: ../glue/qtwidgets.cpp (qtreewidgetitemiterator-value)]
            // ========================================================================

            // End of code injection

            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTreeWidgetItemIterator___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTreeWidgetItemIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTreeWidgetItemIterator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTreeWidgetItemIterator_methods[] = {
    {"value", reinterpret_cast<PyCFunction>(Sbk_QTreeWidgetItemIteratorFunc_value), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTreeWidgetItemIterator___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QTreeWidgetItemIteratorFunc___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTreeWidgetItemIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTreeWidgetItemIterator.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTreeWidgetItemIterator::operator+=(int)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // operator+=(int)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTreeWidgetItemIteratorFunc___iadd___TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator+=(int)
            (*cppSelf) += cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QTreeWidgetItemIteratorFunc___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTreeWidgetItemIteratorFunc___isub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTreeWidgetItemIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTreeWidgetItemIterator.__isub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTreeWidgetItemIterator::operator-=(int)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // operator-=(int)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTreeWidgetItemIteratorFunc___isub___TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator-=(int)
            (*cppSelf) -= cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QTreeWidgetItemIteratorFunc___isub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

} // extern "C"

static int Sbk_QTreeWidgetItemIterator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTreeWidgetItemIterator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTreeWidgetItemIterator_Type = nullptr;
static SbkObjectType *Sbk_QTreeWidgetItemIterator_TypeF(void)
{
    return _Sbk_QTreeWidgetItemIterator_Type;
}

static PyType_Slot Sbk_QTreeWidgetItemIterator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTreeWidgetItemIterator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTreeWidgetItemIterator_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        reinterpret_cast<void *>(Sbk_QTreeWidgetItemIteratorFunc___iter__)},
    {Py_tp_iternext,    reinterpret_cast<void *>(Sbk_QTreeWidgetItemIteratorFunc___next__)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTreeWidgetItemIterator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTreeWidgetItemIterator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_inplace_add, (void *)Sbk_QTreeWidgetItemIteratorFunc___iadd__},
    {Py_nb_inplace_subtract, (void *)Sbk_QTreeWidgetItemIteratorFunc___isub__},
    {0, nullptr}
};
static PyType_Spec Sbk_QTreeWidgetItemIterator_spec = {
    "2:PySide2.QtWidgets.QTreeWidgetItemIterator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTreeWidgetItemIterator_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QTreeWidgetItemIterator::IteratorFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTreeWidgetItemIterator::IteratorFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTreeWidgetItemIterator::IteratorFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTreeWidgetItemIterator::IteratorFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTreeWidgetItemIterator::IteratorFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QTreeWidgetItemIterator::IteratorFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTreeWidgetItemIterator::IteratorFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTreeWidgetItemIterator::IteratorFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTreeWidgetItemIterator::IteratorFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTreeWidgetItemIterator::IteratorFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTreeWidgetItemIterator::IteratorFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTreeWidgetItemIterator::IteratorFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTreeWidgetItemIterator::IteratorFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTreeWidgetItemIterator::IteratorFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTreeWidgetItemIterator::IteratorFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTreeWidgetItemIterator::IteratorFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, self, &cppSelf);
    ::QTreeWidgetItemIterator::IteratorFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QTreeWidgetItemIterator_IteratorFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTreeWidgetItemIterator::IteratorFlag *>(cppOut) =
        static_cast<::QTreeWidgetItemIterator::IteratorFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QTreeWidgetItemIterator_IteratorFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX]))
        return QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QTreeWidgetItemIterator_IteratorFlag;
    return {};
}
static PyObject *QTreeWidgetItemIterator_IteratorFlag_CppToPython_QTreeWidgetItemIterator_IteratorFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTreeWidgetItemIterator::IteratorFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX], castCppIn);

}

static void QFlags_QTreeWidgetItemIterator_IteratorFlag__PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTreeWidgetItemIterator::IteratorFlag> *>(cppOut) =
        ::QFlags<QTreeWidgetItemIterator::IteratorFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTreeWidgetItemIterator_IteratorFlag__PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX]))
        return QFlags_QTreeWidgetItemIterator_IteratorFlag__PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag_;
    return {};
}
static PyObject *QFlags_QTreeWidgetItemIterator_IteratorFlag__CppToPython_QFlags_QTreeWidgetItemIterator_IteratorFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTreeWidgetItemIterator::IteratorFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX]));

}

static void QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTreeWidgetItemIterator::IteratorFlag> *>(cppOut) =
        ::QFlags<QTreeWidgetItemIterator::IteratorFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX]))
        return QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTreeWidgetItemIterator::IteratorFlag> *>(cppOut) =
        ::QFlags<QTreeWidgetItemIterator::IteratorFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX]))
        return number_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTreeWidgetItemIterator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTreeWidgetItemIterator_TypeF())))
        return QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTreeWidgetItemIterator_PTR_CppToPython_QTreeWidgetItemIterator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTreeWidgetItemIterator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTreeWidgetItemIterator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTreeWidgetItemIterator_COPY_CppToPython_QTreeWidgetItemIterator(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTreeWidgetItemIterator_TypeF(), new ::QTreeWidgetItemIterator(*reinterpret_cast<const ::QTreeWidgetItemIterator *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTreeWidgetItemIterator *>(cppOut) = *reinterpret_cast< ::QTreeWidgetItemIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTreeWidgetItemIterator_TypeF())))
        return QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_COPY;
    return {};
}

// Implicit conversions.
static void QTreeWidgetPTR_PythonToCpp_QTreeWidgetItemIterator(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTreeWidgetItemIterator *>(cppOut) = ::QTreeWidgetItemIterator(reinterpret_cast< ::QTreeWidget *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGET_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_QTreeWidgetPTR_PythonToCpp_QTreeWidgetItemIterator_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGET_IDX], pyIn))
        return QTreeWidgetPTR_PythonToCpp_QTreeWidgetItemIterator;
    return {};
}

static void QTreeWidgetItemPTR_PythonToCpp_QTreeWidgetItemIterator(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTreeWidgetItemIterator *>(cppOut) = ::QTreeWidgetItemIterator(reinterpret_cast< ::QTreeWidgetItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEM_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_QTreeWidgetItemPTR_PythonToCpp_QTreeWidgetItemIterator_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEM_IDX], pyIn))
        return QTreeWidgetItemPTR_PythonToCpp_QTreeWidgetItemIterator;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTreeWidgetItemIterator_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QTreeWidgetItemIterator(self,widget:PySide2.QtWidgets.QTreeWidget,flags:PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags=QTreeWidgetItemIterator.All)",
    "1:PySide2.QtWidgets.QTreeWidgetItemIterator(self,item:PySide2.QtWidgets.QTreeWidgetItem,flags:PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags=QTreeWidgetItemIterator.All)",
    "0:PySide2.QtWidgets.QTreeWidgetItemIterator(self,it:PySide2.QtWidgets.QTreeWidgetItemIterator)",
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__iter__(self)->PyObject",
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__next__(self)->PyObject",
    "PySide2.QtWidgets.QTreeWidgetItemIterator.value(self)->PySide2.QtWidgets.QTreeWidgetItem",
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__copy__()",
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__iadd__(self,n:int)->PySide2.QtWidgets.QTreeWidgetItemIterator",
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__isub__(self,n:int)->PySide2.QtWidgets.QTreeWidgetItemIterator",
    nullptr}; // Sentinel

void init_QTreeWidgetItemIterator(PyObject *module)
{
    _Sbk_QTreeWidgetItemIterator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTreeWidgetItemIterator",
        "QTreeWidgetItemIterator",
        &Sbk_QTreeWidgetItemIterator_spec,
        &Shiboken::callCppDestructor< ::QTreeWidgetItemIterator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTreeWidgetItemIterator_Type);
    InitSignatureStrings(pyType, QTreeWidgetItemIterator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTreeWidgetItemIterator_Type), Sbk_QTreeWidgetItemIterator_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTreeWidgetItemIterator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTreeWidgetItemIterator_TypeF(),
        QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_PTR,
        is_QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_PTR_Convertible,
        QTreeWidgetItemIterator_PTR_CppToPython_QTreeWidgetItemIterator,
        QTreeWidgetItemIterator_COPY_CppToPython_QTreeWidgetItemIterator);

    Shiboken::Conversions::registerConverterName(converter, "QTreeWidgetItemIterator");
    Shiboken::Conversions::registerConverterName(converter, "QTreeWidgetItemIterator*");
    Shiboken::Conversions::registerConverterName(converter, "QTreeWidgetItemIterator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTreeWidgetItemIterator).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_COPY,
        is_QTreeWidgetItemIterator_PythonToCpp_QTreeWidgetItemIterator_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTreeWidgetPTR_PythonToCpp_QTreeWidgetItemIterator,
        is_QTreeWidgetPTR_PythonToCpp_QTreeWidgetItemIterator_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTreeWidgetItemPTR_PythonToCpp_QTreeWidgetItemIterator,
        is_QTreeWidgetItemPTR_PythonToCpp_QTreeWidgetItemIterator_Convertible);

    // Initialization of enums.

    // Initialization of enum 'IteratorFlag'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags", SbkPySide2_QtWidgets_QTreeWidgetItemIterator_IteratorFlag_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTreeWidgetItemIterator_TypeF(),
        "IteratorFlag",
        "2:PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlag",
        "QTreeWidgetItemIterator::IteratorFlag",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "All", (long) QTreeWidgetItemIterator::IteratorFlag::All))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "Hidden", (long) QTreeWidgetItemIterator::IteratorFlag::Hidden))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "NotHidden", (long) QTreeWidgetItemIterator::IteratorFlag::NotHidden))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "Selected", (long) QTreeWidgetItemIterator::IteratorFlag::Selected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "Unselected", (long) QTreeWidgetItemIterator::IteratorFlag::Unselected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "Selectable", (long) QTreeWidgetItemIterator::IteratorFlag::Selectable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "NotSelectable", (long) QTreeWidgetItemIterator::IteratorFlag::NotSelectable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "DragEnabled", (long) QTreeWidgetItemIterator::IteratorFlag::DragEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "DragDisabled", (long) QTreeWidgetItemIterator::IteratorFlag::DragDisabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "DropEnabled", (long) QTreeWidgetItemIterator::IteratorFlag::DropEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "DropDisabled", (long) QTreeWidgetItemIterator::IteratorFlag::DropDisabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "HasChildren", (long) QTreeWidgetItemIterator::IteratorFlag::HasChildren))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "NoChildren", (long) QTreeWidgetItemIterator::IteratorFlag::NoChildren))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "Checked", (long) QTreeWidgetItemIterator::IteratorFlag::Checked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "NotChecked", (long) QTreeWidgetItemIterator::IteratorFlag::NotChecked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "Enabled", (long) QTreeWidgetItemIterator::IteratorFlag::Enabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "Disabled", (long) QTreeWidgetItemIterator::IteratorFlag::Disabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "Editable", (long) QTreeWidgetItemIterator::IteratorFlag::Editable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "NotEditable", (long) QTreeWidgetItemIterator::IteratorFlag::NotEditable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
        Sbk_QTreeWidgetItemIterator_TypeF(), "UserFlag", (long) QTreeWidgetItemIterator::IteratorFlag::UserFlag))
        return;
    // Register converter for enum 'QTreeWidgetItemIterator::IteratorFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
            QTreeWidgetItemIterator_IteratorFlag_CppToPython_QTreeWidgetItemIterator_IteratorFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QTreeWidgetItemIterator_IteratorFlag,
            is_QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QTreeWidgetItemIterator_IteratorFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTreeWidgetItemIterator::IteratorFlag");
        Shiboken::Conversions::registerConverterName(converter, "IteratorFlag");
    }
    // Register converter for flag 'QFlags<QTreeWidgetItemIterator::IteratorFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX],
            QFlags_QTreeWidgetItemIterator_IteratorFlag__CppToPython_QFlags_QTreeWidgetItemIterator_IteratorFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag_,
            is_QTreeWidgetItemIterator_IteratorFlag_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTreeWidgetItemIterator_IteratorFlag__PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag_,
            is_QFlags_QTreeWidgetItemIterator_IteratorFlag__PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag_,
            is_number_PythonToCpp_QFlags_QTreeWidgetItemIterator_IteratorFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTreeWidgetItemIterator::IteratorFlags");
        Shiboken::Conversions::registerConverterName(converter, "IteratorFlags");
    }
    // End of 'IteratorFlag' enum/flags.

    qRegisterMetaType< ::QTreeWidgetItemIterator::IteratorFlag >("QTreeWidgetItemIterator::IteratorFlag");
    qRegisterMetaType< ::QTreeWidgetItemIterator::IteratorFlags >("QTreeWidgetItemIterator::IteratorFlags");
}
