/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxml_python.h"

// main header
#include "qdomdocument_wrapper.h"

// inner classes

// Extra includes
#include <QtXml/qdom.h>
#include <QtXml/qxml.h>
#include <qbytearray.h>
#include <qiodevice.h>
#include <qtextstream.h>
#include <qxmlstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDomDocument_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDomDocument >()))
        return -1;

    ::QDomDocument *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDomDocument", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QDomDocument::QDomDocument()
    // 1: QDomDocument::QDomDocument(QDomDocument)
    // 2: QDomDocument::QDomDocument(QDomDocumentType)
    // 3: QDomDocument::QDomDocument(QString)
    if (numArgs == 0) {
        overloadId = 0; // QDomDocument()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 3; // QDomDocument(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENTTYPE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QDomDocument(QDomDocumentType)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QDomDocument(QDomDocument)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocument_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDomDocument()
        {

            if (!PyErr_Occurred()) {
                // QDomDocument()
                cptr = new ::QDomDocument();
            }
            break;
        }
        case 1: // QDomDocument(const QDomDocument & x)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDomDocument cppArg0_local;
            ::QDomDocument *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDomDocument(QDomDocument)
                cptr = new ::QDomDocument(*cppArg0);
            }
            break;
        }
        case 2: // QDomDocument(const QDomDocumentType & doctype)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDomDocumentType cppArg0_local;
            ::QDomDocumentType *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENTTYPE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDomDocument(QDomDocumentType)
                cptr = new ::QDomDocument(*cppArg0);
            }
            break;
        }
        case 3: // QDomDocument(const QString & name)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QDomDocument(QString)
                cptr = new ::QDomDocument(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDomDocument >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDomDocument_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDomDocument_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDomDocumentFunc_createAttribute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomDocument::createAttribute(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // createAttribute(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_createAttribute_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createAttribute(QString)
            QDomAttr cppResult = cppSelf->createAttribute(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMATTR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_createAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_createAttributeNS(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createAttributeNS";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createAttributeNS", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomDocument::createAttributeNS(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // createAttributeNS(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_createAttributeNS_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // createAttributeNS(QString,QString)
            QDomAttr cppResult = cppSelf->createAttributeNS(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMATTR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_createAttributeNS_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_createCDATASection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createCDATASection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomDocument::createCDATASection(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // createCDATASection(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_createCDATASection_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createCDATASection(QString)
            QDomCDATASection cppResult = cppSelf->createCDATASection(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMCDATASECTION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_createCDATASection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_createComment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createComment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomDocument::createComment(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // createComment(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_createComment_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createComment(QString)
            QDomComment cppResult = cppSelf->createComment(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMCOMMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_createComment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_createDocumentFragment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createDocumentFragment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createDocumentFragment()
            QDomDocumentFragment cppResult = cppSelf->createDocumentFragment();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENTFRAGMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomDocumentFunc_createElement(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createElement";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomDocument::createElement(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // createElement(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_createElement_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createElement(QString)
            QDomElement cppResult = cppSelf->createElement(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMELEMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_createElement_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_createElementNS(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createElementNS";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createElementNS", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomDocument::createElementNS(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // createElementNS(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_createElementNS_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // createElementNS(QString,QString)
            QDomElement cppResult = cppSelf->createElementNS(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMELEMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_createElementNS_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_createEntityReference(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createEntityReference";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomDocument::createEntityReference(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // createEntityReference(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_createEntityReference_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createEntityReference(QString)
            QDomEntityReference cppResult = cppSelf->createEntityReference(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_createEntityReference_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_createProcessingInstruction(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createProcessingInstruction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createProcessingInstruction", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomDocument::createProcessingInstruction(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // createProcessingInstruction(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_createProcessingInstruction_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // createProcessingInstruction(QString,QString)
            QDomProcessingInstruction cppResult = cppSelf->createProcessingInstruction(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_createProcessingInstruction_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_createTextNode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.createTextNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomDocument::createTextNode(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // createTextNode(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_createTextNode_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createTextNode(QString)
            QDomText cppResult = cppSelf->createTextNode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_createTextNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_doctype(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.doctype";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // doctype()const
            QDomDocumentType cppResult = const_cast<const ::QDomDocument *>(cppSelf)->doctype();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENTTYPE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomDocumentFunc_documentElement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.documentElement";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // documentElement()const
            QDomElement cppResult = const_cast<const ::QDomDocument *>(cppSelf)->documentElement();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMELEMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomDocumentFunc_elementById(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.elementById";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomDocument::elementById(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // elementById(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_elementById_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // elementById(QString)
            QDomElement cppResult = cppSelf->elementById(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMELEMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_elementById_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_elementsByTagName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.elementsByTagName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomDocument::elementsByTagName(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // elementsByTagName(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_elementsByTagName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // elementsByTagName(QString)const
            QDomNodeList cppResult = const_cast<const ::QDomDocument *>(cppSelf)->elementsByTagName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODELIST_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_elementsByTagName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_elementsByTagNameNS(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.elementsByTagNameNS";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "elementsByTagNameNS", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomDocument::elementsByTagNameNS(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // elementsByTagNameNS(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_elementsByTagNameNS_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // elementsByTagNameNS(QString,QString)
            QDomNodeList cppResult = cppSelf->elementsByTagNameNS(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODELIST_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_elementsByTagNameNS_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_implementation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.implementation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // implementation()const
            QDomImplementation cppResult = const_cast<const ::QDomDocument *>(cppSelf)->implementation();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomDocumentFunc_importNode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.importNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "importNode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomDocument::importNode(QDomNode,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // importNode(QDomNode,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_importNode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDomNode cppArg0_local;
        ::QDomNode *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // importNode(QDomNode,bool)
            QDomNode cppResult = cppSelf->importNode(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_importNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_nodeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.nodeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nodeType()const
            QDomNode::NodeType cppResult = const_cast<const ::QDomDocument *>(cppSelf)->nodeType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomDocumentFunc_setContent(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.setContent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDomDocumentFunc_setContent_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDomDocumentFunc_setContent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:setContent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QDomDocument::setContent(QIODevice*,QString*,int*,int*)
    // 1: QDomDocument::setContent(QIODevice*,bool,QString*,int*,int*)
    // 2: QDomDocument::setContent(QXmlInputSource*,QXmlReader*,QString*,int*,int*)
    // 3: QDomDocument::setContent(QXmlInputSource*,bool,QString*,int*,int*)
    // 4: QDomDocument::setContent(QXmlStreamReader*,bool,QString*,int*,int*)
    // 5: QDomDocument::setContent(QByteArray,QString*,int*,int*)
    // 6: QDomDocument::setContent(QByteArray,bool,QString*,int*,int*)
    // 7: QDomDocument::setContent(QString,QString*,int*,int*)
    // 8: QDomDocument::setContent(QString,bool,QString*,int*,int*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 4; // setContent(QXmlStreamReader*,bool,QString*,int*,int*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 4; // setContent(QXmlStreamReader*,bool,QString*,int*,int*)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 4; // setContent(QXmlStreamReader*,bool,QString*,int*,int*)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                    overloadId = 4; // setContent(QXmlStreamReader*,bool,QString*,int*,int*)
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QXMLINPUTSOURCE_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 3; // setContent(QXmlInputSource*,bool,QString*,int*,int*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QXMLREADER_IDX]), (pyArgs[1])))) {
            overloadId = 2; // setContent(QXmlInputSource*,QXmlReader*,QString*,int*,int*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setContent(QIODevice*,QString*,int*,int*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 1; // setContent(QIODevice*,bool,QString*,int*,int*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 7; // setContent(QString,QString*,int*,int*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 8; // setContent(QString,bool,QString*,int*,int*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 5; // setContent(QByteArray,QString*,int*,int*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 6; // setContent(QByteArray,bool,QString*,int*,int*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_setContent_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setContent(QIODevice * dev, QString * errorMsg, int * errorLine, int * errorColumn)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDomDocumentFunc_setContent_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setContent(QIODevice*,QString*,int*,int*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                QString _errorMsg_;
                int _errorLine_ = 0;
                int _errorColumn_ = 0;
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool _ret_ = cppSelf->setContent(cppArg0, &_errorMsg_, &_errorLine_,
                    &_errorColumn_);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = PyTuple_New(4);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &_ret_));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_errorMsg_));
                PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorLine_));
                PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorColumn_));
                // END of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // setContent(QIODevice * dev, bool namespaceProcessing, QString * errorMsg, int * errorLine, int * errorColumn)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDomDocumentFunc_setContent_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setContent(QIODevice*,bool,QString*,int*,int*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                QString _errorMsg_;
                int _errorLine_ = 0;
                int _errorColumn_ = 0;
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool _ret_ = cppSelf->setContent(cppArg0, cppArg1, &_errorMsg_, &_errorLine_,
                    &_errorColumn_);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = PyTuple_New(4);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &_ret_));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_errorMsg_));
                PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorLine_));
                PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorColumn_));
                // END of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 2: // setContent(QXmlInputSource * source, QXmlReader * reader, QString * errorMsg, int * errorLine, int * errorColumn)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDomDocumentFunc_setContent_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QXmlInputSource *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QXmlReader *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setContent(QXmlInputSource*,QXmlReader*,QString*,int*,int*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                QString _errorMsg_;
                int _errorLine_ = 0;
                int _errorColumn_ = 0;
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool _ret_ = cppSelf->setContent(cppArg0, cppArg1, &_errorMsg_, &_errorLine_,
                    &_errorColumn_);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = PyTuple_New(4);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &_ret_));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_errorMsg_));
                PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorLine_));
                PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorColumn_));
                // END of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                // ========================================================================

                // End of code injection

            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QDomDocument.setContent(QXmlInputSource * source, QXmlReader * reader, QString * errorMsg, int * errorLine, int * errorColumn) is deprecated", 1);
            break;
        }
        case 3: // setContent(QXmlInputSource * source, bool namespaceProcessing, QString * errorMsg, int * errorLine, int * errorColumn)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDomDocumentFunc_setContent_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QXmlInputSource *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setContent(QXmlInputSource*,bool,QString*,int*,int*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                QString _errorMsg_;
                int _errorLine_ = 0;
                int _errorColumn_ = 0;
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool _ret_ = cppSelf->setContent(cppArg0, cppArg1, &_errorMsg_, &_errorLine_,
                    &_errorColumn_);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = PyTuple_New(4);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &_ret_));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_errorMsg_));
                PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorLine_));
                PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorColumn_));
                // END of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                // ========================================================================

                // End of code injection

            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QDomDocument.setContent(QXmlInputSource * source, bool namespaceProcessing, QString * errorMsg, int * errorLine, int * errorColumn) is deprecated", 1);
            break;
        }
        case 4: // setContent(QXmlStreamReader * reader, bool namespaceProcessing, QString * errorMsg, int * errorLine, int * errorColumn)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_errorMsg = Shiboken::String::createStaticString("errorMsg");
                if (PyDict_Contains(kwds, key_errorMsg)) {
                    value = PyDict_GetItem(kwds, key_errorMsg);
                    if (value && pyArgs[2]) {
                        errInfo = key_errorMsg;
                        Py_INCREF(errInfo);
                        goto Sbk_QDomDocumentFunc_setContent_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                            goto Sbk_QDomDocumentFunc_setContent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_errorMsg);
                }
                static PyObject *const key_errorLine = Shiboken::String::createStaticString("errorLine");
                if (PyDict_Contains(kwds, key_errorLine)) {
                    value = PyDict_GetItem(kwds, key_errorLine);
                    if (value && pyArgs[3]) {
                        errInfo = key_errorLine;
                        Py_INCREF(errInfo);
                        goto Sbk_QDomDocumentFunc_setContent_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QDomDocumentFunc_setContent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_errorLine);
                }
                static PyObject *const key_errorColumn = Shiboken::String::createStaticString("errorColumn");
                if (PyDict_Contains(kwds, key_errorColumn)) {
                    value = PyDict_GetItem(kwds, key_errorColumn);
                    if (value && pyArgs[4]) {
                        errInfo = key_errorColumn;
                        Py_INCREF(errInfo);
                        goto Sbk_QDomDocumentFunc_setContent_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QDomDocumentFunc_setContent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_errorColumn);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDomDocumentFunc_setContent_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QXmlStreamReader *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int *cppArg4 = nullptr;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setContent(QXmlStreamReader*,bool,QString*,int*,int*)
                bool cppResult = cppSelf->setContent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 5: // setContent(const QByteArray & text, QString * errorMsg, int * errorLine, int * errorColumn)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDomDocumentFunc_setContent_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setContent(QByteArray,QString*,int*,int*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                QString _errorMsg_;
                int _errorLine_ = 0;
                int _errorColumn_ = 0;
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool _ret_ = cppSelf->setContent(*cppArg0, &_errorMsg_, &_errorLine_,
                    &_errorColumn_);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = PyTuple_New(4);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &_ret_));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_errorMsg_));
                PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorLine_));
                PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorColumn_));
                // END of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 6: // setContent(const QByteArray & text, bool namespaceProcessing, QString * errorMsg, int * errorLine, int * errorColumn)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDomDocumentFunc_setContent_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setContent(QByteArray,bool,QString*,int*,int*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                QString _errorMsg_;
                int _errorLine_ = 0;
                int _errorColumn_ = 0;
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool _ret_ = cppSelf->setContent(*cppArg0, cppArg1, &_errorMsg_, &_errorLine_,
                    &_errorColumn_);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = PyTuple_New(4);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &_ret_));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_errorMsg_));
                PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorLine_));
                PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorColumn_));
                // END of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 7: // setContent(const QString & text, QString * errorMsg, int * errorLine, int * errorColumn)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDomDocumentFunc_setContent_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setContent(QString,QString*,int*,int*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                QString _errorMsg_;
                int _errorLine_ = 0;
                int _errorColumn_ = 0;
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool _ret_ = cppSelf->setContent(cppArg0, &_errorMsg_, &_errorLine_,
                    &_errorColumn_);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = PyTuple_New(4);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &_ret_));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_errorMsg_));
                PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorLine_));
                PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorColumn_));
                // END of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 8: // setContent(const QString & text, bool namespaceProcessing, QString * errorMsg, int * errorLine, int * errorColumn)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDomDocumentFunc_setContent_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setContent(QString,bool,QString*,int*,int*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                QString _errorMsg_;
                int _errorLine_ = 0;
                int _errorColumn_ = 0;
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool _ret_ = cppSelf->setContent(cppArg0, cppArg1, &_errorMsg_, &_errorLine_,
                    &_errorColumn_);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = PyTuple_New(4);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &_ret_));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_errorMsg_));
                PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorLine_));
                PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &_errorColumn_));
                // END of custom code block [file: ../glue/qtxml.cpp (qdomdocument-setcontent)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_setContent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_toByteArray(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.toByteArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDomDocumentFunc_toByteArray_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toByteArray", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDomDocument::toByteArray(int)const
    if (numArgs == 0) {
        overloadId = 0; // toByteArray(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toByteArray(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_toByteArray_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__1 = Shiboken::String::createStaticString("arg__1");
            if (PyDict_Contains(kwds, key_arg__1)) {
                value = PyDict_GetItem(kwds, key_arg__1);
                if (value && pyArgs[0]) {
                    errInfo = key_arg__1;
                    Py_INCREF(errInfo);
                    goto Sbk_QDomDocumentFunc_toByteArray_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QDomDocumentFunc_toByteArray_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__1);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDomDocumentFunc_toByteArray_TypeError;
            }
        }
        int cppArg0 = 1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toByteArray(int)const
            QByteArray cppResult = const_cast<const ::QDomDocument *>(cppSelf)->toByteArray(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_toByteArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocumentFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomDocument.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDomDocumentFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toString", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDomDocument::toString(int)const
    if (numArgs == 0) {
        overloadId = 0; // toString(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toString(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomDocumentFunc_toString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__1 = Shiboken::String::createStaticString("arg__1");
            if (PyDict_Contains(kwds, key_arg__1)) {
                value = PyDict_GetItem(kwds, key_arg__1);
                if (value && pyArgs[0]) {
                    errInfo = key_arg__1;
                    Py_INCREF(errInfo);
                    goto Sbk_QDomDocumentFunc_toString_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QDomDocumentFunc_toString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__1);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDomDocumentFunc_toString_TypeError;
            }
        }
        int cppArg0 = 1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toString(int)const
            QString cppResult = const_cast<const ::QDomDocument *>(cppSelf)->toString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomDocumentFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomDocument___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDomDocument_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDomDocument_methods[] = {
    {"createAttribute", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createAttribute), METH_O},
    {"createAttributeNS", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createAttributeNS), METH_VARARGS},
    {"createCDATASection", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createCDATASection), METH_O},
    {"createComment", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createComment), METH_O},
    {"createDocumentFragment", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createDocumentFragment), METH_NOARGS},
    {"createElement", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createElement), METH_O},
    {"createElementNS", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createElementNS), METH_VARARGS},
    {"createEntityReference", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createEntityReference), METH_O},
    {"createProcessingInstruction", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createProcessingInstruction), METH_VARARGS},
    {"createTextNode", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_createTextNode), METH_O},
    {"doctype", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_doctype), METH_NOARGS},
    {"documentElement", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_documentElement), METH_NOARGS},
    {"elementById", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_elementById), METH_O},
    {"elementsByTagName", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_elementsByTagName), METH_O},
    {"elementsByTagNameNS", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_elementsByTagNameNS), METH_VARARGS},
    {"implementation", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_implementation), METH_NOARGS},
    {"importNode", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_importNode), METH_VARARGS},
    {"nodeType", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_nodeType), METH_NOARGS},
    {"setContent", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_setContent), METH_VARARGS|METH_KEYWORDS},
    {"toByteArray", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_toByteArray), METH_VARARGS|METH_KEYWORDS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QDomDocumentFunc_toString), METH_VARARGS|METH_KEYWORDS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDomDocument___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QDomDocument___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QDomDocument_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDomDocument_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDomDocument_Type = nullptr;
static SbkObjectType *Sbk_QDomDocument_TypeF(void)
{
    return _Sbk_QDomDocument_Type;
}

static PyType_Slot Sbk_QDomDocument_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDomDocument_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDomDocument_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDomDocument_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDomDocument_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QDomDocument___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QDomDocument___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QDomDocument_spec = {
    "2:PySide2.QtXml.QDomDocument",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDomDocument_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDomDocument_PythonToCpp_QDomDocument_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDomDocument_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDomDocument_PythonToCpp_QDomDocument_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomDocument_TypeF())))
        return QDomDocument_PythonToCpp_QDomDocument_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDomDocument_PTR_CppToPython_QDomDocument(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDomDocument *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDomDocument_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDomDocument_COPY_CppToPython_QDomDocument(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDomDocument_TypeF(), new ::QDomDocument(*reinterpret_cast<const ::QDomDocument *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDomDocument_PythonToCpp_QDomDocument_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomDocument *>(cppOut) = *reinterpret_cast< ::QDomDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDomDocument_PythonToCpp_QDomDocument_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomDocument_TypeF())))
        return QDomDocument_PythonToCpp_QDomDocument_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDomDocument_SignatureStrings[] = {
    "3:PySide2.QtXml.QDomDocument(self)",
    "2:PySide2.QtXml.QDomDocument(self,x:PySide2.QtXml.QDomDocument)",
    "1:PySide2.QtXml.QDomDocument(self,doctype:PySide2.QtXml.QDomDocumentType)",
    "0:PySide2.QtXml.QDomDocument(self,name:QString)",
    "PySide2.QtXml.QDomDocument.createAttribute(self,name:QString)->PySide2.QtXml.QDomAttr",
    "PySide2.QtXml.QDomDocument.createAttributeNS(self,nsURI:QString,qName:QString)->PySide2.QtXml.QDomAttr",
    "PySide2.QtXml.QDomDocument.createCDATASection(self,data:QString)->PySide2.QtXml.QDomCDATASection",
    "PySide2.QtXml.QDomDocument.createComment(self,data:QString)->PySide2.QtXml.QDomComment",
    "PySide2.QtXml.QDomDocument.createDocumentFragment(self)->PySide2.QtXml.QDomDocumentFragment",
    "PySide2.QtXml.QDomDocument.createElement(self,tagName:QString)->PySide2.QtXml.QDomElement",
    "PySide2.QtXml.QDomDocument.createElementNS(self,nsURI:QString,qName:QString)->PySide2.QtXml.QDomElement",
    "PySide2.QtXml.QDomDocument.createEntityReference(self,name:QString)->PySide2.QtXml.QDomEntityReference",
    "PySide2.QtXml.QDomDocument.createProcessingInstruction(self,target:QString,data:QString)->PySide2.QtXml.QDomProcessingInstruction",
    "PySide2.QtXml.QDomDocument.createTextNode(self,data:QString)->PySide2.QtXml.QDomText",
    "PySide2.QtXml.QDomDocument.doctype(self)->PySide2.QtXml.QDomDocumentType",
    "PySide2.QtXml.QDomDocument.documentElement(self)->PySide2.QtXml.QDomElement",
    "PySide2.QtXml.QDomDocument.elementById(self,elementId:QString)->PySide2.QtXml.QDomElement",
    "PySide2.QtXml.QDomDocument.elementsByTagName(self,tagname:QString)->PySide2.QtXml.QDomNodeList",
    "PySide2.QtXml.QDomDocument.elementsByTagNameNS(self,nsURI:QString,localName:QString)->PySide2.QtXml.QDomNodeList",
    "PySide2.QtXml.QDomDocument.implementation(self)->PySide2.QtXml.QDomImplementation",
    "PySide2.QtXml.QDomDocument.importNode(self,importedNode:PySide2.QtXml.QDomNode,deep:bool)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomDocument.nodeType(self)->PySide2.QtXml.QDomNode.NodeType",
    "8:PySide2.QtXml.QDomDocument.setContent(self,dev:PySide2.QtCore.QIODevice,errorMsg:QString*,errorLine:int*,errorColumn:int*)->bool",
    "7:PySide2.QtXml.QDomDocument.setContent(self,dev:PySide2.QtCore.QIODevice,namespaceProcessing:bool,errorMsg:QString*,errorLine:int*,errorColumn:int*)->bool",
    "6:PySide2.QtXml.QDomDocument.setContent(self,source:PySide2.QtXml.QXmlInputSource,reader:PySide2.QtXml.QXmlReader,errorMsg:QString*,errorLine:int*,errorColumn:int*)->bool",
    "5:PySide2.QtXml.QDomDocument.setContent(self,source:PySide2.QtXml.QXmlInputSource,namespaceProcessing:bool,errorMsg:QString*,errorLine:int*,errorColumn:int*)->bool",
    "4:PySide2.QtXml.QDomDocument.setContent(self,reader:PySide2.QtCore.QXmlStreamReader,namespaceProcessing:bool,errorMsg:QString*=nullptr,errorLine:int*=nullptr,errorColumn:int*=nullptr)->bool",
    "3:PySide2.QtXml.QDomDocument.setContent(self,text:PySide2.QtCore.QByteArray,errorMsg:QString*,errorLine:int*,errorColumn:int*)->bool",
    "2:PySide2.QtXml.QDomDocument.setContent(self,text:PySide2.QtCore.QByteArray,namespaceProcessing:bool,errorMsg:QString*,errorLine:int*,errorColumn:int*)->bool",
    "1:PySide2.QtXml.QDomDocument.setContent(self,text:QString,errorMsg:QString*,errorLine:int*,errorColumn:int*)->bool",
    "0:PySide2.QtXml.QDomDocument.setContent(self,text:QString,namespaceProcessing:bool,errorMsg:QString*,errorLine:int*,errorColumn:int*)->bool",
    "PySide2.QtXml.QDomDocument.toByteArray(self,arg__1:int=1)->PySide2.QtCore.QByteArray",
    "PySide2.QtXml.QDomDocument.toString(self,arg__1:int=1)->QString",
    "PySide2.QtXml.QDomDocument.__copy__()",
    nullptr}; // Sentinel

void init_QDomDocument(PyObject *module)
{
    _Sbk_QDomDocument_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDomDocument",
        "QDomDocument",
        &Sbk_QDomDocument_spec,
        &Shiboken::callCppDestructor< ::QDomDocument >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDomDocument_Type);
    InitSignatureStrings(pyType, QDomDocument_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDomDocument_Type), Sbk_QDomDocument_PropertyStrings);
    SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDomDocument_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDomDocument_TypeF(),
        QDomDocument_PythonToCpp_QDomDocument_PTR,
        is_QDomDocument_PythonToCpp_QDomDocument_PTR_Convertible,
        QDomDocument_PTR_CppToPython_QDomDocument,
        QDomDocument_COPY_CppToPython_QDomDocument);

    Shiboken::Conversions::registerConverterName(converter, "QDomDocument");
    Shiboken::Conversions::registerConverterName(converter, "QDomDocument*");
    Shiboken::Conversions::registerConverterName(converter, "QDomDocument&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDomDocument).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDomDocument_PythonToCpp_QDomDocument_COPY,
        is_QDomDocument_PythonToCpp_QDomDocument_COPY_Convertible);

    qRegisterMetaType< ::QDomDocument >("QDomDocument");
}
