/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxml_python.h"

// main header
#include "qdomimplementation_wrapper.h"

// inner classes

// Extra includes
#include <QtXml/qdom.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDomImplementation_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDomImplementation >()))
        return -1;

    ::QDomImplementation *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomImplementation.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDomImplementation", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QDomImplementation::QDomImplementation()
    // 1: QDomImplementation::QDomImplementation(QDomImplementation)
    if (numArgs == 0) {
        overloadId = 0; // QDomImplementation()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QDomImplementation(QDomImplementation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomImplementation_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDomImplementation()
        {

            if (!PyErr_Occurred()) {
                // QDomImplementation()
                cptr = new ::QDomImplementation();
            }
            break;
        }
        case 1: // QDomImplementation(const QDomImplementation & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDomImplementation cppArg0_local;
            ::QDomImplementation *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDomImplementation(QDomImplementation)
                cptr = new ::QDomImplementation(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDomImplementation >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDomImplementation_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDomImplementation_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDomImplementationFunc_createDocument(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomImplementation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomImplementation.createDocument";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createDocument", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDomImplementation::createDocument(QString,QString,QDomDocumentType)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENTTYPE_IDX]), (pyArgs[2])))) {
        overloadId = 0; // createDocument(QString,QString,QDomDocumentType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomImplementationFunc_createDocument_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QDomDocumentType cppArg2_local;
        ::QDomDocumentType *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENTTYPE_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // createDocument(QString,QString,QDomDocumentType)
            QDomDocument cppResult = cppSelf->createDocument(cppArg0, cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomImplementationFunc_createDocument_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomImplementationFunc_createDocumentType(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomImplementation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomImplementation.createDocumentType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createDocumentType", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDomImplementation::createDocumentType(QString,QString,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // createDocumentType(QString,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomImplementationFunc_createDocumentType_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // createDocumentType(QString,QString,QString)
            QDomDocumentType cppResult = cppSelf->createDocumentType(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENTTYPE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomImplementationFunc_createDocumentType_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomImplementationFunc_hasFeature(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomImplementation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomImplementation.hasFeature";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "hasFeature", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomImplementation::hasFeature(QString,QString)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // hasFeature(QString,QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomImplementationFunc_hasFeature_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // hasFeature(QString,QString)const
            bool cppResult = const_cast<const ::QDomImplementation *>(cppSelf)->hasFeature(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomImplementationFunc_hasFeature_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomImplementationFunc_invalidDataPolicy(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomImplementation.invalidDataPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // invalidDataPolicy()
            QDomImplementation::InvalidDataPolicy cppResult = ::QDomImplementation::invalidDataPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomImplementationFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomImplementation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomImplementation.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()
            bool cppResult = cppSelf->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomImplementationFunc_setInvalidDataPolicy(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomImplementation.setInvalidDataPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDomImplementation::setInvalidDataPolicy(QDomImplementation::InvalidDataPolicy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setInvalidDataPolicy(QDomImplementation::InvalidDataPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomImplementationFunc_setInvalidDataPolicy_TypeError;

    // Call function/method
    {
        ::QDomImplementation::InvalidDataPolicy cppArg0{QDomImplementation::AcceptInvalidChars};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInvalidDataPolicy(QDomImplementation::InvalidDataPolicy)
            ::QDomImplementation::setInvalidDataPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDomImplementationFunc_setInvalidDataPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomImplementation___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomImplementation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDomImplementation_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDomImplementation_methods[] = {
    {"createDocument", reinterpret_cast<PyCFunction>(Sbk_QDomImplementationFunc_createDocument), METH_VARARGS},
    {"createDocumentType", reinterpret_cast<PyCFunction>(Sbk_QDomImplementationFunc_createDocumentType), METH_VARARGS},
    {"hasFeature", reinterpret_cast<PyCFunction>(Sbk_QDomImplementationFunc_hasFeature), METH_VARARGS},
    {"invalidDataPolicy", reinterpret_cast<PyCFunction>(Sbk_QDomImplementationFunc_invalidDataPolicy), METH_NOARGS|METH_STATIC},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QDomImplementationFunc_isNull), METH_NOARGS},
    {"setInvalidDataPolicy", reinterpret_cast<PyCFunction>(Sbk_QDomImplementationFunc_setInvalidDataPolicy), METH_O|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDomImplementation___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QDomImplementation_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomImplementation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]), (pyArg)))) {
                // operator!=(const QDomImplementation & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDomImplementation cppArg0_local;
                ::QDomImplementation *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]), (pyArg)))) {
                // operator==(const QDomImplementation & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDomImplementation cppArg0_local;
                ::QDomImplementation *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QDomImplementation_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QDomImplementation_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QDomImplementation_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDomImplementation_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDomImplementation_Type = nullptr;
static SbkObjectType *Sbk_QDomImplementation_TypeF(void)
{
    return _Sbk_QDomImplementation_Type;
}

static PyType_Slot Sbk_QDomImplementation_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDomImplementation_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDomImplementation_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QDomImplementation_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDomImplementation_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDomImplementation_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QDomImplementation_spec = {
    "2:PySide2.QtXml.QDomImplementation",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDomImplementation_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QDomImplementation_InvalidDataPolicy_PythonToCpp_QDomImplementation_InvalidDataPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomImplementation::InvalidDataPolicy *>(cppOut) =
        static_cast<::QDomImplementation::InvalidDataPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDomImplementation_InvalidDataPolicy_PythonToCpp_QDomImplementation_InvalidDataPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX]))
        return QDomImplementation_InvalidDataPolicy_PythonToCpp_QDomImplementation_InvalidDataPolicy;
    return {};
}
static PyObject *QDomImplementation_InvalidDataPolicy_CppToPython_QDomImplementation_InvalidDataPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDomImplementation::InvalidDataPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDomImplementation_PythonToCpp_QDomImplementation_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDomImplementation_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDomImplementation_PythonToCpp_QDomImplementation_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomImplementation_TypeF())))
        return QDomImplementation_PythonToCpp_QDomImplementation_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDomImplementation_PTR_CppToPython_QDomImplementation(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDomImplementation *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDomImplementation_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDomImplementation_COPY_CppToPython_QDomImplementation(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDomImplementation_TypeF(), new ::QDomImplementation(*reinterpret_cast<const ::QDomImplementation *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDomImplementation_PythonToCpp_QDomImplementation_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomImplementation *>(cppOut) = *reinterpret_cast< ::QDomImplementation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDomImplementation_PythonToCpp_QDomImplementation_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomImplementation_TypeF())))
        return QDomImplementation_PythonToCpp_QDomImplementation_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDomImplementation_SignatureStrings[] = {
    "1:PySide2.QtXml.QDomImplementation(self)",
    "0:PySide2.QtXml.QDomImplementation(self,arg__1:PySide2.QtXml.QDomImplementation)",
    "PySide2.QtXml.QDomImplementation.createDocument(self,nsURI:QString,qName:QString,doctype:PySide2.QtXml.QDomDocumentType)->PySide2.QtXml.QDomDocument",
    "PySide2.QtXml.QDomImplementation.createDocumentType(self,qName:QString,publicId:QString,systemId:QString)->PySide2.QtXml.QDomDocumentType",
    "PySide2.QtXml.QDomImplementation.hasFeature(self,feature:QString,version:QString)->bool",
    "PySide2.QtXml.QDomImplementation.invalidDataPolicy()->PySide2.QtXml.QDomImplementation.InvalidDataPolicy",
    "PySide2.QtXml.QDomImplementation.isNull(self)->bool",
    "PySide2.QtXml.QDomImplementation.setInvalidDataPolicy(policy:PySide2.QtXml.QDomImplementation.InvalidDataPolicy)",
    "PySide2.QtXml.QDomImplementation.__copy__()",
    nullptr}; // Sentinel

void init_QDomImplementation(PyObject *module)
{
    _Sbk_QDomImplementation_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDomImplementation",
        "QDomImplementation",
        &Sbk_QDomImplementation_spec,
        &Shiboken::callCppDestructor< ::QDomImplementation >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDomImplementation_Type);
    InitSignatureStrings(pyType, QDomImplementation_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDomImplementation_Type), Sbk_QDomImplementation_PropertyStrings);
    SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDomImplementation_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDomImplementation_TypeF(),
        QDomImplementation_PythonToCpp_QDomImplementation_PTR,
        is_QDomImplementation_PythonToCpp_QDomImplementation_PTR_Convertible,
        QDomImplementation_PTR_CppToPython_QDomImplementation,
        QDomImplementation_COPY_CppToPython_QDomImplementation);

    Shiboken::Conversions::registerConverterName(converter, "QDomImplementation");
    Shiboken::Conversions::registerConverterName(converter, "QDomImplementation*");
    Shiboken::Conversions::registerConverterName(converter, "QDomImplementation&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDomImplementation).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDomImplementation_PythonToCpp_QDomImplementation_COPY,
        is_QDomImplementation_PythonToCpp_QDomImplementation_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'InvalidDataPolicy'.
    SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDomImplementation_TypeF(),
        "InvalidDataPolicy",
        "2:PySide2.QtXml.QDomImplementation.InvalidDataPolicy",
        "QDomImplementation::InvalidDataPolicy");
    if (!SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX],
        Sbk_QDomImplementation_TypeF(), "AcceptInvalidChars", (long) QDomImplementation::InvalidDataPolicy::AcceptInvalidChars))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX],
        Sbk_QDomImplementation_TypeF(), "DropInvalidChars", (long) QDomImplementation::InvalidDataPolicy::DropInvalidChars))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX],
        Sbk_QDomImplementation_TypeF(), "ReturnNullNode", (long) QDomImplementation::InvalidDataPolicy::ReturnNullNode))
        return;
    // Register converter for enum 'QDomImplementation::InvalidDataPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX],
            QDomImplementation_InvalidDataPolicy_CppToPython_QDomImplementation_InvalidDataPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDomImplementation_InvalidDataPolicy_PythonToCpp_QDomImplementation_InvalidDataPolicy,
            is_QDomImplementation_InvalidDataPolicy_PythonToCpp_QDomImplementation_InvalidDataPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDomImplementation::InvalidDataPolicy");
        Shiboken::Conversions::registerConverterName(converter, "InvalidDataPolicy");
    }
    // End of 'InvalidDataPolicy' enum.

    qRegisterMetaType< ::QDomImplementation >("QDomImplementation");
    qRegisterMetaType< ::QDomImplementation::InvalidDataPolicy >("QDomImplementation::InvalidDataPolicy");
}
