/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QXMLREADERWRAPPER_H
#define SBK_QXMLREADERWRAPPER_H

#define protected public

#include <QtXml/qxml.h>


// Extra includes
#include <QtXml/qxml.h>
class QXmlReaderWrapper : public QXmlReader
{
public:
    ::QXmlDTDHandler * DTDHandler() const override;
    QXmlReaderWrapper();
    ::QXmlContentHandler * contentHandler() const override;
    ::QXmlDeclHandler * declHandler() const override;
    ::QXmlEntityResolver * entityResolver() const override;
    ::QXmlErrorHandler * errorHandler() const override;
    bool feature(const ::QString & name, bool * ok = nullptr) const override;
    bool hasFeature(const ::QString & name) const override;
    bool hasProperty(const ::QString & name) const override;
    ::QXmlLexicalHandler * lexicalHandler() const override;
    bool parse(const ::QXmlInputSource & input) override;
    bool parse(const ::QXmlInputSource * input) override;
    void * property(const ::QString & name, bool * ok = nullptr) const override;
    void setContentHandler(::QXmlContentHandler * handler) override;
    void setDTDHandler(::QXmlDTDHandler * handler) override;
    void setDeclHandler(::QXmlDeclHandler * handler) override;
    void setEntityResolver(::QXmlEntityResolver * handler) override;
    void setErrorHandler(::QXmlErrorHandler * handler) override;
    void setFeature(const ::QString & name, bool value) override;
    void setLexicalHandler(::QXmlLexicalHandler * handler) override;
    void setProperty(const ::QString & name, void * value) override;
    ~QXmlReaderWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[20];
};

#endif // SBK_QXMLREADERWRAPPER_H

