/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxmlpatterns_python.h"

// main header
#include "qxmlitem_wrapper.h"

// inner classes

// Extra includes
#include <QtXmlPatterns/qabstractxmlnodemodel.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlItem >()))
        return -1;

    ::QXmlItem *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QXmlItem", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QXmlItem::QXmlItem()
    // 1: QXmlItem::QXmlItem(QVariant)
    // 2: QXmlItem::QXmlItem(QXmlItem)
    // 3: QXmlItem::QXmlItem(QXmlNodeModelIndex)
    if (numArgs == 0) {
        overloadId = 0; // QXmlItem()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QXmlItem(QXmlNodeModelIndex)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[0])))) {
        overloadId = 1; // QXmlItem(QVariant)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QXmlItem(QXmlItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlItem_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QXmlItem()
        {

            if (!PyErr_Occurred()) {
                // QXmlItem()
                cptr = new ::QXmlItem();
            }
            break;
        }
        case 1: // QXmlItem(const QVariant & atomicValue)
        {
            ::QVariant cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QXmlItem(QVariant)
                cptr = new ::QXmlItem(cppArg0);
            }
            break;
        }
        case 2: // QXmlItem(const QXmlItem & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlItem cppArg0_local;
            ::QXmlItem *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlItem(QXmlItem)
                cptr = new ::QXmlItem(*cppArg0);
            }
            break;
        }
        case 3: // QXmlItem(const QXmlNodeModelIndex & node)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlNodeModelIndex cppArg0_local;
            ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlItem(QXmlNodeModelIndex)
                cptr = new ::QXmlItem(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QXmlItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QXmlItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QXmlItemFunc_isAtomicValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlItem.isAtomicValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAtomicValue()const
            bool cppResult = const_cast<const ::QXmlItem *>(cppSelf)->isAtomicValue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlItemFunc_isNode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlItem.isNode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNode()const
            bool cppResult = const_cast<const ::QXmlItem *>(cppSelf)->isNode();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlItemFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlItem.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QXmlItem *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlItemFunc_toAtomicValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlItem.toAtomicValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toAtomicValue()const
            QVariant cppResult = const_cast<const ::QXmlItem *>(cppSelf)->toAtomicValue();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlItemFunc_toNodeModelIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlItem.toNodeModelIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toNodeModelIndex()const
            QXmlNodeModelIndex cppResult = const_cast<const ::QXmlItem *>(cppSelf)->toNodeModelIndex();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlItem___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QXmlItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlItem_methods[] = {
    {"isAtomicValue", reinterpret_cast<PyCFunction>(Sbk_QXmlItemFunc_isAtomicValue), METH_NOARGS},
    {"isNode", reinterpret_cast<PyCFunction>(Sbk_QXmlItemFunc_isNode), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QXmlItemFunc_isNull), METH_NOARGS},
    {"toAtomicValue", reinterpret_cast<PyCFunction>(Sbk_QXmlItemFunc_toAtomicValue), METH_NOARGS},
    {"toNodeModelIndex", reinterpret_cast<PyCFunction>(Sbk_QXmlItemFunc_toNodeModelIndex), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QXmlItem___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QXmlItem___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QXmlItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QXmlItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlItem_Type = nullptr;
static SbkObjectType *Sbk_QXmlItem_TypeF(void)
{
    return _Sbk_QXmlItem_Type;
}

static PyType_Slot Sbk_QXmlItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlItem_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QXmlItem___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QXmlItem___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlItem_spec = {
    "2:PySide2.QtXmlPatterns.QXmlItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlItem_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlItem_PythonToCpp_QXmlItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlItem_PythonToCpp_QXmlItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlItem_TypeF())))
        return QXmlItem_PythonToCpp_QXmlItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlItem_PTR_CppToPython_QXmlItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QXmlItem_COPY_CppToPython_QXmlItem(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QXmlItem_TypeF(), new ::QXmlItem(*reinterpret_cast<const ::QXmlItem *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QXmlItem_PythonToCpp_QXmlItem_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlItem *>(cppOut) = *reinterpret_cast< ::QXmlItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QXmlItem_PythonToCpp_QXmlItem_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlItem_TypeF())))
        return QXmlItem_PythonToCpp_QXmlItem_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_constQVariantREF_PythonToCpp_QXmlItem(PyObject *pyIn, void *cppOut) {
    ::QVariant cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QXmlItem *>(cppOut) = ::QXmlItem(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constQVariantREF_PythonToCpp_QXmlItem_Convertible(PyObject *pyIn) {
    if (PyObject_Check(pyIn))
        return PySide2_QtCore_constQVariantREF_PythonToCpp_QXmlItem;
    return {};
}

static void constQXmlNodeModelIndexREF_PythonToCpp_QXmlItem(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlItem *>(cppOut) = ::QXmlItem( *reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQXmlNodeModelIndexREF_PythonToCpp_QXmlItem_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], pyIn))
        return constQXmlNodeModelIndexREF_PythonToCpp_QXmlItem;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlItem_SignatureStrings[] = {
    "3:PySide2.QtXmlPatterns.QXmlItem(self)",
    "2:PySide2.QtXmlPatterns.QXmlItem(self,atomicValue:QVariant)",
    "1:PySide2.QtXmlPatterns.QXmlItem(self,other:PySide2.QtXmlPatterns.QXmlItem)",
    "0:PySide2.QtXmlPatterns.QXmlItem(self,node:PySide2.QtXmlPatterns.QXmlNodeModelIndex)",
    "PySide2.QtXmlPatterns.QXmlItem.isAtomicValue(self)->bool",
    "PySide2.QtXmlPatterns.QXmlItem.isNode(self)->bool",
    "PySide2.QtXmlPatterns.QXmlItem.isNull(self)->bool",
    "PySide2.QtXmlPatterns.QXmlItem.toAtomicValue(self)->QVariant",
    "PySide2.QtXmlPatterns.QXmlItem.toNodeModelIndex(self)->PySide2.QtXmlPatterns.QXmlNodeModelIndex",
    "PySide2.QtXmlPatterns.QXmlItem.__copy__()",
    nullptr}; // Sentinel

void init_QXmlItem(PyObject *module)
{
    _Sbk_QXmlItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlItem",
        "QXmlItem",
        &Sbk_QXmlItem_spec,
        &Shiboken::callCppDestructor< ::QXmlItem >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlItem_Type);
    InitSignatureStrings(pyType, QXmlItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlItem_Type), Sbk_QXmlItem_PropertyStrings);
    SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlItem_TypeF(),
        QXmlItem_PythonToCpp_QXmlItem_PTR,
        is_QXmlItem_PythonToCpp_QXmlItem_PTR_Convertible,
        QXmlItem_PTR_CppToPython_QXmlItem,
        QXmlItem_COPY_CppToPython_QXmlItem);

    Shiboken::Conversions::registerConverterName(converter, "QXmlItem");
    Shiboken::Conversions::registerConverterName(converter, "QXmlItem*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlItem).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QXmlItem_PythonToCpp_QXmlItem_COPY,
        is_QXmlItem_PythonToCpp_QXmlItem_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQVariantREF_PythonToCpp_QXmlItem,
        is_PySide2_QtCore_constQVariantREF_PythonToCpp_QXmlItem_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQXmlNodeModelIndexREF_PythonToCpp_QXmlItem,
        is_constQXmlNodeModelIndexREF_PythonToCpp_QXmlItem_Convertible);

    qRegisterMetaType< ::QXmlItem >("QXmlItem");
}
