
#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#include "shiboken2_python.h"



// Extra includes
#include "sbkversion.h"
#include "voidptr.h"

// Current module's type array.
PyTypeObject **Sbkshiboken2Types = nullptr;
// Current module's PyObject pointer.
PyObject *Sbkshiboken2ModuleObject = nullptr;
// Current module's converter array.
SbkConverter **Sbkshiboken2TypeConverters = nullptr;
// Global functions ------------------------------------------------------------
static PyObject *Sbkshiboken2Module__unpickle_enum(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2._unpickle_enum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "_unpickle_enum", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: _unpickle_enum(PyObject*,PyObject*)
    if (numArgs == 2
        && PyObject_Check(pyArgs[0])
        && PyObject_Check(pyArgs[1])) {
        overloadId = 0; // _unpickle_enum(PyObject*,PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbkshiboken2Module__unpickle_enum_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // _unpickle_enum(PyObject*,PyObject*)
            // Begin code injection
            pyResult = Shiboken::Enum::unpickleEnum(pyArgs[0], pyArgs[1]);

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbkshiboken2Module__unpickle_enum_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbkshiboken2Module_createdByPython(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2.createdByPython";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: createdByPython(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // createdByPython(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbkshiboken2Module_createdByPython_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createdByPython(PyObject*)
            // Begin code injection
            if (Shiboken::Object::checkType(pyArg)) {
                bool wasCreatedByPython = Shiboken::Object::wasCreatedByPython((SbkObject*)pyArg);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &wasCreatedByPython);
            } else {
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");
            }

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbkshiboken2Module_createdByPython_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbkshiboken2Module_delete(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2.delete";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: delete(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // delete(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbkshiboken2Module_delete_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // delete(PyObject*)
            // Begin code injection
            if (Shiboken::Object::checkType(pyArg)) {
                Shiboken::Object::callCppDestructors((SbkObject*)pyArg);
            } else {
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");
            }

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbkshiboken2Module_delete_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbkshiboken2Module_dump(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2.dump";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: dump(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // dump(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbkshiboken2Module_dump_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dump(PyObject*)
            // Begin code injection
            if (!Shiboken::Object::checkType(pyArg)) {
                pyResult = Shiboken::String::fromCString("Ordinary Python type.");
            } else {
                std::string str = Shiboken::Object::info((SbkObject*)pyArg);
                pyResult = Shiboken::String::fromCString(str.c_str());
            }

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbkshiboken2Module_dump_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbkshiboken2Module_getAllValidWrappers(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2.getAllValidWrappers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getAllValidWrappers()
            // Begin code injection
            std::set<PyObject*> setAll = Shiboken::BindingManager::instance().getAllPyObjects();
            PyObject* listAll = PyList_New(0);
            if (listAll == NULL)
                return NULL;

            const std::set<PyObject*>::iterator end = setAll.end();
            for (std::set<PyObject*>::iterator iter = setAll.begin(); iter != end; ++iter) {
                if (*iter != NULL) {
                    if (PyList_Append(listAll, *iter) != 0) {
                        Py_DECREF(listAll);
                        return NULL;
                    }
                }
            }
            return listAll;

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbkshiboken2Module_getCppPointer(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2.getCppPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: getCppPointer(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // getCppPointer(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbkshiboken2Module_getCppPointer_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getCppPointer(PyObject*)
            // Begin code injection
            if (Shiboken::Object::checkType(pyArg)) {
                std::vector<void*> ptrs = Shiboken::Object::cppPointers((SbkObject*)pyArg);
                pyResult = PyTuple_New(ptrs.size());
                for (std::size_t i = 0; i < ptrs.size(); ++i)
                    PyTuple_SET_ITEM(pyResult, i, PyLong_FromVoidPtr(ptrs[i]));
            } else {
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");
            }

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbkshiboken2Module_getCppPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbkshiboken2Module_invalidate(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2.invalidate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: invalidate(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // invalidate(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbkshiboken2Module_invalidate_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // invalidate(PyObject*)
            // Begin code injection
            Shiboken::Object::invalidate(pyArg);

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbkshiboken2Module_invalidate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbkshiboken2Module_isValid(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2.isValid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: isValid(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // isValid(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbkshiboken2Module_isValid_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid(PyObject*)
            // Begin code injection
            bool isValid = Shiboken::Object::isValid(pyArg, false);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &isValid);

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbkshiboken2Module_isValid_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbkshiboken2Module_ownedByPython(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2.ownedByPython";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ownedByPython(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // ownedByPython(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbkshiboken2Module_ownedByPython_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ownedByPython(PyObject*)
            // Begin code injection
            if (Shiboken::Object::checkType(pyArg)) {
                bool hasOwnership = Shiboken::Object::hasOwnership((SbkObject*)pyArg);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &hasOwnership);
            } else {
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");
            }

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbkshiboken2Module_ownedByPython_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbkshiboken2Module_wrapInstance(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "shiboken2.wrapInstance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "wrapInstance", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: wrapInstance(size_t,PyType)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<size_t>(), (pyArgs[0])))
        && PyType_Check(pyArgs[1])) {
        overloadId = 0; // wrapInstance(size_t,PyType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbkshiboken2Module_wrapInstance_TypeError;

    // Call function/method
    {
        ::size_t cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // wrapInstance(size_t,PyType)
            // Begin code injection
            if (Shiboken::ObjectType::checkType((PyTypeObject*)pyArgs[1]))
                pyResult = Shiboken::Object::newObject((SbkObjectType*)pyArgs[1], (void*)cppArg0, false, true);
            else
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbkshiboken2Module_wrapInstance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static PyMethodDef shiboken2_methods[] = {
    {"_unpickle_enum", reinterpret_cast<PyCFunction>(Sbkshiboken2Module__unpickle_enum), METH_VARARGS},
    {"createdByPython", reinterpret_cast<PyCFunction>(Sbkshiboken2Module_createdByPython), METH_O},
    {"delete", reinterpret_cast<PyCFunction>(Sbkshiboken2Module_delete), METH_O},
    {"dump", reinterpret_cast<PyCFunction>(Sbkshiboken2Module_dump), METH_O},
    {"getAllValidWrappers", reinterpret_cast<PyCFunction>(Sbkshiboken2Module_getAllValidWrappers), METH_NOARGS},
    {"getCppPointer", reinterpret_cast<PyCFunction>(Sbkshiboken2Module_getCppPointer), METH_O},
    {"invalidate", reinterpret_cast<PyCFunction>(Sbkshiboken2Module_invalidate), METH_O},
    {"isValid", reinterpret_cast<PyCFunction>(Sbkshiboken2Module_isValid), METH_O},
    {"ownedByPython", reinterpret_cast<PyCFunction>(Sbkshiboken2Module_ownedByPython), METH_O},
    {"wrapInstance", reinterpret_cast<PyCFunction>(Sbkshiboken2Module_wrapInstance), METH_VARARGS},
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------


// Module initialization ------------------------------------------------------------
#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "shiboken2",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ shiboken2_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *shiboken2_SignatureStrings[] = {
    "shiboken2._unpickle_enum(arg__1:PyObject,arg__2:PyObject)->PyObject",
    "shiboken2.createdByPython(arg__1:PyObject)->bool",
    "shiboken2.delete(arg__1:PyObject)",
    "shiboken2.dump(arg__1:PyObject)->PyObject",
    "shiboken2.getAllValidWrappers()->PyObject",
    "shiboken2.getCppPointer(arg__1:PyObject)->PyObject",
    "shiboken2.invalidate(arg__1:PyObject)",
    "shiboken2.isValid(arg__1:PyObject)->bool",
    "shiboken2.ownedByPython(arg__1:PyObject)->bool",
    "shiboken2.wrapInstance(arg__1:size_t,arg__2:PyType)->PyObject",
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(shiboken2)
    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_shiboken2_CONVERTERS_IDX_COUNT];
    Sbkshiboken2TypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("shiboken2", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("shiboken2", shiboken2_methods);
#endif

    // Make module available from global scope
    Sbkshiboken2ModuleObject = module;

    // Initialize classes in the type system
    // Register primitive types converters.

    Shiboken::Module::registerTypeConverters(module, Sbkshiboken2TypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module shiboken2");
    }
    // Begin code injection
    // Add __version__ and __version_info__ attributes to the module
    PyObject* version = PyTuple_New(5);
    PyTuple_SET_ITEM(version, 0, PyInt_FromLong(SHIBOKEN_MAJOR_VERSION));
    PyTuple_SET_ITEM(version, 1, PyInt_FromLong(SHIBOKEN_MINOR_VERSION));
    PyTuple_SET_ITEM(version, 2, PyInt_FromLong(SHIBOKEN_MICRO_VERSION));
    PyTuple_SET_ITEM(version, 3, Shiboken::String::fromCString(SHIBOKEN_RELEASE_LEVEL));
    PyTuple_SET_ITEM(version, 4, PyInt_FromLong(SHIBOKEN_SERIAL));
    PyModule_AddObject(module, "__version_info__", version);
    PyModule_AddStringConstant(module, "__version__", SHIBOKEN_VERSION);

    VoidPtr::addVoidPtrToModule(module);

    // End of code injection

    FinishSignatureInitialization(module, shiboken2_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
