/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSANGLEInstancedArrays.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionDrawArraysInstancedANGLE(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionDrawElementsInstancedANGLE(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionVertexAttribDivisorANGLE(JSC::ExecState*);

class JSANGLEInstancedArraysPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSANGLEInstancedArraysPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSANGLEInstancedArraysPrototype* ptr = new (NotNull, JSC::allocateCell<JSANGLEInstancedArraysPrototype>(vm.heap)) JSANGLEInstancedArraysPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSANGLEInstancedArraysPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSANGLEInstancedArraysPrototypeTableValues[] =
{
    { "drawArraysInstancedANGLE", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsANGLEInstancedArraysPrototypeFunctionDrawArraysInstancedANGLE), (intptr_t) (4) } },
    { "drawElementsInstancedANGLE", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsANGLEInstancedArraysPrototypeFunctionDrawElementsInstancedANGLE), (intptr_t) (5) } },
    { "vertexAttribDivisorANGLE", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsANGLEInstancedArraysPrototypeFunctionVertexAttribDivisorANGLE), (intptr_t) (2) } },
    { "VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x88FE) } },
};

const ClassInfo JSANGLEInstancedArraysPrototype::s_info = { "ANGLEInstancedArraysPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSANGLEInstancedArraysPrototype) };

void JSANGLEInstancedArraysPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSANGLEInstancedArraysPrototypeTableValues, *this);
}

const ClassInfo JSANGLEInstancedArrays::s_info = { "ANGLEInstancedArrays", &Base::s_info, 0, CREATE_METHOD_TABLE(JSANGLEInstancedArrays) };

JSANGLEInstancedArrays::JSANGLEInstancedArrays(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ANGLEInstancedArrays>&& impl)
    : JSDOMWrapper<ANGLEInstancedArrays>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSANGLEInstancedArrays::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSANGLEInstancedArraysPrototype::create(vm, globalObject, JSANGLEInstancedArraysPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSANGLEInstancedArrays::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSANGLEInstancedArrays>(vm, globalObject);
}

void JSANGLEInstancedArrays::destroy(JSC::JSCell* cell)
{
    JSANGLEInstancedArrays* thisObject = static_cast<JSANGLEInstancedArrays*>(cell);
    thisObject->JSANGLEInstancedArrays::~JSANGLEInstancedArrays();
}

EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionDrawArraysInstancedANGLE(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSANGLEInstancedArrays*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "ANGLEInstancedArrays", "drawArraysInstancedANGLE");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSANGLEInstancedArrays::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    unsigned mode = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int first = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int count = toInt32(state, state->argument(2), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int primcount = toInt32(state, state->argument(3), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawArraysInstancedANGLE(mode, first, count, primcount);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionDrawElementsInstancedANGLE(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSANGLEInstancedArrays*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "ANGLEInstancedArrays", "drawElementsInstancedANGLE");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSANGLEInstancedArrays::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 5))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    unsigned mode = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int count = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned type = toUInt32(state, state->argument(2), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    long long offset = toInt64(state, state->argument(3), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int primcount = toInt32(state, state->argument(4), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawElementsInstancedANGLE(mode, count, type, offset, primcount);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionVertexAttribDivisorANGLE(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSANGLEInstancedArrays*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "ANGLEInstancedArrays", "vertexAttribDivisorANGLE");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSANGLEInstancedArrays::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned divisor = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.vertexAttribDivisorANGLE(index, divisor);
    return JSValue::encode(jsUndefined());
}

bool JSANGLEInstancedArraysOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsANGLEInstancedArrays = jsCast<JSANGLEInstancedArrays*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsANGLEInstancedArrays->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSANGLEInstancedArraysOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsANGLEInstancedArrays = jsCast<JSANGLEInstancedArrays*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsANGLEInstancedArrays->wrapped(), jsANGLEInstancedArrays);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ANGLEInstancedArrays@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20ANGLEInstancedArraysE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, ANGLEInstancedArrays* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSANGLEInstancedArrays>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, ANGLEInstancedArrays* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSANGLEInstancedArrays>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7ANGLEInstancedArrays@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore20ANGLEInstancedArraysE[2];
#if COMPILER(CLANG)
    // If this fails ANGLEInstancedArrays does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(ANGLEInstancedArrays), ANGLEInstancedArrays_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // ANGLEInstancedArrays has subclasses. If ANGLEInstancedArrays has subclasses that get passed
    // to toJS() we currently require ANGLEInstancedArrays you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSANGLEInstancedArrays>(globalObject, impl);
}

ANGLEInstancedArrays* JSANGLEInstancedArrays::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSANGLEInstancedArrays*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
