/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioContext.h"

#include "AnalyserNode.h"
#include "AudioBuffer.h"
#include "AudioBufferSourceNode.h"
#include "AudioDestinationNode.h"
#include "AudioListener.h"
#include "BiquadFilterNode.h"
#include "ChannelMergerNode.h"
#include "ChannelSplitterNode.h"
#include "ConvolverNode.h"
#include "DelayNode.h"
#include "DynamicsCompressorNode.h"
#include "ExceptionCode.h"
#include "GainNode.h"
#include "JSAnalyserNode.h"
#include "JSAudioBuffer.h"
#include "JSAudioBufferCallback.h"
#include "JSAudioBufferSourceNode.h"
#include "JSAudioDestinationNode.h"
#include "JSAudioListener.h"
#include "JSBiquadFilterNode.h"
#include "JSChannelMergerNode.h"
#include "JSChannelSplitterNode.h"
#include "JSConvolverNode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMPromise.h"
#include "JSDelayNode.h"
#include "JSDynamicsCompressorNode.h"
#include "JSEventListener.h"
#include "JSGainNode.h"
#include "JSHTMLMediaElement.h"
#include "JSMediaElementAudioSourceNode.h"
#include "JSOscillatorNode.h"
#include "JSPannerNode.h"
#include "JSPeriodicWave.h"
#include "JSScriptProcessorNode.h"
#include "JSWaveShaperNode.h"
#include "MediaElementAudioSourceNode.h"
#include "OscillatorNode.h"
#include "PannerNode.h"
#include "PeriodicWave.h"
#include "ScriptProcessorNode.h"
#include "WaveShaperNode.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionSuspend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionResume(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionDecodeAudioData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBufferSource(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateMediaElementSource(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateGain(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDelay(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBiquadFilter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateWaveShaper(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreatePanner(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateConvolver(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDynamicsCompressor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateAnalyser(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateScriptProcessor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateOscillator(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreatePeriodicWave(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelSplitter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelMerger(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionStartRendering(JSC::ExecState*);
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateGainNode(JSC::ExecState*);
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDelayNode(JSC::ExecState*);
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateJavaScriptNode(JSC::ExecState*);
#endif

// Attributes

JSC::EncodedJSValue jsAudioContextDestination(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextCurrentTime(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextSampleRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextListener(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextOnstatechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioContextOnstatechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioContextActiveSourceCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextOncomplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioContextOncomplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioContextConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioContextConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioContextPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSAudioContextPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioContextPrototype>(vm.heap)) JSAudioContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSAudioContext> JSAudioContextConstructor;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSAudioContextConstructor::construct(JSC::ExecState* state)
{
    return constructJSAudioContext(state);
}

template<> JSValue JSAudioContextConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSAudioContextConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioContext::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("webkitAudioContext"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSAudioContextConstructor::s_info = { "webkitAudioContext", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioContextConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioContextPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioContextConstructor) } },
    { "destination", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextDestination), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentTime", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextCurrentTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sampleRate", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextSampleRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "listener", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextListener), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "state", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onstatechange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextOnstatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioContextOnstatechange) } },
    { "activeSourceCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextActiveSourceCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "oncomplete", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextOncomplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioContextOncomplete) } },
    { "suspend", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionSuspend), (intptr_t) (0) } },
    { "resume", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionResume), (intptr_t) (0) } },
    { "close", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionClose), (intptr_t) (0) } },
    { "createBuffer", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateBuffer), (intptr_t) (3) } },
    { "decodeAudioData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionDecodeAudioData), (intptr_t) (2) } },
    { "createBufferSource", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateBufferSource), (intptr_t) (0) } },
    { "createMediaElementSource", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateMediaElementSource), (intptr_t) (1) } },
    { "createGain", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateGain), (intptr_t) (0) } },
    { "createDelay", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateDelay), (intptr_t) (0) } },
    { "createBiquadFilter", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateBiquadFilter), (intptr_t) (0) } },
    { "createWaveShaper", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateWaveShaper), (intptr_t) (0) } },
    { "createPanner", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreatePanner), (intptr_t) (0) } },
    { "createConvolver", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateConvolver), (intptr_t) (0) } },
    { "createDynamicsCompressor", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateDynamicsCompressor), (intptr_t) (0) } },
    { "createAnalyser", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateAnalyser), (intptr_t) (0) } },
    { "createScriptProcessor", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateScriptProcessor), (intptr_t) (1) } },
    { "createOscillator", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateOscillator), (intptr_t) (0) } },
    { "createPeriodicWave", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreatePeriodicWave), (intptr_t) (2) } },
    { "createChannelSplitter", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateChannelSplitter), (intptr_t) (0) } },
    { "createChannelMerger", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateChannelMerger), (intptr_t) (0) } },
    { "startRendering", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionStartRendering), (intptr_t) (0) } },
#if ENABLE(LEGACY_WEB_AUDIO)
    { "createGainNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateGainNode), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
    { "createDelayNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateDelayNode), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
    { "createJavaScriptNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateJavaScriptNode), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSAudioContextPrototype::s_info = { "webkitAudioContextPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioContextPrototype) };

void JSAudioContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioContextPrototypeTableValues, *this);
}

const ClassInfo JSAudioContext::s_info = { "webkitAudioContext", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioContext) };

JSAudioContext::JSAudioContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioContext>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSAudioContext::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSAudioContextPrototype::create(vm, globalObject, JSAudioContextPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSAudioContext::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioContext>(vm, globalObject);
}

EncodedJSValue jsAudioContextDestination(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioContext*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioContext", "destination");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.destination()));
    return JSValue::encode(result);
}


EncodedJSValue jsAudioContextCurrentTime(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioContext*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioContext", "currentTime");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.currentTime());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioContextSampleRate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioContext*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioContext", "sampleRate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.sampleRate());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioContextListener(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioContext*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioContext", "listener");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.listener()));
    return JSValue::encode(result);
}


EncodedJSValue jsAudioContextState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioContext*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioContext", "state");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.state());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioContextOnstatechange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioContext*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioContext", "onstatechange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().statechangeEvent));
}


EncodedJSValue jsAudioContextActiveSourceCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioContext*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioContext", "activeSourceCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.activeSourceCount());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioContextOncomplete(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioContext*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioContext", "oncomplete");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().completeEvent));
}


EncodedJSValue jsAudioContextConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSAudioContextPrototype* domObject = jsDynamicCast<JSAudioContextPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSAudioContext::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSAudioContextConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSAudioContextPrototype* domObject = jsDynamicCast<JSAudioContextPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSAudioContextOnstatechange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioContext* castedThis = jsDynamicCast<JSAudioContext*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioContext", "onstatechange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().statechangeEvent, value);
}


void setJSAudioContextOncomplete(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioContext* castedThis = jsDynamicCast<JSAudioContext*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioContext", "oncomplete");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().completeEvent, value);
}


JSValue JSAudioContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioContextConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

static inline EncodedJSValue jsAudioContextPrototypeFunctionSuspendPromise(ExecState*, JSPromiseDeferred*);
EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionSuspend(ExecState* state)
{
    return JSValue::encode(callPromiseFunction(*state, jsAudioContextPrototypeFunctionSuspendPromise));
}

static inline EncodedJSValue jsAudioContextPrototypeFunctionSuspendPromise(ExecState* state, JSPromiseDeferred* promiseDeferred)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "suspend");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    impl.suspend(DeferredWrapper(state, castedThis->globalObject(), promiseDeferred));
    return JSValue::encode(jsUndefined());
}

static inline EncodedJSValue jsAudioContextPrototypeFunctionResumePromise(ExecState*, JSPromiseDeferred*);
EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionResume(ExecState* state)
{
    return JSValue::encode(callPromiseFunction(*state, jsAudioContextPrototypeFunctionResumePromise));
}

static inline EncodedJSValue jsAudioContextPrototypeFunctionResumePromise(ExecState* state, JSPromiseDeferred* promiseDeferred)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "resume");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    impl.resume(DeferredWrapper(state, castedThis->globalObject(), promiseDeferred));
    return JSValue::encode(jsUndefined());
}

static inline EncodedJSValue jsAudioContextPrototypeFunctionClosePromise(ExecState*, JSPromiseDeferred*);
EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionClose(ExecState* state)
{
    return JSValue::encode(callPromiseFunction(*state, jsAudioContextPrototypeFunctionClosePromise));
}

static inline EncodedJSValue jsAudioContextPrototypeFunctionClosePromise(ExecState* state, JSPromiseDeferred* promiseDeferred)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "close");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    impl.close(DeferredWrapper(state, castedThis->globalObject(), promiseDeferred));
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBuffer1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createBuffer");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned numberOfChannels = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned numberOfFrames = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sampleRate = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createBuffer(numberOfChannels, numberOfFrames, sampleRate, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBuffer2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createBuffer");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    ArrayBuffer* buffer = toArrayBuffer(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool mixToMono = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createBuffer(buffer, mixToMono, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBuffer(ExecState* state)
{
    size_t argsCount = std::min<size_t>(3, state->argumentCount());
    if (argsCount == 3)
        return jsAudioContextPrototypeFunctionCreateBuffer1(state);
    JSValue arg0(state->argument(0));
    if ((argsCount == 2 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSArrayBuffer::info())))))
        return jsAudioContextPrototypeFunctionCreateBuffer2(state);
    if (argsCount < 2)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionDecodeAudioData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "decodeAudioData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    ArrayBuffer* audioData = toArrayBuffer(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!state->argument(1).isFunction())
        return throwArgumentMustBeFunctionError(*state, 1, "successCallback", "AudioContext", "decodeAudioData");
    RefPtr<AudioBufferCallback> successCallback = JSAudioBufferCallback::create(asObject(state->uncheckedArgument(1)), castedThis->globalObject());
    RefPtr<AudioBufferCallback> errorCallback;
    if (!state->argument(2).isUndefinedOrNull()) {
        if (!state->uncheckedArgument(2).isFunction())
            return throwArgumentMustBeFunctionError(*state, 2, "errorCallback", "AudioContext", "decodeAudioData");
        errorCallback = JSAudioBufferCallback::create(asObject(state->uncheckedArgument(2)), castedThis->globalObject());
    }
    impl.decodeAudioData(audioData, successCallback, errorCallback, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBufferSource(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createBufferSource");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createBufferSource()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateMediaElementSource(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createMediaElementSource");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLMediaElement* mediaElement = JSHTMLMediaElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createMediaElementSource(mediaElement, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateGain(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createGain");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createGain()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDelay(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createDelay");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createDelay(ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    double maxDelayTime = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createDelay(maxDelayTime, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBiquadFilter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createBiquadFilter");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createBiquadFilter()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateWaveShaper(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createWaveShaper");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createWaveShaper()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreatePanner(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createPanner");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createPanner()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateConvolver(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createConvolver");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createConvolver()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDynamicsCompressor(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createDynamicsCompressor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createDynamicsCompressor()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateAnalyser(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createAnalyser");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createAnalyser()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateScriptProcessor(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createScriptProcessor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned bufferSize = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createScriptProcessor(bufferSize, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    unsigned numberOfInputChannels = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 2) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createScriptProcessor(bufferSize, numberOfInputChannels, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    unsigned numberOfOutputChannels = toUInt32(state, state->argument(2), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createScriptProcessor(bufferSize, numberOfInputChannels, numberOfOutputChannels, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateOscillator(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createOscillator");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createOscillator()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreatePeriodicWave(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createPeriodicWave");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    RefPtr<Float32Array> real = toFloat32Array(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<Float32Array> imag = toFloat32Array(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createPeriodicWave(real.get(), imag.get(), ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelSplitter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createChannelSplitter");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createChannelSplitter(ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    unsigned numberOfOutputs = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createChannelSplitter(numberOfOutputs, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelMerger(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createChannelMerger");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createChannelMerger(ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    unsigned numberOfInputs = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createChannelMerger(numberOfInputs, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionStartRendering(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "startRendering");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    impl.startRendering();
    return JSValue::encode(jsUndefined());
}

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateGainNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createGainNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createGain()));
    return JSValue::encode(result);
}

#endif

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDelayNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createDelayNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createDelay(ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    double maxDelayTime = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createDelay(maxDelayTime, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateJavaScriptNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioContext", "createJavaScriptNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioContext::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned bufferSize = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createScriptProcessor(bufferSize, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    unsigned numberOfInputChannels = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 2) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createScriptProcessor(bufferSize, numberOfInputChannels, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    unsigned numberOfOutputChannels = toUInt32(state, state->argument(2), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createScriptProcessor(bufferSize, numberOfInputChannels, numberOfOutputChannels, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

#endif

void JSAudioContext::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAudioContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSAudioContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsAudioContext = jsCast<JSAudioContext*>(handle.slot()->asCell());
    if (jsAudioContext->wrapped().hasPendingActivity())
        return true;
    if (jsAudioContext->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSAudioContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioContext = jsCast<JSAudioContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioContext->wrapped(), jsAudioContext);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12AudioContextE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioContext* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSAudioContext>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioContext* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioContext>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AudioContext@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12AudioContextE[2];
#if COMPILER(CLANG)
    // If this fails AudioContext does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AudioContext), AudioContext_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AudioContext has subclasses. If AudioContext has subclasses that get passed
    // to toJS() we currently require AudioContext you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSAudioContext>(globalObject, impl);
}

AudioContext* JSAudioContext::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
