/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioParam.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetValueAtTime(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionLinearRampToValueAtTime(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionExponentialRampToValueAtTime(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetTargetAtTime(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetValueCurveAtTime(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionCancelScheduledValues(JSC::ExecState*);
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetTargetValueAtTime(JSC::ExecState*);
#endif

// Attributes

JSC::EncodedJSValue jsAudioParamValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioParamValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioParamMinValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioParamMaxValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioParamDefaultValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioParamName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioParamUnits(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioParamConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioParamConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioParamPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSAudioParamPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioParamPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioParamPrototype>(vm.heap)) JSAudioParamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioParamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSAudioParam> JSAudioParamConstructor;

template<> JSValue JSAudioParamConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAudioParamConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioParam::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("AudioParam"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSAudioParamConstructor::s_info = { "AudioParam", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioParamConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioParamPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioParamConstructor) } },
    { "value", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioParamValue) } },
    { "minValue", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamMinValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "maxValue", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamMaxValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultValue", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamDefaultValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "name", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "units", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamUnits), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setValueAtTime", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetValueAtTime), (intptr_t) (2) } },
    { "linearRampToValueAtTime", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionLinearRampToValueAtTime), (intptr_t) (2) } },
    { "exponentialRampToValueAtTime", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionExponentialRampToValueAtTime), (intptr_t) (2) } },
    { "setTargetAtTime", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetTargetAtTime), (intptr_t) (3) } },
    { "setValueCurveAtTime", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetValueCurveAtTime), (intptr_t) (3) } },
    { "cancelScheduledValues", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionCancelScheduledValues), (intptr_t) (1) } },
#if ENABLE(LEGACY_WEB_AUDIO)
    { "setTargetValueAtTime", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetTargetValueAtTime), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSAudioParamPrototype::s_info = { "AudioParamPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioParamPrototype) };

void JSAudioParamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioParamPrototypeTableValues, *this);
}

const ClassInfo JSAudioParam::s_info = { "AudioParam", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioParam) };

JSAudioParam::JSAudioParam(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioParam>&& impl)
    : JSDOMWrapper<AudioParam>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSAudioParam::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSAudioParamPrototype::create(vm, globalObject, JSAudioParamPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSAudioParam::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioParam>(vm, globalObject);
}

void JSAudioParam::destroy(JSC::JSCell* cell)
{
    JSAudioParam* thisObject = static_cast<JSAudioParam*>(cell);
    thisObject->JSAudioParam::~JSAudioParam();
}

EncodedJSValue jsAudioParamValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioParam*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioParam", "value");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.value());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioParamMinValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioParam*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioParam", "minValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.minValue());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioParamMaxValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioParam*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioParam", "maxValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.maxValue());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioParamDefaultValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioParam*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioParam", "defaultValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.defaultValue());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioParamName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioParam*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioParam", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.name());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioParamUnits(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioParam*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioParam", "units");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.units());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioParamConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSAudioParamPrototype* domObject = jsDynamicCast<JSAudioParamPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSAudioParam::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSAudioParamConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSAudioParamPrototype* domObject = jsDynamicCast<JSAudioParamPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSAudioParamValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioParam* castedThis = jsDynamicCast<JSAudioParam*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioParam", "value");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setValue(nativeValue);
}


JSValue JSAudioParam::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioParamConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetValueAtTime(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioParam*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioParam", "setValueAtTime");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioParam::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float value = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float time = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setValueAtTime(value, time);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionLinearRampToValueAtTime(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioParam*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioParam", "linearRampToValueAtTime");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioParam::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float value = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float time = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.linearRampToValueAtTime(value, time);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionExponentialRampToValueAtTime(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioParam*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioParam", "exponentialRampToValueAtTime");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioParam::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float value = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float time = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.exponentialRampToValueAtTime(value, time);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetTargetAtTime(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioParam*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioParam", "setTargetAtTime");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioParam::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float target = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float time = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float timeConstant = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setTargetAtTime(target, time, timeConstant);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetValueCurveAtTime(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioParam*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioParam", "setValueCurveAtTime");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioParam::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    RefPtr<Float32Array> values = toFloat32Array(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float time = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float duration = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setValueCurveAtTime(values.get(), time, duration);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionCancelScheduledValues(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioParam*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioParam", "cancelScheduledValues");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioParam::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float startTime = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.cancelScheduledValues(startTime);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetTargetValueAtTime(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioParam*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioParam", "setTargetValueAtTime");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioParam::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float targetValue = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float time = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float timeConstant = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setTargetAtTime(targetValue, time, timeConstant);
    return JSValue::encode(jsUndefined());
}

#endif

bool JSAudioParamOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSAudioParamOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioParam = jsCast<JSAudioParam*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioParam->wrapped(), jsAudioParam);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioParam@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10AudioParamE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioParam* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSAudioParam>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioParam* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioParam>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AudioParam@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10AudioParamE[2];
#if COMPILER(CLANG)
    // If this fails AudioParam does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AudioParam), AudioParam_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AudioParam has subclasses. If AudioParam has subclasses that get passed
    // to toJS() we currently require AudioParam you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSAudioParam>(globalObject, impl);
}

AudioParam* JSAudioParam::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioParam*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
