/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSKeyframeRule.h"

#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "StyleProperties.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsCSSKeyframeRuleKeyText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSKeyframeRuleKeyText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCSSKeyframeRuleStyle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSKeyframeRuleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSKeyframeRuleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCSSKeyframeRulePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCSSKeyframeRulePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSKeyframeRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSKeyframeRulePrototype>(vm.heap)) JSCSSKeyframeRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSKeyframeRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCSSKeyframeRule> JSCSSKeyframeRuleConstructor;

template<> JSValue JSCSSKeyframeRuleConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSRule::getConstructor(vm, &globalObject);
}

template<> void JSCSSKeyframeRuleConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSKeyframeRule::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CSSKeyframeRule"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCSSKeyframeRuleConstructor::s_info = { "CSSKeyframeRule", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSKeyframeRuleConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSKeyframeRulePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSKeyframeRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSKeyframeRuleConstructor) } },
    { "keyText", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSKeyframeRuleKeyText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSKeyframeRuleKeyText) } },
    { "style", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSKeyframeRuleStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSCSSKeyframeRulePrototype::s_info = { "CSSKeyframeRulePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSKeyframeRulePrototype) };

void JSCSSKeyframeRulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSKeyframeRulePrototypeTableValues, *this);
}

const ClassInfo JSCSSKeyframeRule::s_info = { "CSSKeyframeRule", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSKeyframeRule) };

JSCSSKeyframeRule::JSCSSKeyframeRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSKeyframeRule>&& impl)
    : JSCSSRule(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCSSKeyframeRule::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCSSKeyframeRulePrototype::create(vm, globalObject, JSCSSKeyframeRulePrototype::createStructure(vm, globalObject, JSCSSRule::getPrototype(vm, globalObject)));
}

JSObject* JSCSSKeyframeRule::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSKeyframeRule>(vm, globalObject);
}

EncodedJSValue jsCSSKeyframeRuleKeyText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSKeyframeRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSKeyframeRule", "keyText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.keyText());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSKeyframeRuleStyle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSKeyframeRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSKeyframeRule", "style");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.style()));
    return JSValue::encode(result);
}


EncodedJSValue jsCSSKeyframeRuleConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCSSKeyframeRulePrototype* domObject = jsDynamicCast<JSCSSKeyframeRulePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCSSKeyframeRule::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCSSKeyframeRuleConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCSSKeyframeRulePrototype* domObject = jsDynamicCast<JSCSSKeyframeRulePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSCSSKeyframeRuleKeyText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCSSKeyframeRule* castedThis = jsDynamicCast<JSCSSKeyframeRule*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CSSKeyframeRule", "keyText");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setKeyText(nativeValue);
}


JSValue JSCSSKeyframeRule::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSKeyframeRuleConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
