/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSChannelSplitterNode.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsChannelSplitterNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSChannelSplitterNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSChannelSplitterNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSChannelSplitterNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSChannelSplitterNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSChannelSplitterNodePrototype>(vm.heap)) JSChannelSplitterNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSChannelSplitterNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSChannelSplitterNode> JSChannelSplitterNodeConstructor;

template<> JSValue JSChannelSplitterNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSChannelSplitterNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSChannelSplitterNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ChannelSplitterNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSChannelSplitterNodeConstructor::s_info = { "ChannelSplitterNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSChannelSplitterNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSChannelSplitterNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsChannelSplitterNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSChannelSplitterNodeConstructor) } },
};

const ClassInfo JSChannelSplitterNodePrototype::s_info = { "ChannelSplitterNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSChannelSplitterNodePrototype) };

void JSChannelSplitterNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSChannelSplitterNodePrototypeTableValues, *this);
}

const ClassInfo JSChannelSplitterNode::s_info = { "ChannelSplitterNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSChannelSplitterNode) };

JSChannelSplitterNode::JSChannelSplitterNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ChannelSplitterNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSChannelSplitterNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSChannelSplitterNodePrototype::create(vm, globalObject, JSChannelSplitterNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSChannelSplitterNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSChannelSplitterNode>(vm, globalObject);
}

EncodedJSValue jsChannelSplitterNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSChannelSplitterNodePrototype* domObject = jsDynamicCast<JSChannelSplitterNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSChannelSplitterNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSChannelSplitterNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSChannelSplitterNodePrototype* domObject = jsDynamicCast<JSChannelSplitterNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSChannelSplitterNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSChannelSplitterNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSChannelSplitterNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSChannelSplitterNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ChannelSplitterNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19ChannelSplitterNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, ChannelSplitterNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSChannelSplitterNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, ChannelSplitterNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSChannelSplitterNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7ChannelSplitterNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore19ChannelSplitterNodeE[2];
#if COMPILER(CLANG)
    // If this fails ChannelSplitterNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(ChannelSplitterNode), ChannelSplitterNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // ChannelSplitterNode has subclasses. If ChannelSplitterNode has subclasses that get passed
    // to toJS() we currently require ChannelSplitterNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSChannelSplitterNode>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
