/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMimeTypeArray.h"

#include "DOMMimeType.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMMimeType.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMMimeTypeArrayPrototypeFunctionItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMimeTypeArrayPrototypeFunctionNamedItem(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDOMMimeTypeArrayLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMimeTypeArrayConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMMimeTypeArrayConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMMimeTypeArrayPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMMimeTypeArrayPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMMimeTypeArrayPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMMimeTypeArrayPrototype>(vm.heap)) JSDOMMimeTypeArrayPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMMimeTypeArrayPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSDOMMimeTypeArray> JSDOMMimeTypeArrayConstructor;

template<> JSValue JSDOMMimeTypeArrayConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMMimeTypeArrayConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMMimeTypeArray::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MimeTypeArray"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDOMMimeTypeArrayConstructor::s_info = { "MimeTypeArray", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMMimeTypeArrayConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMMimeTypeArrayPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeArrayConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMimeTypeArrayConstructor) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeArrayLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMMimeTypeArrayPrototypeFunctionItem), (intptr_t) (0) } },
    { "namedItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMMimeTypeArrayPrototypeFunctionNamedItem), (intptr_t) (0) } },
};

const ClassInfo JSDOMMimeTypeArrayPrototype::s_info = { "MimeTypeArrayPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMMimeTypeArrayPrototype) };

void JSDOMMimeTypeArrayPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMMimeTypeArrayPrototypeTableValues, *this);
}

const ClassInfo JSDOMMimeTypeArray::s_info = { "MimeTypeArray", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMMimeTypeArray) };

JSDOMMimeTypeArray::JSDOMMimeTypeArray(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMMimeTypeArray>&& impl)
    : JSDOMWrapper<DOMMimeTypeArray>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDOMMimeTypeArray::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDOMMimeTypeArrayPrototype::create(vm, globalObject, JSDOMMimeTypeArrayPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSDOMMimeTypeArray::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMMimeTypeArray>(vm, globalObject);
}

void JSDOMMimeTypeArray::destroy(JSC::JSCell* cell)
{
    JSDOMMimeTypeArray* thisObject = static_cast<JSDOMMimeTypeArray*>(cell);
    thisObject->JSDOMMimeTypeArray::~JSDOMMimeTypeArray();
}

bool JSDOMMimeTypeArray::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSDOMMimeTypeArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(proto)->hasProperty(state, propertyName))
        return false;

    if (!optionalIndex && thisObject->classInfo() == info()) {
        JSValue value;
        if (thisObject->nameGetter(state, propertyName, value)) {
            slot.setValue(thisObject, ReadOnly | DontDelete | DontEnum, value);
            return true;
        }
    }
    return false;
}

bool JSDOMMimeTypeArray::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSDOMMimeTypeArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsDOMMimeTypeArrayLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMMimeTypeArray*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMMimeTypeArray", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMMimeTypeArrayConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDOMMimeTypeArrayPrototype* domObject = jsDynamicCast<JSDOMMimeTypeArrayPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDOMMimeTypeArray::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDOMMimeTypeArrayConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDOMMimeTypeArrayPrototype* domObject = jsDynamicCast<JSDOMMimeTypeArrayPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSDOMMimeTypeArray::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSDOMMimeTypeArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    if (mode.includeDontEnumProperties()) {
        for (auto& propertyName : thisObject->wrapped().supportedPropertyNames())
            propertyNames.add(Identifier::fromString(state, propertyName));
    }
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSDOMMimeTypeArray::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMimeTypeArrayConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMMimeTypeArrayPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMMimeTypeArray*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMMimeTypeArray", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMMimeTypeArray::info());
    auto& impl = castedThis->wrapped();
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMMimeTypeArrayPrototypeFunctionNamedItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMMimeTypeArray*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMMimeTypeArray", "namedItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMMimeTypeArray::info());
    auto& impl = castedThis->wrapped();
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.namedItem(name)));
    return JSValue::encode(result);
}

bool JSDOMMimeTypeArrayOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsDOMMimeTypeArray = jsCast<JSDOMMimeTypeArray*>(handle.slot()->asCell());
    Frame* root = WTF::getPtr(jsDOMMimeTypeArray->wrapped().frame());
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSDOMMimeTypeArrayOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMMimeTypeArray = jsCast<JSDOMMimeTypeArray*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMMimeTypeArray->wrapped(), jsDOMMimeTypeArray);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMMimeTypeArray@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16DOMMimeTypeArrayE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMMimeTypeArray* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDOMMimeTypeArray>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMMimeTypeArray* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMMimeTypeArray>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DOMMimeTypeArray@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16DOMMimeTypeArrayE[2];
#if COMPILER(CLANG)
    // If this fails DOMMimeTypeArray does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DOMMimeTypeArray), DOMMimeTypeArray_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DOMMimeTypeArray has subclasses. If DOMMimeTypeArray has subclasses that get passed
    // to toJS() we currently require DOMMimeTypeArray you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSDOMMimeTypeArray>(globalObject, impl);
}

DOMMimeTypeArray* JSDOMMimeTypeArray::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMMimeTypeArray*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
