/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMURL.h"

#include "ExceptionCode.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMURL.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(MEDIA_SOURCE)
#include "DOMURLMediaSource.h"
#include "JSMediaSource.h"
#endif

#if ENABLE(MEDIA_STREAM)
#include "DOMURLMediaStream.h"
#include "JSMediaStream.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMURLConstructorFunctionCreateObjectURL(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMURLConstructorFunctionRevokeObjectURL(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMURLPrototypeFunctionToString(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDOMURLHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLOrigin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMURLProtocol(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLProtocol(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLUsername(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLUsername(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLPassword(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLPassword(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLHost(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLHost(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLHostname(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLHostname(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLPort(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLPort(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLPathname(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLPathname(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLSearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLSearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLHash(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLHash(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMURLConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMURLConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMURLPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMURLPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMURLPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMURLPrototype>(vm.heap)) JSDOMURLPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMURLPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSDOMURL> JSDOMURLConstructor;

/* Hash table for constructor */

static const HashTableValue JSDOMURLConstructorTableValues[] =
{
    { "createObjectURL", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMURLConstructorFunctionCreateObjectURL), (intptr_t) (1) } },
    { "revokeObjectURL", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMURLConstructorFunctionRevokeObjectURL), (intptr_t) (1) } },
};

static inline EncodedJSValue constructJSDOMURL1(ExecState* state)
{
    auto* castedThis = jsCast<JSDOMURLConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String url = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<DOMURL> object = DOMURL::create(url, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

static inline EncodedJSValue constructJSDOMURL2(ExecState* state)
{
    auto* castedThis = jsCast<JSDOMURLConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String url = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String base = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<DOMURL> object = DOMURL::create(url, base, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

static inline EncodedJSValue constructJSDOMURL3(ExecState* state)
{
    auto* castedThis = jsCast<JSDOMURLConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String url = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    DOMURL* base = JSDOMURL::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<DOMURL> object = DOMURL::create(url, base, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> EncodedJSValue JSC_HOST_CALL JSDOMURLConstructor::construct(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    if (argsCount == 1)
        return constructJSDOMURL1(state);
    if (argsCount == 2)
        return constructJSDOMURL2(state);
    JSValue arg1(state->argument(1));
    if ((argsCount == 2 && ((arg1.isObject() && asObject(arg1)->inherits(JSDOMURL::info())))))
        return constructJSDOMURL3(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

template<> JSValue JSDOMURLConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMURLConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMURL::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("URL"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSDOMURLConstructorTableValues, *this);
}

template<> const ClassInfo JSDOMURLConstructor::s_info = { "URL", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMURLConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMURLPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLConstructor) } },
    { "href", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLHref), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLHref) } },
    { "origin", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "protocol", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLProtocol), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLProtocol) } },
    { "username", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLUsername), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLUsername) } },
    { "password", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLPassword), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLPassword) } },
    { "host", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLHost), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLHost) } },
    { "hostname", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLHostname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLHostname) } },
    { "port", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLPort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLPort) } },
    { "pathname", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLPathname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLPathname) } },
    { "search", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLSearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLSearch) } },
    { "hash", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLHash), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMURLHash) } },
    { "toString", DontEnum | JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMURLPrototypeFunctionToString), (intptr_t) (0) } },
};

const ClassInfo JSDOMURLPrototype::s_info = { "URLPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMURLPrototype) };

void JSDOMURLPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMURLPrototypeTableValues, *this);
}

const ClassInfo JSDOMURL::s_info = { "URL", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMURL) };

JSDOMURL::JSDOMURL(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMURL>&& impl)
    : JSDOMWrapper<DOMURL>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDOMURL::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDOMURLPrototype::create(vm, globalObject, JSDOMURLPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSDOMURL::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMURL>(vm, globalObject);
}

void JSDOMURL::destroy(JSC::JSCell* cell)
{
    JSDOMURL* thisObject = static_cast<JSDOMURL*>(cell);
    thisObject->JSDOMURL::~JSDOMURL();
}

EncodedJSValue jsDOMURLHref(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "href");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.href());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLOrigin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "origin");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.origin());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLProtocol(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "protocol");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.protocol());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLUsername(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "username");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.username());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLPassword(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "password");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.password());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLHost(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "host");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.host());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLHostname(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "hostname");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.hostname());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLPort(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "port");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.port());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLPathname(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "pathname");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.pathname());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLSearch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "search");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.search());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLHash(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMURL*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMURL", "hash");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.hash());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMURLConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDOMURLPrototype* domObject = jsDynamicCast<JSDOMURLPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDOMURL::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDOMURLConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDOMURLPrototype* domObject = jsDynamicCast<JSDOMURLPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSDOMURLHref(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "href");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHref(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSDOMURLProtocol(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "protocol");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setProtocol(nativeValue);
}


void setJSDOMURLUsername(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "username");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setUsername(nativeValue);
}


void setJSDOMURLPassword(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "password");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPassword(nativeValue);
}


void setJSDOMURLHost(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "host");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHost(nativeValue);
}


void setJSDOMURLHostname(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "hostname");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHostname(nativeValue);
}


void setJSDOMURLPort(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "port");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPort(nativeValue);
}


void setJSDOMURLPathname(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "pathname");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPathname(nativeValue);
}


void setJSDOMURLSearch(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "search");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSearch(nativeValue);
}


void setJSDOMURLHash(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDOMURL* castedThis = jsDynamicCast<JSDOMURL*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DOMURL", "hash");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHash(nativeValue);
}


JSValue JSDOMURL::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMURLConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

static EncodedJSValue JSC_HOST_CALL jsDOMURLConstructorFunctionCreateObjectURL1(ExecState* state)
{
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob = JSBlob::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, DOMURL::createObjectURL(scriptContext, blob));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMURLConstructorFunctionRevokeObjectURL(ExecState* state)
{
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    String url = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    DOMURL::revokeObjectURL(scriptContext, url);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(MEDIA_SOURCE)
static EncodedJSValue JSC_HOST_CALL jsDOMURLConstructorFunctionCreateObjectURL2(ExecState* state)
{
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    MediaSource* source = JSMediaSource::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, WebCore::DOMURLMediaSource::createObjectURL(scriptContext, source));
    return JSValue::encode(result);
}

#endif

#if ENABLE(MEDIA_STREAM)
static EncodedJSValue JSC_HOST_CALL jsDOMURLConstructorFunctionCreateObjectURL3(ExecState* state)
{
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    MediaStream* stream = JSMediaStream::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, WebCore::DOMURLMediaStream::createObjectURL(scriptContext, stream));
    return JSValue::encode(result);
}

#endif

EncodedJSValue JSC_HOST_CALL jsDOMURLConstructorFunctionCreateObjectURL(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSBlob::info())))))
        return jsDOMURLConstructorFunctionCreateObjectURL1(state);
#if ENABLE(MEDIA_SOURCE)
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSMediaSource::info())))))
        return jsDOMURLConstructorFunctionCreateObjectURL2(state);
#endif

#if ENABLE(MEDIA_STREAM)
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSMediaStream::info())))))
        return jsDOMURLConstructorFunctionCreateObjectURL3(state);
#endif

    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsDOMURLPrototypeFunctionToString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMURL*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMURL", "toString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMURL::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.toString());
    return JSValue::encode(result);
}

bool JSDOMURLOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMURLOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMURL = jsCast<JSDOMURL*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMURL->wrapped(), jsDOMURL);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMURL* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDOMURL>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMURL* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMURL>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMURL.
    COMPILE_ASSERT(!__is_polymorphic(DOMURL), DOMURL_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSDOMURL>(globalObject, impl);
}

DOMURL* JSDOMURL::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMURL*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
