/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocumentType.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDocumentTypePrototypeFunctionBefore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentTypePrototypeFunctionAfter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentTypePrototypeFunctionReplaceWith(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentTypePrototypeFunctionRemove(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDocumentTypeName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentTypePublicId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentTypeSystemId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentTypeInternalSubset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentTypeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentTypeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDocumentTypePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDocumentTypePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDocumentTypePrototype* ptr = new (NotNull, JSC::allocateCell<JSDocumentTypePrototype>(vm.heap)) JSDocumentTypePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDocumentTypePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSDocumentType> JSDocumentTypeConstructor;

template<> JSValue JSDocumentTypeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSDocumentTypeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDocumentType::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("DocumentType"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDocumentTypeConstructor::s_info = { "DocumentType", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDocumentTypeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDocumentTypePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentTypeConstructor) } },
    { "name", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "publicId", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypePublicId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "systemId", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeSystemId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "internalSubset", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeInternalSubset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "before", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentTypePrototypeFunctionBefore), (intptr_t) (0) } },
    { "after", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentTypePrototypeFunctionAfter), (intptr_t) (0) } },
    { "replaceWith", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentTypePrototypeFunctionReplaceWith), (intptr_t) (0) } },
    { "remove", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentTypePrototypeFunctionRemove), (intptr_t) (0) } },
};

const ClassInfo JSDocumentTypePrototype::s_info = { "DocumentTypePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDocumentTypePrototype) };

void JSDocumentTypePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDocumentTypePrototypeTableValues, *this);
}

const ClassInfo JSDocumentType::s_info = { "DocumentType", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDocumentType) };

JSDocumentType::JSDocumentType(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DocumentType>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDocumentType::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDocumentTypePrototype::create(vm, globalObject, JSDocumentTypePrototype::createStructure(vm, globalObject, JSNode::getPrototype(vm, globalObject)));
}

JSObject* JSDocumentType::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDocumentType>(vm, globalObject);
}

EncodedJSValue jsDocumentTypeName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDocumentType*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DocumentType", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.name());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentTypePublicId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDocumentType*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DocumentType", "publicId");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.publicId());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentTypeSystemId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDocumentType*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DocumentType", "systemId");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.systemId());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentTypeInternalSubset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDocumentType*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DocumentType", "internalSubset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.internalSubset());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentTypeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDocumentTypePrototype* domObject = jsDynamicCast<JSDocumentTypePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDocumentType::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDocumentTypeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDocumentTypePrototype* domObject = jsDynamicCast<JSDocumentTypePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSDocumentType::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentTypeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDocumentTypePrototypeFunctionBefore(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDocumentType*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DocumentType", "before");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocumentType::info());
    return JSValue::encode(castedThis->before(*state));
}

EncodedJSValue JSC_HOST_CALL jsDocumentTypePrototypeFunctionAfter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDocumentType*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DocumentType", "after");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocumentType::info());
    return JSValue::encode(castedThis->after(*state));
}

EncodedJSValue JSC_HOST_CALL jsDocumentTypePrototypeFunctionReplaceWith(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDocumentType*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DocumentType", "replaceWith");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocumentType::info());
    return JSValue::encode(castedThis->replaceWith(*state));
}

EncodedJSValue JSC_HOST_CALL jsDocumentTypePrototypeFunctionRemove(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDocumentType*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DocumentType", "remove");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocumentType::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    impl.remove(ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

void JSDocumentType::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSDocumentType*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DocumentType@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12DocumentTypeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DocumentType* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDocumentType>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DocumentType* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDocumentType>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DocumentType@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12DocumentTypeE[2];
#if COMPILER(CLANG)
    // If this fails DocumentType does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DocumentType), DocumentType_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DocumentType has subclasses. If DocumentType has subclasses that get passed
    // to toJS() we currently require DocumentType you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSDocumentType>(globalObject, impl);
}

DocumentType* JSDocumentType::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDocumentType*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
