/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FETCH_API)

#include "JSFetchRequest.h"

#include "ExceptionCode.h"
#include "FetchHeaders.h"
#include "FetchRequest.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMPromise.h"
#include "JSFetchHeaders.h"
#include "JSFetchRequest.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(FETCH_API)
#include "Dictionary.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionClone(JSC::ExecState*);
#if ENABLE(FETCH_API)
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionArrayBuffer(JSC::ExecState*);
#endif
#if ENABLE(FETCH_API)
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionBlob(JSC::ExecState*);
#endif
#if ENABLE(FETCH_API)
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionFormData(JSC::ExecState*);
#endif
#if ENABLE(FETCH_API)
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionJson(JSC::ExecState*);
#endif
#if ENABLE(FETCH_API)
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionText(JSC::ExecState*);
#endif

// Attributes

JSC::EncodedJSValue jsFetchRequestMethod(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestUrl(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestHeaders(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestDestination(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestReferrer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestReferrerPolicy(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestCredentials(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestCache(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestRedirect(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestIntegrity(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(FETCH_API)
JSC::EncodedJSValue jsFetchRequestBodyUsed(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsFetchRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFetchRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSFetchRequestPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSFetchRequestPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFetchRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSFetchRequestPrototype>(vm.heap)) JSFetchRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFetchRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSFetchRequest> JSFetchRequestConstructor;

static inline EncodedJSValue constructJSFetchRequest1(ExecState* state)
{
    auto* castedThis = jsCast<JSFetchRequestConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    FetchRequest* input = JSFetchRequest::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Dictionary init = { state, state->argument(1) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "FetchRequest");
    RefPtr<FetchRequest> object = FetchRequest::create(*context, input, init, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

static inline EncodedJSValue constructJSFetchRequest2(ExecState* state)
{
    auto* castedThis = jsCast<JSFetchRequestConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String input = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Dictionary init = { state, state->argument(1) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "FetchRequest");
    RefPtr<FetchRequest> object = FetchRequest::create(*context, input, init, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> EncodedJSValue JSC_HOST_CALL JSFetchRequestConstructor::construct(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSFetchRequest::info())))) || (argsCount == 2 && ((arg0.isObject() && asObject(arg0)->inherits(JSFetchRequest::info())))))
        return constructJSFetchRequest1(state);
    if (argsCount == 1 || argsCount == 2)
        return constructJSFetchRequest2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

template<> JSValue JSFetchRequestConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFetchRequestConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFetchRequest::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Request"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
}

template<> const ClassInfo JSFetchRequestConstructor::s_info = { "Request", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFetchRequestConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFetchRequestPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFetchRequestConstructor) } },
    { "method", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestMethod), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "url", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestUrl), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "headers", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestHeaders), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "destination", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestDestination), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "referrer", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestReferrer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "referrerPolicy", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestReferrerPolicy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "mode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "credentials", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestCredentials), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "cache", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestCache), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirect", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestRedirect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "integrity", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestIntegrity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(FETCH_API)
    { "bodyUsed", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestBodyUsed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "clone", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchRequestPrototypeFunctionClone), (intptr_t) (0) } },
#if ENABLE(FETCH_API)
    { "arrayBuffer", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchRequestPrototypeFunctionArrayBuffer), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FETCH_API)
    { "blob", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchRequestPrototypeFunctionBlob), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FETCH_API)
    { "formData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchRequestPrototypeFunctionFormData), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FETCH_API)
    { "json", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchRequestPrototypeFunctionJson), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FETCH_API)
    { "text", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchRequestPrototypeFunctionText), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSFetchRequestPrototype::s_info = { "RequestPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFetchRequestPrototype) };

void JSFetchRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFetchRequestPrototypeTableValues, *this);
}

const ClassInfo JSFetchRequest::s_info = { "Request", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFetchRequest) };

JSFetchRequest::JSFetchRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FetchRequest>&& impl)
    : JSDOMWrapper<FetchRequest>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSFetchRequest::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSFetchRequestPrototype::create(vm, globalObject, JSFetchRequestPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSFetchRequest::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFetchRequest>(vm, globalObject);
}

void JSFetchRequest::destroy(JSC::JSCell* cell)
{
    JSFetchRequest* thisObject = static_cast<JSFetchRequest*>(cell);
    thisObject->JSFetchRequest::~JSFetchRequest();
}

EncodedJSValue jsFetchRequestMethod(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "method");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.method());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestUrl(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "url");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.url());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestHeaders(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "headers");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.headers()));
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestDestination(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "destination");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.destination());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestReferrer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "referrer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.referrer());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestReferrerPolicy(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "referrerPolicy");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.referrerPolicy());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "mode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.mode());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestCredentials(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "credentials");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.credentials());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestCache(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "cache");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.cache());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestRedirect(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "redirect");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.redirect());
    return JSValue::encode(result);
}


EncodedJSValue jsFetchRequestIntegrity(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "integrity");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.integrity());
    return JSValue::encode(result);
}


#if ENABLE(FETCH_API)
EncodedJSValue jsFetchRequestBodyUsed(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFetchRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FetchRequest", "bodyUsed");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.isDisturbed());
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsFetchRequestConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSFetchRequestPrototype* domObject = jsDynamicCast<JSFetchRequestPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSFetchRequest::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSFetchRequestConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSFetchRequestPrototype* domObject = jsDynamicCast<JSFetchRequestPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSFetchRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFetchRequestConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionClone(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchRequest", "clone");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchRequest::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.clone(ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

#if ENABLE(FETCH_API)
static inline EncodedJSValue jsFetchRequestPrototypeFunctionArrayBufferPromise(ExecState*, JSPromiseDeferred*);
EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionArrayBuffer(ExecState* state)
{
    return JSValue::encode(callPromiseFunction(*state, jsFetchRequestPrototypeFunctionArrayBufferPromise));
}

static inline EncodedJSValue jsFetchRequestPrototypeFunctionArrayBufferPromise(ExecState* state, JSPromiseDeferred* promiseDeferred)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchRequest", "arrayBuffer");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchRequest::info());
    auto& impl = castedThis->wrapped();
    impl.arrayBuffer(DeferredWrapper(state, castedThis->globalObject(), promiseDeferred));
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(FETCH_API)
static inline EncodedJSValue jsFetchRequestPrototypeFunctionBlobPromise(ExecState*, JSPromiseDeferred*);
EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionBlob(ExecState* state)
{
    return JSValue::encode(callPromiseFunction(*state, jsFetchRequestPrototypeFunctionBlobPromise));
}

static inline EncodedJSValue jsFetchRequestPrototypeFunctionBlobPromise(ExecState* state, JSPromiseDeferred* promiseDeferred)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchRequest", "blob");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchRequest::info());
    auto& impl = castedThis->wrapped();
    impl.blob(DeferredWrapper(state, castedThis->globalObject(), promiseDeferred));
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(FETCH_API)
static inline EncodedJSValue jsFetchRequestPrototypeFunctionFormDataPromise(ExecState*, JSPromiseDeferred*);
EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionFormData(ExecState* state)
{
    return JSValue::encode(callPromiseFunction(*state, jsFetchRequestPrototypeFunctionFormDataPromise));
}

static inline EncodedJSValue jsFetchRequestPrototypeFunctionFormDataPromise(ExecState* state, JSPromiseDeferred* promiseDeferred)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchRequest", "formData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchRequest::info());
    auto& impl = castedThis->wrapped();
    impl.formData(DeferredWrapper(state, castedThis->globalObject(), promiseDeferred));
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(FETCH_API)
static inline EncodedJSValue jsFetchRequestPrototypeFunctionJsonPromise(ExecState*, JSPromiseDeferred*);
EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionJson(ExecState* state)
{
    return JSValue::encode(callPromiseFunction(*state, jsFetchRequestPrototypeFunctionJsonPromise));
}

static inline EncodedJSValue jsFetchRequestPrototypeFunctionJsonPromise(ExecState* state, JSPromiseDeferred* promiseDeferred)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchRequest", "json");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchRequest::info());
    auto& impl = castedThis->wrapped();
    impl.json(*state, DeferredWrapper(state, castedThis->globalObject(), promiseDeferred));
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(FETCH_API)
static inline EncodedJSValue jsFetchRequestPrototypeFunctionTextPromise(ExecState*, JSPromiseDeferred*);
EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionText(ExecState* state)
{
    return JSValue::encode(callPromiseFunction(*state, jsFetchRequestPrototypeFunctionTextPromise));
}

static inline EncodedJSValue jsFetchRequestPrototypeFunctionTextPromise(ExecState* state, JSPromiseDeferred* promiseDeferred)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchRequest", "text");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchRequest::info());
    auto& impl = castedThis->wrapped();
    impl.text(DeferredWrapper(state, castedThis->globalObject(), promiseDeferred));
    return JSValue::encode(jsUndefined());
}

#endif

bool JSFetchRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSFetchRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFetchRequest = jsCast<JSFetchRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFetchRequest->wrapped(), jsFetchRequest);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, FetchRequest* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSFetchRequest>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, FetchRequest* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFetchRequest>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to FetchRequest.
    COMPILE_ASSERT(!__is_polymorphic(FetchRequest), FetchRequest_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSFetchRequest>(globalObject, impl);
}

FetchRequest* JSFetchRequest::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFetchRequest*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(FETCH_API)
