/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATALIST_ELEMENT)

#include "JSHTMLDataListElement.h"

#include "HTMLCollection.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSHTMLCollection.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLDataListElementOptions(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLDataListElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDataListElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLDataListElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLDataListElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLDataListElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLDataListElementPrototype>(vm.heap)) JSHTMLDataListElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLDataListElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLDataListElement> JSHTMLDataListElementConstructor;

template<> JSValue JSHTMLDataListElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLDataListElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLDataListElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLDataListElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLDataListElementConstructor::s_info = { "HTMLDataListElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLDataListElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLDataListElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataListElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDataListElementConstructor) } },
    { "options", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataListElementOptions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSHTMLDataListElementPrototype::s_info = { "HTMLDataListElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLDataListElementPrototype) };

void JSHTMLDataListElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLDataListElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLDataListElement::s_info = { "HTMLDataListElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLDataListElement) };

JSHTMLDataListElement::JSHTMLDataListElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLDataListElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLDataListElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLDataListElementPrototype::create(vm, globalObject, JSHTMLDataListElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLDataListElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDataListElement>(vm, globalObject);
}

EncodedJSValue jsHTMLDataListElementOptions(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDataListElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDataListElement", "options");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.options()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDataListElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLDataListElementPrototype* domObject = jsDynamicCast<JSHTMLDataListElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLDataListElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLDataListElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLDataListElementPrototype* domObject = jsDynamicCast<JSHTMLDataListElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSHTMLDataListElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDataListElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLDataListElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLDataListElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}

#endif // ENABLE(DATALIST_ELEMENT)
