/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLObjectElement.h"

#include "Document.h"
#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDocument.h"
#include "JSHTMLFormElement.h"
#include "JSSVGDocument.h"
#include "JSValidityState.h"
#include "SVGDocument.h"
#include "URL.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionCheckValidity(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionSetCustomValidity(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionGetSVGDocument(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsHTMLObjectElementForm(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLObjectElementCode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementCode(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementAlign(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementAlign(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementArchive(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementArchive(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementBorder(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementBorder(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementCodeBase(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementCodeBase(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementCodeType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementCodeType(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementData(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementData(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementDeclare(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementDeclare(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementHspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementHspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementStandby(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementStandby(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementType(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementUseMap(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementUseMap(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementVspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementVspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLObjectElementWillValidate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLObjectElementValidity(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLObjectElementValidationMessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLObjectElementContentDocument(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLObjectElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLObjectElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLObjectElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLObjectElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLObjectElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLObjectElementPrototype>(vm.heap)) JSHTMLObjectElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLObjectElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLObjectElement> JSHTMLObjectElementConstructor;

template<> JSValue JSHTMLObjectElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLObjectElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLObjectElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLObjectElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLObjectElementConstructor::s_info = { "HTMLObjectElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLObjectElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLObjectElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementConstructor) } },
    { "form", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementForm), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "code", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementCode) } },
    { "align", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementAlign), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementAlign) } },
    { "archive", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementArchive), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementArchive) } },
    { "border", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementBorder), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementBorder) } },
    { "codeBase", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementCodeBase), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementCodeBase) } },
    { "codeType", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementCodeType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementCodeType) } },
    { "data", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementData), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementData) } },
    { "declare", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementDeclare), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementDeclare) } },
    { "height", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementHeight) } },
    { "hspace", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementHspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementHspace) } },
    { "name", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementName) } },
    { "standby", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementStandby), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementStandby) } },
    { "type", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementType) } },
    { "useMap", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementUseMap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementUseMap) } },
    { "vspace", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementVspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementVspace) } },
    { "width", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLObjectElementWidth) } },
    { "willValidate", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementWillValidate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validity", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementValidity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validationMessage", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementValidationMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "contentDocument", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementContentDocument), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "checkValidity", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLObjectElementPrototypeFunctionCheckValidity), (intptr_t) (0) } },
    { "setCustomValidity", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLObjectElementPrototypeFunctionSetCustomValidity), (intptr_t) (1) } },
    { "getSVGDocument", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLObjectElementPrototypeFunctionGetSVGDocument), (intptr_t) (0) } },
};

const ClassInfo JSHTMLObjectElementPrototype::s_info = { "HTMLObjectElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLObjectElementPrototype) };

void JSHTMLObjectElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLObjectElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLObjectElement::s_info = { "HTMLObjectElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLObjectElement) };

JSHTMLObjectElement::JSHTMLObjectElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLObjectElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLObjectElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLObjectElementPrototype::create(vm, globalObject, JSHTMLObjectElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLObjectElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLObjectElement>(vm, globalObject);
}

bool JSHTMLObjectElement::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLObjectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSHTMLObjectElement::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLObjectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsHTMLObjectElementForm(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "form");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.form()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementCode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "code");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::codeAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementAlign(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "align");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementArchive(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "archive");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::archiveAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementBorder(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "border");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::borderAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementCodeBase(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "codeBase");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::codebaseAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementCodeType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "codeType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::codetypeAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementData(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "data");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getURLAttribute(WebCore::HTMLNames::dataAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementDeclare(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "declare");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::declareAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "height");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementHspace(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "hspace");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.getIntegralAttribute(WebCore::HTMLNames::hspaceAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getNameAttribute());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementStandby(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "standby");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::standbyAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::typeAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementUseMap(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "useMap");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::usemapAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementVspace(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "vspace");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.getIntegralAttribute(WebCore::HTMLNames::vspaceAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "width");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementWillValidate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "willValidate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.willValidate());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementValidity(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "validity");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.validity()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementValidationMessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "validationMessage");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.validationMessage());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLObjectElementContentDocument(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLObjectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLObjectElement", "contentDocument");
    }
    auto& impl = castedThis->wrapped();
    return JSValue::encode(shouldAllowAccessToNode(state, impl.contentDocument()) ? toJS(state, castedThis->globalObject(), WTF::getPtr(impl.contentDocument())) : jsNull());
}


EncodedJSValue jsHTMLObjectElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLObjectElementPrototype* domObject = jsDynamicCast<JSHTMLObjectElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLObjectElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLObjectElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLObjectElementPrototype* domObject = jsDynamicCast<JSHTMLObjectElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSHTMLObjectElement::put(JSCell* cell, ExecState* state, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::put(thisObject, state, propertyName, value, slot);
}

void JSHTMLObjectElement::putByIndex(JSCell* cell, ExecState* state, unsigned index, JSValue value, bool shouldThrow)
{
    auto* thisObject = jsCast<JSHTMLObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    PutPropertySlot slot(thisObject, shouldThrow);
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::putByIndex(cell, state, index, value, shouldThrow);
}

void setJSHTMLObjectElementCode(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "code");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::codeAttr, nativeValue);
}


void setJSHTMLObjectElementAlign(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "align");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::alignAttr, nativeValue);
}


void setJSHTMLObjectElementArchive(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "archive");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::archiveAttr, nativeValue);
}


void setJSHTMLObjectElementBorder(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "border");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::borderAttr, nativeValue);
}


void setJSHTMLObjectElementCodeBase(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "codeBase");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::codebaseAttr, nativeValue);
}


void setJSHTMLObjectElementCodeType(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "codeType");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::codetypeAttr, nativeValue);
}


void setJSHTMLObjectElementData(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "data");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::dataAttr, nativeValue);
}


void setJSHTMLObjectElementDeclare(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "declare");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::declareAttr, nativeValue);
}


void setJSHTMLObjectElementHeight(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "height");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::heightAttr, nativeValue);
}


void setJSHTMLObjectElementHspace(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "hspace");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setIntegralAttribute(WebCore::HTMLNames::hspaceAttr, nativeValue);
}


void setJSHTMLObjectElementName(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "name");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, nativeValue);
}


void setJSHTMLObjectElementStandby(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "standby");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::standbyAttr, nativeValue);
}


void setJSHTMLObjectElementType(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "type");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::typeAttr, nativeValue);
}


void setJSHTMLObjectElementUseMap(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "useMap");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::usemapAttr, nativeValue);
}


void setJSHTMLObjectElementVspace(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "vspace");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setIntegralAttribute(WebCore::HTMLNames::vspaceAttr, nativeValue);
}


void setJSHTMLObjectElementWidth(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLObjectElement* castedThis = jsDynamicCast<JSHTMLObjectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLObjectElement", "width");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::widthAttr, nativeValue);
}


JSValue JSHTMLObjectElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLObjectElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionCheckValidity(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLObjectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLObjectElement", "checkValidity");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLObjectElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionSetCustomValidity(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLObjectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLObjectElement", "setCustomValidity");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLObjectElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String error = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionGetSVGDocument(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLObjectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLObjectElement", "getSVGDocument");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLObjectElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    if (!shouldAllowAccessToNode(state, impl.getSVGDocument(ec)))
        return JSValue::encode(jsNull());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getSVGDocument(ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSHTMLObjectElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
