/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHistory.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionPushState(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionReplaceState(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsHistoryLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHistoryState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHistoryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHistoryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHistoryPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHistoryPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHistoryPrototype* ptr = new (NotNull, JSC::allocateCell<JSHistoryPrototype>(vm.heap)) JSHistoryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHistoryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHistory> JSHistoryConstructor;

template<> JSValue JSHistoryConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSHistoryConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHistory::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("History"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHistoryConstructor::s_info = { "History", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHistoryConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHistoryPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHistoryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHistoryConstructor) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHistoryLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "state", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHistoryState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "back", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionBack), (intptr_t) (0) } },
    { "forward", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionForward), (intptr_t) (0) } },
    { "go", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionGo), (intptr_t) (0) } },
    { "pushState", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionPushState), (intptr_t) (2) } },
    { "replaceState", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionReplaceState), (intptr_t) (2) } },
};

const ClassInfo JSHistoryPrototype::s_info = { "HistoryPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHistoryPrototype) };

void JSHistoryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHistoryPrototypeTableValues, *this);
}

const ClassInfo JSHistory::s_info = { "History", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHistory) };

JSHistory::JSHistory(Structure* structure, JSDOMGlobalObject& globalObject, Ref<History>&& impl)
    : JSDOMWrapper<History>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHistory::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHistoryPrototype::create(vm, globalObject, JSHistoryPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSHistory::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHistory>(vm, globalObject);
}

void JSHistory::destroy(JSC::JSCell* cell)
{
    JSHistory* thisObject = static_cast<JSHistory*>(cell);
    thisObject->JSHistory::~JSHistory();
}

EncodedJSValue jsHistoryLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHistory*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "History", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsHistoryState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHistory*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "History", "state");
    }
    return JSValue::encode(castedThis->state(*state));
}


EncodedJSValue jsHistoryConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHistoryPrototype* domObject = jsDynamicCast<JSHistoryPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHistory::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHistoryConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHistoryPrototype* domObject = jsDynamicCast<JSHistoryPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSHistory::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHistoryConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionBack(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHistory*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "History", "back");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHistory::info());
    auto& impl = castedThis->wrapped();
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    impl.back(scriptContext);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionForward(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHistory*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "History", "forward");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHistory::info());
    auto& impl = castedThis->wrapped();
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    impl.forward(scriptContext);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionGo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHistory*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "History", "go");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHistory::info());
    auto& impl = castedThis->wrapped();
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    int distance = toInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.go(scriptContext, distance);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionPushState(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHistory*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "History", "pushState");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHistory::info());
    return JSValue::encode(castedThis->pushState(*state));
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionReplaceState(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHistory*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "History", "replaceState");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHistory::info());
    return JSValue::encode(castedThis->replaceState(*state));
}

void JSHistory::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHistory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(&thisObject->m_state);
}

bool JSHistoryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsHistory = jsCast<JSHistory*>(handle.slot()->asCell());
    Frame* root = WTF::getPtr(jsHistory->wrapped().frame());
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSHistoryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHistory = jsCast<JSHistory*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHistory->wrapped(), jsHistory);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7History@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7HistoryE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, History* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSHistory>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, History* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSHistory>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7History@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore7HistoryE[2];
#if COMPILER(CLANG)
    // If this fails History does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(History), History_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // History has subclasses. If History has subclasses that get passed
    // to toJS() we currently require History you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSHistory>(globalObject, impl);
}

History* JSHistory::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHistory*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
