/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSPannerNode.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetPosition(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetOrientation(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetVelocity(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsPannerNodePanningModel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPannerNodePanningModel(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeDistanceModel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPannerNodeDistanceModel(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeRefDistance(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPannerNodeRefDistance(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeMaxDistance(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPannerNodeMaxDistance(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeRolloffFactor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPannerNodeRolloffFactor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeConeInnerAngle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPannerNodeConeInnerAngle(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeConeOuterAngle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPannerNodeConeOuterAngle(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeConeOuterGain(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPannerNodeConeOuterGain(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPannerNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPannerNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSPannerNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPannerNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSPannerNodePrototype>(vm.heap)) JSPannerNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPannerNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSPannerNode> JSPannerNodeConstructor;

/* Hash table for constructor */

static const HashTableValue JSPannerNodeConstructorTableValues[] =
{
    { "EQUALPOWER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "HRTF", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SOUNDFIELD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "LINEAR_DISTANCE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "INVERSE_DISTANCE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "EXPONENTIAL_DISTANCE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
};


COMPILE_ASSERT(0 == PannerNode::EQUALPOWER, PannerNodeEnumEQUALPOWERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == PannerNode::HRTF, PannerNodeEnumHRTFIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == PannerNode::SOUNDFIELD, PannerNodeEnumSOUNDFIELDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == PannerNode::LINEAR_DISTANCE, PannerNodeEnumLINEAR_DISTANCEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == PannerNode::INVERSE_DISTANCE, PannerNodeEnumINVERSE_DISTANCEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == PannerNode::EXPONENTIAL_DISTANCE, PannerNodeEnumEXPONENTIAL_DISTANCEIsWrongUseDoNotCheckConstants);

template<> JSValue JSPannerNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSPannerNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPannerNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("webkitAudioPannerNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSPannerNodeConstructorTableValues, *this);
}

template<> const ClassInfo JSPannerNodeConstructor::s_info = { "webkitAudioPannerNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPannerNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPannerNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeConstructor) } },
    { "panningModel", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodePanningModel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodePanningModel) } },
    { "distanceModel", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeDistanceModel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeDistanceModel) } },
    { "refDistance", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeRefDistance), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeRefDistance) } },
    { "maxDistance", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeMaxDistance), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeMaxDistance) } },
    { "rolloffFactor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeRolloffFactor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeRolloffFactor) } },
    { "coneInnerAngle", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeConeInnerAngle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeConeInnerAngle) } },
    { "coneOuterAngle", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeConeOuterAngle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeConeOuterAngle) } },
    { "coneOuterGain", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeConeOuterGain), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeConeOuterGain) } },
    { "setPosition", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsPannerNodePrototypeFunctionSetPosition), (intptr_t) (3) } },
    { "setOrientation", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsPannerNodePrototypeFunctionSetOrientation), (intptr_t) (3) } },
    { "setVelocity", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsPannerNodePrototypeFunctionSetVelocity), (intptr_t) (3) } },
    { "EQUALPOWER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "HRTF", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SOUNDFIELD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "LINEAR_DISTANCE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "INVERSE_DISTANCE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "EXPONENTIAL_DISTANCE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

const ClassInfo JSPannerNodePrototype::s_info = { "webkitAudioPannerNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPannerNodePrototype) };

void JSPannerNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPannerNodePrototypeTableValues, *this);
}

const ClassInfo JSPannerNode::s_info = { "webkitAudioPannerNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPannerNode) };

JSPannerNode::JSPannerNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PannerNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSPannerNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSPannerNodePrototype::create(vm, globalObject, JSPannerNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSPannerNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPannerNode>(vm, globalObject);
}

EncodedJSValue jsPannerNodePanningModel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPannerNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PannerNode", "panningModel");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.panningModel());
    return JSValue::encode(result);
}


EncodedJSValue jsPannerNodeDistanceModel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPannerNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PannerNode", "distanceModel");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.distanceModel());
    return JSValue::encode(result);
}


EncodedJSValue jsPannerNodeRefDistance(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPannerNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PannerNode", "refDistance");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.refDistance());
    return JSValue::encode(result);
}


EncodedJSValue jsPannerNodeMaxDistance(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPannerNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PannerNode", "maxDistance");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.maxDistance());
    return JSValue::encode(result);
}


EncodedJSValue jsPannerNodeRolloffFactor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPannerNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PannerNode", "rolloffFactor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.rolloffFactor());
    return JSValue::encode(result);
}


EncodedJSValue jsPannerNodeConeInnerAngle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPannerNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PannerNode", "coneInnerAngle");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.coneInnerAngle());
    return JSValue::encode(result);
}


EncodedJSValue jsPannerNodeConeOuterAngle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPannerNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PannerNode", "coneOuterAngle");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.coneOuterAngle());
    return JSValue::encode(result);
}


EncodedJSValue jsPannerNodeConeOuterGain(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPannerNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PannerNode", "coneOuterGain");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.coneOuterGain());
    return JSValue::encode(result);
}


EncodedJSValue jsPannerNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSPannerNodePrototype* domObject = jsDynamicCast<JSPannerNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSPannerNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSPannerNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSPannerNodePrototype* domObject = jsDynamicCast<JSPannerNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSPannerNodePanningModel(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSPannerNode* castedThis = jsDynamicCast<JSPannerNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "PannerNode", "panningModel");
        return;
    }
    castedThis->setPanningModel(*state, value);
}


void setJSPannerNodeDistanceModel(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSPannerNode* castedThis = jsDynamicCast<JSPannerNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "PannerNode", "distanceModel");
        return;
    }
    castedThis->setDistanceModel(*state, value);
}


void setJSPannerNodeRefDistance(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSPannerNode* castedThis = jsDynamicCast<JSPannerNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "PannerNode", "refDistance");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setRefDistance(nativeValue);
}


void setJSPannerNodeMaxDistance(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSPannerNode* castedThis = jsDynamicCast<JSPannerNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "PannerNode", "maxDistance");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMaxDistance(nativeValue);
}


void setJSPannerNodeRolloffFactor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSPannerNode* castedThis = jsDynamicCast<JSPannerNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "PannerNode", "rolloffFactor");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setRolloffFactor(nativeValue);
}


void setJSPannerNodeConeInnerAngle(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSPannerNode* castedThis = jsDynamicCast<JSPannerNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "PannerNode", "coneInnerAngle");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setConeInnerAngle(nativeValue);
}


void setJSPannerNodeConeOuterAngle(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSPannerNode* castedThis = jsDynamicCast<JSPannerNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "PannerNode", "coneOuterAngle");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setConeOuterAngle(nativeValue);
}


void setJSPannerNodeConeOuterGain(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSPannerNode* castedThis = jsDynamicCast<JSPannerNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "PannerNode", "coneOuterGain");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setConeOuterGain(nativeValue);
}


JSValue JSPannerNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPannerNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetPosition(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSPannerNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "PannerNode", "setPosition");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSPannerNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float z = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setPosition(x, y, z);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetOrientation(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSPannerNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "PannerNode", "setOrientation");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSPannerNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float z = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setOrientation(x, y, z);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetVelocity(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSPannerNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "PannerNode", "setVelocity");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSPannerNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float z = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setVelocity(x, y, z);
    return JSValue::encode(jsUndefined());
}

void JSPannerNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPannerNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PannerNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10PannerNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, PannerNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSPannerNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, PannerNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPannerNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7PannerNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10PannerNodeE[2];
#if COMPILER(CLANG)
    // If this fails PannerNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(PannerNode), PannerNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // PannerNode has subclasses. If PannerNode has subclasses that get passed
    // to toJS() we currently require PannerNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSPannerNode>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
