/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(STREAMS_API)

#include "JSReadableStream.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "ReadableStreamBuiltins.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions


// Attributes

JSC::EncodedJSValue jsReadableStreamConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSReadableStreamConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSReadableStreamPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSReadableStreamPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSReadableStreamPrototype* ptr = new (NotNull, JSC::allocateCell<JSReadableStreamPrototype>(vm.heap)) JSReadableStreamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSReadableStreamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSBuiltinConstructor<JSReadableStream> JSReadableStreamConstructor;

template<> JSValue JSReadableStreamConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSReadableStreamConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSReadableStream::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ReadableStream"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> FunctionExecutable* JSReadableStreamConstructor::initializeExecutable(VM& vm)
{
    return readableStreamInitializeReadableStreamCodeGenerator(vm);
}

template<> const ClassInfo JSReadableStreamConstructor::s_info = { "ReadableStream", &Base::s_info, 0, CREATE_METHOD_TABLE(JSReadableStreamConstructor) };

/* Hash table for prototype */

static const HashTableValue JSReadableStreamPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsReadableStreamConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSReadableStreamConstructor) } },
    { "locked", ReadOnly | Accessor | Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamLockedCodeGenerator), (intptr_t) (0) } },
    { "cancel", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamCancelCodeGenerator), (intptr_t) (0) } },
    { "getReader", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamGetReaderCodeGenerator), (intptr_t) (0) } },
    { "pipeTo", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamPipeToCodeGenerator), (intptr_t) (2) } },
    { "pipeThrough", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamPipeThroughCodeGenerator), (intptr_t) (2) } },
    { "tee", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamTeeCodeGenerator), (intptr_t) (0) } },
};

const ClassInfo JSReadableStreamPrototype::s_info = { "ReadableStreamPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSReadableStreamPrototype) };

void JSReadableStreamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSReadableStreamPrototypeTableValues, *this);
}

const ClassInfo JSReadableStream::s_info = { "ReadableStream", &Base::s_info, 0, CREATE_METHOD_TABLE(JSReadableStream) };

JSReadableStream::JSReadableStream(Structure* structure, JSDOMGlobalObject& globalObject)
    : JSDOMObject(structure, globalObject) { }

JSObject* JSReadableStream::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSReadableStreamPrototype::create(vm, globalObject, JSReadableStreamPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSReadableStream::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSReadableStream>(vm, globalObject);
}

void JSReadableStream::destroy(JSC::JSCell* cell)
{
    JSReadableStream* thisObject = static_cast<JSReadableStream*>(cell);
    thisObject->JSReadableStream::~JSReadableStream();
}

EncodedJSValue jsReadableStreamConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSReadableStreamPrototype* domObject = jsDynamicCast<JSReadableStreamPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSReadableStream::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSReadableStreamConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSReadableStreamPrototype* domObject = jsDynamicCast<JSReadableStreamPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSReadableStream::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSReadableStreamConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSReadableStream::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSReadableStream*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
}


}

#endif // ENABLE(STREAMS_API)
