/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(STREAMS_API)

#include "JSReadableStreamReader.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "ReadableStreamReaderBuiltins.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions


// Attributes

JSC::EncodedJSValue jsReadableStreamReaderConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSReadableStreamReaderConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSReadableStreamReaderPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSReadableStreamReaderPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSReadableStreamReaderPrototype* ptr = new (NotNull, JSC::allocateCell<JSReadableStreamReaderPrototype>(vm.heap)) JSReadableStreamReaderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSReadableStreamReaderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSReadableStreamReader> JSReadableStreamReaderConstructor;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSReadableStreamReaderConstructor::construct(JSC::ExecState* state)
{
    return constructJSReadableStreamReader(state);
}

template<> JSValue JSReadableStreamReaderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSReadableStreamReaderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSReadableStreamReader::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ReadableStreamReader"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSReadableStreamReaderConstructor::s_info = { "ReadableStreamReader", &Base::s_info, 0, CREATE_METHOD_TABLE(JSReadableStreamReaderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSReadableStreamReaderPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsReadableStreamReaderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSReadableStreamReaderConstructor) } },
    { "closed", ReadOnly | Accessor | Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamReaderClosedCodeGenerator), (intptr_t) (0) } },
    { "read", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamReaderReadCodeGenerator), (intptr_t) (0) } },
    { "cancel", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamReaderCancelCodeGenerator), (intptr_t) (0) } },
    { "releaseLock", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(readableStreamReaderReleaseLockCodeGenerator), (intptr_t) (0) } },
};

const ClassInfo JSReadableStreamReaderPrototype::s_info = { "ReadableStreamReaderPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSReadableStreamReaderPrototype) };

void JSReadableStreamReaderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSReadableStreamReaderPrototypeTableValues, *this);
}

const ClassInfo JSReadableStreamReader::s_info = { "ReadableStreamReader", &Base::s_info, 0, CREATE_METHOD_TABLE(JSReadableStreamReader) };

JSReadableStreamReader::JSReadableStreamReader(Structure* structure, JSDOMGlobalObject& globalObject)
    : JSDOMObject(structure, globalObject) { }

JSObject* JSReadableStreamReader::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSReadableStreamReaderPrototype::create(vm, globalObject, JSReadableStreamReaderPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSReadableStreamReader::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSReadableStreamReader>(vm, globalObject);
}

void JSReadableStreamReader::destroy(JSC::JSCell* cell)
{
    JSReadableStreamReader* thisObject = static_cast<JSReadableStreamReader*>(cell);
    thisObject->JSReadableStreamReader::~JSReadableStreamReader();
}

EncodedJSValue jsReadableStreamReaderConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSReadableStreamReaderPrototype* domObject = jsDynamicCast<JSReadableStreamReaderPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    JSValue constructor = JSReadableStreamReaderConstructor::create(state->vm(), JSReadableStreamReaderConstructor::createStructure(state->vm(), *domObject->globalObject(), domObject->globalObject()->objectPrototype()), *jsCast<JSDOMGlobalObject*>(domObject->globalObject()));
    // Shadowing constructor property to ensure reusing the same constructor object
    domObject->putDirect(state->vm(), state->propertyNames().constructor, constructor, DontEnum | ReadOnly);
    return JSValue::encode(constructor);
}

void setJSReadableStreamReaderConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSReadableStreamReaderPrototype* domObject = jsDynamicCast<JSReadableStreamReaderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}


}

#endif // ENABLE(STREAMS_API)
