/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLResultSet.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSQLResultSetRowList.h"
#include "SQLResultSetRowList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSQLResultSetRows(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSQLResultSetInsertId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSQLResultSetRowsAffected(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSQLResultSetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSQLResultSetPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSQLResultSetPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLResultSetPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLResultSetPrototype>(vm.heap)) JSSQLResultSetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLResultSetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSSQLResultSetPrototypeTableValues[] =
{
    { "rows", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetRows), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "insertId", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetInsertId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rowsAffected", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetRowsAffected), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSQLResultSetPrototype::s_info = { "SQLResultSetPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLResultSetPrototype) };

void JSSQLResultSetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLResultSetPrototypeTableValues, *this);
}

const ClassInfo JSSQLResultSet::s_info = { "SQLResultSet", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLResultSet) };

JSSQLResultSet::JSSQLResultSet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLResultSet>&& impl)
    : JSDOMWrapper<SQLResultSet>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSQLResultSet::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSQLResultSetPrototype::create(vm, globalObject, JSSQLResultSetPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSQLResultSet::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSQLResultSet>(vm, globalObject);
}

void JSSQLResultSet::destroy(JSC::JSCell* cell)
{
    JSSQLResultSet* thisObject = static_cast<JSSQLResultSet*>(cell);
    thisObject->JSSQLResultSet::~JSSQLResultSet();
}

EncodedJSValue jsSQLResultSetRows(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSQLResultSet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SQLResultSet", "rows");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.rows()));
    return JSValue::encode(result);
}


EncodedJSValue jsSQLResultSetInsertId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSQLResultSet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SQLResultSet", "insertId");
    }
    ExceptionCode ec = 0;
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.insertId(ec));
    setDOMException(state, ec);
    return JSValue::encode(result);
}


EncodedJSValue jsSQLResultSetRowsAffected(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSQLResultSet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SQLResultSet", "rowsAffected");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.rowsAffected());
    return JSValue::encode(result);
}


void setJSSQLResultSetConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSQLResultSetPrototype* domObject = jsDynamicCast<JSSQLResultSetPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

bool JSSQLResultSetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSQLResultSetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLResultSet = jsCast<JSSQLResultSet*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSQLResultSet->wrapped(), jsSQLResultSet);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLResultSet* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSQLResultSet>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLResultSet* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSQLResultSet>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SQLResultSet.
    COMPILE_ASSERT(!__is_polymorphic(SQLResultSet), SQLResultSet_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSSQLResultSet>(globalObject, impl);
}

SQLResultSet* JSSQLResultSet::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLResultSet*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
