/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLResultSetRowList.h"

#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSQLResultSetRowListPrototypeFunctionItem(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSQLResultSetRowListLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSQLResultSetRowListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSQLResultSetRowListPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSQLResultSetRowListPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLResultSetRowListPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLResultSetRowListPrototype>(vm.heap)) JSSQLResultSetRowListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLResultSetRowListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSSQLResultSetRowListPrototypeTableValues[] =
{
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetRowListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSQLResultSetRowListPrototypeFunctionItem), (intptr_t) (1) } },
};

const ClassInfo JSSQLResultSetRowListPrototype::s_info = { "SQLResultSetRowListPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLResultSetRowListPrototype) };

void JSSQLResultSetRowListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLResultSetRowListPrototypeTableValues, *this);
}

const ClassInfo JSSQLResultSetRowList::s_info = { "SQLResultSetRowList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLResultSetRowList) };

JSSQLResultSetRowList::JSSQLResultSetRowList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLResultSetRowList>&& impl)
    : JSDOMWrapper<SQLResultSetRowList>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSQLResultSetRowList::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSQLResultSetRowListPrototype::create(vm, globalObject, JSSQLResultSetRowListPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSQLResultSetRowList::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSQLResultSetRowList>(vm, globalObject);
}

void JSSQLResultSetRowList::destroy(JSC::JSCell* cell)
{
    JSSQLResultSetRowList* thisObject = static_cast<JSSQLResultSetRowList*>(cell);
    thisObject->JSSQLResultSetRowList::~JSSQLResultSetRowList();
}

EncodedJSValue jsSQLResultSetRowListLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSQLResultSetRowList*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SQLResultSetRowList", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


void setJSSQLResultSetRowListConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSQLResultSetRowListPrototype* domObject = jsDynamicCast<JSSQLResultSetRowListPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

EncodedJSValue JSC_HOST_CALL jsSQLResultSetRowListPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSQLResultSetRowList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SQLResultSetRowList", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSQLResultSetRowList::info());
    return JSValue::encode(castedThis->item(*state));
}

bool JSSQLResultSetRowListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSQLResultSetRowListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLResultSetRowList = jsCast<JSSQLResultSetRowList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSQLResultSetRowList->wrapped(), jsSQLResultSetRowList);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLResultSetRowList* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSQLResultSetRowList>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLResultSetRowList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSQLResultSetRowList>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SQLResultSetRowList.
    COMPILE_ASSERT(!__is_polymorphic(SQLResultSetRowList), SQLResultSetRowList_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSSQLResultSetRowList>(globalObject, impl);
}

SQLResultSetRowList* JSSQLResultSetRowList::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLResultSetRowList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
