/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSegMovetoRel.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGPathSegMovetoRelX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegMovetoRelX(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegMovetoRelY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegMovetoRelY(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegMovetoRelConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegMovetoRelConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGPathSegMovetoRelPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGPathSegMovetoRelPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegMovetoRelPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegMovetoRelPrototype>(vm.heap)) JSSVGPathSegMovetoRelPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegMovetoRelPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGPathSegMovetoRel> JSSVGPathSegMovetoRelConstructor;

template<> JSValue JSSVGPathSegMovetoRelConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSeg::getConstructor(vm, &globalObject);
}

template<> void JSSVGPathSegMovetoRelConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSegMovetoRel::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGPathSegMovetoRel"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGPathSegMovetoRelConstructor::s_info = { "SVGPathSegMovetoRel", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPathSegMovetoRelConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegMovetoRelPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegMovetoRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegMovetoRelConstructor) } },
    { "x", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegMovetoRelX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegMovetoRelX) } },
    { "y", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegMovetoRelY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegMovetoRelY) } },
};

const ClassInfo JSSVGPathSegMovetoRelPrototype::s_info = { "SVGPathSegMovetoRelPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPathSegMovetoRelPrototype) };

void JSSVGPathSegMovetoRelPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSegMovetoRelPrototypeTableValues, *this);
}

const ClassInfo JSSVGPathSegMovetoRel::s_info = { "SVGPathSegMovetoRel", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPathSegMovetoRel) };

JSSVGPathSegMovetoRel::JSSVGPathSegMovetoRel(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSegMovetoRel>&& impl)
    : JSSVGPathSeg(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGPathSegMovetoRel::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGPathSegMovetoRelPrototype::create(vm, globalObject, JSSVGPathSegMovetoRelPrototype::createStructure(vm, globalObject, JSSVGPathSeg::getPrototype(vm, globalObject)));
}

JSObject* JSSVGPathSegMovetoRel::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSegMovetoRel>(vm, globalObject);
}

EncodedJSValue jsSVGPathSegMovetoRelX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSegMovetoRel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSegMovetoRel", "x");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.x());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegMovetoRelY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSegMovetoRel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSegMovetoRel", "y");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.y());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegMovetoRelConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGPathSegMovetoRelPrototype* domObject = jsDynamicCast<JSSVGPathSegMovetoRelPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGPathSegMovetoRel::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGPathSegMovetoRelConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGPathSegMovetoRelPrototype* domObject = jsDynamicCast<JSSVGPathSegMovetoRelPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGPathSegMovetoRelX(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGPathSegMovetoRel* castedThis = jsDynamicCast<JSSVGPathSegMovetoRel*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGPathSegMovetoRel", "x");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setX(nativeValue);
}


void setJSSVGPathSegMovetoRelY(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGPathSegMovetoRel* castedThis = jsDynamicCast<JSSVGPathSegMovetoRel*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGPathSegMovetoRel", "y");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setY(nativeValue);
}


JSValue JSSVGPathSegMovetoRel::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegMovetoRelConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
