/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSSourceBuffer.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSTimeRanges.h"
#include "TimeRanges.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(VIDEO_TRACK)
#include "AudioTrackList.h"
#include "JSAudioTrackList.h"
#include "JSTextTrackList.h"
#include "JSVideoTrackList.h"
#include "TextTrackList.h"
#include "VideoTrackList.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAppendBuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAbort(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionRemove(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSourceBufferMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSourceBufferMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferUpdating(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSourceBufferBuffered(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSourceBufferTimestampOffset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSourceBufferTimestampOffset(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsSourceBufferAudioTracks(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsSourceBufferVideoTracks(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsSourceBufferTextTracks(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsSourceBufferAppendWindowStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSourceBufferAppendWindowStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferAppendWindowEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSourceBufferAppendWindowEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
void setJSSourceBufferConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSourceBufferPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSourceBufferPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSourceBufferPrototype* ptr = new (NotNull, JSC::allocateCell<JSSourceBufferPrototype>(vm.heap)) JSSourceBufferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSourceBufferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSSourceBufferPrototypeTableValues[] =
{
    { "mode", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferMode) } },
    { "updating", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferUpdating), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "buffered", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferBuffered), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timestampOffset", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferTimestampOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferTimestampOffset) } },
#if ENABLE(VIDEO_TRACK)
    { "audioTracks", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferAudioTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "videoTracks", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferVideoTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "textTracks", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferTextTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "appendWindowStart", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferAppendWindowStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferAppendWindowStart) } },
    { "appendWindowEnd", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferAppendWindowEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferAppendWindowEnd) } },
    { "appendBuffer", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSourceBufferPrototypeFunctionAppendBuffer), (intptr_t) (1) } },
    { "abort", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSourceBufferPrototypeFunctionAbort), (intptr_t) (0) } },
    { "remove", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSourceBufferPrototypeFunctionRemove), (intptr_t) (2) } },
};

const ClassInfo JSSourceBufferPrototype::s_info = { "SourceBufferPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSourceBufferPrototype) };

void JSSourceBufferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSourceBufferPrototypeTableValues, *this);
}

const ClassInfo JSSourceBuffer::s_info = { "SourceBuffer", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSourceBuffer) };

JSSourceBuffer::JSSourceBuffer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SourceBuffer>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSourceBuffer::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSourceBufferPrototype::create(vm, globalObject, JSSourceBufferPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSSourceBuffer::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSourceBuffer>(vm, globalObject);
}

EncodedJSValue jsSourceBufferMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSourceBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SourceBuffer", "mode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.mode());
    return JSValue::encode(result);
}


EncodedJSValue jsSourceBufferUpdating(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSourceBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SourceBuffer", "updating");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.updating());
    return JSValue::encode(result);
}


EncodedJSValue jsSourceBufferBuffered(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSourceBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SourceBuffer", "buffered");
    }
    ExceptionCode ec = 0;
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.buffered(ec)));
    setDOMException(state, ec);
    return JSValue::encode(result);
}


EncodedJSValue jsSourceBufferTimestampOffset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSourceBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SourceBuffer", "timestampOffset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.timestampOffset());
    return JSValue::encode(result);
}


#if ENABLE(VIDEO_TRACK)
EncodedJSValue jsSourceBufferAudioTracks(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSourceBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SourceBuffer", "audioTracks");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.audioTracks()));
    return JSValue::encode(result);
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue jsSourceBufferVideoTracks(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSourceBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SourceBuffer", "videoTracks");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.videoTracks()));
    return JSValue::encode(result);
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue jsSourceBufferTextTracks(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSourceBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SourceBuffer", "textTracks");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.textTracks()));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsSourceBufferAppendWindowStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSourceBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SourceBuffer", "appendWindowStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.appendWindowStart());
    return JSValue::encode(result);
}


EncodedJSValue jsSourceBufferAppendWindowEnd(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSourceBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SourceBuffer", "appendWindowEnd");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.appendWindowEnd());
    return JSValue::encode(result);
}


void setJSSourceBufferConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSourceBufferPrototype* domObject = jsDynamicCast<JSSourceBufferPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSourceBufferMode(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSourceBuffer* castedThis = jsDynamicCast<JSSourceBuffer*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SourceBuffer", "mode");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (nativeValue != "segments" && nativeValue != "sequence")
        return;
    impl.setMode(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSSourceBufferTimestampOffset(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSourceBuffer* castedThis = jsDynamicCast<JSSourceBuffer*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SourceBuffer", "timestampOffset");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setTimestampOffset(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSSourceBufferAppendWindowStart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSourceBuffer* castedThis = jsDynamicCast<JSSourceBuffer*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SourceBuffer", "appendWindowStart");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAppendWindowStart(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSSourceBufferAppendWindowEnd(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSourceBuffer* castedThis = jsDynamicCast<JSSourceBuffer*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SourceBuffer", "appendWindowEnd");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAppendWindowEnd(nativeValue, ec);
    setDOMException(state, ec);
}


static EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAppendBuffer1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSourceBuffer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SourceBuffer", "appendBuffer");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSourceBuffer::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    ArrayBuffer* data = toArrayBuffer(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.appendBuffer(data, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAppendBuffer2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSourceBuffer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SourceBuffer", "appendBuffer");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSourceBuffer::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    RefPtr<ArrayBufferView> data = toArrayBufferView(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.appendBuffer(data.get(), ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAppendBuffer(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSArrayBuffer::info())))))
        return jsSourceBufferPrototypeFunctionAppendBuffer1(state);
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSArrayBufferView::info())))))
        return jsSourceBufferPrototypeFunctionAppendBuffer2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAbort(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSourceBuffer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SourceBuffer", "abort");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSourceBuffer::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    impl.abort(ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionRemove(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSourceBuffer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SourceBuffer", "remove");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSourceBuffer::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    double start = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double end = state->argument(1).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.remove(start, end, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

void JSSourceBuffer::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSSourceBuffer*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSSourceBufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsSourceBuffer = jsCast<JSSourceBuffer*>(handle.slot()->asCell());
    if (jsSourceBuffer->wrapped().hasPendingActivity())
        return true;
    if (jsSourceBuffer->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSourceBufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSourceBuffer = jsCast<JSSourceBuffer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSourceBuffer->wrapped(), jsSourceBuffer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SourceBuffer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12SourceBufferE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SourceBuffer* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSourceBuffer>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SourceBuffer* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSourceBuffer>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SourceBuffer@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12SourceBufferE[2];
#if COMPILER(CLANG)
    // If this fails SourceBuffer does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SourceBuffer), SourceBuffer_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SourceBuffer has subclasses. If SourceBuffer has subclasses that get passed
    // to toJS() we currently require SourceBuffer you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSSourceBuffer>(globalObject, impl);
}

SourceBuffer* JSSourceBuffer::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSourceBuffer*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SOURCE)
