/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStyleSheet.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSMediaList.h"
#include "JSNode.h"
#include "JSStyleSheet.h"
#include "MediaList.h"
#include "Node.h"
#include "StyleSheet.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsStyleSheetType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStyleSheetDisabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSStyleSheetDisabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsStyleSheetOwnerNode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStyleSheetParentStyleSheet(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStyleSheetHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStyleSheetTitle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStyleSheetMedia(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStyleSheetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSStyleSheetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSStyleSheetPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSStyleSheetPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStyleSheetPrototype* ptr = new (NotNull, JSC::allocateCell<JSStyleSheetPrototype>(vm.heap)) JSStyleSheetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStyleSheetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSStyleSheet> JSStyleSheetConstructor;

template<> JSValue JSStyleSheetConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSStyleSheetConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSStyleSheet::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("StyleSheet"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSStyleSheetConstructor::s_info = { "StyleSheet", &Base::s_info, 0, CREATE_METHOD_TABLE(JSStyleSheetConstructor) };

/* Hash table for prototype */

static const HashTableValue JSStyleSheetPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSStyleSheetConstructor) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "disabled", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetDisabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSStyleSheetDisabled) } },
    { "ownerNode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetOwnerNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "parentStyleSheet", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetParentStyleSheet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "href", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetHref), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "title", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetTitle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "media", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleSheetMedia), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSStyleSheetPrototype::s_info = { "StyleSheetPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSStyleSheetPrototype) };

void JSStyleSheetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStyleSheetPrototypeTableValues, *this);
}

const ClassInfo JSStyleSheet::s_info = { "StyleSheet", &Base::s_info, 0, CREATE_METHOD_TABLE(JSStyleSheet) };

JSStyleSheet::JSStyleSheet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StyleSheet>&& impl)
    : JSDOMWrapper<StyleSheet>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSStyleSheet::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSStyleSheetPrototype::create(vm, globalObject, JSStyleSheetPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSStyleSheet::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStyleSheet>(vm, globalObject);
}

void JSStyleSheet::destroy(JSC::JSCell* cell)
{
    JSStyleSheet* thisObject = static_cast<JSStyleSheet*>(cell);
    thisObject->JSStyleSheet::~JSStyleSheet();
}

EncodedJSValue jsStyleSheetType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStyleSheet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StyleSheet", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsStyleSheetDisabled(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStyleSheet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StyleSheet", "disabled");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.disabled());
    return JSValue::encode(result);
}


EncodedJSValue jsStyleSheetOwnerNode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStyleSheet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StyleSheet", "ownerNode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.ownerNode()));
    return JSValue::encode(result);
}


EncodedJSValue jsStyleSheetParentStyleSheet(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStyleSheet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StyleSheet", "parentStyleSheet");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.parentStyleSheet()));
    return JSValue::encode(result);
}


EncodedJSValue jsStyleSheetHref(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStyleSheet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StyleSheet", "href");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.href());
    return JSValue::encode(result);
}


EncodedJSValue jsStyleSheetTitle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStyleSheet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StyleSheet", "title");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.title());
    return JSValue::encode(result);
}


EncodedJSValue jsStyleSheetMedia(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStyleSheet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StyleSheet", "media");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.media()));
    return JSValue::encode(result);
}


EncodedJSValue jsStyleSheetConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSStyleSheetPrototype* domObject = jsDynamicCast<JSStyleSheetPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSStyleSheet::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSStyleSheetConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSStyleSheetPrototype* domObject = jsDynamicCast<JSStyleSheetPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSStyleSheetDisabled(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSStyleSheet* castedThis = jsDynamicCast<JSStyleSheet*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "StyleSheet", "disabled");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDisabled(nativeValue);
}


JSValue JSStyleSheet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStyleSheetConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSStyleSheet::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSStyleSheet*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSStyleSheetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsStyleSheet = jsCast<JSStyleSheet*>(handle.slot()->asCell());
    void* root = WebCore::root(&jsStyleSheet->wrapped());
    return visitor.containsOpaqueRoot(root);
}

void JSStyleSheetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsStyleSheet = jsCast<JSStyleSheet*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsStyleSheet->wrapped(), jsStyleSheet);
}

StyleSheet* JSStyleSheet::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSStyleSheet*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
