/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouchEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMWindow.h"
#include "JSTouchList.h"
#include "TouchList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTouchEventPrototypeFunctionInitTouchEvent(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsTouchEventTouches(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventTargetTouches(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventChangedTouches(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventCtrlKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventShiftKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventAltKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventMetaKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTouchEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTouchEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTouchEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTouchEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSTouchEventPrototype>(vm.heap)) JSTouchEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTouchEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSTouchEvent> JSTouchEventConstructor;

/* Hash table */

static const struct CompactHashIndex JSTouchEventTableIndex[18] = {
    { -1, -1 },
    { -1, -1 },
    { 3, 17 },
    { 4, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 1, 16 },
    { -1, -1 },
    { 2, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 0, -1 },
    { 5, -1 },
    { 6, -1 },
};


static const HashTableValue JSTouchEventTableValues[] =
{
    { "touches", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventTouches), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "targetTouches", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventTargetTouches), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "changedTouches", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventChangedTouches), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ctrlKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventCtrlKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shiftKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventShiftKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "altKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventAltKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "metaKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventMetaKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

static const HashTable JSTouchEventTable = { 7, 15, true, JSTouchEventTableValues, JSTouchEventTableIndex };
template<> JSValue JSTouchEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSTouchEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTouchEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TouchEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTouchEventConstructor::s_info = { "TouchEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTouchEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTouchEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTouchEventConstructor) } },
    { "initTouchEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTouchEventPrototypeFunctionInitTouchEvent), (intptr_t) (0) } },
};

const ClassInfo JSTouchEventPrototype::s_info = { "TouchEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTouchEventPrototype) };

void JSTouchEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTouchEventPrototypeTableValues, *this);
}

const ClassInfo JSTouchEvent::s_info = { "TouchEvent", &Base::s_info, &JSTouchEventTable, CREATE_METHOD_TABLE(JSTouchEvent) };

JSTouchEvent::JSTouchEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TouchEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSTouchEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTouchEventPrototype::create(vm, globalObject, JSTouchEventPrototype::createStructure(vm, globalObject, JSUIEvent::getPrototype(vm, globalObject)));
}

JSObject* JSTouchEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTouchEvent>(vm, globalObject);
}

bool JSTouchEvent::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSTouchEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (getStaticValueSlot<JSTouchEvent, Base>(state, JSTouchEventTable, thisObject, propertyName, slot))
        return true;
    return false;
}

EncodedJSValue jsTouchEventTouches(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouchEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouchEvent*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "TouchEvent", "touches");
        reportDeprecatedGetterError(*state, "TouchEvent", "touches");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.touches()));
    return JSValue::encode(result);
}


EncodedJSValue jsTouchEventTargetTouches(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouchEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouchEvent*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "TouchEvent", "targetTouches");
        reportDeprecatedGetterError(*state, "TouchEvent", "targetTouches");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.targetTouches()));
    return JSValue::encode(result);
}


EncodedJSValue jsTouchEventChangedTouches(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouchEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouchEvent*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "TouchEvent", "changedTouches");
        reportDeprecatedGetterError(*state, "TouchEvent", "changedTouches");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.changedTouches()));
    return JSValue::encode(result);
}


EncodedJSValue jsTouchEventCtrlKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouchEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouchEvent*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "TouchEvent", "ctrlKey");
        reportDeprecatedGetterError(*state, "TouchEvent", "ctrlKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.ctrlKey());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchEventShiftKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouchEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouchEvent*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "TouchEvent", "shiftKey");
        reportDeprecatedGetterError(*state, "TouchEvent", "shiftKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.shiftKey());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchEventAltKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouchEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouchEvent*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "TouchEvent", "altKey");
        reportDeprecatedGetterError(*state, "TouchEvent", "altKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.altKey());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchEventMetaKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouchEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouchEvent*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "TouchEvent", "metaKey");
        reportDeprecatedGetterError(*state, "TouchEvent", "metaKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.metaKey());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTouchEventPrototype* domObject = jsDynamicCast<JSTouchEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSTouchEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTouchEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTouchEventPrototype* domObject = jsDynamicCast<JSTouchEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSTouchEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTouchEventPrototypeFunctionInitTouchEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTouchEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TouchEvent", "initTouchEvent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTouchEvent::info());
    auto& impl = castedThis->wrapped();
    TouchList* touches = JSTouchList::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    TouchList* targetTouches = JSTouchList::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    TouchList* changedTouches = JSTouchList::toWrapped(state->argument(2));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String type = state->argument(3).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    DOMWindow* view = JSDOMWindow::toWrapped(state->argument(4));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int screenX = toInt32(state, state->argument(5), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int screenY = toInt32(state, state->argument(6), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int clientX = toInt32(state, state->argument(7), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int clientY = toInt32(state, state->argument(8), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool ctrlKey = state->argument(9).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool altKey = state->argument(10).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool shiftKey = state->argument(11).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool metaKey = state->argument(12).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.initTouchEvent(touches, targetTouches, changedTouches, type, view, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey);
    return JSValue::encode(jsUndefined());
}


}

#endif // ENABLE(TOUCH_EVENTS)
