/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSVideoPlaybackQuality.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsVideoPlaybackQualityCreationTime(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoPlaybackQualityTotalVideoFrames(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoPlaybackQualityDroppedVideoFrames(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoPlaybackQualityCorruptedVideoFrames(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoPlaybackQualityTotalFrameDelay(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVideoPlaybackQualityConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSVideoPlaybackQualityPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSVideoPlaybackQualityPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoPlaybackQualityPrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoPlaybackQualityPrototype>(vm.heap)) JSVideoPlaybackQualityPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVideoPlaybackQualityPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSVideoPlaybackQualityPrototypeTableValues[] =
{
    { "creationTime", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityCreationTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "totalVideoFrames", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityTotalVideoFrames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "droppedVideoFrames", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityDroppedVideoFrames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "corruptedVideoFrames", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityCorruptedVideoFrames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "totalFrameDelay", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityTotalFrameDelay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSVideoPlaybackQualityPrototype::s_info = { "VideoPlaybackQualityPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVideoPlaybackQualityPrototype) };

void JSVideoPlaybackQualityPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVideoPlaybackQualityPrototypeTableValues, *this);
}

const ClassInfo JSVideoPlaybackQuality::s_info = { "VideoPlaybackQuality", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVideoPlaybackQuality) };

JSVideoPlaybackQuality::JSVideoPlaybackQuality(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VideoPlaybackQuality>&& impl)
    : JSDOMWrapper<VideoPlaybackQuality>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSVideoPlaybackQuality::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSVideoPlaybackQualityPrototype::create(vm, globalObject, JSVideoPlaybackQualityPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSVideoPlaybackQuality::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSVideoPlaybackQuality>(vm, globalObject);
}

void JSVideoPlaybackQuality::destroy(JSC::JSCell* cell)
{
    JSVideoPlaybackQuality* thisObject = static_cast<JSVideoPlaybackQuality*>(cell);
    thisObject->JSVideoPlaybackQuality::~JSVideoPlaybackQuality();
}

EncodedJSValue jsVideoPlaybackQualityCreationTime(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoPlaybackQuality*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoPlaybackQuality", "creationTime");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.creationTime());
    return JSValue::encode(result);
}


EncodedJSValue jsVideoPlaybackQualityTotalVideoFrames(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoPlaybackQuality*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoPlaybackQuality", "totalVideoFrames");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.totalVideoFrames());
    return JSValue::encode(result);
}


EncodedJSValue jsVideoPlaybackQualityDroppedVideoFrames(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoPlaybackQuality*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoPlaybackQuality", "droppedVideoFrames");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.droppedVideoFrames());
    return JSValue::encode(result);
}


EncodedJSValue jsVideoPlaybackQualityCorruptedVideoFrames(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoPlaybackQuality*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoPlaybackQuality", "corruptedVideoFrames");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.corruptedVideoFrames());
    return JSValue::encode(result);
}


EncodedJSValue jsVideoPlaybackQualityTotalFrameDelay(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVideoPlaybackQuality*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VideoPlaybackQuality", "totalFrameDelay");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.totalFrameDelay());
    return JSValue::encode(result);
}


void setJSVideoPlaybackQualityConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSVideoPlaybackQualityPrototype* domObject = jsDynamicCast<JSVideoPlaybackQualityPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

bool JSVideoPlaybackQualityOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSVideoPlaybackQualityOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVideoPlaybackQuality = jsCast<JSVideoPlaybackQuality*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsVideoPlaybackQuality->wrapped(), jsVideoPlaybackQuality);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, VideoPlaybackQuality* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSVideoPlaybackQuality>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, VideoPlaybackQuality* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSVideoPlaybackQuality>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to VideoPlaybackQuality.
    COMPILE_ASSERT(!__is_polymorphic(VideoPlaybackQuality), VideoPlaybackQuality_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSVideoPlaybackQuality>(globalObject, impl);
}

VideoPlaybackQuality* JSVideoPlaybackQuality::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVideoPlaybackQuality*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SOURCE)
