/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLShaderPrecisionFormat.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLShaderPrecisionFormatRangeMin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebGLShaderPrecisionFormatRangeMax(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebGLShaderPrecisionFormatPrecision(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebGLShaderPrecisionFormatConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLShaderPrecisionFormatConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLShaderPrecisionFormatPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLShaderPrecisionFormatPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLShaderPrecisionFormatPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLShaderPrecisionFormatPrototype>(vm.heap)) JSWebGLShaderPrecisionFormatPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLShaderPrecisionFormatPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWebGLShaderPrecisionFormat> JSWebGLShaderPrecisionFormatConstructor;

template<> JSValue JSWebGLShaderPrecisionFormatConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLShaderPrecisionFormatConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLShaderPrecisionFormat::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebGLShaderPrecisionFormat"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebGLShaderPrecisionFormatConstructor::s_info = { "WebGLShaderPrecisionFormat", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormatConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLShaderPrecisionFormatPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLShaderPrecisionFormatConstructor) } },
    { "rangeMin", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatRangeMin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rangeMax", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatRangeMax), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "precision", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatPrecision), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSWebGLShaderPrecisionFormatPrototype::s_info = { "WebGLShaderPrecisionFormatPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormatPrototype) };

void JSWebGLShaderPrecisionFormatPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLShaderPrecisionFormatPrototypeTableValues, *this);
}

const ClassInfo JSWebGLShaderPrecisionFormat::s_info = { "WebGLShaderPrecisionFormat", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormat) };

JSWebGLShaderPrecisionFormat::JSWebGLShaderPrecisionFormat(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLShaderPrecisionFormat>&& impl)
    : JSDOMWrapper<WebGLShaderPrecisionFormat>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLShaderPrecisionFormat::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLShaderPrecisionFormatPrototype::create(vm, globalObject, JSWebGLShaderPrecisionFormatPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLShaderPrecisionFormat::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLShaderPrecisionFormat>(vm, globalObject);
}

void JSWebGLShaderPrecisionFormat::destroy(JSC::JSCell* cell)
{
    JSWebGLShaderPrecisionFormat* thisObject = static_cast<JSWebGLShaderPrecisionFormat*>(cell);
    thisObject->JSWebGLShaderPrecisionFormat::~JSWebGLShaderPrecisionFormat();
}

EncodedJSValue jsWebGLShaderPrecisionFormatRangeMin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLShaderPrecisionFormat*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLShaderPrecisionFormat", "rangeMin");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.rangeMin());
    return JSValue::encode(result);
}


EncodedJSValue jsWebGLShaderPrecisionFormatRangeMax(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLShaderPrecisionFormat*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLShaderPrecisionFormat", "rangeMax");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.rangeMax());
    return JSValue::encode(result);
}


EncodedJSValue jsWebGLShaderPrecisionFormatPrecision(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLShaderPrecisionFormat*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLShaderPrecisionFormat", "precision");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.precision());
    return JSValue::encode(result);
}


EncodedJSValue jsWebGLShaderPrecisionFormatConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebGLShaderPrecisionFormatPrototype* domObject = jsDynamicCast<JSWebGLShaderPrecisionFormatPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebGLShaderPrecisionFormat::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebGLShaderPrecisionFormatConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLShaderPrecisionFormatPrototype* domObject = jsDynamicCast<JSWebGLShaderPrecisionFormatPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWebGLShaderPrecisionFormat::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLShaderPrecisionFormatConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSWebGLShaderPrecisionFormatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLShaderPrecisionFormatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLShaderPrecisionFormat = jsCast<JSWebGLShaderPrecisionFormat*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLShaderPrecisionFormat->wrapped(), jsWebGLShaderPrecisionFormat);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLShaderPrecisionFormat* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLShaderPrecisionFormat>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLShaderPrecisionFormat* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLShaderPrecisionFormat>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebGLShaderPrecisionFormat.
    COMPILE_ASSERT(!__is_polymorphic(WebGLShaderPrecisionFormat), WebGLShaderPrecisionFormat_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSWebGLShaderPrecisionFormat>(globalObject, impl);
}

WebGLShaderPrecisionFormat* JSWebGLShaderPrecisionFormat::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLShaderPrecisionFormat*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
