/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLUniformLocation.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLUniformLocationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLUniformLocationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLUniformLocationPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLUniformLocationPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLUniformLocationPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLUniformLocationPrototype>(vm.heap)) JSWebGLUniformLocationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLUniformLocationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWebGLUniformLocation> JSWebGLUniformLocationConstructor;

template<> JSValue JSWebGLUniformLocationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLUniformLocationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLUniformLocation::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebGLUniformLocation"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebGLUniformLocationConstructor::s_info = { "WebGLUniformLocation", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLUniformLocationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLUniformLocationPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLUniformLocationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLUniformLocationConstructor) } },
};

const ClassInfo JSWebGLUniformLocationPrototype::s_info = { "WebGLUniformLocationPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLUniformLocationPrototype) };

void JSWebGLUniformLocationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLUniformLocationPrototypeTableValues, *this);
}

const ClassInfo JSWebGLUniformLocation::s_info = { "WebGLUniformLocation", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLUniformLocation) };

JSWebGLUniformLocation::JSWebGLUniformLocation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLUniformLocation>&& impl)
    : JSDOMWrapper<WebGLUniformLocation>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLUniformLocation::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLUniformLocationPrototype::create(vm, globalObject, JSWebGLUniformLocationPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLUniformLocation::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLUniformLocation>(vm, globalObject);
}

void JSWebGLUniformLocation::destroy(JSC::JSCell* cell)
{
    JSWebGLUniformLocation* thisObject = static_cast<JSWebGLUniformLocation*>(cell);
    thisObject->JSWebGLUniformLocation::~JSWebGLUniformLocation();
}

EncodedJSValue jsWebGLUniformLocationConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebGLUniformLocationPrototype* domObject = jsDynamicCast<JSWebGLUniformLocationPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebGLUniformLocation::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebGLUniformLocationConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLUniformLocationPrototype* domObject = jsDynamicCast<JSWebGLUniformLocationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWebGLUniformLocation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLUniformLocationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSWebGLUniformLocationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLUniformLocationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLUniformLocation = jsCast<JSWebGLUniformLocation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLUniformLocation->wrapped(), jsWebGLUniformLocation);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLUniformLocation* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLUniformLocation>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLUniformLocation* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLUniformLocation>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebGLUniformLocation.
    COMPILE_ASSERT(!__is_polymorphic(WebGLUniformLocation), WebGLUniformLocation_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSWebGLUniformLocation>(globalObject, impl);
}

WebGLUniformLocation* JSWebGLUniformLocation::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLUniformLocation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
